#define _CRT_SECURE_NO_WARNINGS

#include"AddressBook.h"

#define PRIVATE static

PRIVATE int FindName(AddressBook* address_book, char search_name[100]) {

	for (int i = 0; i < address_book->size; i++) {
		// ҵ±
		// ע all_address[i] ĳԱʷʽΪ .  ->
		if (strcmp(address_book->all_address[i].name, search_name) == 0) {
			return i;
		}
	}
	//ûҵ -1
	return -1;
}

// 
PRIVATE void ReallocBook(AddressBook* address_book){
	// ʼ capacity Ϊ 1
	int newSize = address_book->capacity == 0 ? 1 : 2 * address_book->capacity;
	
	PersonInfo* newAddress = realloc(address_book->all_address, newSize * sizeof(PersonInfo));
	if (!newAddress){
		strerror(errno);
		exit(EXIT_FAILURE);
	}
	// 
	address_book->all_address = newAddress;
	address_book->capacity = newSize;
}

// ļȡݵ
PRIVATE void LoadBook(AddressBook* address_book){
	FILE* fp = fopen("address_book.txt", "r");
	
	if (fp == NULL){
		strerror(errno);
		exit(EXIT_FAILURE);
	}

	// 򻺳ȡΪ֪ļжѧϢǲһԶ
	// ʹ while ѭظȡѧϢ
	while (1) {
		if (address_book->size == address_book->capacity) {
			ReallocBook(address_book);
		}
		PersonInfo tmp = {0};
		int n = fread(&tmp, sizeof(PersonInfo), 1, fp);
		// ȡ
		if (n < 1) {
			break;
		}
		//  tmp 뻺ҽ size  1
		address_book->all_address[address_book->size++] = tmp;
	}
	printf("ļ룡\n");
	fclose(fp);
}

// 滺ݵļ
PRIVATE void SaveBook(AddressBook* address_book) {
	FILE* fp = fopen("address_book.txt", "w");
	
	if (fp == NULL) {
		strerror(errno);
		exit(EXIT_FAILURE);
	}
	// ڵдļ
	int n = fwrite(address_book->all_address, sizeof(PersonInfo), address_book->size, fp);
	if (n != address_book->size) {
		strerror(errno);
		exit(EXIT_FAILURE);
	}
	printf("ļѱ棡\n");
	fclose(fp);
}


int Menu(void) {
	printf("\n\n\n\n\n\t\t\t\t\t\t AddressBook Management System\n");
	printf("\t\t\t\t\t\t     @authorShepard Wang \n");
	printf("\t\t\t\t\t\033[0;42m ϸעԼںţ̵ĳԲ \033[0m \n");
	printf("\t\t\t\t\t\t    ======================\n");
	printf("\t\t\t\t\t\t    ***     0.˳     ***\n");
	printf("\t\t\t\t\t\t    ***  1.ϵ  ***\n");
	printf("\t\t\t\t\t\t    ***  2.ɾϵ  ***\n");
	printf("\t\t\t\t\t\t    ***  3.ϵ  ***\n");
	printf("\t\t\t\t\t\t    ***  4.޸ϵ  ***\n");
	printf("\t\t\t\t\t\t    ***  5.ӡϵ  ***\n");
	printf("\t\t\t\t\t\t    ***  6.ϵ  ***\n");
	printf("\t\t\t\t\t\t    ***  7.ϵ  ***\n");
	printf("\t\t\t\t\t\t    ======================\n");

	printf("ѡ");
	int choice;
	scanf("%d", &choice);

	return choice;
}

//ʼ
void InitBook(AddressBook* address_book) {

	address_book->size = 0;
	// magic number()
	address_book->all_address = NULL;
	address_book->capacity = 0;

	// ʼûļȡ
	LoadBook(address_book);
}

void AddPersonInfo(AddressBook* address_book) {
	
	printf("ϵ\n");

	if (address_book->size >= address_book->capacity) {
		ReallocBook(address_book);
	}

	PersonInfo* info = &address_book->all_address[address_book->size];
	
	printf("ϵ");
	scanf("%s", info->name);
	printf("ϵ˵绰");
	scanf("%s", info->phone);

	address_book->size++;

	system("pause");
}

void DelPersonInfo(AddressBook* address_book) {
	
	//ɾķܶ࣬Ը绰ŵȵɾ
	//ǾҸ˱Ƚϳõ ֵɾ

	char search_name[100] = { 0 };

	printf("ɾϵ\n");
	printf("ϵ");
	scanf("%s", search_name);

	int name_exist = FindName(address_book, search_name);
	
	//ע FindName ֵ趨ҪɾԪ± 0»᷵ 0 
	if (name_exist == -1) {
		printf("ϵ˲ڣ\n");
		system("pause");
		return;
	}

	//ɾͬĵһ󣬼ѰҸ֣ҵˣظĲûҵ˳ѭ
	//ͬȽϸӣ޸ģңȵȳ鷳
	//ƽʱͨѶ¼ѵὫͬ˵ıעдһ
	//ԣҽɾʵһͬ˼·Ĭûظ
	while (name_exist != -1) {
		
		// all_address һԪظֵҪɾԪأɾ
		//ṹǿֱӸֵ
		address_book->all_address[name_exist] = address_book->all_address[address_book->size - 1];
		address_book->size--;
		// Ѱͬ
		name_exist = FindName(address_book, search_name);
	}

	printf("ɾɹ\n");
	
	system("pause");
}


void FindPersonInfo(AddressBook* address_book) {

	char search_name[100] = { 0 };

	//˵ķʽҲֵܶ࣬ķ
	printf("ϵ\n");
	printf("");
	scanf("%s", search_name);

	for (int i = 0; i < address_book->size; i++) {
		PersonInfo* info = &address_book->all_address[i];// һ PersonInfo ͵ı򻯳򣬲Ȼʾ̫
		if (strcmp(info->name, search_name) == 0) {
			printf("[%d] %s  %s\n", i, info->name, info->phone);
		}
	}
	
	system("pause");
}

void ModifyPersonInfo(AddressBook* address_book) {
	
	char search_name[100] = { 0 };
	int isjump = 1;

	printf("޸ϵ\n");
	printf("ϵ");
	scanf("%s", search_name);

	int name_exist = FindName(address_book, search_name);

	if (name_exist == -1) {
		printf("ϵ˲ڣ\n");
		system("pause");
		return;
	}
	
	//Żû
	printf("µ 0 ");
	scanf("%d", &isjump);
	if (isjump) {
		scanf("%s", address_book->all_address[name_exist].name);
	}
	printf("µĵ绰 0 ");
	scanf("%d", &isjump);
	if (isjump) {
		scanf("%s", address_book->all_address[name_exist].phone);
	}

	printf("³ɹ\n");
	system("pause");
}

void PrintPersonInfo(AddressBook* address_book) {
	
	PersonInfo* info;

	if (address_book->size == 0) {
		printf("ǰûϵˣ\n");
		system("pause");
		return;
	}

	printf("ϵϢ£\n");
	
	for (int i = 0; i < address_book->size; i++) {
		info = &address_book->all_address[i];
		printf("[%03d]%4s  %s\n", i, info->name, info->phone);
	}

	system("pause");
}

void ClearPersonInfo(AddressBook* address_book) {
	
	//Ϣһ ΣյΪûȷһ
	//ӦԼֻϻظãϵͳӦûȷϲֹһΣ
	int is_continue = 0;

	printf("ϵˣȷ 0 : ");
	scanf("%d", &is_continue);
	if(is_continue == 0) {
		// size Ϊ 0 ɣҲԽÿԪض
		address_book->size = 0;
		printf("ɣ\n");
	}
	printf("ȡ\n");
	
	system("pause");
}

void SortPersonInfo(AddressBook* address_book) {

	printf("ͨѶ¼\n");

	for (int i = 0; i < address_book->size - 1; i++) {
		for (int j = 0; j < address_book->size - 1 - i; j++) {
			PersonInfo* info = &address_book->all_address[j];
			PersonInfo* info_next = &address_book->all_address[j + 1];
			//򵥵 strcmp 򣬲Ϊоǡδ塱ģ
			//йɣٶԻֺᷢܶûйɡ
			//Ҳкܶĺ磺strcoll,wcsscoll,wcscmp ЩֻҪŪҲá
			//õʵְ취Ⲣص㡣
			if (strcmp(info->name, info_next->name) > 0) {
				PersonInfo tmp;
				tmp = *info;
				*info = *info_next;
				*info_next = tmp;
			}
		}
	}
	printf("ɹ\n");

	system("pause");
}

void DestoryBook(AddressBook* address_book) {

	// Ҫ˳ʱڵдļ
	SaveBook(address_book);

	free(address_book->all_address);
	address_book->all_address = NULL;
	address_book->capacity = address_book->size = 0;
}

