# awesome-nlp-sentiment-analysis
收集NLP领域相关的数据集、论文、开源实现，尤其是情感分析、情绪原因识别、评价对象和评价词抽取等方面。

# :book: Papers & :speak_no_evil: Codes

## 情感分析

1. **Deep Learning for Sentiment analysis: A Survey.**
[paper](https://arxiv.org/ftp/arxiv/papers/1801/1801.07883.pdf)

## 情绪归因

1. **An Ensemble Approach for Emotion Cause Detection with Event Extraction and Multi-Kernel SVMs.** 
[paper](https://ieeexplore.ieee.org/stamp/stamp.jsp?tp=&arnumber=8195347)

2. **Event-Driven Emotion Cause Extraction with Corpus Construction.**
[paper](http://www.aclweb.org/anthology/D16-1170)

3. **A Question Answering Approach to Emotion Cause Extraction.** 
[paper](https://www.aclweb.org/anthology/D17-1167)

4. **A Bootstrap Method for Automatic Rule Acquisition on Emotion Cause Extraction.**
[paper](http://sentic.net/sentire2017yada.pdf)

5. **Emotion Cause Detection for Chinese Micro-Blogs Based on ECOCC Model.**
[paper](https://link.springer.com/chapter/10.1007/978-3-319-18032-8_1)

6. **Emotion Cause Detection with Linguistic Constructions.**
[paper](https://link.springer.com/chapter/10.1007/978-3-662-45924-9_42)

7. **Emotion Cause Extraction, A Challenging Task with Corpus Construction.**
[paper](https://link.springer.com/chapter/10.1007/978-981-10-2993-6_8)

8. **Extracting Causes of Emotions from Text.**
[paper](http://aclweb.org/anthology/I13-1121)

9. **基于E-CNN神经网络的情绪原因识别方法.**
[paper](http://jcip.cipsc.org.cn/CN/Y2018/V32/I2/120)

10. **基于序列标注模型的情绪原因识别方法.**
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1756.shtml)

11. **基于文本的情绪自动归因方法研究.**
[paper](http://cdmd.cnki.com.cn/Article/CDMD-10213-1015979471.htm)

12. **A Co-Attention Neural Network Model for Emotion Cause Analysis with Emotional Context Awareness.**
[paper](https://www.aclweb.org/anthology/D18-1506.pdf)

13. **Emotion-Cause Pair Extraction: A New Task to Emotion Analysis in Texts.**
[paper](https://arxiv.org/pdf/1906.01267.pdf)
[code](https://github.com/NUSTM/ECPE)

## 评价对象和评价词抽取

4. **Fine-grained Opinion Mining with Recurrent Neural Networks and Word Embeddings.** 
[paper](https://pdfs.semanticscholar.org/8208/43544be57efa903ce14d6967b0eeafd6a7ed.pdf) 
[code](https://github.com/pdsujnow/opinion-target)

5. **Character-based BiLSTM-CRF Incorporating POS and Dictionaries for Chinese Opinion Target Extraction.** 
[paper](http://proceedings.mlr.press/v95/li18d/li18d.pdf) 
[code](https://github.com/kdsec/chinese-opinion-target-extraction)

6. **A Unified Model for Opinion Target Extraction and Target Sentiment Prediction.**
[paper](https://arxiv.org/abs/1811.05082)
[code](https://github.com/lixin4ever/E2E-TBSA)

7. **评价对象抽取研究综述.** 
[paper](http://www.aas.net.cn/CN/10.16383/j.aas.2017.c170049)

8. **使用深度长短时记忆模型对于评价词和评价对象的联合抽取.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract2522.shtml)

9. **基于语义和句法依存特征的评论对象抽取研究.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract2585.shtml)

10. **基于条件随机场的评价对象缺省项识别.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract2317.shtml)

11. **基于CRFs和领域本体的中文微博评价对象抽取研究.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract2260.shtml)

12. **基于微博的情感倾向性分析方法研究.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract229.shtml)

13. **基于迭代两步CRF模型的评价对象与极性抽取研究.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract53.shtml)

14. **基于句法特征的评价对象抽取方法研究.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract172.shtml)

15. **基于层叠CRFs的中文句子评价对象抽取.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1718.shtml)

16. **评价对象及其倾向性的抽取和判别.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1633.shtml)

17. **基于非完备信息系统的评价对象情感聚类.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1634.shtml)

18. **基于CRFs的评价对象抽取特征研究.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1588.shtml)

19. **基于核心句及句法关系的评价对象抽取.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1478.shtml)

20. **面向特定领域的产品评价对象自动识别研究.**
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1332.shtml)

21. **评价对象抽取及其倾向性分析.** 
[paper](http://jcip.cipsc.org.cn/CN/abstract/abstract1331.shtml)

22. **Aspect extraction for opinion mining with a deep convolutional neural network.**
[paper](https://ww.w.sentic.net/aspect-extraction-for-opinion-mining.pdf)

23. **Recursive neural conditional random fields for aspect-based sentiment analysis.**
[paper](https://www.aclweb.org/anthology/D16-1059)

24. **Coupled multi-layer attentions for co-extraction of aspect and opinion terms.**
[paper](http://www.aaai.org/Conferences/AAAI/2017/PreliminaryPapers/15-Wang-W-14441.pdf)

# :floppy_disk: Dataset

## 评价对象和评价词抽取

- [SemEval-2014 Task 4](http://alt.qcri.org/semeval2014/task4/index.php?id=data-and-tools)

- [中文微博情感分析测评数据](https://mlln.cn/2018/10/11/%E4%B8%AD%E6%96%87%E6%83%85%E6%84%9F%E5%88%86%E6%9E%90%E8%AF%AD%E6%96%99%E5%BA%93%E5%A4%A7%E5%85%A8-%E5%B8%A6%E4%B8%8B%E8%BD%BD%E5%9C%B0%E5%9D%80/)

- [百度、马蜂窝和大众点评数据集](https://github.com/lsvih/chinese-customer-review)

- [情感原因对数据集](https://github.com/NUSTM/ECPE/tree/master/data_combine)
