---
title: Overview
nav_order: 1
layout: page
---

# Overview

DalFox is a powerful open-source tool designed for automated detection of XSS vulnerabilities. With its advanced testing engine and comprehensive feature set, DalFox simplifies the process of scanning, analyzing parameters, and verifying vulnerabilities. Whether you are performing quick scans or detailed analyses, DalFox provides a streamlined experience tailored to the needs of security professionals and researchers.

![](/images/screen.png)

The name "DalFox" has a unique origin:
- **Dal ([달](https://en.wiktionary.org/wiki/달))**: The Korean word for "moon."
- **Fox**: An acronym for "Finder Of XSS" 🦊.

Key highlights of DalFox include:
- **Flexible Scanning Modes**: Supports URL-based scans, file-based inputs, pipelines, and server modes.
- **Comprehensive Analysis**: Detects reflected, stored, and DOM-based XSS, along with parameter mining and static analysis.
- **Extensibility**: Offers custom payloads, remote wordlists, and API integrations for tailored testing.
- **Performance Optimization**: Features such as payload abstraction, bad character filtering, and parallel encoding improve efficiency.
- **Detailed Reporting**: Outputs can be formatted as plain text or JSON, with options for in-depth reports.

## Contributors

DalFox is an open-source project made with ❤️

If you want to contribute to this project, please see [CONTRIBUTING.md](https://github.com/hahwul/dalfox/blob/main/CONTRIBUTING.md) and submit a Pull Request with your cool content.

[![Contributors](https://github.com/hahwul/dalfox/raw/main/CONTRIBUTORS.svg)](https://github.com/hahwul/dalfox/graphs/contributors)