---
title: Format Of PoC
redirect_from: /docs/format-of-poc/
nav_order: 5
parent: Resources
toc: true
layout: page
---

# Format Of PoC

This guide provides a detailed explanation of the format of Proof of Concept (PoC) logs generated by Dalfox. The PoC log contains various information along with the PoC code. The distinction character between information data and PoC code is a blank space.

## Sample PoC Log

Here is a sample PoC log:

```
[POC][G][BUILT-IN/dalfox-error-mysql/GET] http://testphp.vulnweb.com/listproducts.php?artist=123&asdf=ff&cat=123DalFox
[POC][V][GET] http://testphp.vulnweb.com/listproducts.php?artist=123&asdf=ff&cat=123%22%3E%3Csvg%2Fclass%3D%22dalfox%22onLoad%3Dalert%2845%29%3E
```

## PoC Log Format

| Identity | Type | Information                     | BLANK | PoC Code                                                     |
| -------- | ---- | ------------------------------- | ----- | ------------------------------------------------------------ |
| POC      | G    | BUILT-IN/dalfox-error-mysql/GET |       | http://testphp.vulnweb.com/listproducts.php?artist=123&asdf=ff&cat=123DalFox |
| POC      | V    | GET                             |       | http://testphp.vulnweb.com/listproducts.php?artist=123&asdf=ff&cat=123%22%3E%3Csvg%2Fclass%3D%22dalfox%22onLoad%3Dalert%2845%29%3E |

### Explanation of Fields

- **Identity**: Always `POC` to indicate a Proof of Concept log entry.
- **Type**: Indicates the type of PoC. Possible values are:
  - `G` (Grep)
  - `R` (Reflected)
  - `V` (Verify)
- **Information**: Contains additional information such as the HTTP method and grepping name.
- **BLANK**: A blank space used as a delimiter.
- **PoC Code**: The actual PoC URL or payload.

## Why is there a gap?

The gap (blank space) is used to make it easier to parse only the PoC code using tools like `cut`. For example, you can extract the PoC code as follows:

```shell
dalfox url http://testphp.vulnweb.com/listproducts.php?cat=123&artist=123&asdf=ff | cut -d " " -f 2 > output
cat output
http://testphp.vulnweb.com/listproducts.php?artist=123&asdf=ff&cat=123DalFox
http://testphp.vulnweb.com/listproducts.php?artist=123&asdf=ff&cat=123%22%3E%3Csvg%2FOnLoad%3D%22%60%24%7Bprompt%60%60%7D%60%22+class%3Ddalfox%3E
```
