"""django_views_tutorial URL Configuration
from django.urls import include, path

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/2.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import include, path

urlpatterns = [
    path("admin/", admin.site.urls),
    path("", include("homepage.urls"), name="home"),
    path(
        "function_views/",
        include(("function_views.urls", "function_views"), namespace="function_views"),
    ),
    path(
        "class_views/",
        include(("class_views.urls", "class_views"), namespace="class_views"),
    ),
    path(
        "model_views/",
        include(("model_views.urls", "model_views"), namespace="model_views"),
    ),
] + static(settings.STATIC_URL, document_root=settings.STATIC_ROOT)
