# Awesome Design
[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)
[![Build Status](https://travis-ci.org/gztchan/awesome-design.svg?branch=master)](https://travis-ci.org/gztchan/awesome-design)
[![PRs & Issues Welcome](https://img.shields.io/badge/PRs%20&%20Issues-welcome-brightgreen.svg)](https://github.com/gztchan/awesome-design/pulls)

> Awesome Design focuses on collecting high quality resources and tools which can be used by UI/UX designers in daily work. Thanks to the community,
the repo keeps being updated continuously from people around the world who provide amazing resources.
Don't hesitate to open an [issue](https://github.com/gztchan/awesome-design/issues/new) or create [pull request](https://github.com/gztchan/awesome-design/pulls) to share your intelligence.

![design](/design.png)

#### What should I do with the curated resources?

People, including developers, designers, scientists and others, create awesome things every single day. To be honest, we who are not superheroes, can't know all best things from the world. So, for saving your time, i suggest you to pick those you like, take benefits from them, and finally put it into your kit. :smile:

#### Contents

**Get things done**

- [Stock](#stock)
- [Icon and Logo](#icon-and-logo)
- [Color](#color)
- [Typography](#typography)
- [Toolkit](#toolkit)
- [Prototyping](#prototyping)
- [Mockup](#mockup)
- [User Testing](#user-testing)

**Concepts**

- [Read and Digest](#read-and-digest)
- [Styleguide and Branding](#styleguide-and-branding)
- [Tutorial](#tutorial)
- [Book](#book)
- [Award](#award)
- [Conference and Festival](#conference-and-festival)
- [Podcast](#podcast)
- [Community](#community)

## Stock

- [Albumarium](http://albumarium.com/) "The best place to find & share beautiful images."
- [The Stocks](http://thestocks.im/) "The best royalty free stock photos are delivered now along with videos, audios, icons, fonts and colors."
- [Polayoutu](http://www.polayoutu.com/collections) is community of photographers based in China who contribute photos under the Creative Common Zero License. 🌟
- [Illusion](http://illusion.scene360.com/)
- [Baubauhaus](http://www.baubauhaus.com/) feed your daily need of design, illustration, photography, fashion and of all else art-related.
- [500px](https://web.500px.com/) over 15 million photographers from 195 countries. 🌟
- [1x](https://1x.com/) Shop wall art by 16000+ Curated Artists. 🌟
- [LIFE OF PIX](http://www.lifeofpix.com/) Free high-resolution photos, no copyrights restrictions for personal and commercial use.
- [Unsplash](https://unsplash.com/)
- [Stokpic](http://stokpic.com/)
- [Raumrot](https://www.howtostartanllc.org/free-stock-photos/)
- [Death to Stock](http://deathtothestockphoto.com/)
- [Gratisography](http://www.gratisography.com/) "The world’s quirkiest collection of high-resolution free stock images."
- [picjumbo](https://picjumbo.com/) Download free stock photos, backgrounds and images in high‑resolution for personal and commercial use.
- [Magdeleine](https://magdeleine.co/browse/) Hand-picked free photos for your inspiration.
- [Pexels](https://www.pexels.com/) "The best free stock photos & videos shared by talented creators."
- [imcreator](http://imcreator.com/)
- [Startup Stock Photos](http://startupstockphotos.com/) Free photos for startups, bloggers, publishers, websites, designers, developers, creators,
& everyone else.
- [New Old Stock Photos](http://nos.twnsnd.co/) Vintage photos from the public archives, free of known copyright restrictions. recapturing history.
- [Realistics Shots](http://realisticshots.com/) Free stock photos (high resolution) for personal and commercial use. 7 new photos every week.
- [SplitShire](https://www.splitshire.com/) Free stock photos for commercial use.
- [FancyCrave](http://fancycrave.com/) Free travel photos for commercial use.
- [LIBRESHOT](https://libreshot.com/) Free fine art and ordinary photography. Free images for blogs or websites even for commercial use.
No need to mention the author.
- [BARNIMAGES](https://barnimages.com/) Free high-resolution images for everyone.
- [MMT](https://mmtstock.com/) Free photos and videos for commercial use.
- [JAY MANTRI](http://jaymantri.com/) free pics. do anything(CC0). make magic.
- [FoodiesFeed](https://www.foodiesfeed.com/) is a resource of awesome naturally looking food photos that are completely free to download.
- [Little Visuals](http://littlevisuals.co/)
- [Bucketlistly Blog](http://photos.bucketlistly.com/) A free creative commons (Attribution-NonCommercial) collection of over 8000+ travel photos from all over the world anyone can use.
- [Pinterest](https://www.pinterest.com/) is a social media web and mobile application company that operates a software system designed to discover information on the World Wide Web. 🌟
- [pixabay](https://pixabay.com/) Over 1 million+ high quality stock images and videos shared by our talented community.
- [depositphotos](https://depositphotos.com/) Over 100 million high-quality royalty-free stock images and high-definition footage at the best prices to fill all your creative needs.
- [Stocksy](https://www.stocksy.com) is home to a highly curated collection of royalty-free stock photography and video footage that is beautiful, distinctive, and highly usable.
- [butdoesitfloat](http://butdoesitfloat.com/)
- [AllTheFreeStock](http://allthefreestock.com/)
- [UI Faces](https://uifaces.co/) UI Faces aggregates thousands of avatars which you can carefully filter to create your perfect personas or just generate random avatars.

## Color

- [Coolors](https://coolors.co/) The super fast color schemes generator!
- [Colordot](https://color.hailpixel.com/)
- [Brand Colors](https://brandcolors.net/) The biggest collection of official brand color codes around.
- [Material Design Palette](https://www.materialpalette.com/)
- [Flat UI Color Picker](http://www.flatuicolorpicker.com/)
- [LOL COLORS](https://www.webdesignrankings.com/resources/lolcolors/) Curated color palette inspiration.
- [The Day's Color](http://www.thedayscolor.com/) is to find colorful inspiration from things that surround us. Daily.
- [Color Claim](http://colorclaim.tumblr.com/)
- [Color Hunt](http://colorhunt.co/) is a free and open platform for color inspiration with thousands of trendy hand-picked color palettes.
- [CSS Colours Name](http://colours.neilorangepeel.com/)
- [rgb.to](http://rgb.to/)
- [Color Code](http://www.colourco.de/)
- [Colorrrs](http://www.webpagefx.com/web-design/hex-to-rgb/)
- [Nippon Colors](http://nipponcolors.com/)
- [Colorize](https://alexbeals.com/projects/colorize/) is a website that turns any word or phrase into a hex color.
- [Hello Color](http://jxnblk.com/hello-color/)
- [Color Lisa](http://www.colorlisa.com/) is a curated list of color palettes based on masterpieces of the worlds greatest artists.
- [ColorDrop](https://colordrop.io/)
- [colorfavs](http://www.colorfavs.com/) a place that made it easy to create and discover new colors and palettes for all of your projects.
- [uiGradients](https://uigradients.com/)
- [HTML Color Codes](http://htmlcolorcodes.com/) Get HTML color codes, Hex color codes, RGB and HSL values with our color picker, color chart and HTML color names.
- [palettr](http://palettr.com/) is a web tool for designers.
- [Paletton](http://paletton.com/)
- [Palettable](http://www.palettable.io/) Generate beautiful color palettes using the knowledge of millions of designers.
- [Picular](https://picular.co/)
- [Colorable](https://colorable.jxnblk.com/) “If one says ‘Red’ (the name of the color) and there are 50 people listening, it can be expected that there will be 50 reds in their minds. And one can be sure that all these reds will be very different.” – Josef Albers
- [Google Colors](https://material.io/guidelines/style/color.html) The Material Design color system can be used to create a color theme that reflects your brand or style.
- [WebGradients](https://webgradients.com/) Free collection of 180 linear gradients that you can use as content backdrops in any part of your website.
- [Chinese Colors](http://zhongguose.com) is a collection of Chinese traditional colors.
- [Gradienta](https://gradienta.io/) Multicolor CSS Gradients, JPG Downloads, 100% Free!
- [Veranda Color](https://verandacolor.com) Browse color palettes made by other designers, generate and submit your own.

## Icon and Logo

- [macOS Icon Gallery](http://macosicongallery.com/)
- [icon54](https://icon54.com)
- [icons8](https://icons8.com/)
- [Iconfinder](https://www.iconfinder.com/) provides high-quality icons to millions of creative professionals.
- [icon dock](http://icondock.com/)
- [Genericons Neue](https://genericons.com/) generic looking icons, suitable for a blog or simple website.
- [FlatIcons.net](http://flaticons.net/) is a free flat icon maker.
- [FLATICON](http://www.flaticon.com/)
- [Evil Icons](http://evil-icons.io/) Simple and clean SVG icon pack with the code to support Rails, Sprockets, Node.js, Gulp, Grunt and CDN.
- [Typeicons](http://typicons.com/) are free-to-use vector icons embedded in a webfont for easy use in any UI, whether it be on the web or in a native app.
- [The Noun Project](https://thenounproject.com/)
- [Nucleoapp](https://nucleoapp.com/) is a beautiful library of 27500 icons, and a powerful application to collect, customize and export all your icons.
- [Picons](https://picons.me/) Vector Icons for iOS, Android, Websites & Apps. Icons designed to perfection.
- [Pictos](http://pictos.cc/) is back once again with Redux: all new carefully crafted interface icons. Each icon in Redux has three variations: Line, Solid & Color.
- [Smashicons](https://smashicons.com/) is the largest and most distinct Icon Pack in the World. Smashicons offers the simplest, effortless way to use icons.
- [Symbolset](https://symbolset.com/icons)
- [logofaves](http://logofaves.com/)
- [Logo of the day](http://logooftheday.com/)
- [LogoMoose](https://www.logomoose.com/) is a logo inspiration and design community showcasing logos submitted by professional logo designers.
- [Logospire](http://logospire.com/) is a logo inspiration gallery.
- [Squid.ink](http://thesquid.ink)
- [Game Icons](http://game-icons.net/)
- [svgicons.sparkk.fr](http://svgicons.sparkk.fr/)
- [Material Design Icons](https://materialdesignicons.com/)
- [Material Design Iconic Font](http://zavoloklom.github.io/material-design-iconic-font/index.html) is a full suite of material design icons (created and maintained by Google) with additional community-designed and brands icons for easy scalable vector graphics on websites or desktop.
- [Bytesize](http://danklammer.com/bytesize-icons/) is a tiny style-controlled SVG iconset.
- [NOVA Material Design Icons](http://www.webalys.com/nova/index.html) 4,000 vector icons provided in two styles: Line and Solid.
- [Free Icon Shop](https://freeiconshop.com/) is a large collection of beautiful free icons in vector formats. All icons are commercially free to use. Download free icons in PNG, SVG, Ai or PSD formats.
- [Simple Icons](https://simpleicons.org/) Free SVG icons for popular brands.
- [iconmonstr](https://iconmonstr.com/) Free, monstrously big and continuously growing source of simple icons run by one creator.
- [Octions](https://octicons.github.com/) GitHub's icons.
- [We Love Icon Fonts](http://weloveiconfonts.com/)
- [IconStore](https://iconstore.co/) Free icons by first-class designers.
- [Google Material Icons](https://design.google.com/icons/) Material icons are delightful, beautifully crafted symbols for common actions and items. 🌟
- [Font Awesome](http://fontawesome.io/) Get vector icons and social logos on your website with Font Awesome, the web's most popular icon set and toolkit. 🌟
- [IconMoon](https://icomoon.io/) Pixel perfect icon solutions.
- [ICONO](http://saeedalipoor.github.io/icono/) pure css icons, with only one element.
- [svg-icon](http://leungwensen.github.io/svg-icon/) is an ultimate SVG icons collection done right.
- [Iconfont+](http://www.iconfont.cn/) 阿里妈妈 MUX 倾力打造的矢量图标管理、交流平台。
- [CoreUI Icons](http://coreui.io/icons/) Premium designed free icon set with marks in SVG, Webfont and raster formats.

## Typography

- [typography](https://www.typography.com/)
- [i love typography](http://ilovetypography.com/) was born on August 7, 2007. It exists because I have a passion for typography, type design, and lettering, and for the pages, words, and letters born of those disciplines.
- [Type is Beautiful](https://www.typeisbeautiful.com/) 是一个关于文字设计和视觉文化的媒体计划。我们关注的话题包括字体、排版、平面设计、公共设计、技术和视觉文化。
- [Butterick's Practical Typography](http://practicaltypography.com/)
- [Fonts](https://www.fonts.com/) store from Monotype offers more than 150,000 desktop and Web font products for you to preview, purchase and download. You can also learn about new typeface releases and discover typographic tips and techniques.
- [Font Squirrel](https://www.fontsquirrel.com/) 100% free for commercial use.
- [Typewolf](https://www.typewolf.com/) what’s trending in type.
- [Type Novel](http://typenovel.tumblr.com/)
- [Fonts In Use](https://fontsinuse.com/) is a public archive of typography indexed by typeface, format, industry, and period.
- [My Fonts](http://www.myfonts.com/)
- [The Designers Foundry](https://www.thedesignersfoundry.com/)
- [Adobe Fonts](https://fonts.adobe.com/fonts) Enjoy quick browsing, easy use in desktop applications or on the web, and endless typographic inspiration.
- [Google Fonts](https://fonts.google.com/)
- [Google Font Combinations](https://femmebot.github.io/google-type/)
- [justfont](http://blog.justfont.com/) 是新世代字型設計暨推廣教育團隊，致力於培育台灣下一代的設計力量。
- [Font Library](http://katydecorah.com/font-library/)
- [Type Guide](http://www.typogui.de/) A Pocket Guide to Master Every Day’s Typographic Adventures.
- [workmark](https://wordmark.it/)
- [fontfling](http://fontfling.com/)
- [Glyphr Studio](http://www.glyphrstudio.com/online/)
- [Lost Type](http://www.losttype.com/browse/) is a collaborative digital type foundry.
- [Brick](http://brick.im/)
- [Village](https://vllg.com/)
- [Klim](https://klim.co.nz/)
- [Milieu Grotesque](https://www.milieugrotesque.com/) is an independent type foundry, offering an exclusive library of digital typefaces and related products.
- [Lineto](https://lineto.com/)
- [Colophon](https://www.colophon-foundry.org/) is an international, award-winning type foundry based in London (UK) and Los Angeles (US).
- [T26](https://www.t26.com/)
- [Typ.io](https://typ.io) at Typ.io, we're revealing designers' decisions for all to see; peeking under the hood of beautiful websites to find out what fonts they're using and how they're using them.
- [TypeNetwork](https://www.typenetwork.com/)
- [The League of Moveable Type](https://www.theleagueofmoveabletype.com/)

## Toolkit

- [Sketch](https://www.sketchapp.com/) is a platform to empower designers to share and collaborate on their designs and work better, together. [Developer](http://developer.sketchapp.com/), [Sketch App Sources](https://www.sketchappsources.com/), [Sketch Repo](https://sketchrepo.com/), [Sketch Plugins](https://github.com/sketchplugins/plugin-directory), [Sketch.im](http://sketch.im/).🌟
- [Adobe Photoshop](http://www.adobe.com/products/photoshop.html) Best imaging and design app is at the core of almost every creative project. [PSD Repo](https://psdrepo.com/), [PSDDD](https://psddd.co/). 🌟
- [Adobe Illustrator](http://www.adobe.com/products/illustrator.html) The industry-standard vector graphics app lets you create logos, icons, sketches, typography, and complex illustrations for print, web, interactive, video, and mobile. 🌟
- [Adobe After Effects](http://www.adobe.com/products/aftereffects.html) Bold new ways to put your ideas in motion. v
- [Adobe Project Felix](http://www.adobe.com/products/project-felix.html) A new app for working with 3D models, materials, and lights with 2D background images to create fully rendered, high-quality images with photorealistic effects.
- [Adobe XD](https://www.adobe.com/products/xd.html) Vector-based tool for designing and prototyping user experience for web and mobile apps. 🌟
- [Zeplin](https://zeplin.io/) Build pixel perfect apps in peace.
- [Panda](http://usepanda.com/) A smart news reader built for productivity, powered by integrations.
- [INBOARD](https://inboardapp.com/) Organize your inspiration.
- [Sip](http://sipapp.io/) The best way to collect, organize & share your colors.
- [RightFont](https://rightfontapp.com/) The future of font manager software for Mac OS X.
- [Dropbox](https://www.dropbox.com/) Get to all your files from anywhere, on any device, and share them with anyone. 🌟
- [Iconjar](https://geticonjar.com/) Organize, search and use icons the easy way.
- [Affinity Designer](https://affinity.serif.com/en-gb/designer/) - Professional graphic design software for Mac.
- [Inkscape](https://inkscape.org/en/) Free vector graphics tool.
- [Figma](https://www.figma.com/) The first interface design tool with real-time collaboration. 🌟
- [Gravit](https://www.gravit.io/) End-to-end web-based design platform.
- [Taskade](https://www.taskade.com/) Collaborate with clients on the same page visually with team tasks, notes and meeting agendas.
- [Framer X](https://framer.com/) Design tool for creating interactive designs, interfaces and animations.

## Prototyping

- [Marvel](https://marvelapp.com/) Simple design, prototyping and collaboration.
- [InVision](https://www.invisionapp.com/) The world's leading prototyping, collaboration & workflow platform.
- [Origami](http://origami.design/) Design Prototyping.
- [Haiku](https://www.haiku.ai/) Animation tool for UI components, ready for iOS, Android or Web Apps.
- [Atomic](https://www.atomic.io/) The prototyping tool designed for teams.
- [Proto.io](https://proto.io/) Prototypes that feel real.
- [Protopie](https://www.protopie.io/) Interactive prototypes with simple triggers, connects to phone features like vibration, proximity, and camera.
- [Justinmind](https://www.justinmind.com/) Prototype Faster, Communicate Better.
- [Principle](http://principleformac.com/) Animate Your Ideas, Design Better Apps.
- [Flinto](https://www.flinto.com/) App prototyping tools for designers.
- [Axure](https://www.axure.com/) Design the right solution and align your team.
- [Form](http://www.relativewave.com/form/) Build and customize native prototypes directly on device.
- [Bootstrap Studio](https://bootstrapstudio.io/) A powerful desktop app for creating responsive websites using the Bootstrap framework.
- [Adobe Experience Design](http://www.adobe.com/products/experience-design.html) Design, prototype and quickly share user experiences.
- [UXPin](https://www.uxpin.com/) High fidelity animated prototypes created in minutes.
- [MockingBot](https://modao.cc/) Mobile prototyping tool without headache.
- [POP](https://marvelapp.com/pop/?popref=1) Transform pen and paper ideas into a real working prototype.
- [Prott](https://prottapp.com/) Prototyping tool for Web, iOS, Android apps.

## Mockup

- [Mockup World](https://www.mockupworld.co/) handpicks and presents the best photorealistic Photoshop mockups that designers and agencies worldwide have published online.
- [Placeit](https://placeit.net/) marry design and technology to create high-quality branding and marketing tools so anyone from individuals to large companies can create amazing visual assets for their brand regardless of technical or artistic skills.
- [Epicpxls](https://www.epicpxls.com/) Free & premium curated fonts, graphics, templates, mobile app designs & UI Kits.
- [360 Mockups](https://360mockups.com/) Totally FREE to download PSD Mockups to present your works.
- [Facebook Devices](http://facebook.design/devices) Images and Sketch files of popular devices.
- [Facebook HandsKit](http://facebook.design/handskit) Photos of hands holding various phones, to be used in any presentation of your designs.
- [UINames](https://uinames.com/) is a simple tool to generate fake names for use in designs and mockups.
- [NinjaMock](https://ninjamock.com/) is a small startup based in Denmark, a country famous for its strong attitude towards design and quality.
- [Smartmockups app](https://smartmockups.com/) The #1 tool for creating stunning marketing images.
- [Froala Design Blocks](https://www.froala.com/design-blocks) Over 170 responsive design blocks ready to be used in your web or mobile apps. All blocks are based on the Bootstrap Library, and they are the building blocks for beautiful websites.
- [ScreenSpace](https://www.screenspace.io)
- [Rotato 3D mockups](https://rotato.xyz)
- [Lorem Ipsum](http://www.lipsum.com/feed/html)
- [BrowserFrame](https://browserframe.com/) is the easiest way to wrap screenshots in browser frames. Supports multiple browsers, operating systems, and themes. Great for landing pages and mockups.
- [Device Shots](https://deviceshots.com) is a tool that helps you create beautiful device mockups to share on social media platforms, with the screenshot of your website or mobile application, for free.

## User Testing

- [Lookback.io](https://lookback.io/) Capture exactly how users experience your product: no guesswork required.
- [UserTesting](https://www.usertesting.com/) Get videos of real people speaking their thoughts as they use your website or mobile app. Go beyond analytics and understand why users do what they do.
- [UserBrain](https://userbrain.net/) Keep getting videos of real people testing your website, web app or prototype and make it ridiculously easy to use.
- [Reflector](http://www.airsquirrels.com/reflector/) Wireless mirroring and streaming receiver.
- [User Zoom](http://www.userzoom.co.uk/) All-in-One Agile UX Research Platform.
- [Ethn.io](https://ethn.io/) Remote user testing suite. Intercept real people for user research.
- [Usabilla](https://usabilla.com/) Customer feedback and survey tool.
- [UserTest.io](https://usertest.io/) Remote, easy and simple user testing.
- [Validately](https://validately.com/) Easy way to recruit testers, launch tests, and analyze results.
- [Users Think](http://usersthink.com/) Get user feedback from real people, on demand, when you need it.
- [CrazyEgg](https://www.crazyegg.com/) Heatmapping software.
- [HotJar](https://www.hotjar.com/) Includes screen recordings, heatmapping, form and funnel analysis and user feedback polls & surveys
- [Inspectlet](https://www.inspectlet.com/) Captures user actions and browsing, generates heatmaps, records with a realtime timeline
- [Clicktale](https://www.clicktale.com) is a user experience management platform.
- [Maze Design](http://maze.design) is a great way to conduct user interviews

## Read and Digest

- [Design Milk](http://design-milk.com/) is an online magazine dedicated to modern design, offers what’s new in art, architecture, interior design, furniture and decor, fashion and technology. 🌟
- [frog](https://www.frogdesign.com/) is a global Design, innovation and strategy firm.
- [Danish Design Centre](http://danskdesigncenter.dk/)
- [Google Design](https://design.google.com/) is a cooperative effort led by a group of designers, writers, and developers at Google. 🌟
- [Google Art & Culture](https://www.google.com/culturalinstitute/beta/), explore collections and stories from around the world.
- [Airbnb Design](https://airbnb.design/) is a cross-disciplinary group of experience and production designers, researchers, technologists, writers and content strategists, graphic designers, filmmakers, producers, interior architects, project managers, photographers and more. 🌟
- [Fast.Co Design](https://www.fastcodesign.com/) is the world’s leading business media brand, with an editorial focus on innovation in technology, leadership, world changing ideas, creativity, and design. 🌟
- [Smashing Magazine](https://www.smashingmagazine.com/) founded in September 2006 in Germany, Smashing Magazine delivers reliable, useful, but most importantly practical articles to web designers and developers. 🌟
- [Design Taxi](http://designtaxi.com/)
- [Yanko Design](http://www.yankodesign.com/)
- [Swiss Miss](http://www.swiss-miss.com/) is a design blog/studio run by tina roth eisenberg.
- [UX Magazine](http://uxmag.com/) is a free community resource exploring all facets of experience design.
- [UXBooth](http://www.uxbooth.com/) is a publication by and for the user experience community.
- [IDEO](https://www.ideo.com/)
- [Design Shack](https://designshack.net/) established in 2003, Design Shack is a magazine for creatives, designers, and developers.
- [Booooooom](http://www.booooooom.com/blog/design/) was launched in 2008 by Vancouver-based artist Jeff Hamada. It is Canada’s highest traffic art platform, and one of the largest on the Internet.
- [designmodo](https://designmodo.com/inspiration/) provides articles, tutorials and industry news about trends and techniques.
- [webdesignerdepot](https://www.webdesignerdepot.com/)
- [UX Movement](http://uxmovement.com/) shows you which way gives the best user experience.
- [Speckyboy](https://speckyboy.com/) was launched with the intent of serving as an inspirational hub for web designers.
- [HUGE](http://www.hugeinc.com/)
- [Sitepoint Blog](https://www.sitepoint.com/blog/)
- [UIE](https://articles.uie.com/) helps people have the expertise they need to deliver better design.
- [Attack the Front](http://attackthefront.com)
- [codrops](https://tympanus.net/codrops/) is a web design and development blog that publishes articles and tutorials about the latest web trends, techniques and new possibilities.
- [The Great Discontent](https://thegreatdiscontent.com/) is a print publication and online magazine featuring inspiring conversations with today’s artists, makers, and risk-takers.
- [Underconsideration](http://underconsideration.com/) are a graphic design firm generating it own projects, initiatives, and content while taking on limited client work.
- [Little Big Details](http://littlebigdetails.com/) is a curated collection of the finer details of design, updated every day.
- [WAYS WE WORK](http://wayswework.io/) is a digital publication focused on telling stories and getting first-hand accounts of how people do the work they love.
- [Creative Review](https://www.creativereview.co.uk/) has been bringing the creative community together since 1980.
- [Creativeoverflow](http://creativeoverflow.net/) is an online design magazine for anything creative.
- [FORM UP NORTH](http://www.fromupnorth.com/)
- [Facebook](http://facebook.design/) is a facebook design blogs.
- [Facebook Design on Medium](https://medium.com/facebook-design) experiences from the people designing products billions of people use every day.
- [Hacking UI](http://hackingui.com/) is a community for designers, developers and creative entrepreneurs with a passion.
- [PixelSquid Blog](https://blog.pixelsquid.com/)
- [LOGO DESIGN LOVE](http://www.logodesignlove.com/) is a website and book devoted to the design of logos and brand identities.
- [DesignM.ag](https://designm.ag/) is a community-based website for web designers and developers.
- [HeyDesigner](http://heydesigner.com/) daily curated design knowledge.
- [Nicely Done](http://nicelydone.club/) is a curation of the nicest digital products.
- [Dropbox Design on Medium](https://medium.com/dropbox-design) Stories and musings from the Dropbox Design team. 🌟
- [Designer News](https://www.designernews.co/) is a large, global community of people working in design and technology or those interested in the topics. 🌟
- [Sidebar](https://sidebar.io/) has been collecting the best links about UI design, typography, CSS, user research, and all other facets of design since 2012. 🌟
- [CodePen Blog](https://blog.codepen.io/) where CodePen post announcements, tips and tricks, new and updated features, fun roundups, new podcast episodes, and more.
- [Web Designer News](http://www.webdesignernews.com/) curated stories for designers. 🌟
- [The UX for VR](https://www.uxofvr.com/) is a curated list of resources to help you on your journey into the User Experience of Virtual Reality.
- [Reeoo](http://reeoo.com/) provides web design inspiration and gallery for web designers.
- [CREATIVE BLOQ](http://www.creativebloq.com/) delivers a daily mix of advice and inspiration for digital and traditional artists, web designers, graphic designers, 3D and VFX artists, illustrators, and more. 🌟
- [Pond5](https://www.pond5.com/)
- [Dexigner](https://www.dexigner.com/)
- [Nicce on Medium](https://blog.niice.co/)  Gather, share & discuss ideas with your team.
- [Artwxrk](https://www.artwxrk.com)
- [Designspiration](http://designspiration.net/) is committed to being the best product that it can.
- [Freebiesbug](https://freebiesbug.com/) Hand-picked resources for web designer and developers, constantly updated.
- [Muuuuu](http://muuuuu.org/)
- [Muzli on Medium](https://medium.muz.li/) The freshest links about design and interactive, from around the web.
- [The Best Designs](https://www.thebestdesigns.com/)
- [Flat Inspire](http://flatinspire.com/) is a curated gallery & showcase of the best websites rocking a Flat Design/UI style.
- [Site Inspire](https://www.siteinspire.com/) is a showcase of the finest web and interactive design.
- [Media Queries](https://mediaqueri.es/)
- [One Page Love](https://onepagelove.com/) is the leading showcase of beautiful One Page websites, templates and resources.
- [Admire the Web](https://www.admiretheweb.com/)
- [Pttrns](https://pttrns.com/)
- [CRAFTED BY LOVE](http://www.craftedbylove.com/#/)
- [HTTPSTER](https://httpster.net/)
- [Empty States](http://emptystat.es/)
- [Call to Idea](http://www.calltoidea.com/)
- [Siiimple](https://siiimple.com/)
- [Zurb PatternTap](http://zurb.com/patterntap)
- [Land Book](https://land-book.com/) created this place for Designers, Developers, Product Owners, Marketing Managers, Startupers, Freelancers and, really, for everyone who appreciates fine designs and well-crafted sites.
- [oozled](http://oozled.com/)
- [DESIGN DETAILS](http://www.brianlovin.com/design-details/)
- [officelovin](https://www.officelovin.com/) is an online platform about office architecture & design.
- [Best Website](https://bestwebsite.gallery/) The most beautiful websites handpicked for you — since 2008!
- [FreeDesignResources](http://freedesignresources.net/)
- [Abduzeedo](http://abduzeedo.com/)
- [Material UI](https://www.materialui.co)
- [1stwebdesigner](https://1stwebdesigner.com) By web design professionals, for web design professionals. We're on a mission to help you build a better web.
- [EMOJI CHEAT SHEET](https://www.webpagefx.com/tools/emoji-cheat-sheet/)
- [EMOJI CSS](https://afeld.github.io/emoji-css/?ref=webdesignernews.com)
- [DesignShock](https://www.designshock.com/) is the biggest bundle/subscription you can find in one place including icons, avatars, graphic elements, GUI packs, design sets and both web and print templates
- [SVG PORN](http://www.svgporn.com/)
- [Up](https://www.uplabs.com/) is the leading community of creatives, offering the best downloadable resources, every day.
- [Freebbble](http://freebbble.com/)
- [Baianat](https://www.baianat.com/resources/)
- [Graphberry](http://www.graphberry.com/) provide you with the creative graphic resources you need to transform into your personal or commercial work.
- [UX Project Checklist](http://uxchecklist.github.io/) 🌟
- [TRIDIV](http://tridiv.com/) is a web-based editor for creating 3D shapes in CSS.
- [Mobile Mozaic](http://www.mobilemozaic.com/)
- [wwwhere](http://wwwhere.io/)
- [Lapa](http://www.lapa.ninja/) is a gallery featuring the best 1920 landing page examples from around the web.
- [Designer Mill](https://www.designermill.com/)
- [Freebiesjedi](http://freebiesjedi.com)
- [Webfieldmanual](https://webfieldmanual.com/)
- [UXTOOLS](https://uxtools.co/)
- [CodeMyUI](https://codemyui.com/) Web Design & UI Inspiration with Code Snippets.
- [A List Apart](https://alistapart.com/) has been discussing design, development and meaning of web content since 1997 and remains a great resource for designers and programmers alike.

## Styleguide and Branding

- [Brand Style Guide Examples](https://saijogeorge.com/brand-style-guide-examples/)
- [Mozilla](https://www.mozilla.org/en-US/styleguide/)
- [Mailchimp](http://ux.mailchimp.com/patterns/)
- [Lonely Planet](http://rizzo.lonelyplanet.com/styleguide/design-elements/colours)
- [Starbucks](https://www.starbucks.com/static/reference/styleguide/)
- [Yelp](https://www.yelp.com/styleguide)
- [IBM](https://www.ibm.com/design/language/)
- [Uber](https://medium.com/uber-design)
- [Atlassian](https://www.atlassian.design/)
- [Dropbox](https://www.dropbox.com/branding)
- [Spotify](https://developer.spotify.com/design/)
- [Youtube](https://www.youtube.com/yt/about/brand-resources/)
- [Facebook - Brand Resource Center Book](https://en.facebookbrand.com/)
- [Vimeo](https://press.vimeo.com/brand-guidelines)
- [Ubuntu](http://design.ubuntu.com/)
- [BBC](http://www.bbc.co.uk/gel)
- [Channel4](http://styleguides.channel4.com/E4_StyleGuide.pdf)
- [Twitter](https://brand.twitter.com/)
- [Nike Pro](http://manualcreative.com/project/nike-pro-services/)
- [Medium](https://www.behance.net/gallery/7226653/Medium-Brand-Development)
- [Linkedin](https://brand.linkedin.com/)
- [Red Cross](http://www.redcross.org/images/MEDIA_CustomProductCatalog/m6440103_BrandPoster.pdf)
- [Marvel](https://marvelapp.com/styleguide/overview/introduction)
- [buffer](https://buffer.com/style-guide)
- [VSCO](http://vsco.co/id/journal/p/1)
- [Instagram](https://en.instagram-brand.com/)
- [WhatsApp](https://www.whatsappbrand.com/)
- [Snapchat](https://www.snapchat.com/brand-guidelines#general-usage-guidelines)
- [Atlassian](https://atlassian.design/)
- [Clarity](http://clarity.design)
- [Apple iOS](https://developer.apple.com/ios/human-interface-guidelines/)
- [Apple macOS](https://developer.apple.com/library/mac/documentation/UserExperience/Conceptual/OSXHIGuidelines/)
- [Google Trends](https://newslab.withgoogle.com/assets/docs/google-trends-guide.pdf)
- [Google Visual Assets Guidelines](https://www.behance.net/gallery/9028077/Google-Visual-Assets-Guidelines-Part-2)
- [Google Design for Glass](https://developers.google.com/glass/design/)
- [Google Material Design](https://material.io/guidelines/)
- [Microsoft Design](https://www.microsoft.com/en-us/design)
- [Microsoft Fluent Design System](http://fluent.microsoft.com/)
- [NASA 2011](https://sservi.nasa.gov/wp-content/uploads/2011/10/NASA_Style_Guide_v2.1.pdf)
- [NASA 1976](https://www.nasa.gov/sites/default/files/atoms/files/nasa_graphics_manual_nhb_1430-2_jan_1976.pdf)
- [Ant Design](http://ant.design) is a design system with values of Nature and Determinacy for better user experience of enterprise applications.
- [Audi](https://www.audi.com/ci/en/renewed-brand.html) Audi Corporate Identity Portal

## Tutorial

- [Lynda](https://www.lynda.com/) is a leading online learning platform that helps anyone learn business, software, technology and creative skills to achieve personal and professional goals. 🌟
- [CreativeLive](https://www.creativelive.com/)
- [DesignSchool](https://designschool.canva.com/) Anyone can make beautiful designs with Canva.
- [Envato Tuts+](https://tutsplus.com/) helps you learn creative skills and shape the life you want.
- [Udemy](https://www.udemy.com/courses/design/) The leading global marketplace for learning and instruction.
- [AboutCG](http://www.aboutcg.com/) 前身是 CG 共和国（CGGHG）, 是成立于2004年的计算机图形图像教学服务网站，也是国内最早的原创CG视频教学的制作者。
- [DevDojo](https://devdojo.com/)
- [Platzi](https://courses.platzi.com) Growth marketing Course.
- [greyscalegorilla](https://greyscalegorilla.com/)

## Book

- [Universal Principles of Design](https://www.amazon.com/Universal-Principles-Design-Revised-Updated/dp/1592535879/ref=sr_1_2?s=books&ie=UTF8&qid=1473096298&sr=1-2&keywords=Universal+Methods+of+Design)
- [Universal Methods of Design](https://www.amazon.com/Universal-Methods-Design-Innovative-Effective/dp/1592537561/ref=pd_sim_14_3?ie=UTF8&psc=1&refRID=2NG71RWR7MKGXE1B8GZ3)
- [Don't Make Me Think](https://www.amazon.com/gp/product/0321965515/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=0321965515&linkCode=as2&tag=office03a70-20&linkId=PF4EASLP4EM62N73)
- [About Face: The Essentials of Interaction Design](https://www.amazon.com/gp/product/1118766571/ref=as_li_qf_sp_asin_il_tl?ie=UTF8&camp=1789&creative=9325&creativeASIN=1118766571&linkCode=as2&tag=office03a70-20&linkId=I5TMKUXHZ43SHHPE)
- [How to Be a Graphic Designer without Losing Your Soul](https://www.amazon.com/Graphic-Designer-without-Losing-Expanded/dp/1568989830)
- [Simple and Usable Web, Mobile, and Interaction Design](https://www.amazon.com/gp/product/0321703545)
- [Lean UX: Applying Lean Principles to Improve User Experience](https://www.amazon.com/Lean-UX-Applying-Principles-Experience/dp/1449311652)
- [Designing Interfaces](https://www.amazon.com/Designing-Interfaces-Jenifer-Tidwell/dp/1449379702)
- [100 Things Every Designer Needs to Know About People](https://www.amazon.com/Things-Designer-People-Voices-Matter/dp/0321767535)
- [The UX Book: Process and Guidelines for Ensuring a Quality User Experience](https://www.amazon.com/UX-Book-Guidelines-Ensuring-Experience/dp/0123852412)
- [Thinking with Type](https://www.amazon.com/gp/product/1568989695/)
- [The Elements of Graphic Design](https://www.amazon.com/Elements-Graphic-Design-Second/dp/1581157622/)
- [Usability Matters: Mobile-first UX for developers and other accidental designers](https://www.manning.com/books/usability-matters)
- [Design for the Mind](https://www.manning.com/books/design-for-the-mind)

## Award

- [Good Design Award](http://www.g-mark.org/?locale=en) has been a sole comprehensive design evaluation and commendation system in Japan sin 1957.
- [Red Dot Award](http://en.red-dot.org/) stands for belonging to the best in design and business. It's international design competition, the “Red Dot Design Award”, is aimed at all those who would like to distinguish their business activities through design. 🌟
- [Apple Design Awards](https://developer.apple.com/design/awards/) is a special event hosted by Apple Inc. at its annual Worldwide Developers Conference. 🌟
- [iF Product Design Award](http://ifworlddesignguide.com/) was introduced in 1954 and is annually conferred by the iF International Forum Design. The award, which spans multiple disciplines, has more than 5,500 entries from around 59 nations every year. 🌟
- [FWA](https://thefwa.com/) to showcase cutting edge creativity, regardless of the medium or technology used.
- [CSS Design Awards](http://www.cssdesignawards.com/) is a web design & development award platform for digital folk, UI/UX peeps and inspiring leaders of the web.
- [CSS Awards](https://www.cssawards.net/) is a web designer/agency/studio inspiration gallery, where a high quality of CSS websites placed from around the world.
- [Creative AD Awards](http://www.creativeadawards.com/) Discover the Most Creative & Sophisticated Advertising Campaigns around the World.
- [D&AD](https://www.dandad.org/)
- [Awwwards](https://www.awwwards.com/) The awards for design, creativity and innovation on the Internet. 🌟
- [CSS Winner](http://www.csswinner.com/) is a unique global platform awarding and showcasing the best websites and promoting innovative web designers, developers and agencies.

## Conference and Festival

- [Uideo](https://uideo.net) talks for designers from 69 ux/ui conferences all over the world.
- [MAX](https://max.adobe.com/) Get inspired. Learn skills. Play.
- [The AIGA Design Conference](http://designconference.aiga.org/#!/)
- [SXSW](https://www.sxsw.com/) founded in 1987 in Austin, Texas, SXSW is best known for its conference and festivals that celebrate the convergence of the interactive, film, and music industries.
- [ICON9](http://www.theillustrationconference.org/) brings together top illustrators, designers, educators, representatives, and art buyers to explore the future of illustration.
- [Mirror](http://www.mirrorconf.com) is a conference designed to empower designers and front-end developers who have a thirst for knowledge and want to broaden their horizons.
- [Interaction](http://interaction16.ixda.org/)
- [Offset](http://www.iloveoffset.com/) has fast become one of the world’s most inspirational, educational and vocational conferences for the design and creative industries.
- [99U](http://conference.99u.com/) Adobe 99U Conference.
- [Typographics](http://typographics.com) is a multi-part event series foc­used on con­tempo­rary typo­graphy and where its future may lie.
- [Brand New Conference](http://underconsideration.com/brandnewconference/) is a two-day event organized by UnderConsideration.
- [How Design Live](http://www.howdesignlive.com/) is one of the largest annual gatherings of creative professionals in the world, HOW Design Live is a career-changing, life-altering experience.
- [Better by Design](http://betterbydesignconference.com/) is about conference & workshops.
- [What Design Can Do](http://www.whatdesigncando.com/) is an international platform on the impact of design.
- [Design and Content](https://www.designcontentconf.com/) The Conference for Designers & Content Strategists — we're better together.
- [generate](https://www.generateconf.com/) the award winning conference for web designers returns to NYC!
- [Typo International Design Talks](https://www.typotalks.com/) is where the world’s design experts speak
- [Service Design Days](http://servicedesigndays.com/)
- [SemiPermanent](https://www.semipermanent.com)
- [Dribbble Meetups](https://dribbble.com/meetups) are a chance for designers to socialize, talk shop, and foster their local design communities.
- [CreativeMornings](https://creativemornings.com/) is a breakfast lecture series for the creative community.
- [CodePen Meetups](https://blog.codepen.io/meetups/) for like-minded code people to hang out, do show-and-tell, and bask in the lovely culture that is front end.

## Podcast

- [99% INVISIBLE](http://99percentinvisible.org/)
- [Shop Talk](http://shoptalkshow.com/) is an internet radio show about the internet starring [Dave Rupert](http://daverupert.com/) and [Chris Coyier](http://chriscoyier.net/).
- [workmode](http://workmode.show/) is a podcast series about being a pro.
- [UX Podcast](http://uxpodcast.com/) is a twice-monthly digital design podcast sharing insights about business, technology and people since 2011.
- [Anyway.fm - 设计杂谈](http://anyway.fm/) 是一档播客节目，由 UI 设计师 JJ Ying 和 Leon Gao 主播，我们的目标是让你的听觉更懂视觉。
- [The Deeply Graphic Design](http://thedeependdesign.com/graphic-design-podcast/) The web + graphic design podcast that offsers both pratical and creative design advice you can use.
- [Tentative.fm](http://tentative.fm/) is a podcast about digital product design. Hosted by thoughtbot's Chief Design Officer Kyle Fiedler & Boston Design Director Jaclyn Perrone.
- [Pagebreak](http://www.pagebreakpodcast.com/) is an audio podcast hosted by [Liz Andrade](http://cmdshiftdesign.com/) and [Niki Brown](http://nikibrown.com/).
- [Design Matters](http://www.debbiemillman.com/designmatters/) The world's first podcast about design and an inquiry into the broader world of creative culture through wide-ranging conversations with designers, writers, artists, curators, musicians, and other luminaries of contemporary thought
- [The Greate Discontent Podcast](https://thegreatdiscontent.com/podcast) features in-depth conversations with today’s artists, makers, and risk-takers.
- [Design Details Podcast](https://spec.fm/podcasts/design-details) A weekly conversation about design process and culture.
- [Layout.fm](http://layout.fm/) A weekly podcast about design, technology, programming and everything else.
- [Type is Beautiful - 字谈字畅](https://itunes.apple.com/podcast/zi-tan-zi-chang/id1041704528) 是第一档用华语制作的字体排印主题播客节目，由 Eric Liu 与钱争予搭档主播。
- [Boagworld UX Show](https://boagworld.com/show/) Every Thursday Paul Boag and Marcus Lillington are joined by a variety of guests to discuss a range of web design related topics.
- [Responsive Web Design Podcast](https://responsivewebdesign.com/podcast/) Karen and Ethan interview the people who make responsive redesigns happen.
- [Adventures in Design](http://www.adventuresindesignmarket.com/)
- [The Hacking UI Podcast](http://hackingui.com/podcast/) is hosted by Sagi Shrieber and David Tintner, who are both a designer and developer as well as entrepreneurs, bloggers, productivity/time-hacker maniacs, and all around tech geeks.
- [CodePen Radio](https://blog.codepen.io/radio/) is a podcast all about what it's like running a small web software business. The good, the bad, and the ugly.
- [UX COFFEE - 设计咖](http://www.uxcoffee.com/) 设计无处不在。在这个节目里，我们试图探寻设计的力量、这个世界被创造的过程、以及参与设计了这个世界的人们。主播：Riceman、Hoka、帆啊帆、张挠挠。

## Community

- [Dribbble](https://dribbble.com/) Show and tell for designers. 🌟
- [Behance](https://www.behance.net/) Showcase and discover the latest work from top online portfolios by creative professionals across industries. 🌟
- [Medium](https://medium.com/) is a place to read, write, and interact with the stories that matter most to you. 🌟
- [Fribbble](http://www.fribbble.com/) Free PSD files and other free design resources by Dribbblers.
- [DeviantArt](http://www.deviantart.com/) The largest online art gallery and community.
- [CARGO](https://2.cargocollective.com)
- [tumblr](https://www.tumblr.com/) Come for what you love. Stay for what you discover.

## Contributors

Thank you for contributing to AwesomeDesign.

[![contributors](https://opencollective.com/awesome-design/contributors.svg?width=890&button=false)](https://github.com/gztchan/awesome-design/graphs/contributors)

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Tony Chan](https://github.com/gztchan) has waived all copyright and related or neighboring rights to this work.
