## Booting Composite kernel on Bare-metal (x86)

[Composite](http://http://composite.seas.gwu.edu/) kernel can be booted up from any bootloader that supports [Multiboot specification](https://www.gnu.org/software/grub/manual/multiboot/multiboot.html).

Procedure (from *transfer* directory):
* Run *geniso.sh* script: This generates **composite.iso** bootable CD-ROM image.
* Run *qemu-iso.sh* script to execute *composite.iso* in [Qemu](http://wiki.qemu.org/Main_Page) emulator.
* To Boot *composite.iso* on Bare metal:
	* Burn this image in to a USB: `sudo dd if=composite.iso of=/dev/sdX bs=8M`
	* Reboot PC and select USB as Bootable device from BIOS.

This is the most straight forward and less tedious way to boot on Bare metal.

**NOTES**
* If you're not running Composite on baremetal, you don't need to generate a ISO image to run.
  Instead, you could just run it using QEMU emulation -- `./qemu.sh <runscript>` in your `transfer/` directory.
* `geniso.sh` may fail if you've an outdated `xorriso` version. Be sure to check the logs and update your `xorriso` package. example error log:
   ```
   $ ./geniso.sh micro_boot.sh 
   grub-mkrescue: warning: Your xorriso doesn't support `--grub2-boot-info'. Some features are disabled. Please use xorriso 1.2.9 or later..
   ```

## Working with Grub bootloaders on the Host PC Disk
**(I've not tested these with the latest Composite kernel.)**
These are just some leads that you can use if you don't have Flash drive or would rather boot from Disk.

### Grub-legacy

In order to boot from Grub-legacy, do the following:

* Add an entry in to the /boot/grub/menu.lst.

```
title 	Composite kernel
	kernel	/boot/co_kernel.img
    module	/boot/40800000-40800870
    quiet
```
* After this is done, save menu.lst and reboot the PC.
* Select 'Composite kernel' from Grub-legacy bootloader.

### Grub2

In order to boot from Grub2, do the following:

* Add an entry in to the /etc/grub.d/40_custom.

```
menuentry "Composite kernel" {
	multiboot	/boot/co_kernel.img
    module	/boot/40800000-40800870 /boot/40800000-40800870
    boot
}
```
* Update grub: `sudo update-grub`. Reboot the PC.
* Select 'Composite kernel' from Grub2 bootloader.

**Note: ** For this to work, there is some work to do in Composite src ;)

	1. You have to copy the composite kernel image and the module to /boot/.
	2. You may need to rename your kernel.img or edit 'kernel' line above to match what you've.
	3. You have to make sure that the name of the module in Grub config file is same as module generated by 'micro_boot.sh'.


### Debug: Console or VGA

You can see the Logs on VGA but is not something that you'd really want to work with because VGA buffer is **25rows * 80 cols** which limits the display to most recent 25 lines of logs and the log rotates.

### Debug: Serial

Good news, we found some [Null-Modem RS232 Serial cables](https://www.amazon.com/StarTech-com-USB-Serial-Adapter-Modem/dp/B008634VJY/ref=pd_cp_147_2?_encoding=UTF8&pd_rd_i=B008634VJY&pd_rd_r=HKWQ429M9PDSE567JMVT&pd_rd_w=xvaFb&pd_rd_wg=QJsOn&psc=1&refRID=HKWQ429M9PDSE567JMVT) that work for serial communication between two intel PCs.

If you've a UNIX-based machine, you could use `minicom` to see the serial output from Composite running on baremetal on your host machine.

To get minicom working with the RS232 Serial to USB cables, you'd need to change the serail port to: `/dev/ttyUSB0` ideally using `minicom -s`. (You should verify this device from the `dmesg` output to be sure you're using the right port).
Next, you'd need to set up the baudrate to match what composite uses (38400bps).
To see the logs correctly, you'd need to set the linefeed, carriage return, and linewrap to "Yes".

The contents of my minicom config file `minirc.dfl`:
```
# Machine-generated file - use "minicom -s" to change parameters.
pu port             /dev/ttyUSB0
pu baudrate         38400
pu histlines        5000
pu addlinefeed      Yes
pu linewrap         Yes
pu addcarreturn     Yes

```
I've also set to have the maximum number of history lines, which is not a necessity.
