### Summary of this Pull Request (PR)

**Add description here.**

### Intent for your PR

Choose one (Mandatory):

- [ ] This PR is for a code-review and is intended to get feedback, but not to be pulled yet.
- [ ] This PR is mature, and ready to be integrated into the repo.

### Reviewers (Mandatory):
(Specify @<github.com username(s)> of the reviewers. Ex: @user1, @user2)


### Code Quality

As part of this pull request, I've considered the following:

[Style](https://github.com/gparmer/composite/raw/ppos/doc/style_guide/composite_coding_style.pdf):

- [ ] Comments adhere to the Style Guide (SG)
- [ ] Spacing adhere's to the SG
- [ ] Naming adhere's to the SG
- [ ] All other aspects of the SG are adhered to, or exceptions are justified in this pull request
- [ ] I have run the auto formatter on my code before submitting this PR (see doc/auto_formatter.md for instructions)

[Code Craftsmanship](http://www2.seas.gwu.edu/~gparmer/posts/2016-03-07-code-craftsmanship.html):

- [ ] I've made an attempt to remove all redundant code
- [ ] I've considered ways in which my changes might impact existing code, and cleaned it up
- [ ] I've formatted the code in an effort to make it easier to read (proper error handling, function use, etc...)
- [ ] I've commented appropriately where code is tricky
- [ ] I agree that there is no "throw-away" code, and that code in this PR is of high quality

### Testing

I've tested the code using the following test programs (provide list here):

- [ ] micro_booter
- [ ] unit_pingpong
- [ ] unit_schedtests
- [ ] ...(add others here)
