﻿using Dollet.Core.Entities;

namespace Dollet.Core.Abstractions.Repositories
{
    public interface IAccountRepository
    {
        Task<Account?> GetAsync(int id);
        Task<Account?> GetDefaultAsync();
        Task<IEnumerable<Account>> GetAllAsync();
        Task<bool> ExistsAsync();
        void Add(Account account);
        void Delete(Account account);
        void Update(Account account);
    }
}
