import { connectToDB } from "@utils/database";
import Prompt from "@models/prompt";

//backend api route to create new post/prompt

export const POST = async (req) => {
  const { userId, prompt, tag } = await req.json();
  try {
    await connectToDB();
    const newPrompt = new Prompt({
      creator: userId,
      prompt,
      tag,
    });

    await newPrompt.save();

    return new Response(
      JSON.stringify(newPrompt, {
        status: 201,
      })
    );
  } catch (err) {
    console.log(err);
    return new Response("Failed to create a new prompt", { status: 500 });
  }
};
