/**
 * MIT License
 *
 * Copyright (c) 2016-2018 Angel Leon, Alden Torres
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


//
// Created by gubatron on 11/16/16.
//

#include "key.hpp"
#include <iostream>

namespace yuca {
    bool Key::operator<(const Key &right_side) const {
        return id < right_side.id;
    }

    bool Key::operator<=(const Key &right_side) const {
        return id <= right_side.id;
    }

    bool Key::operator>(const Key &right_side) const {
        return id > right_side.id;
    }

    bool Key::operator>=(const Key &right_side) const {
        return id >= right_side.id;
    }

    bool Key::operator==(const Key &other) const {
        return id == other.id && group == other.group;
    }

    std::string Key::getGroup() const {
        return group;
    }

    long Key::getId() const {
        return id;
    }

    std::ostream &operator<<(std::ostream &output_stream, Key &key) {
        output_stream << "Key(@" << (long(&key) % 10000) << ", id=" << key.id << ", group=" << key.group << ")";
        output_stream.flush();
        return output_stream;
    }

    std::ostream &operator<<(std::ostream &output_stream, StringKey &key) {
        output_stream << "StringKey(@" << (long(&key) % 10000) << ", str_key=\"" << key.str_key << "\", id=" << key.id
                      << ", group=" << key.group << ")";
        output_stream.flush();
        return output_stream;
    }
}
