/* eslint-disable max-len */
/* If SVGs are updated, remember to keep props. */
import React from "react";

export const LegacyTextIcon: React.FunctionComponent<React.ComponentProps<"svg">> = (
    props: React.ComponentProps<"svg">
) => (
    <svg
        {...props}
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0_5250_851)">
            <circle cx="16" cy="16" r="16" className="ids-option-button__icon-circle" />
            <path
                d="M23.963 26.0296C25.03 26.0296 24.2124 10.0177 24.0067 6.27549C23.9825 5.83494 23.6247 5.5 23.1834 5.5L8.65899 5.50005C6.65998 5.50007 7.85352 22.788 7.85352 25.3092C7.85352 27.4703 22.7548 26.0296 23.963 26.0296Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M15.5358 11.2583C13.4703 11.2877 11.5563 11.3885 11.1234 11.4607C10.7148 11.5288 10.3284 11.2527 10.2603 10.8442C10.1922 10.4356 10.4682 10.0492 10.8768 9.98107C11.4439 9.88655 13.48 9.78738 15.5144 9.75844C16.5465 9.74375 17.6038 9.74678 18.5082 9.77915C19.3876 9.81064 20.1947 9.87143 20.682 9.99325C21.0839 10.0937 21.3282 10.5009 21.2277 10.9028C21.1273 11.3046 20.7201 11.5489 20.3182 11.4485C20.0055 11.3703 19.3501 11.3103 18.4545 11.2782C17.584 11.247 16.5537 11.2438 15.5358 11.2583Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20.3768 16.2398C17.4672 15.7549 15.043 15.7505 11.0931 16.2442C10.6821 16.2956 10.3072 16.004 10.2559 15.593C10.2045 15.182 10.496 14.8071 10.9071 14.7558C14.9571 14.2495 17.533 14.2452 20.6234 14.7602C21.0319 14.8283 21.308 15.2147 21.2399 15.6233C21.1718 16.0319 20.7854 16.3079 20.3768 16.2398Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M14.7057 20.2437C13.0994 20.2798 11.5633 20.3874 11.147 20.4716C10.741 20.5537 10.3453 20.2912 10.2632 19.8852C10.1811 19.4792 10.4436 19.0835 10.8496 19.0014C11.4189 18.8862 13.0906 18.7796 14.672 18.7441C15.4776 18.7259 16.2896 18.7256 16.9636 18.754C17.3 18.7682 17.6116 18.7899 17.8755 18.822C18.1196 18.8516 18.39 18.8972 18.6031 18.9843C18.9865 19.1412 19.1701 19.5791 19.0133 19.9625C18.8565 20.3458 18.4186 20.5295 18.0352 20.3727C18.0356 20.3729 18.0355 20.3728 18.0348 20.3726C18.0305 20.3711 18.0042 20.3623 17.9462 20.3503C17.883 20.3372 17.7996 20.3238 17.6947 20.311C17.4846 20.2855 17.2158 20.266 16.9004 20.2527C16.2708 20.2261 15.494 20.226 14.7057 20.2437Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M8.27614 12.5686C8.29077 13.3727 8.30604 14.2119 8.30606 15.0696C8.30609 17.4809 8.30618 19.7263 8.36854 21.5679C8.42383 23.2007 8.52714 24.4356 8.69522 25.1787C8.81252 25.2193 8.98242 25.2678 9.21711 25.318C9.64611 25.4096 10.2034 25.4893 10.8607 25.5543C12.1731 25.684 13.8294 25.75 15.5429 25.75C17.2552 25.75 19.0097 25.6841 20.517 25.5534C21.8058 25.4417 22.864 25.2863 23.5583 25.1018C23.5865 24.9612 23.6163 24.7685 23.6429 24.515C23.6938 24.029 23.7258 23.402 23.7405 22.6606C23.77 21.1795 23.7297 19.2894 23.6482 17.2528C23.4972 13.4812 23.2061 9.24315 22.9646 6.25H9.06538C8.97554 6.25 8.92757 6.27219 8.88543 6.30522C8.83102 6.34787 8.75019 6.44003 8.66434 6.63052C8.48576 7.02682 8.3659 7.66299 8.30421 8.54296C8.22378 9.69028 8.24885 11.0682 8.27614 12.5686ZM7.96007 5.12467C8.27561 4.87733 8.65213 4.75 9.06538 4.75H23.6555C24.0455 4.75 24.3705 5.04893 24.4029 5.43759C24.6551 8.4571 24.9829 13.0938 25.147 17.1928C25.229 19.241 25.2705 21.1654 25.2402 22.6904C25.2251 23.4519 25.1918 24.1258 25.1347 24.6713C25.0809 25.1847 24.9977 25.6827 24.8366 26.0233C24.751 26.2042 24.5966 26.3434 24.4078 26.4099C23.5554 26.7102 22.1821 26.9147 20.6466 27.0478C19.0881 27.183 17.2895 27.25 15.5429 27.25C13.7975 27.25 12.0893 27.1831 10.7132 27.047C10.0263 26.9791 9.40832 26.8926 8.90382 26.7849C8.43294 26.6843 7.95202 26.5445 7.62722 26.3157C7.49288 26.221 7.39334 26.0849 7.34391 25.9282C7.05634 25.0165 6.93167 23.4577 6.8694 21.6187C6.80613 19.75 6.80609 17.4817 6.80606 15.084L6.80606 15.0696C6.80604 14.285 6.79168 13.4831 6.77757 12.6947C6.74983 11.1454 6.72302 9.64853 6.80788 8.43806C6.87199 7.52372 7.0037 6.66464 7.29679 6.01425C7.44678 5.68141 7.65681 5.36238 7.96007 5.12467Z"
                fill="currentColor"
            />
        </g>
        <defs>
            <clipPath id="clip0_5250_851">
                <rect width="32" height="32" fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export const LegacyOptionScaleIcon: React.FunctionComponent<
React.ComponentProps<"svg">
> = (props: React.ComponentProps<"svg">) => (
    <svg
        {...props}
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0_5250_1132)">
            <circle cx="16" cy="16" r="16" className="ids-option-button__icon-circle" />
            <path
                d="M6.98339 17.6064H2.04443V13.9106H7.17845C8.25654 8.08379 12.5266 6.76405 14.7272 6.87987C19.6238 6.87987 21.7563 7.68064 24.1566 12.8653C24.3184 13.2147 24.4569 13.5635 24.5735 13.9106H30.1554V17.6064H25.0354C24.762 20.8704 22.702 23.5585 20.1999 24.5462C16.785 25.8941 7.73452 25.3916 6.98339 17.6064Z"
                fill="white"
            />
            <path
                d="M16.6306 13.0583C16.6306 12.6441 16.2949 12.3083 15.8806 12.3083C15.4664 12.3083 15.1306 12.6441 15.1306 13.0583V18.9416C15.1306 19.3558 15.4664 19.6916 15.8806 19.6916C16.2949 19.6916 16.6306 19.3558 16.6306 18.9416V13.0583Z"
                fill="currentColor"
            />
            <path
                d="M12.735 14.0521C12.735 13.6379 12.3992 13.3021 11.985 13.3021C11.5707 13.3021 11.235 13.6379 11.235 14.0521V17.9478C11.235 18.362 11.5707 18.6978 11.985 18.6978C12.3992 18.6978 12.735 18.362 12.735 17.9478V14.0521Z"
                fill="currentColor"
            />
            <path
                d="M20.0148 13.4214C20.429 13.4214 20.7648 13.7572 20.7648 14.1714V17.8286C20.7648 18.2428 20.429 18.5786 20.0148 18.5786C19.6006 18.5786 19.2648 18.2428 19.2648 17.8286V14.1714C19.2648 13.7572 19.6006 13.4214 20.0148 13.4214Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M9.5895 7.9463C11.3356 6.48626 13.3648 6.0623 14.7463 6.12984C17.1988 6.13084 19.1297 6.32593 20.7577 7.2815C22.4008 8.24592 23.6152 9.91058 24.8372 12.5502C24.9315 12.7538 25.0184 12.9573 25.0983 13.1606H27.82C28.9722 13.1606 29.7606 13.5937 30.2197 14.2811C30.6415 14.9126 30.7054 15.6443 30.7054 16.1115C30.7054 16.6838 30.5142 17.3602 30.0421 17.905C29.5512 18.4713 28.8046 18.8392 27.82 18.8392H25.6111C24.9767 21.8451 22.941 24.2704 20.4753 25.2437C18.47 26.0353 14.8395 26.2244 11.7488 24.9906C10.1847 24.3663 8.72249 23.3632 7.68624 21.8512C7.10001 20.9959 6.66249 19.9956 6.41501 18.8393H4.17979C3.19522 18.8393 2.44857 18.4714 1.95772 17.905C1.48555 17.3602 1.29443 16.6838 1.29443 16.1116C1.29443 15.6444 1.35832 14.9126 1.78005 14.2812C2.23915 13.5938 3.02763 13.1606 4.17979 13.1606H6.56925C7.13516 10.7365 8.25951 9.05841 9.5895 7.9463ZM25.8048 17.3392H27.82C28.4024 17.3392 28.7235 17.1361 28.9085 16.9226C29.1123 16.6875 29.2054 16.3751 29.2054 16.1115C29.2054 15.743 29.1461 15.3743 28.9724 15.1142C28.836 14.9101 28.5568 14.6606 27.82 14.6606H25.5639C25.7736 15.5744 25.8473 16.4732 25.8048 17.3392ZM6.20118 15.8668C6.17503 16.3794 6.17844 16.87 6.20942 17.3393H4.17979C3.59736 17.3393 3.27633 17.1362 3.09125 16.9226C2.8875 16.6876 2.79443 16.3751 2.79443 16.1116C2.79443 15.7431 2.85373 15.3744 3.02743 15.1143C3.16376 14.9101 3.44296 14.6606 4.17979 14.6606H6.30508C6.25748 15.0468 6.22251 15.4487 6.20118 15.8668ZM7.69923 15.9432C7.88239 12.3532 9.14463 10.2736 10.5517 9.09701C11.9814 7.90149 13.6373 7.57352 14.6878 7.6288L14.7075 7.62984H14.7272C17.1623 7.62984 18.7402 7.83661 19.9984 8.57512C21.2458 9.30726 22.2978 10.6353 23.476 13.1804C25.6962 17.9759 23.1697 22.5675 19.9245 23.8485C18.2814 24.4971 15.047 24.6921 12.3049 23.5975C10.9527 23.0578 9.75653 22.2186 8.92353 21.0032C8.09452 19.7936 7.58638 18.1552 7.69923 15.9432Z"
                fill="currentColor"
            />
        </g>
        <defs>
            <clipPath id="clip0_5250_1132">
                <rect width="32" height="32" fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export const LegacyMultipleChoiceIcon: React.FunctionComponent<
React.ComponentProps<"svg">
> = (props: React.ComponentProps<"svg">) => (
    <svg
        {...props}
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0_5250_1169)">
            <circle cx="16" cy="16" r="16" className="ids-option-button__icon-circle" />
            <path
                d="M23.963 26.0296C25.03 26.0296 24.2124 10.0177 24.0067 6.27549C23.9825 5.83494 23.6247 5.5 23.1834 5.5L8.65899 5.50005C6.65998 5.50007 7.85352 22.788 7.85352 25.3092C7.85352 27.4703 22.7548 26.0296 23.963 26.0296Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.7988 10.258C16.9085 10.2861 16.0918 10.3826 15.6234 10.4607C15.2148 10.5288 14.8284 10.2528 14.7603 9.84418C14.6922 9.4356 14.9682 9.04918 15.3768 8.98109C15.9085 8.89248 16.7918 8.78902 17.7515 8.75875C18.7013 8.7288 19.7823 8.76834 20.682 8.99327C21.0839 9.09374 21.3282 9.50094 21.2277 9.90278C21.1273 10.3046 20.7201 10.549 20.3182 10.4485C19.6179 10.2734 18.6989 10.2296 17.7988 10.258Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.5327 16.5374C17.4715 16.5659 16.3182 16.6639 15.5829 16.7456C15.1712 16.7913 14.8004 16.4947 14.7547 16.083C14.7089 15.6713 15.0056 15.3005 15.4172 15.2547C16.182 15.1698 17.3786 15.0678 18.4925 15.0379C19.0484 15.023 19.5978 15.0256 20.0686 15.06C20.5028 15.0916 20.9889 15.1561 21.3355 15.3293C21.706 15.5146 21.8561 15.9651 21.6709 16.3356C21.4856 16.7061 21.0351 16.8562 20.6647 16.671C20.6649 16.6711 20.6607 16.669 20.6507 16.6652C20.6408 16.6614 20.6269 16.6566 20.6084 16.6511C20.5708 16.6399 20.5206 16.6276 20.4562 16.6154C20.3264 16.5909 20.1601 16.5706 19.9596 16.556C19.5586 16.5268 19.0642 16.5231 18.5327 16.5374Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M18.3207 22.2582C17.2909 22.2866 16.2405 22.3843 15.5931 22.4652C15.1821 22.5166 14.8072 22.225 14.7559 21.814C14.7045 21.403 14.996 21.0282 15.4071 20.9768C16.093 20.891 17.1926 20.7887 18.2794 20.7588C19.3268 20.7299 20.4951 20.7621 21.2372 21.0095C21.6302 21.1405 21.8426 21.5652 21.7116 21.9582C21.5806 22.3511 21.1559 22.5635 20.7629 22.4325C20.3051 22.2799 19.39 22.2287 18.3207 22.2582Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.7178 16.8401C11.817 16.8328 12.0211 16.794 12.2269 16.6122C12.218 16.6201 12.263 16.5822 12.3187 16.5067C12.3725 16.4336 12.4207 16.3472 12.4564 16.2522C12.464 16.2321 12.471 16.2116 12.4774 16.1908C12.4875 16.1578 12.4949 16.1277 12.5003 16.1017C12.5065 16.0716 12.5101 16.0469 12.5121 16.0294C12.4914 15.8069 12.4175 15.6527 12.3789 15.5826C12.3304 15.4947 12.2826 15.4404 12.2546 15.412C12.2056 15.3622 12.1381 15.3109 12.0268 15.275C11.9081 15.2366 11.6325 15.1884 11.3237 15.3455C11.2708 15.3724 11.2243 15.4015 11.1836 15.4314C10.98 15.5811 10.9203 15.75 10.9186 15.7553C10.8941 15.8313 10.87 15.9799 10.9112 16.1602C10.9249 16.22 10.9457 16.2833 10.9761 16.3486C11.0893 16.5919 11.2686 16.72 11.3873 16.7766C11.5012 16.8309 11.6116 16.8479 11.7178 16.8401ZM13.6963 15.0835C13.9417 15.6111 13.9355 16.1756 13.7733 16.6777C13.6093 17.1852 13.2786 17.7169 12.6838 18.0194C12.0977 18.3175 11.5129 18.2617 11.1043 18.1296C10.7032 18 10.3652 17.7691 10.1165 17.5164C9.91792 17.3146 9.5427 16.861 9.51879 16.2115C9.51861 16.2065 9.51841 16.2013 9.51821 16.196C9.51182 16.0261 9.49849 15.6715 9.60968 15.3097C9.75478 14.8374 10.039 14.542 10.2404 14.3641C10.9986 13.6941 12.024 13.7566 12.6785 14.0687C13.059 14.2501 13.4597 14.5747 13.6963 15.0835Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M10.5886 10.8046C10.6067 10.8268 10.685 10.9219 10.8359 11.0165C10.9521 11.0892 11.1825 11.1779 11.467 11.1395C11.5295 11.131 11.5947 11.1164 11.6618 11.0941C11.9975 10.9827 12.1367 10.7599 12.1654 10.7067L12.0248 10.631C12.0248 10.631 12.0248 10.631 12.0248 10.631L12.1654 10.7067C12.1798 10.6799 12.1934 10.6487 12.2035 10.5996C12.2124 10.5561 12.2352 10.4175 12.1809 10.2267C12.1167 10.0013 11.9673 9.78967 11.7606 9.65739C11.742 9.64547 11.724 9.63492 11.7069 9.62556L12.4281 8.47381C12.8339 8.72796 13.0734 9.10836 13.1908 9.32627C13.3327 9.58977 13.4624 9.92968 13.5084 10.3053C13.5511 10.654 13.5463 11.2728 13.1122 11.8229C12.6325 12.4307 11.9392 12.5749 11.4098 12.5536C11.0058 12.5372 10.5531 12.4464 10.1433 12.1841C9.70309 11.9023 9.42173 11.4915 9.29551 11.0481C9.07738 10.282 9.35548 9.59715 9.52409 9.2841C9.73446 8.89349 10.1112 8.44781 10.717 8.24677C11.3597 8.0335 11.9742 8.1896 12.4281 8.47381L11.7069 9.62556C11.6244 9.5806 11.5603 9.56352 11.5309 9.55758C11.5271 9.55682 11.5239 9.55625 11.5213 9.55582C11.4368 9.55548 11.0642 9.58434 10.7662 9.95308C10.7632 9.9568 10.7602 9.96055 10.7572 9.96433C10.49 10.3029 10.5256 10.6286 10.5306 10.6696C10.5356 10.7106 10.543 10.7328 10.5445 10.7371C10.5463 10.7424 10.5475 10.7451 10.5495 10.7489L10.5496 10.749C10.551 10.7515 10.5616 10.7714 10.5886 10.8046ZM11.5132 9.55473C11.5132 9.55469 11.5146 9.55482 11.5173 9.5552C11.5145 9.55495 11.5131 9.55476 11.5132 9.55473Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.1398 20.9524C11.1188 20.9798 11.0435 21.0806 10.9878 21.2521C10.9478 21.3749 10.9265 21.5771 10.9992 21.7969C11.0193 21.8574 11.0464 21.9192 11.0823 21.9811C11.113 22.0342 11.1459 22.0799 11.1792 22.1193C11.216 22.1706 11.2578 22.21 11.3033 22.239C11.3859 22.3036 11.4563 22.3322 11.4831 22.3413L11.4961 22.3032L11.4831 22.3413C11.5046 22.3486 11.5344 22.357 11.5858 22.3586C11.6296 22.3599 11.7869 22.3595 11.9837 22.257C12.2052 22.1415 12.3764 21.9469 12.4618 21.7314C12.4677 21.7165 12.4733 21.7015 12.4783 21.6863C12.5052 21.6064 12.5138 21.5435 12.5163 21.5051C12.5168 21.4963 12.5171 21.4888 12.5171 21.4827C12.5031 21.434 12.4589 21.3097 12.346 21.1772C12.3061 21.1236 12.2555 21.0755 12.1949 21.0336C12.1509 20.9996 12.1011 20.9666 12.0449 20.936C12.0207 20.9228 11.9968 20.9109 11.9732 20.9001C11.6372 20.7466 11.3602 20.821 11.2982 20.8411C11.2218 20.8657 11.1967 20.8899 11.1945 20.892C11.1944 20.892 11.1944 20.8921 11.1943 20.8921C11.1892 20.8966 11.1689 20.9145 11.1398 20.9524ZM12.5164 21.463C12.5165 21.463 12.5167 21.4651 12.5169 21.4689C12.5165 21.4649 12.5164 21.4629 12.5164 21.463ZM10.6104 23.5708C9.95574 23.2144 9.67612 22.5884 9.57651 22.0705C9.4989 21.6669 9.47788 21.1967 9.63488 20.7299C9.80664 20.2193 10.1548 19.8272 10.5967 19.5968C11.3463 19.206 12.1169 19.3881 12.4489 19.501C12.885 19.6493 13.3703 19.9459 13.678 20.477C14.0017 21.0357 14.012 21.6531 13.8407 22.1798C13.6871 22.6523 13.3611 22.9839 13.1606 23.1579C12.9231 23.364 12.6016 23.5726 12.2207 23.6957C11.8524 23.8147 11.2332 23.9099 10.6104 23.5708Z"
                fill="currentColor"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M8.27614 12.5686C8.29077 13.3727 8.30604 14.2119 8.30606 15.0696C8.30609 17.4809 8.30618 19.7263 8.36854 21.5679C8.42383 23.2007 8.52714 24.4356 8.69522 25.1787C8.81252 25.2193 8.98242 25.2678 9.21711 25.318C9.64611 25.4096 10.2034 25.4893 10.8607 25.5543C12.1731 25.684 13.8294 25.75 15.5429 25.75C17.2552 25.75 19.0097 25.6841 20.517 25.5534C21.8058 25.4417 22.864 25.2863 23.5583 25.1018C23.5865 24.9612 23.6163 24.7685 23.6429 24.515C23.6938 24.029 23.7258 23.402 23.7405 22.6606C23.77 21.1795 23.7297 19.2894 23.6482 17.2528C23.4972 13.4812 23.2061 9.24315 22.9646 6.25H9.06538C8.97554 6.25 8.92757 6.27219 8.88543 6.30522C8.83102 6.34787 8.75019 6.44003 8.66434 6.63052C8.48576 7.02682 8.3659 7.66299 8.30421 8.54296C8.22378 9.69028 8.24885 11.0682 8.27614 12.5686ZM7.96007 5.12467C8.27561 4.87733 8.65213 4.75 9.06538 4.75H23.6555C24.0455 4.75 24.3705 5.04893 24.4029 5.43759C24.6551 8.4571 24.9829 13.0938 25.147 17.1928C25.229 19.241 25.2705 21.1654 25.2402 22.6904C25.2251 23.4519 25.1918 24.1258 25.1347 24.6713C25.0809 25.1847 24.9977 25.6827 24.8366 26.0233C24.751 26.2042 24.5966 26.3434 24.4078 26.4099C23.5554 26.7102 22.1821 26.9147 20.6466 27.0478C19.0881 27.183 17.2895 27.25 15.5429 27.25C13.7975 27.25 12.0893 27.1831 10.7132 27.047C10.0263 26.9791 9.40832 26.8926 8.90382 26.7849C8.43294 26.6843 7.95202 26.5445 7.62722 26.3157C7.49288 26.221 7.39334 26.0849 7.34391 25.9282C7.05634 25.0165 6.93167 23.4577 6.8694 21.6187C6.80613 19.75 6.80609 17.4817 6.80606 15.084L6.80606 15.0696C6.80604 14.285 6.79168 13.4831 6.77757 12.6947C6.74983 11.1454 6.72302 9.64853 6.80788 8.43806C6.87199 7.52372 7.0037 6.66464 7.29679 6.01425C7.44678 5.68141 7.65681 5.36238 7.96007 5.12467Z"
                fill="currentColor"
            />
        </g>
        <defs>
            <clipPath id="clip0_5250_1169">
                <rect width="32" height="32" fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export const LegacyLikertIcon: React.FunctionComponent<
React.ComponentProps<"svg">
> = (props: React.ComponentProps<"svg">) => (
    <svg
        {...props}
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0_10101_20294)">
            <circle cx="16" cy="16" r="16" className="ids-option-button__icon-circle" />
            <path
                d="M6 17.7601L6.21611 13.7108C7.41054 7.32656 12.1414 5.88058 14.5795 6.00747C20.0045 6.00747 22.3671 6.88485 25.0264 12.5655C25.2056 12.9483 25.3591 13.3304 25.4883 13.7108L26 17.7601C25.6971 21.3363 23.4148 24.2816 20.6427 25.3637C16.8593 26.8406 6.83219 26.29 6 17.7601Z"
                fill="white"
            />
            <path
                d="M30.4861 3L15.6129 21.0849L10.0903 14.8"
                stroke="currentColor"
                strokeWidth="1.5"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
            <path
                d="M21.6682 7.72961C20.2412 6.27698 17.6443 6.17441 16.2636 6.04412C14.5746 5.88476 12.9662 6.17695 11.5989 6.60191C10.2317 7.02687 7.20243 9.31108 6.45181 12.7905C5.70118 16.27 5.53587 20.8007 8.78411 23.4679C12.6981 26.6817 19.9429 26.7173 22.6773 24.2471C24.8648 22.271 25.6579 20.1823 25.8699 18.7929C26.0819 17.4036 26.0877 15.2098 25.4817 13.5441"
                stroke="currentColor"
                strokeWidth="1.5"
                strokeLinecap="round"
                strokeLinejoin="round"
            />
        </g>
        <defs>
            <clipPath id="clip0_10101_20294">
                <rect width="32" height="32" fill="white" />
            </clipPath>
        </defs>
    </svg>
);


export const TextIcon: React.FunctionComponent<React.ComponentProps<"svg">> = (
    props: React.ComponentProps<"svg">
) => (
    <svg 
        {...props} 
        xmlns="http://www.w3.org/2000/svg" 
        width="40" 
        height="40" 
        fill="none" 
        viewBox="0 0 40 40"
    >
        <path className="ids-option-button__icon-circle" d="M0 20C0 8.954 8.954 0 20 0s20 8.954 20 20-8.954 20-20 20S0 31.046 0 20Z" />
        <path fill="currentColor" d="M12.828 7a2 2 0 0 0-1.414.586L9.586 9.414A2 2 0 0 0 9 10.828V31a2 2 0 0 0 2 2h16.172a2 2 0 0 0 1.414-.586l1.828-1.828A2 2 0 0 0 31 29.172V9a2 2 0 0 0-2-2H12.828Z" />
        <path fill="#fff" fillRule="evenodd" d="M13 8.25h16a.75.75 0 0 1 .75.75v20a.75.75 0 0 1-.75.75H13a.75.75 0 0 1-.75-.75V9a.75.75 0 0 1 .75-.75Zm14 4.375H15v-1.25h12v1.25Zm-12 4h12v-1.25H15v1.25Zm12 4H15v-1.25h12v1.25Zm-12 4h7v-1.25h-7v1.25Z" clipRule="evenodd" />
    </svg>

);

export const OptionScaleIcon: React.FunctionComponent<
React.ComponentProps<"svg">
> = (props: React.ComponentProps<"svg">) => (
    <svg 
        {...props} 
        xmlns="http://www.w3.org/2000/svg" 
        width="40" 
        height="40" 
        fill="none" 
        viewBox="0 0 40 40"
    >
        <path className="ids-option-button__icon-circle" d="M0 20C0 8.954 8.954 0 20 0s20 8.954 20 20-8.954 20-20 20S0 31.046 0 20Z" />
        <path fill="currentColor" d="M31.928 24.179c-.713 1.557-1.765 2.942-3.107 4.178-2.45 2.658-5.943 4.643-9.75 4.643-5.54 0-10.21-3.733-11.628-8.821h-2.3a2.321 2.321 0 0 1-2.322-2.322V20c0-.97.64-1.6 1.323-2.273a9.63 9.63 0 0 0 .608-.63c.499-.555 1.146-1.276 2.248-1.276h1.138c.63-1.26 1.504-2.427 2.576-3.714 1.505-1.806 3.29-3.168 5.223-4.03a12.153 12.153 0 0 1 7.024-.907 12.046 12.046 0 0 1 6.659 3.524 12.057 12.057 0 0 1 2.937 5.127h2.3a2.322 2.322 0 0 1 2.322 2.322V20c0 1.137-.433 1.57-1.234 2.358l-.142.14c-1.307 1.288-1.705 1.68-2.803 1.68h-1.072Z" />
        <path fill="#fff" fillRule="evenodd" d="M20.929 29.893c5.976 0 10.821-4.845 10.821-10.822 0-5.976-4.845-10.821-10.821-10.821-5.977 0-10.822 4.845-10.822 10.821 0 5.977 4.845 10.822 10.822 10.822Zm.625-16.393v11.143h-1.25V13.5h1.25Zm-3.715 1.857v7.429h-1.25v-7.429h1.25Zm7.429 7.429v-7.429h-1.25v7.429h1.25Z" clipRule="evenodd" />
        <path fill="#fff" d="M32.858 20.929a12.162 12.162 0 0 0 0-3.715h1.928a1 1 0 0 1 1 1v1.715a1 1 0 0 1-1 1h-1.928ZM7.071 17.214H9a12.165 12.165 0 0 0 0 3.715H7.071a1 1 0 0 1-1-1v-1.715a1 1 0 0 1 1-1Z" />
    </svg>

);

export const MultipleChoiceIcon: React.FunctionComponent<
React.ComponentProps<"svg">
> = (props: React.ComponentProps<"svg">) => (
    <svg 
        {...props} 
        xmlns="http://www.w3.org/2000/svg" 
        width="40" 
        height="40" 
        fill="none" 
        viewBox="0 0 40 40"
    >
        <path className="ids-option-button__icon-circle" d="M0 20C0 8.954 8.954 0 20 0s20 8.954 20 20-8.954 20-20 20S0 31.046 0 20Z" />
        <path fill="currentColor" d="M12.828 7a2 2 0 0 0-1.414.586L9.586 9.414A2 2 0 0 0 9 10.828V31a2 2 0 0 0 2 2h16.172a2 2 0 0 0 1.414-.586l1.828-1.828A2 2 0 0 0 31 29.172V9a2 2 0 0 0-2-2H12.828Z" />
        <path fill="#fff" fillRule="evenodd" d="M29 8.25H13a.75.75 0 0 0-.75.75v20c0 .414.336.75.75.75h16a.75.75 0 0 0 .75-.75V9a.75.75 0 0 0-.75-.75ZM16.5 14.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3Zm3.5-.875h7v-1.25h-7v1.25Zm0 6h7v-1.25h-7v1.25Zm7 6h-7v-1.25h7v1.25ZM16.5 20.5a1.5 1.5 0 1 0 0-3 1.5 1.5 0 0 0 0 3ZM18 25a1.5 1.5 0 1 1-3 0 1.5 1.5 0 0 1 3 0Z" clipRule="evenodd" />
    </svg>

);

export const LikertIcon: React.FunctionComponent<
React.ComponentProps<"svg">
> = (props: React.ComponentProps<"svg">) => (
    <svg 
        {...props} 
        xmlns="http://www.w3.org/2000/svg" 
        width="40" 
        height="40" 
        fill="none" 
        viewBox="0 0 40 40"
    >
        <path className="ids-option-button__icon-circle" d="M0 20C0 8.954 8.954 0 20 0s20 8.954 20 20-8.954 20-20 20S0 31.046 0 20Z" />
        <path fill="currentColor" d="M31.928 24.179c-.713 1.557-1.765 2.942-3.107 4.178-2.45 2.658-5.943 4.643-9.75 4.643-5.54 0-10.21-3.733-11.628-8.821h-2.3a2.321 2.321 0 0 1-2.322-2.322V20c0-.97.64-1.6 1.323-2.273a9.63 9.63 0 0 0 .608-.63c.499-.555 1.146-1.276 2.248-1.276h1.138c.63-1.26 1.504-2.427 2.576-3.714 1.505-1.805 3.289-3.168 5.222-4.03a12.028 12.028 0 0 1 6.02-1.034c5.084.429 9.271 4.008 10.601 8.778h2.3a2.322 2.322 0 0 1 2.322 2.322V20c0 1.137-.433 1.57-1.234 2.358l-.142.14c-1.307 1.288-1.705 1.68-2.803 1.68h-1.072Z" />
        <path fill="#fff" fillRule="evenodd" d="M20.928 29.893c5.977 0 10.822-4.845 10.822-10.822 0-5.976-4.845-10.821-10.822-10.821-5.976 0-10.82 4.845-10.82 10.821 0 5.977 4.844 10.822 10.82 10.822Zm-1.621-5.788 7.84-9.773-.976-.782-7.403 9.23-3.18-3.177-.883.885 3.673 3.668a.625.625 0 0 0 .929-.05Z" clipRule="evenodd" />
        <path fill="#fff" d="M8.857 19.071c0 .632.049 1.252.142 1.858H7.071a1 1 0 0 1-1-1v-1.715a.998.998 0 0 1 1-1H9a12.165 12.165 0 0 0-.142 1.857Zm24.143 0c0-.631-.048-1.251-.142-1.857h1.928a1 1 0 0 1 1 1v1.715a1 1 0 0 1-1 1h-1.928A12.11 12.11 0 0 0 33 19.071Z" />
    </svg>

);