/* eslint-disable max-len */
import React from "react";

export const TadaIcon: React.FunctionComponent = () => (
    <svg
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0_908_3484)">
            <circle cx="16" cy="16" r="16" fill="#30C9AD" />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M23.6128 1.1425C23.9763 1.40218 24.0605 1.90739 23.8008 2.27092C23.4685 2.73623 22.5425 3.73321 21.2565 4.34113C20.914 4.50302 20.5837 4.8738 20.3049 5.383C20.034 5.87794 19.8679 6.4014 19.8021 6.71081C19.7091 7.14778 19.2795 7.42664 18.8425 7.33367C18.4056 7.2407 18.1267 6.8111 18.2197 6.37413C18.3143 5.92952 18.5307 5.25489 18.8859 4.60612C19.2332 3.97162 19.7726 3.25309 20.5651 2.8785C21.5488 2.41348 22.2746 1.62422 22.4844 1.33054C22.7441 0.967015 23.2493 0.882826 23.6128 1.1425Z"
                fill="#233043"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M31.185 9.16114C31.4871 9.49022 31.4653 10.0019 31.1362 10.3041C30.397 10.9828 28.4153 12.0767 25.9558 11.5106C25.1789 11.3318 24.6162 11.5687 24.1858 11.9509C23.7253 12.3598 23.4279 12.9346 23.3068 13.324C23.1741 13.7505 22.7207 13.9888 22.2941 13.856C21.8675 13.7233 21.6293 13.2699 21.762 12.8433C21.9496 12.2403 22.3831 11.388 23.1116 10.7411C23.8701 10.0676 24.9543 9.61999 26.3187 9.93401C28.1416 10.3536 29.5977 9.52035 30.0421 9.11238C30.3711 8.81023 30.8828 8.83206 31.185 9.16114Z"
                fill="#233043"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M13.4418 1.11874C13.8886 1.11874 14.2507 1.4809 14.2507 1.92765V4.35438C14.2507 4.80113 13.8886 5.16329 13.4418 5.16329C12.9951 5.16329 12.6329 4.80113 12.6329 4.35438V1.92765C12.6329 1.4809 12.9951 1.11874 13.4418 1.11874Z"
                fill="#233043"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M23.1488 18.1059C23.1488 17.6592 23.511 17.297 23.9577 17.297H28.8112C29.2579 17.297 29.6201 17.6592 29.6201 18.1059C29.6201 18.5527 29.2579 18.9148 28.8112 18.9148H23.9577C23.511 18.9148 23.1488 18.5527 23.1488 18.1059Z"
                fill="#233043"
            />
            <path
                d="M20.3162 21.5289C22.0072 20.4373 21.2976 16.3296 18.7313 12.354C16.1649 8.37851 12.7137 6.04061 11.0227 7.13219C10.3937 7.53827 10.0968 8.36174 10.1042 9.44054C5.8582 14.6664 2.90944 22.6662 2.11704 24.9816C1.64034 25.9346 14.8413 24.2297 18.8049 21.7419C19.3877 21.8572 19.9042 21.7948 20.3162 21.5289Z"
                fill="white"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M13.1688 6.89881C14.7958 7.44164 16.9112 8.90334 19.2862 11.9876C20.9961 14.2081 21.6929 16.3135 21.7649 18.0092C21.8007 18.8539 21.6815 19.6089 21.4422 20.2238C21.2087 20.8235 20.8306 21.3609 20.2976 21.6488C20.2486 21.6752 20.197 21.6966 20.1436 21.7125L20.1012 21.7251L19.9774 21.7622C19.8695 21.7947 19.7127 21.842 19.518 21.9014C19.1285 22.0202 18.5877 22.187 17.9829 22.379C17.0249 22.6831 15.9197 23.0461 15.0013 23.3798C15.1462 24.0306 15.1964 24.8072 14.9843 25.5706C14.6569 26.7496 13.7441 27.7507 12.0252 28.1919C10.3044 28.6335 8.87168 28.1983 7.82956 27.4886C7.11129 26.9995 6.56495 26.3715 6.22061 25.7931C5.02216 26.065 3.8375 26.3108 2.92855 26.4222C2.41438 26.4852 1.89496 26.5185 1.49743 26.4461C1.31431 26.4128 0.997396 26.3313 0.760014 26.0703C0.450229 25.7298 0.459086 25.3093 0.571576 25.0066C2.36519 20.1812 6.83925 12.2055 9.85124 7.67542C10.0279 7.08737 10.6285 6.80359 11.0618 6.70583C11.6369 6.57609 12.359 6.6286 13.1688 6.89881ZM10.0456 10.3603C7.34367 14.6708 4.01005 20.7459 2.36502 24.8539C2.47302 24.8454 2.59509 24.8331 2.73182 24.8164C3.70174 24.6976 5.06976 24.4012 6.48419 24.0725C6.96305 23.9612 7.43914 23.8548 7.91223 23.749C9.90534 23.3035 11.8453 22.8698 13.7156 22.1354C14.7289 21.7374 16.1394 21.2687 17.3245 20.8907C16.9611 20.644 16.5941 20.3582 16.2322 20.0501C14.9528 18.9611 13.6295 17.5 12.6026 16.1876C11.5102 14.7915 10.7697 12.9948 10.3249 11.4564C10.2152 11.0768 10.1222 10.7085 10.0456 10.3603ZM19.6077 20.1669C19.479 20.1662 19.2438 20.1207 18.8713 19.9335C18.4119 19.7025 17.8695 19.3193 17.2809 18.8183C16.1079 17.8197 14.8588 16.4457 13.8767 15.1906C12.96 14.0191 12.293 12.4389 11.8791 11.0071C11.6739 10.2972 11.5362 9.64229 11.4613 9.11804C11.4048 8.72326 11.3909 8.44846 11.3938 8.28968C11.4013 8.28781 11.4094 8.28591 11.4179 8.28399C11.6308 8.23594 12.0447 8.22924 12.6568 8.43346C13.8736 8.83946 15.7454 10.0411 18.0044 12.9747C19.5438 14.9738 20.0928 16.7658 20.1485 18.0778C20.1765 18.737 20.0799 19.2635 19.9346 19.6368C19.8226 19.9244 19.6972 20.0854 19.6077 20.1669ZM7.92267 25.4049C8.13338 25.6599 8.40637 25.9241 8.74019 26.1514C9.45028 26.635 10.4103 26.936 11.623 26.6248C12.8376 26.3131 13.2679 25.7051 13.4255 25.1377C13.5304 24.7601 13.5281 24.3448 13.4648 23.9522C11.7262 24.5559 9.93773 24.9551 8.21552 25.3395C8.11768 25.3614 8.02006 25.3832 7.92267 25.4049Z"
                fill="#233043"
            />
        </g>
        <defs>
            <clipPath>
                <rect width="32" height="32" fill="white" />
            </clipPath>
        </defs>
    </svg>
);

export const InfoIcon: React.FunctionComponent = () => (
    <svg
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <circle cx="16" cy="16" r="16" fill="#B2DDF2" />
        <path
            d="M16.6158 7.39951C17.34 8.52136 17.0484 9.99799 15.9645 10.6977C14.8807 11.3973 13.4149 11.0551 12.6908 9.93323C11.9666 8.81138 12.2582 7.33475 13.342 6.63509C14.4259 5.93542 15.8916 6.27767 16.6158 7.39951Z"
            fill="white"
        />
        <path
            d="M17.5039 13.6C16.8639 13.6 14.5706 15.2 13.5039 16C9.50391 19.2 14.7039 17.2 15.1039 18.4C15.4239 19.36 15.7706 24.1333 15.9039 26.4C15.9274 26.8 20.2449 26.517 20.8 26C22.1927 24.703 19.4993 24.2993 18.8 23.6C18.4 23.2 18.3039 13.6 17.5039 13.6Z"
            fill="white"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.4 7.2C13.5163 7.2 12.8 7.91634 12.8 8.8C12.8 9.68365 13.5163 10.4 14.4 10.4C15.2837 10.4 16 9.68365 16 8.8C16 7.91634 15.2837 7.2 14.4 7.2ZM11.2 8.8C11.2 7.03269 12.6327 5.6 14.4 5.6C16.1673 5.6 17.6 7.03269 17.6 8.8C17.6 10.5673 16.1673 12 14.4 12C12.6327 12 11.2 10.5673 11.2 8.8Z"
            fill="#233043"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16.1657 13.8343C16.4781 14.1467 16.4781 14.6533 16.1657 14.9657C15.7262 15.4052 15.1488 16.0779 14.5585 16.7694C14.5313 16.8013 14.504 16.8333 14.4767 16.8653C14.3774 16.9816 14.2777 17.0984 14.1787 17.214C14.3856 17.2056 14.5962 17.2 14.8 17.2C15.1982 17.2 15.5357 17.4927 15.592 17.8869L16.6939 25.6H19.6687L18.2344 24.1657C18.1038 24.0351 18.0224 23.8634 18.004 23.6796L17.204 15.6796C17.16 15.24 17.4808 14.8479 17.9204 14.804C18.3601 14.76 18.7521 15.0808 18.7961 15.5204L19.5677 23.2362L22.1657 25.8343C22.3945 26.0631 22.463 26.4072 22.3391 26.7061C22.2153 27.0051 21.9236 27.2 21.6 27.2H16C15.6019 27.2 15.2644 26.9073 15.2081 26.5131L14.1088 18.8184C13.9024 18.8281 13.6984 18.8404 13.5033 18.8522C13.3696 18.8603 13.24 18.8681 13.1167 18.8747C12.889 18.8868 12.642 18.8971 12.459 18.8829C12.4091 18.879 12.3448 18.872 12.2763 18.8574C12.2223 18.8458 12.0937 18.8154 11.9611 18.7295C11.8112 18.6325 11.5593 18.3884 11.5818 17.9884C11.5993 17.6772 11.7818 17.4869 11.8344 17.4343C12.196 17.0727 12.7175 16.4617 13.2927 15.7878C13.309 15.7688 13.3253 15.7497 13.3416 15.7306C13.9179 15.0554 14.5405 14.3281 15.0344 13.8343C15.3468 13.5219 15.8533 13.5219 16.1657 13.8343Z"
            fill="#233043"
        />
    </svg>
);

export const CrownIcon: React.FunctionComponent = () => (
    <svg
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <circle cx="16" cy="16" r="16" fill="#FCD35A" />
        <path
            d="M8.96947 24.9545L6.83852 15.2951C6.68402 14.5947 7.47379 14.0722 8.05793 14.4883L11.8237 17.1708L16.2621 11.959C16.5912 11.5725 17.1954 11.5964 17.493 12.0076L20.9763 16.8195L24.8133 14.5833C25.4095 14.2359 26.1311 14.7731 25.9692 15.4438L23.8258 24.3271C23.7442 24.6653 23.4494 24.9091 23.102 24.9258L9.77212 25.5682C9.39077 25.5866 9.05172 25.3274 8.96947 24.9545Z"
            fill="white"
        />
        <path
            d="M17.5834 1.2667C17.5834 0.834078 17.2326 0.483368 16.8 0.483368C16.3674 0.483368 16.0167 0.834078 16.0167 1.2667V5.6667C16.0167 6.09932 16.3674 6.45003 16.8 6.45003C17.2326 6.45003 17.5834 6.09932 17.5834 5.6667V1.2667Z"
            fill="#233043"
        />
        <path
            d="M9.85177 4.83217C9.61179 4.47221 9.12544 4.37494 8.76548 4.61492C8.40552 4.85489 8.30825 5.34124 8.54822 5.70121L10.1482 8.1012C10.3882 8.46117 10.8745 8.55844 11.2345 8.31846C11.5945 8.07849 11.6917 7.59214 11.4518 7.23217L9.85177 4.83217Z"
            fill="#233043"
        />
        <path
            d="M24.0553 5.02928C24.4074 5.28073 24.4889 5.76996 24.2374 6.122L22.2374 8.922C21.986 9.27404 21.4967 9.35558 21.1447 9.10413C20.7927 8.85267 20.7111 8.36344 20.9626 8.0114L22.9626 5.2114C23.214 4.85936 23.7033 4.77782 24.0553 5.02928Z"
            fill="#233043"
        />
        <path
            d="M17.4018 11.0985C17.2609 10.9295 17.0553 10.8275 16.8355 10.8175C16.6156 10.8075 16.4017 10.8905 16.2461 11.0461L11.4731 15.8191L7.19468 13.3234C6.92756 13.1676 6.59377 13.1835 6.34269 13.364C6.09161 13.5445 5.97024 13.8559 6.03289 14.1587L8.43289 25.7587C8.52055 26.1824 8.93504 26.4548 9.35869 26.3671C9.78234 26.2795 10.0547 25.865 9.96707 25.4413L7.92308 15.562L11.2053 17.4766C11.5127 17.6559 11.9023 17.6055 12.1539 17.3539L16.7473 12.7605L20.1982 16.9015C20.413 17.1592 20.768 17.2516 21.0812 17.1311L24.9186 15.6552L22.9663 24.4405L13.1699 24.8173C12.7376 24.8339 12.4006 25.1978 12.4172 25.6301C12.4339 26.0624 12.7978 26.3994 13.2301 26.3828L23.6301 25.9828C23.9857 25.9691 24.2875 25.7174 24.3647 25.3699L26.7647 14.5699C26.8273 14.2882 26.7299 13.9949 26.5113 13.8066C26.2926 13.6182 25.9881 13.5653 25.7188 13.6689L21.0425 15.4675L17.4018 11.0985Z"
            fill="#233043"
        />
    </svg>
);

export const SuccessIcon: React.FunctionComponent = () => (
    <svg
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <circle cx="16" cy="16" r="16" fill="#30C9AD" />
        <path
            d="M19.9396 12.6745C19.0968 10.9892 13.876 12.5147 12.4715 13.2169C12.2666 12.3097 12.2538 10.444 11.6424 7.44605C10.9828 4.21213 8.73001 3.9351 8.02771 7.44663C7.3254 10.9582 5.19122 27.7739 10.8097 27.8617C16.4281 27.9495 23.5389 26.1059 24.0657 23.2089C24.4871 20.8913 23.6166 20.344 23.1287 20.3601C23.2933 20.1143 23.4342 19.8359 23.5389 19.5218C24.1008 17.8363 22.7909 17.4205 22.0657 17.4233C22.5343 16.9848 22.8662 16.4265 22.8366 15.7469C22.7664 14.1316 20.405 14.2506 19.2331 14.5119C19.9218 14.0236 20.3063 13.4078 19.9396 12.6745Z"
            fill="white"
        />
        <path
            d="M17.9512 0.780488C17.9512 0.349436 17.6018 0 17.1707 0C16.7397 0 16.3902 0.349436 16.3902 0.780488V4.60647C16.3902 5.03752 16.7397 5.38696 17.1707 5.38696C17.6018 5.38696 17.9512 5.03752 17.9512 4.60647V0.780488Z"
            fill="#233043"
        />
        <path
            d="M26.4964 2.83689C26.77 2.50381 26.7218 2.01199 26.3887 1.73838C26.0557 1.46478 25.5638 1.51299 25.2902 1.84608L22.0311 5.81373C21.7575 6.14682 21.8057 6.63864 22.1388 6.91224C22.4718 7.18585 22.9637 7.13763 23.2373 6.80455L26.4964 2.83689Z"
            fill="#233043"
        />
        <path
            d="M24.2949 11.5115C24.2586 11.082 24.5774 10.7044 25.007 10.6681L31.1538 10.1491C31.5833 10.1129 31.9609 10.4317 31.9972 10.8612C32.0335 11.2907 31.7147 11.6683 31.2852 11.7046L25.1383 12.2236C24.7088 12.2598 24.3312 11.941 24.2949 11.5115Z"
            fill="#233043"
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8.79302 7.5997C8.95481 6.79076 9.19259 6.27556 9.41518 5.98553C9.63371 5.70079 9.78008 5.69481 9.81433 5.69642C9.86591 5.69885 10.0386 5.73845 10.2705 6.05208C10.4985 6.3604 10.728 6.86812 10.8776 7.60202C11.177 9.06978 11.3299 10.2604 11.4336 11.201C11.4567 11.4103 11.4777 11.6128 11.4979 11.8067C11.5646 12.4487 11.6216 12.9967 11.7101 13.3888C11.7629 13.6228 11.9204 13.8195 12.1372 13.9222C12.3539 14.0249 12.6059 14.0223 12.8205 13.915C13.4397 13.6054 15.018 13.069 16.5417 12.8207C17.3027 12.6967 17.9921 12.6547 18.5127 12.7233C19.0665 12.7963 19.2096 12.9597 19.2415 13.0236C19.3234 13.1874 19.3079 13.2803 19.269 13.3679C19.2126 13.4948 19.069 13.6715 18.7817 13.8752C18.0243 14.4122 16.7484 14.8055 15.8412 14.9806C15.418 15.0623 15.1411 15.4716 15.2228 15.8948C15.3045 16.3181 15.7138 16.595 16.137 16.5133C17.0711 16.333 18.5177 15.9188 19.5442 15.2444C20.0634 15.144 20.753 15.0897 21.3044 15.1928C21.6036 15.2488 21.7957 15.3391 21.9036 15.4307C21.9864 15.501 22.0487 15.5927 22.0569 15.7808C22.0733 16.158 21.8984 16.5108 21.5324 16.8534C21.0124 17.34 20.2404 17.6692 19.7399 17.8016C19.3232 17.9119 19.0748 18.3392 19.1851 18.7559C19.2954 19.1726 19.7226 19.4209 20.1393 19.3106C20.7172 19.1577 21.5969 18.8076 22.3258 18.2284C22.4997 18.2619 22.6618 18.3283 22.7617 18.4186C22.82 18.4712 22.8623 18.5349 22.8824 18.6353C22.9043 18.7453 22.908 18.9464 22.7985 19.275C22.7167 19.5203 22.6074 19.7358 22.4803 19.9256C21.9142 20.7703 20.9645 21.1379 20.5186 21.2092C20.093 21.2773 19.8031 21.6776 19.8712 22.1032C19.9393 22.5288 20.3396 22.8187 20.7652 22.7506C21.3845 22.6515 22.454 22.2642 23.2981 21.3879C23.3908 21.6445 23.4645 22.1524 23.2978 23.0693C23.2355 23.4116 23.0032 23.8026 22.514 24.223C22.0273 24.6413 21.3381 25.0428 20.4805 25.407C18.7669 26.1348 16.5057 26.6616 14.198 26.9151C13.7696 26.9622 13.4604 27.3477 13.5074 27.7762C13.5545 28.2046 13.94 28.5138 14.3685 28.4668C16.7788 28.202 19.198 27.6476 21.0906 26.8438C22.0361 26.4423 22.8816 25.9654 23.5314 25.4068C24.1788 24.8504 24.6849 24.166 24.8336 23.3485C25.0593 22.1072 24.9703 21.1875 24.6271 20.5427C24.508 20.3189 24.3614 20.1357 24.1983 19.9914C24.227 19.9187 24.2541 19.8445 24.2794 19.7686C24.4508 19.2544 24.5014 18.7715 24.4131 18.3296C24.3229 17.878 24.0978 17.5219 23.8081 17.2603C23.6711 17.1365 23.5226 17.0359 23.3696 16.9546C23.5385 16.59 23.6365 16.1757 23.6164 15.713C23.5894 15.0935 23.3302 14.5943 22.9139 14.2408C22.5227 13.9086 22.038 13.742 21.5915 13.6585C21.3425 13.6119 21.0848 13.5874 20.8287 13.5794C20.9066 13.1731 20.8479 12.7459 20.6377 12.3254C20.2482 11.5467 19.4226 11.2688 18.7166 11.1757C17.9774 11.0783 17.1158 11.1456 16.2907 11.2801C15.1552 11.4651 13.979 11.7967 13.1002 12.1134C13.0876 11.9965 13.0745 11.8707 13.0603 11.7353C13.0383 11.5246 13.0139 11.2904 12.9852 11.03C12.8784 10.0615 12.7192 8.82027 12.4071 7.29007C12.227 6.40702 11.9275 5.66739 11.5256 5.12396C11.1277 4.58585 10.5696 4.1693 9.88779 4.13718C9.18861 4.10423 8.59887 4.48529 8.17686 5.03516C7.7589 5.57975 7.45172 6.34674 7.26236 7.29356C6.88843 9.16318 6.12615 14.657 6.28233 19.5334C6.27953 20.8039 6.41336 22.7453 6.83373 24.4733C7.04427 25.3388 7.33615 26.1912 7.74495 26.8867C8.14958 27.575 8.72444 28.2016 9.53631 28.4398C9.94992 28.5612 10.3836 28.3243 10.505 27.9107C10.6264 27.4971 10.3895 27.0634 9.97587 26.942C9.70159 26.8615 9.3958 26.6148 9.09066 26.0956C8.78967 25.5836 8.54263 24.8943 8.35047 24.1044C7.96699 22.5279 7.83978 20.7114 7.84334 19.5242C7.84336 19.515 7.84323 19.5057 7.84293 19.4966C7.68973 14.7664 8.4355 9.38731 8.79302 7.5997ZM23.1326 21.1391C23.1293 21.1377 23.1275 21.1374 23.1274 21.1376C23.1274 21.1377 23.1279 21.138 23.1291 21.1383C23.13 21.1386 23.1311 21.1388 23.1326 21.1391Z"
            fill="#233043"
        />
    </svg>
);

export const WarningIcon: React.FunctionComponent = () => (
    <svg
        width="32"
        height="32"
        viewBox="0 0 32 32"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
    >
        <g clipPath="url(#clip0_907_3511)">
            <circle cx="16" cy="16" r="16" fill="#FFA878" />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M13.0893 9.02848C9.74346 13.4534 7.802 16.8421 5.32718 22.0413C5.05044 22.6213 4.76414 23.2531 4.82336 23.835C4.9008 24.5862 5.52241 24.9816 6.113 25.2509C10.2582 27.1379 17.8205 26.9353 22.6883 25.2582C24.0395 24.7922 25.6024 24.0051 26.1531 22.4948C26.4877 21.5772 26.3392 20.6435 26.1704 19.785C25.187 14.7467 22.3569 9.99406 20.5077 5.45748C20.3079 4.96707 19.895 3.4167 18.1771 3.46115C17.1816 3.48686 15.3199 6.07853 13.0893 9.02848Z"
                fill="white"
            />
            <path
                d="M21.0927 5.38396C20.8693 4.74404 20.4122 3.81227 19.7307 3.16454C19.3836 2.83463 18.9345 2.5371 18.3875 2.43597C17.8185 2.33077 17.2361 2.45554 16.6824 2.81243C16.3281 3.04075 15.9252 3.44812 15.5164 3.91526C15.0915 4.40088 14.6057 5.01559 14.0831 5.71724C13.0371 7.12177 11.8186 8.90826 10.6051 10.7819C8.18523 14.5184 5.74361 18.6662 4.71221 20.882C4.182 22.021 3.94441 22.9796 4.01093 23.7923C4.0814 24.6533 4.48754 25.2771 5.06292 25.702C5.60061 26.0991 6.26004 26.3043 6.84237 26.4393C7.1405 26.5085 7.44102 26.5639 7.71822 26.6138L7.81991 26.632C8.06329 26.6757 8.28435 26.7154 8.49105 26.7598C9.58611 26.9951 13.0822 27.3194 16.7488 27.1553C18.5904 27.0729 20.5088 26.8662 22.2131 26.4508C23.8985 26.0399 25.4706 25.4027 26.5276 24.3935C26.539 24.3827 26.55 24.3715 26.5607 24.36C26.9151 23.9793 27.0792 23.4825 27.1504 22.9998C27.2227 22.51 27.2108 21.9579 27.148 21.3827C27.0221 20.2316 26.6772 18.8627 26.2345 17.4637C25.3468 14.6582 24.0213 11.5933 23.0713 9.62538C22.8792 9.22749 22.401 9.06064 22.0031 9.25271C21.6052 9.44479 21.4383 9.92305 21.6304 10.3209C22.5597 12.246 23.8517 15.2369 24.7091 17.9464C25.1389 19.305 25.4483 20.5584 25.5574 21.5566C25.612 22.056 25.6127 22.4602 25.5676 22.7662C25.5246 23.0571 25.4496 23.1973 25.4005 23.2573C24.6432 23.9681 23.4052 24.5133 21.8342 24.8963C20.2666 25.2784 18.4601 25.4772 16.6773 25.5569C13.0954 25.7173 9.74553 25.3928 8.8271 25.1955C8.59168 25.1449 8.34144 25.1 8.10143 25.057L8.00172 25.0391C7.7252 24.9893 7.45942 24.94 7.20384 24.8807C6.67875 24.7589 6.2811 24.6126 6.01339 24.4149C5.78337 24.2451 5.6358 24.0308 5.60559 23.6618C5.57143 23.2444 5.68621 22.5809 6.16275 21.5572C7.14485 19.4474 9.53562 15.3767 11.9481 11.6516C13.1509 9.7945 14.3486 8.03946 15.3663 6.67295C15.8757 5.98907 16.3338 5.41088 16.7205 4.96888C17.1234 4.50839 17.4 4.25342 17.5491 4.15732C17.8008 3.99515 17.9735 3.98655 18.0966 4.00931C18.2418 4.03614 18.4219 4.12791 18.6285 4.32428C19.0544 4.7291 19.4028 5.39778 19.5821 5.91133C19.7277 6.32847 20.1839 6.54857 20.601 6.40294C21.0182 6.25731 21.2383 5.8011 21.0927 5.38396Z"
                fill="#233043"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M20.2087 8.76427C20.3791 8.91607 20.4766 9.13344 20.4766 9.36167C20.4766 10.4448 20.2762 12.1126 19.9718 13.6862C19.6729 15.2317 19.2458 16.8389 18.7363 17.7261C18.5713 18.0132 18.2465 18.1691 17.9194 18.1181C17.5922 18.0671 17.3302 17.8198 17.2605 17.4961L15.6264 9.90945C15.5789 9.68891 15.6268 9.45857 15.7581 9.27517C15.8895 9.09177 16.0922 8.97235 16.3163 8.94634L19.5843 8.56701C19.8111 8.54069 20.0382 8.61247 20.2087 8.76427ZM17.3761 10.4341L18.2084 14.2982C18.2756 14.0037 18.3401 13.6969 18.4009 13.3824C18.6146 12.2778 18.7684 11.1561 18.8369 10.2645L17.3761 10.4341Z"
                fill="#233043"
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M17.0156 19.4477C17.5612 19.1564 18.1618 19.1703 18.5407 19.2481C19.6232 19.4704 20.3981 20.2513 20.681 21.1229C20.9697 22.0121 20.754 23.1184 19.693 23.6631C18.8717 24.0847 17.9396 24.1339 17.1788 23.6783C16.4084 23.2168 16 22.3506 16 21.3294C16 20.4228 16.3944 19.7793 17.0156 19.4477ZM17.6707 20.955C17.6433 21.004 17.6 21.1136 17.6 21.3294C17.6 21.9302 17.8236 22.1994 18.001 22.3056C18.1881 22.4177 18.5198 22.4669 18.9623 22.2397C19.1652 22.1355 19.2654 21.9442 19.1592 21.6169C19.0472 21.272 18.7161 20.9175 18.2189 20.8154C18.0712 20.785 17.8819 20.7989 17.7692 20.8591C17.7268 20.8817 17.6962 20.9095 17.6707 20.955Z"
                fill="#233043"
            />
        </g>
        <defs>
            <clipPath>
                <rect width="32" height="32" fill="white" />
            </clipPath>
        </defs>
    </svg>
);
