<div align="center">
  <h1>Igloo</h1>

  <p>Igloo gives a collection of React components for building their products</p>
  <p><a href="https://github.com/gsoft-inc/ov-igloo-ui/issues/new">Report a Issue</a> . <a href="https://gsoft.slack.com/archives/C02J8004TDK">Ask a Question</a></p>
</div>

## Documentation

Visit [igloo.officevibe.design](https://igloo.officevibe.design) to learn more.

## Usage

To use a component from this repo you will first need to install the component into your project.

For an example we will try to use the `@igloo-ui/card` component.

```bash
npm i @igloo-ui/card
# or with yarn
yarn add @igloo-ui/card
```

Then to use the component in your code just import it!

```js
import Card from '@igloo-ui/card';
```

## Getting Started

Before starting make sure [node](https://nodejs.org/en/) and [yarn](https://yarnpkg.com/) is installed

### Install

After cloning ov-igloo-ui, run `yarn` to install dependencies.

```bash
git clone https://github.com/gsoft-inc/ov-igloo-ui.git
cd ov-igloo-ui
yarn
yarn storybook
```

### Scripts

- `yarn storybook`: run Storybook
- `yarn test`: run tests
- `yarn lint`: check if the JS, TS correspond on standard
- `yarn lint:style`: check if the style correspond on standard

## 🤝 Contributing

Pull requests are welcome. For major changes, please open an issue first to discuss what you would like to change.If you're interested, definitely check out our Contributing Guide!

## License

Copyright © 2019, GSoft inc. This code is licensed under the Apache License, Version 2.0. You may obtain a copy of this license at https://github.com/gsoft-inc/gsoft-license/blob/master/LICENSE.
