// Original file: deps/envoy-api/envoy/service/status/v3/csds.proto

import type { ConfigStatus as _envoy_service_status_v3_ConfigStatus, ConfigStatus__Output as _envoy_service_status_v3_ConfigStatus__Output } from '../../../../envoy/service/status/v3/ConfigStatus';
import type { ListenersConfigDump as _envoy_admin_v3_ListenersConfigDump, ListenersConfigDump__Output as _envoy_admin_v3_ListenersConfigDump__Output } from '../../../../envoy/admin/v3/ListenersConfigDump';
import type { ClustersConfigDump as _envoy_admin_v3_ClustersConfigDump, ClustersConfigDump__Output as _envoy_admin_v3_ClustersConfigDump__Output } from '../../../../envoy/admin/v3/ClustersConfigDump';
import type { RoutesConfigDump as _envoy_admin_v3_RoutesConfigDump, RoutesConfigDump__Output as _envoy_admin_v3_RoutesConfigDump__Output } from '../../../../envoy/admin/v3/RoutesConfigDump';
import type { ScopedRoutesConfigDump as _envoy_admin_v3_ScopedRoutesConfigDump, ScopedRoutesConfigDump__Output as _envoy_admin_v3_ScopedRoutesConfigDump__Output } from '../../../../envoy/admin/v3/ScopedRoutesConfigDump';
import type { EndpointsConfigDump as _envoy_admin_v3_EndpointsConfigDump, EndpointsConfigDump__Output as _envoy_admin_v3_EndpointsConfigDump__Output } from '../../../../envoy/admin/v3/EndpointsConfigDump';
import type { ClientConfigStatus as _envoy_service_status_v3_ClientConfigStatus, ClientConfigStatus__Output as _envoy_service_status_v3_ClientConfigStatus__Output } from '../../../../envoy/service/status/v3/ClientConfigStatus';

/**
 * Detailed config (per xDS) with status.
 * [#next-free-field: 8]
 */
export interface PerXdsConfig {
  /**
   * Config status generated by management servers. Will not be present if the
   * CSDS server is an xDS client.
   */
  'status'?: (_envoy_service_status_v3_ConfigStatus);
  'listener_config'?: (_envoy_admin_v3_ListenersConfigDump | null);
  'cluster_config'?: (_envoy_admin_v3_ClustersConfigDump | null);
  'route_config'?: (_envoy_admin_v3_RoutesConfigDump | null);
  'scoped_route_config'?: (_envoy_admin_v3_ScopedRoutesConfigDump | null);
  'endpoint_config'?: (_envoy_admin_v3_EndpointsConfigDump | null);
  /**
   * Client config status is populated by xDS clients. Will not be present if
   * the CSDS server is an xDS server. No matter what the client config status
   * is, xDS clients should always dump the most recent accepted xDS config.
   * 
   * .. attention::
   * This field is deprecated. Use :ref:`ClientResourceStatus
   * <envoy_v3_api_enum_admin.v3.ClientResourceStatus>` for per-resource
   * config status instead.
   * @deprecated
   */
  'client_status'?: (_envoy_service_status_v3_ClientConfigStatus);
  'per_xds_config'?: "listener_config"|"cluster_config"|"route_config"|"scoped_route_config"|"endpoint_config";
}

/**
 * Detailed config (per xDS) with status.
 * [#next-free-field: 8]
 */
export interface PerXdsConfig__Output {
  /**
   * Config status generated by management servers. Will not be present if the
   * CSDS server is an xDS client.
   */
  'status': (_envoy_service_status_v3_ConfigStatus__Output);
  'listener_config'?: (_envoy_admin_v3_ListenersConfigDump__Output | null);
  'cluster_config'?: (_envoy_admin_v3_ClustersConfigDump__Output | null);
  'route_config'?: (_envoy_admin_v3_RoutesConfigDump__Output | null);
  'scoped_route_config'?: (_envoy_admin_v3_ScopedRoutesConfigDump__Output | null);
  'endpoint_config'?: (_envoy_admin_v3_EndpointsConfigDump__Output | null);
  /**
   * Client config status is populated by xDS clients. Will not be present if
   * the CSDS server is an xDS server. No matter what the client config status
   * is, xDS clients should always dump the most recent accepted xDS config.
   * 
   * .. attention::
   * This field is deprecated. Use :ref:`ClientResourceStatus
   * <envoy_v3_api_enum_admin.v3.ClientResourceStatus>` for per-resource
   * config status instead.
   * @deprecated
   */
  'client_status': (_envoy_service_status_v3_ClientConfigStatus__Output);
  'per_xds_config': "listener_config"|"cluster_config"|"route_config"|"scoped_route_config"|"endpoint_config";
}
