### Stock

- New product option "Move on open" (defaults to disabled)
  - When enabled, on marking the product as opened, the corresponding amount will be moved to the products default consume location
  - (Thanks @RosemaryOrchard)
- The stock setting "Decimal places allowed for prices" has been split into separate settings for input and displaying prices (the existing setting will be set for both new options on migration, so no changed behavior when not configured)
- Optimized that when the plural form(s) of a quantity unit is/are not provided, the singular form is used to display plural amounts
- Fixed that "Automatically add products that are below their defined min. stock amount to the shopping list" (stock setting) was only done when consuming products, not when opening them
- Fixed that the price history chart (product card) showed the price on a wrong date when having multiple purchases on the same date from different stores

### Recipes

- Fixed that when a substituted product is used to display costs and calories (so when a parent product ingredient is currently not in stock itself), no unit conversions were considered for costs/calories calculation
- Fixed that the displayed "already on the shopping list"-amount (for missing ingredients) was wrong when the products "Factor purchase to stock quantity unit" wasn't 1

### Chores

- Fixed that rescheduling of "Track date only"-chores for today was not possible

### Calendar

- Fixed that clicking on meal plan product and notes calendar entries redirected to an invalid page

### General

- LDAP authentication: Optimized that it's not required that LDAP accounts need to have a first-/lastname

### API

- Endpoint `/stock/products/{productId}`: New field/property `default_consume_location` (contains the products default consume location object)
- Endpoint `/stock/products/{productId}/add`: Fixed that the request body parameter `transaction_type` was ignored / always set to `purchase`
- Fixed that the endpoint `/stock/products/by-barcode/{barcode}/open` didn't handle stock entries provided by a Grocycode (thanks @jtommi)
- Fixed that less or equal (`<=`) and greater or equal (`>=`) filter comparisons didn't work (optional `query[]` request query parameter on most endpoints)
