### New feature: Notes and Userfields for stock entries

- Stock entries can now have notes
  - For example to distinguish between same, yet different products (e.g. having only a generic product "Chocolate" and note in that field what special one it is exactly this time - as an alternative to have sub products)
  - Or for example to track ownership of stock items when sharing the fridge with your flatmates
  - => New field on the purchase and inventory (and stock entry edit) page
  - => New column on the stock entries and stock journal page
  - => Visible also in the "Use a specific stock item" dropdown on the consume and transfer page
- Additionally it's also possible to add arbitrary own fields by using Userfields
  - => Configure the desired Userfields for the entity `stock`
  - => Those Userfields are then visible on the same places as mentioned above for the built-in "Note" field

### New feature: Recipes "Due score"

- A number (new column on the recipes page) which represents a score which is higher the more ingredients, of the corresponding recipe, currently in stock are due soon, overdue or already expired
  - Or in other words: A score to see which recipes to cook to not waste already overdue/expired or due soon products
- The score is in detail based on:
  - 1 point for each due soon ingredient (based on the stock setting "Due soon days")
  - 10 points per overdue ingredient
  - 20 points per expired ingredient
  - (or else 0)
- The corresponding ingredient is also highlighted in red/yellow/grey (same colors as on the stock overview page)

### Stock

- It's now possible to change a products stock QU, even after it was once added to stock
  - When the product was once added to stock, there needs to exist a corresponding unit conversion for the new QU
- Product card, stock overiew and stock entries page optimizations regarding displaying prices:
  - Prices are now shown per default purchase quantity unit, instead of per stock QU and when clicking/hovering, a tooltip shows the price per stock QU
  - The price history chart is now based on the value per purchase QU, instead of per stock QU
- New product option "Default consume location" (not mandatory, defaults to not set / empty)
  - When set, stock entries at that location will be consumed first
  - => This will be automatically taken into account when consuming from the stock overview page and all other places where no specific location can be selected
  - => On the consume page the location is preselected in the following order:
    1. The new default consume location, if the product currently has any stock there, otherwise
    2. The products default location, if the product currently has any stock there, otherwise
    3. The first location where the product currently has any stock
- Optimized quantity unit conversion handling:
  - The option "Create inverse QU conversion" was removed when creating a QU conversion
  - => Instead the corresponding inverse conversion is now always created/updated/deleted automatically
- New product option "Disable own stock" (defaults to disabled)
  - When enabled, the corresponding product can't have own stock, means it will not be selectable on purchase (useful for parent products which are just used as a summary/total view of the sub products)
- The location content sheet can now optionally list also out of stock products (at the products default location, new checkbox "Show only in-stock products" at the top of the page, defaults to enabled)
- Added a location filter to the stock entries page
- Added the product Grocycode as a (hidden by default) column to the products list (master data)
- The price entered on the inventory page is now related to the selected quantity unit (like on the purchase page, was always related to the products stock QU before)
- Fixed that consuming via the consume page was not possible when `FEATURE_FLAG_STOCK_LOCATION_TRACKING` was disabled

### Shopping list

- Added a new shopping list setting (top right corner settings menu) to automatically add products, that are below their defined min. stock amount, to the shopping list (defaults to disabled)
- Fixed that when using "Add products that are below defined min. stock amount", the calculated missing amount was wrong for products which had the new product option `Treat opened as out of stock` set and when having at least one opened stock entry

### Recipes

- When a parent product is used as an ingredient, which is currently not in stock itself, the substituted product (so the one which was already taken into account when consuming the recipe) is now displayed below the ingredient and the costs (and calories) are taken from that one, to reflect the current real costs even better
- Added a new recipes setting (top right corner settings menu) "Show a little checkbox next to each ingredient to mark it as done" (defaults to disabled)
  - When enabled, next to each ingredient a little checkbox will be shown
  - When clicked, the ingredient is crossed out
  - This status is not saved, means reset when the page is reloaded
- Fixed that consuming recipes was possible when not all ingredients were in stock (and this potentially consumed some of the in stock ingredients; not matching the message "nothing removed")
- Fixed that the price of the "Produces product"-product, which is added to stock on consuming a recipe, was wrong (was the recipe total costs multiplied by the serving amount instead of only the recipe total costs)
- Fixed that calories of recipe ingredients were displayed with an indefinite number of decimal places
- Fixed that ingredient amounts were wrong for multi-nested (> 2 levels) recipes, when the included recipe used an serving amount other than 1
- Fixed that searching/filtering the recipe gallery view did not work correctly
- Fixed that searching/filtering recipes by products did not work (e.g. via the context-/more menu option "Search for recipes containing this product" on the stock overview page)

### Meal plan

- The day is now editable on the edit dialog of any meal plan entry, which makes it possible to move entries to a different day
- Fixed that it was not possible to print the meal plan (and other pages) in landscape (thanks @miguelangel-nubla)

### Chores

- The `Daily` period type has been changed to schedule the chore at the _same time_ (based on the start date) each `n` days
  - This period type scheduled chores `n` days _after the last execution_ before, which is also possible by using the `Hourly` period type and a corresponding period interval; all existing `Daily` schedules will be converted to that on migration
- It's now possible to manually reschedule / assign chores
  - New entry "Reschedule next execution" in the context/more menu on the chores overview page
  - If you have rescheduled a chore and want to continue the normal schedule/assignment instead, use the "Clear" button in the same dialog
  - Rescheduled/reassigned chores will be highlighted with an corresponding icon next to the "Next estimated tracking date" / "Assigned to"
- Optimized that when skipping chores via the chore tracking page, the given time is used as the "skipped time", not the scheduled next estimated tracking time of the corresponding chore (making it essentially possible to skip more then one schedule at once)
- Fixed that when consuming a parent product on chore execution (chore option "Consume product on chore execution"), no child products were used if the parent product itself is not in stock
- Fixed that the upgrade to v3.2.0 failed when having any former "Dynamic Regular" chore with a "Period interval" of `0` (which makes absolutely no sense in reality)

### Tasks

- Fixed that tasks without a due date were highlighted in red (like overdue tasks)

### Batteries

- Fixed that the batteries overview page was broken when there was any battery Userfield with enabled "Show as column in tables" option
- Fixed that Grocycode label printer printing didn't work from the battery edit page (master data) (thanks @andreheuer)
- Fixed that undoing a battery charge cycle had no effect on "Last charged" and "Next planned charge cycle" of the corresponding battery

### Equipment

- It's now possible to add multiple files (PDFs / manuals) to each equipment
  - Define as many Userfields for the entity `equipment` and use the type `File`
  - => Each of those File-Userfields will be shown as a separate tab on the equipment page

### Userfields

- Userfields of type "Date & time" and "Date (without time)" have now the option to default to now / today for new objects (new Userfield option "Default value")

### General

- Optimized form validation: Save / submit buttons are now not disabled when the form is invalid, the invalid / missing fields are instead highlighted when trying to submit / save the form (making it more obvious which fields are invalid / missing exactly)
- Night mode can now use / follow the system preferred color scheme
  - The view/user setting "Enable night mode" has been removed and replaced by "Night mode" which now defaults to "Use system setting" (which uses the system preferred color scheme, "On" and "Off" are other possible options to always enable/disable night mode)
- Some night mode style refinements
- Fixed an server error (on every page) when not having any quantity unit
- New translations: (thanks all the translators)
  - Slovenian (demo available at <https://sl.demo.grocy.info>)

### API

- Added a new endpoint `GET /stock/locations/{locationId}/entries` to get all stock entries of a given location (similar to the already existing endpoint `GET /stock/products/{productId}/entries`)
- Endpoint `/recipes/{recipeId}/consume`: Fixed that consuming partially fulfilled recipes was possible, although an error was already returned in that case (and potentially some of the in stock ingredients were consumed in fact)
- Endpoint `/stock/products/{productId}`:
  - New field/property `current_price` which returns the current price of the corresponding product, based on the stock entry to use next (defined by the default consume rule "Opened first, then first due first, then first in first out") or on the last price if the product is currently not in stock
  - The field/property  `oldest_price` is deprecated and will be removed in a future version (this had no real sense, currently returns the same as `current_price`)
