### New feature: Price history per store
- Define stores under master data
- New product option to set the default store
- Track on purchase/inventory in which store you bought the product (gets prefilled by the last store you purchased the product, or the default store of the product if you never bought it)
- => The price history chart on the product card shows a line per store
- (Thanks @immae and @kriddles)

### Stock improvements/fixes
- When creating a new product, the "QU id stock" is now preset by the "QU id purchase" (because most of the time that's most probably the same) (thanks @Mik-)
- Clarified the row-button colors and toolips on the stock entries page
- Added a camera-barcode-scanning-button to the barcode(s) field on the product edit page to be able to also scan barcodes by the device camera there
- Added a new option (stock settings / top right corner settings menu) to show an icon on the stock overview if the product is already on the shopping list (next to the amount) (defaults to enabled)
- Fixed that the aggregated parent product amount (displayed on the stock overview page and on the product card) did not respect quantity unit conversions when the parent/sub products had different stock quantity units (the unit conversion needs to be globally defined, or as an override on the sub product)
- Fixed the conversion factor hint to display also decimal places on the purchase page (only displayed when the product has a different purchase/stock quantity unit)
- Fixed that the stock entries page was broken when there were product userfields defined with enabled "Show as column in tables"
- Fixed that best before dates were displayed on the stock overview and stock entries page even with disabled `FEATURE_FLAG_STOCK_BEST_BEFORE_DATE_TRACKING`
- Fixed that when editing a stock entry and setting a decimal amount, the decimal part was ignored (only possible when the product option "Allow partial units in stock" is enabled)
- Fixed that "Default best before days" and "Default best before days after opened" on the product edit page were always shown regardless of the feature flags `FEATURE_FLAG_STOCK_BEST_BEFORE_DATE_TRACKING` and `FEATURE_FLAG_STOCK_PRODUCT_OPENED_TRACKING`
- Fixed that the form validation limits for the amount input and products with enabled tare weight handling were wrong
- Fixed that the price was saved wrong for products with a different purchase/stock quantity unit when using "Total price" on purchase (resulted for example in wrong recipe costs)
- Fixed that undoing "product-opened"-actions was not possible
- Fixed/improved consuming from the stock overview page for products with enabled tare weight handling ("consume 1" button is now disabled for such products, "consume all" works again)

### Shopping list improvements/fixes
- It's now possible to collapse/expand the product group sections (by clicking on the grey group header)
- Fixed that the "shopping list to stock workflow"-dialog was not visible in compact view
- Fixed that when printing the shopping list, configured userfields were not included

### Recipe fixes
- Fixed that when editing an ingredient with "Only check if a single unit is in stock" set, the quantity unit was always set to the products stock quantity unit regardless if a different one was selected for that ingredient
- Fixed a PHP notice on the recipes page when there are no recipes (thanks @mrunkel)

### Chores fixes
- Fixed that weekly chores, where the next execution should be in the same week, were scheduled always for the next week only

### Calendar fixes
- Fixed that the "Share/Integrate calendar (iCal)" button did not work (thanks @tsia)

### API improvements/fixes
- New endpoint `/user/settings` to get all user settings of the currently logged in user (key/value pairs)
- New endpoint `/system/config` to get all config settings (`config.php`) (key/value pairs)
- The endpoint `/stock/products/{productId}/locations` now also returns the current stock amount of the product in that loctation (new field/property `amount`) (thanks @Forceu)
- The endpoints `/objects/{entity}` and `/objects/{entity}/{objectId}` now also include/return userfields of the object(s) (new field/property `userfields` per object, key/value pairs or `null`, when the object has no userfields)
- Fixed that CORS was broken (there was no response to preflight OPTIONS requests)

### General & other improvements/fixes
- Optimized that sometimes the corresponding form was not validated when selecting a date from the datetimepicker
- New `config.php` setting `FEATURE_FLAG_STOCK_BEST_BEFORE_DATE_FIELD_NUMBER_PAD` which activates the number pad for best-before-date fields on (supported) mobile browsers (useful because of [shorthands](https://github.com/grocy/grocy#input-shorthands-for-date-fields)) (defaults to `true`) (thanks @Mik-)
- Enhancements for the camera barcode scanner
  - Torch / light improvements (thanks @Mik-)
    - The light button is only displayed when the device has a flash light
    - New `config.php` setting `FEATURE_FLAG_AUTO_TORCH_ON_WITH_CAMERA` to always enable the flash light automatically
  - It's now possible to change the camera when the device has more than one (dropdown in the camera scanning dialog, only visible if there is more than one camera available) (thanks @MichaelMadsen)
  - Replaced [QuaggaJS](https://github.com/serratus/quaggaJS) (seems to be unmaintained) by [Quagga2](https://github.com/ericblade/quagga2)
  - New user setting `quagga2_numofworkers` (`config.php`) to make the Quagga2 setting "numOfWorkers" adjustable (defaults to `4`)
  - Various display/CSS improvements (thanks @Mik-)
- Prerequisites (PHP extensions, critical files/folders) will now be checked and properly reported if there are problems (thanks @Forceu)
- Improved the the overview pages on mobile devices (main column was hidden) (thanks @Mik-)
- The general search field now searches accent insensitive (and table sorting is also accent insensitive)
- Fixed that all number inputs are always prefilled in the browser locale number format
- Optimized the handling of settings provided by `data/settingoverrides` files (thanks @dacto)
- Optimized the update script (`update.sh`) to create the backup tar archive before writing to it (was a problem on Btrfs file systems) (thanks @shane-kerr)
- Fixed (again) that the `update.sh` file had wrong line endings (DOS instead of Unix)
- New translations: (thanks all the translators)
  - Japanese (demo available at https://ja.demo.grocy.info)
  - Chinese (Taiwan) (demo available at https://zh-tw.demo.grocy.info)
