### New feature: Transfer products between locations and edit stock entries
- New menu entry in the sidebar to transfer products (or as a shortcut in the more/context menu per line on the stock overview page)
- New button "Stock entries" in the header of the stock overview page (or as a shortcut in the more/context menu per line) to show the detail stock entries behind each product
  - From there you can also edit the stock entries
- (A huge THANK YOU goes to @kriddles for the work on this feature)

### New feature: Scan mode
- Just scan one product after another, no manual input required and audio feedback is provided
- New switch-button on the purchase and consume page
- When enabled
  - The amount will always be filled with `1` after changing/scanning a product
  - If all fields could be automatically populated (means for purchase the product has a default best before date set), the transaction is automatically submitted
    - If not, a warning is displayed and you can fill in the missing information
  - Audio feedback is provided after scanning and on success/error of the transaction
- => Quick video demo: https://www.youtube.com/watch?v=83dm9iD718k

### New feature: Self produced products
- To a recipe a product can be attached
  - This products needs a "Default best before date"
- On using "Consume all ingredients needed by this recipe" and when it has a product attached, one unit of that product (per serving in purchase quantity unit) will be added to stock (with the proper price based on the recipe ingredients)
- (Thanks @kriddles for the initial work on this)

### New feature: Freeze/Thaw products
- New product options "Default best before days after freezing/thawing" to set how the best before date should be changed on freezing/thawing
- New location option "Is freezer" to indicate if the location is a freezer
- => When moving a product from/to a freezer location, the best before date is changed accordingly
- There is also a new sub feature flag `FEATURE_FLAG_STOCK_PRODUCT_FREEZING` to disable this if you don't need it (defaults to `true`)

### Stock improvements/fixes
- The product card gets now also refreshed after a transaction was posted (purchase/consume/etc.) (thanks @kriddles)
- The product field calories (kcal) now also allows decimal numbers
- On the inventory page, "New amount" is now prefilled with the current stock amount of the selected product
- Fixed that entering partial amounts was not possible on the inventory page (only applies if the product option "Allow partial units in stock" is enabled)
- Fixed that on purchase a wrong minimum amount was enforced for products with enabled tare weight handling in combination with different purchase/stock quantity units
- Fixed that the product card did not load correctly when `FEATURE_FLAG_STOCK_LOCATION_TRACKING` was set to `false` (thanks @kriddles)
- Fixed that the "Add as barcode to existing product" workflow did not work twice when not switching the page inbetween

### Shopping list improvements/fixes
- Added a compact view to have a better shopping list for shopping trips (new button "Compact view" in the header, additionally this is automatically enabled on mobile devices / when screen width is < 768 px)
- It's now possible to filter for only undone (not striked through) items (new option in the "Filter by status" dropdown)
- Fixed that when `FEATURE_FLAG_SHOPPINGLIST_MULTIPLE_LISTS` was set to `false`, the shopping list appeared empty after some actions

### Recipe improvements
- When consuming a recipe and if an ingredient is not in stock, but that product has any subproduct which is in stock, this gets now consumed (before consuming was not possible in that case)
- When adding or editing a recipe ingredient, a dialog is now used instead of switching between pages (thanks @kriddles)

### Meal plan improvements/fixes
- It's now possible to add notes per day (in the dropdown of the add button in the header of each day column)
- It's now possible to products directly (also in the dropdown of the add button in the header of each day column, maybe useful in combination with the new "Self produced products" feature)
- Added that the calories per serving are now also shown
- Added that the total costs and calories per day are displayed in the header of each day column
- Added a new `config.php` setting `MEAL_PLAN_FIRST_DAY_OF_WEEK` which can be used to start the meal plan on a different day (defaults to `CALENDAR_FIRST_DAY_OF_WEEK`, so no changed behavior when not configured)
- Fixed that when `FEATURE_FLAG_STOCK_PRICE_TRACKING` was set to `false`, prices were still shown (thanks @kriddles)
- Fixed that the week costs were missing for the weeks 1 - 9 of a year

### Calendar improvements
- Improved that meal plan events in the iCal calendar export now contain a link to the appropriate meal plan week in the body of the event (thanks @kriddles)

### Task fixes
- Fixed that a due date was required when editing an existing task

### API improvements/fixes
- The endpoint `/stock` now includes also the product object itself (new field/property `product`) (thanks @gsacre)
- The endpoint `/stock/products/{productId}/entries` can now include stock entries of child products (if the given product is a parent product and in addition to the ones of the given product) - new query parameter `include_sub_products` (defaults to `false` so no changed behavior when not supplied)
- New endpoints for the new stock transfer & stock entry edit capabilities
- Fixed that the route `/stock/barcodes/external-lookup/{barcode}` did not work, because the `barcode` argument was expected as a route argument but the route was missing it (thanks @Mikhail5555 and @beetle442002)
- Fixed the response type description of the `/stock/volatile` endpoint

### General & other improvements/fixes
- It's now possible to keep the screen on always or when a "fullscreen-card" (e. g. used for recipes) is displayed
  - New user options in the display settings menu in the top right corner (defaults to disabled)
- Slightly optimized table loading & search performance (thanks @lwis)
- Added that the currently active sidebar menu item is always in view
- Reordered the sidebar menu items a little bit, grouped them by borders and made them a little smaller to waste less space
- Changed/removed some animations (and replaced jQuery UI by [Animate.css](https://daneden.github.io/animate.css/)) to improve responsiveness
- Fixed that also the first column (where in most tables only buttons/menus are displayed) in tables was searched when using the general search field
- Fixed that the meal plan menu entry (sidebar) was not visible when the calendar was disabled (`FEATURE_FLAG_CALENDAR`) (thanks @lwis)
- For integration: If a `GET` parameter `closeAfterCreation` is passed to the product edit page, the window will be closed on save (due to Browser restrictions, this only works when the window was opened from JavaScript) (thanks @Forceu)
- Fixed that the `update.sh` file had wrong line endings (DOS instead of Unix)
- Internal change: Demo mode is now handled via the setting `MODE` instead of checking the existence of the file `data/demo.txt`
- There is now a RSS feed for the changelog, subscribe to get notified about new releases: https://grocy.info/changelog/feed
- New translations: (thanks all the translators)
  - Hungarian (demo available at https://hu.demo.grocy.info)
  - Portuguese (Brazil) (demo available at https://pt-br.demo.grocy.info)
  - Slovak (demo available at https://sk.demo.grocy.info)
