# Rules

- [Rules](#rules)
  - [Rules support matrix by techno](#rules-support-matrix-by-techno)
  - [Rules to be reworked / measured / clarified](#rules-to-be-reworked--measured--clarified)
  - [Deprecated rules](#deprecated-rules)
  - [Refused / Deleted rules](#refused--deleted-rules)

## Rules support matrix by techno

This matrix lists all the rules identified as implementable within the standard creedengo plugin.

Some are applicable for different technologies.

- ✅ Rule included in current version of creedengo
- 🚧 Rule implementation in progress
- 🚀 Rule to implement
- ❓ Rule to analyze for applicability
- 🚫 Non applicable rule

| Rule key | Name                                                          | Description                                                                                                                                                                                                                                                                                                                                                                                                                   | Reference/Validation                                                                                                                                                    | Java | Php | JS | Python | Rust | C# | HTML |
|----------|---------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------|------|-----|----|--------|------|----|------|
| CRJVM205 | Force usage of FetchType LAZY for collections on JPA entities |                                                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | 🚧   | ❓   | ❓  | ❓      | ❓    | ❓  | 🚫   |
| CRJVM206 | Avoid N+1 selects problem                                     |                                                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | 🚧   | ❓   | ❓  | ❓      | ❓    | ❓  | 🚫   |
| CRJVM207 | Customer data must have end-of-life information               |                                                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | 🚧   | ❓   | ❓  | ❓      | ❓    | ❓  | ❓    |
| CRJVM??? | Persistence Java : Avoid Joints on non indexed columns        |                                                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | 🚧   | ❓   | ❓  | ❓      | ❓    | ❓  | 🚫   |
| GCI1     | Calling a Spring repository inside a loop or a stream         | The use of Spring repository in a loop or a stream induces unnecessary calculations by the CPU and therefore superfluous energy consumption.                                                                                                                                                                                                                                                                                  |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI2     | Multiple if-else statements                                   | Using too many conditional if-else statements will impact performance since JVM will have to compare the conditions. Prefer using a switch statement instead of multiple if-else if possible, or refactor your code to reduce conditonnal statements on the same variable. Switch statement has a performance advantage over if – else.                                                                                       |                                                                                                                                                                         | ✅    | ✅   | 🚀 | ✅      | 🚀   | 🚀 | 🚫   |
| GCI3     | Getting the size of the collection in the loop                | When iterating over any collection, fetch the size of the collection in advance to avoid fetching it on each iteration, this saves CPU cycles, and therefore consumes less power.                                                                                                                                                                                                                                             |                                                                                                                                                                         | ✅    | ✅   | 🚀 | 🚫     | 🚀   | 🚫 | 🚫   |
| GCI4     | Use global variables                                          | When using a global variable, the interpretation engine must check:  1) that it exists in the current scope, in the one above, etc. ; 2) the variable has a value; 3) ... To avoid all these checks, it is often possible to pass the useful variables as arguments of routines, making them local.  This process saves computational time (CPU cycles).                                                                      | [cnumr best practices (3rd edition) BP_050 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | 🚫   | ✅   | 🚀 | ✅      | 🚀   | 🚫 | 🚫   |
| GCI5     | Usage of preparedStatement instead of Statement               | SQL will only commit the query once, whereas if you used only one statement, it would commit the query every time and thus induce unnecessary calculations by the CPU and therefore superfluous energy consumption.                                                                                                                                                                                                           |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI7     | Rewrite native getter/setters                                 | Overloading them lengthens the compilation and execution times of these methods, which are usually much better optimized by the language than by the developer.                                                                                                                                                                                                                                                               | [cnumr best practices (3rd edition) BP_062 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | 🚫   | 🚫  | 🚀 | ✅      | 🚀   | 🚫 | 🚫   |
| GCI9     | No import all from library                                    | ESLint key : @ecocode/no-import-all-from-library /// type : Common                                                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                         | ❓    | ❓   | ✅  | ❓      | ❓    | ❓  | 🚫   |
| GCI10    | Use unoptimized vector images                                 | Less heavy SVG images using less bandwidth                                                                                                                                                                                                                                                                                                                                                                                    | [cnumr best practices (3rd edition) BP_036](https://github.com/cnumr/best-practices/blob/main/chapters/BP_036_fr.md)                                                    | 🚧   | 🚀  | 🚀 | ✅      | 🚀   | 🚫 | ❓    |
| GCI11    | Call a DOM element multiple times without caching             | ESLint key : @ecocode/no-multiple-access-dom-element /// type : Front-end                                                                                                                                                                                                                                                                                                                                                     |                                                                                                                                                                         | 🚫   | ❓   | ✅  | 🚫     | 🚫   | ❓  | 🚫   |
| GCI12    | Modify several CSS properties all at once                     | ESLint key : @ecocode/no-multiple-style-changes /// type : Front-end                                                                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                         | 🚫   | ❓   | ✅  | 🚫     | 🚫   | ❓  | 🚫   |
| GCI13    | Prefer API collections with pagination                        | ESLint key : @ecocode/prefer-collections-with-pagination /// type : Back-end                                                                                                                                                                                                                                                                                                                                                  |                                                                                                                                                                         | ❓    | ❓   | ✅  | ❓      | ❓    | ❓  | 🚫   |
| GCI22    | The use of methods for basic operations                       | Using methods for basic operations consumes additional system resources. The interpreter must in effect and solve the objects and then the methods, just to carry out these simple operations of the language.                                                                                                                                                                                                                | [cnumr best practices (3rd edition) BP_048 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | 🚫   | 🚫  | 🚀 | 🚀     | 🚀   | 🚫 | 🚫   |
| GCI24    | Limit the number of returns for a SQL query                   | ESLint key : @ecocode/limit-db-query-results /// type : Back-end                                                                                                                                                                                                                                                                                                                                                              |                                                                                                                                                                         | 🚧   | 🚀  | ✅  | 🚀     | 🚀   | 🚀 | 🚫   |
| GCI25    | Do not use an image with empty source attribute               | ESLint key : @ecocode/no-empty-image-src-attribute /// type : Front-end                                                                                                                                                                                                                                                                                                                                                       |                                                                                                                                                                         | ❓    | ❓   | ✅  | ❓      | ❓    | ❓  | 🚀   |
| GCI26    | Prefer shorthand CSS notations                                | ESLint key : @ecocode/prefer-shorthand-css-notations /// type : Front-end                                                                                                                                                                                                                                                                                                                                                     |                                                                                                                                                                         | ❓    | ❓   | ✅  | ❓      | ❓    | ❓  | 🚫   |
| GCI27    | Usage of system.arraycopy to copy arrays                      | Programs spend most of the time in loops. These can be resource consuming, especially when they integrate heavy processing (IO access). Moreover, the size of the data and processing inside the loops will not allow full use of hardware mechanisms such as the cache or compiler optimization mechanisms.                                                                                                                  |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI28    | Optimize read file exceptions                                 |                                                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI29    | Avoid usage of CSS animations                                 | ESLint key : @ecocode/avoid-css-animations /// type : Front-end                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | ❓    | ❓   | ✅  | ❓      | ❓    | ❓  | 🚫   |
| GCI30    | Provide a print stylesheet                                    | ESLint key : @ecocode/provide-print-css /// type : Front-end                                                                                                                                                                                                                                                                                                                                                                  |                                                                                                                                                                         | ❓    | ❓   | ✅  | ❓      | ❓    | ❓  | 🚫   |
| GCI31    | Prefer lighter formats for image files                        | ESLint key : ... /// type : ...                                                                                                                                                                                                                                                                                                                                                                                               |                                                                                                                                                                         | ❓    | ❓   | 🚀 | ❓      | ❓    | ❓  | 🚀   | 
| GCI32    | Initialize builder/buffer with the appropriate size           | If you know in advance how many characters would be appended, initialize builder/buffer with the appropriate size. They will thus never have to be resized. This saves CPU cycles and therefore consumes less energy.                                                                                                                                                                                                         |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI35    | Using try...catch calls (on File Not Found error)             | When an exception is thrown, a variable (the exception itself) is created in the catch block and destroyed at the end of the block.  Creating this variable and destroying it consumes CPU cycles and RAM unnecessarily. That is why it is important not to use this construction and to prefer, as much as possible, a logical test.  This new rule replace old GCI34 only for a particular use case (FileNotFoundException) | [cnumr best practices (3rd edition) BP_047 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | 🚫   | ✅   | 🚀 | ✅      | 🚀   | 🚫 | 🚫   |
| GCI36    | Avoid autoplay for videos and audio content                   | Autoplaying media consumes unnecessary energy, especially when users might not be actively engaging with the content.                                                                                                                                                                                                                                                                                                         | [cnumr best practices BP_4003](https://github.com/cnumr/best-practices/blob/main/chapters/BP_4003_en.md)                                                                | 🚫   | 🚫  | 🚀 | 🚫     | 🚫   | 🚫 | 🚧   |
| GCI66    | Use single quote (') instead of quotation mark (")            | The shape using the quotation marks allows the developer to insert variables that will be substituted at run time. But if the string does not have a variable, use quotes instead. Thus, language will not look for variables to subtituture, which will reduce the consumption of CPU cycles.                                                                                                                                | [cnumr best practices (3rd edition) BP_066 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | 🚀   | ✅   | 🚀 | 🚫     | 🚀   | 🚫 | 🚫   |
| GCI67    | Use the $i++ variable during an iteration                     | The $i++ form has the disadvantage of generating a tem-porary variable during incrementation, which is not the case with the ++$i form.                                                                                                                                                                                                                                                                                       | [cnumr best practices (3rd edition) BP_067 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | ✅    | ✅   | 🚀 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI69    | Calling a loop invariant function in a loop condition         | Avoid calling loop invariant functions in loop conditions.                                                                                                                                                                                                                                                                                                                                                                    | [cnumr best practices (3rd edition) BP_069 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | ✅    | ✅   | 🚀 | 🚫     | 🚀   | ✅  | 🚫   |
| GCI72    | Perform an SQL query inside a loop                            | Servers are optimized to process multiple selections, insertions, or changes in a single query or transaction. consume CPU cycles, RAM, and bandwidth unnecessarily.                                                                                                                                                                                                                                                          | [cnumr best practices (3rd edition) BP_072](https://github.com/cnumr/best-practices/blob/main/chapters/BP_072_fr.md)                                                    | ✅    | ✅   | 🚀 | ✅      | 🚀   | ✅  | 🚫   |
| GCI74    | Write SELGCIT * FROM                                          | The database server must resolve the fields based on the schema. If you are familiar with the diagram, it is strongly recommended to name the fields.                                                                                                                                                                                                                                                                         | [cnumr best practices (3rd edition) BP_074 (no longer exists in edition 4)](https://www.greenit.fr/2019/05/07/ecoconception-web-les-115-bonnes-pratiques-3eme-edition/) | ✅    | ✅   | 🚀 | ✅      | 🚀   | 🚀 | 🚫   |
| GCI75    | Don't concatenate strings in loops                            | Avoid repeated string allocations and consider using a StringBuilder instead.                                                                                                                                                                                                                                                                                                                                                 |                                                                                                                                                                         | 🚫   | ❓   | ❓  | ❓      | ❓    | ✅  | 🚫   |
| GCI76    | Usage of static collections                                   | Avoid usage of static collections. If you want to use static collections make them final and create for example a singleton if needed containing the collections. The static fields are more complicated for the Garbage Collector to manage and can lead to memory leaks.                                                                                                                                                    |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI77    | Usage Pattern.compile() in a non-static context               | Avoid using Pattern.compile() in a non-static context. This operation requires a non negligible amount of computational power, Using a single match saves CPU cycles and RAM consumption.                                                                                                                                                                                                                                     |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI78    | Const parameter in batch update                               | Don't set const parameter in batch update => Put its in query. Creating this parameter and destroying it consumes CPU cycles and RAM unnecessarily.                                                                                                                                                                                                                                                                           |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI79    | Free resources                                                | try-with-resources Statement needs to be implemented for any object that implements the AutoCloseable interface, it save computer resources.                                                                                                                                                                                                                                                                                  |                                                                                                                                                                         | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI81    | Specify struct layouts                                        | When possible, specify struct layouts to optimize their memory footprint                                                                                                                                                                                                                                                                                                                                                      |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI82    | Make variable constant                                        | A variable is never reassigned and can be made constant                                                                                                                                                                                                                                                                                                                                                                       |                                                                                                                                                                         | 🚀   | 🚀  | 🚀 | 🚀     | 🚀   | ✅  | 🚫   |
| GCI83    | Replace Enum ToString() with nameof                           | When no string format is applied, use nameof instead of ToString() for performance                                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI84    | Avoid async void methods                                      | Use async Task methods instead, for performance, stability and testability                                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI85    | Make type sealed                                              | Seal types that don't need inheritance for performance reasons                                                                                                                                                                                                                                                                                                                                                                |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI86    | GC.Collect should not be called                               | In most cases, the cost of calling GC.Collect far outweighs the benefits                                                                                                                                                                                                                                                                                                                                                      |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI87    | Use collection indexer                                        | Collection indexers should be used instead of Linq, when available                                                                                                                                                                                                                                                                                                                                                            |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI88    | Dispose resource asynchronously                               | Resources that implement `IAsyncDisposable` should be disposed asynchronously                                                                                                                                                                                                                                                                                                                                                 |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI89    | Avoid using function cache without limit                      | If a function has decorators without max size cache, the program will store unlimited data                                                                                                                                                                                                                                                                                                                                    |                                                                                                                                                                         | ❓    | ❓   | ❓  | ✅      | ❓    | ❓  | ❓    |
| GCI91    | Use `Where` before `OrderBy`                                  | Filter elements before sorting them for improved efficiency                                                                                                                                                                                                                                                                                                                                                                   |                                                                                                                                                                         | ❓    | ❓   | ❓  | ❓      | ❓    | ✅  | ❓    |
| GCI92    | Use string.Length instead of comparison with empty string     | Comparing a string to an empty string is unnecessary and can be replaced by a call to `string.Length` which is more performant and more readable.                                                                                                                                                                                                                                                                             |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | ✅  | 🚫   |
| GCI93    | Return `Task` directly                                        | Consider returning a `Task` directly instead of a single `await`                                                                                                                                                                                                                                                                                                                                                              |                                                                                                                                                                         | ❓    | ❓   | ❓  | ❓      | ❓    | ✅  | ❓    |
| GCI94    | Use orElseGet instead of orElse                               | Parameter of orElse() is evaluated, even when having a non-empty Optional. Supplier method of orElseGet passed as an argument is only executed when an Optional value isn’t present. Therefore, using orElseGet() will save computing time.                                                                                                                                                                                   | [Optimized use of Java Optional Else](https://github.com/green-code-initiative/creedengo-challenge/issues/77)                                                           | ✅    | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
| GCI203   | Detect unoptimized file formats                               | When it is possible, to use svg format image over other image format                                                                                                                                                                                                                                                                                                                                                          |                                                                                                                                                                         | 🚀   | 🚀  | 🚀 | ✅      | 🚀   | 🚀 | 🚫   |
| GCI404   | Avoid list comprehension in iterations                        | Use generator comprehension instead of list comprehension in for loop declaration                                                                                                                                                                                                                                                                                                                                             |                                                                                                                                                                         | 🚫   | 🚫  | 🚫 | ✅      | 🚫   | 🚫 | 🚫   |
|          | Use official social media sharing buttons                     | These JavaScript plugins are very resource-intensive: to work, they require a large number of requests and download heavy files. It is better to prefer direct links.                                                                                                                                                                                                                                                         | [cnumr best practices (3rd edition) BP_019](https://github.com/cnumr/best-practices/blob/main/chapters/BP_019_fr.md)                                                    | 🚫   | 🚫  | 🚀 | 🚫     | 🚫   | 🚫 | 🚀   |
|          | Non-grouped similar CSS declarations                          | When multiple Document Object Model (DOM) elements have common CSS properties, declare them together in the same style sheet. This method reduces the weight of CSS.                                                                                                                                                                                                                                                          | [cnumr best practices (3rd edition) BP_025](https://github.com/cnumr/best-practices/blob/main/chapters/BP_025_fr.md)                                                    | 🚫   | 🚫  | 🚧 | 🚫     | 🚫   | 🚫 | 🚫   |
|          | Non-standard fonts used                                       | Prefer standard fonts, as they are already present on the user's computer, so they do not need to download them. This saves bandwidth, while speeding up the display of the site.                                                                                                                                                                                                                                             | [cnumr best practices (3rd edition) BP_029](https://github.com/cnumr/best-practices/blob/main/chapters/BP_029_fr.md)                                                    | 🚫   | 🚫  | 🚫 | 🚫     | 🚫   | 🚫 | 🚫   |
|          | Non-outsourced CSS and Javascript                             | If you include CSS or JavaScript code in the body of the HTML file, while the HTML file is used by several pages (or even the entire site), this code must be transferred for each page requested by the user, which increases the volume of data transmitted.                                                                                                                                                                | [cnumr best practices (3rd edition) BP_032](https://github.com/cnumr/best-practices/blob/main/chapters/BP_032_fr.md)                                                    | 🚫   | 🚫  | 🚀 | 🚫     | 🚫   | 🚫 | 🚀   |
|          | Resize images browser-side                                    | Do not resize images using the HEIGHT and WIDTH attributes of the HTML code. This approach requires transferring these images to their original size, wasting bandwidth and CPU cycles.                                                                                                                                                                                                                                       | [cnumr best practices (3rd edition) BP_034](https://github.com/cnumr/best-practices/blob/main/chapters/BP_034_fr.md)                                                    | 🚫   | 🚫  | 🚧 | 🚫     | 🚫   | 🚫 | 🚀   |
|          | Modify the DOM when traversing it                             | Modifying the DOM (Document Object Model) as you traverse it can lead to situations where the loop becomes very resource-intensive, especially CPU cycles.                                                                                                                                                                                                                                                                    | [cnumr best practices (3rd edition) BP_041](https://github.com/cnumr/best-practices/blob/main/chapters/BP_041_fr.md)                                                    | 🚫   | 🚫  | 🚧 | 🚫     | 🚫   | 🚫 | 🚫   |
|          | Edit DOM elements to make it invisible                        | When an element of the Document Object Model (DOM) needs to be modified by several properties, each change in style or content will generate a repaint or reflow.                                                                                                                                                                                                                                                             | [cnumr best practices (3rd edition) BP_042](https://github.com/cnumr/best-practices/blob/main/chapters/BP_042_fr.md)                                                    | 🚫   | 🚫  | 🚀 | 🚫     | 🚫   | 🚫 | 🚫   |

## Rules to be reworked / measured / clarified

This table lists rules proposed by the community but they have to be reworked / measured / clarified before being
implemented in creedengo plugins.
(Issues and PR are closed, but they can be reopen once rework launched)

| Rule key | Language | Name                                             | Description                                                                           | Invalidation                                                                                                                                                                                                                   |
|----------|----------|--------------------------------------------------|---------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| CRJVM204 | Java     | Detect unoptimized file formats                  | We have to clarify and rework this rule for Java before accepting the implementation  | [Github discussion - issue](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/105)<br/>[Github discussion - PR](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/153) |
| GCI22    | Java     | The use of methods for basic operations          | We have to measure this rule for Java before accepting the implementation             | [Github discussion - issue](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/131)<br/>[Github discussion - PR](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/148) |
| GCI22    | PHP      | The use of methods for basic operations          | We have to measure this rule for PHP before accepting the implementation              | [Github discussion - issue](https://github.com/green-code-initiative/creedengo-php/issues/23)                                                                                                                                  |
| GCI53    | Java     | Using arrays in foreach loops                    | No good arguments and not enough green measures.                                      | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/240)                                                                                                           |
| GRSP0007 | PHP      | Prefer using foreach                             | We have to clarify and measure this rule for PHP before accepting the implementation  | [Github discussion - PR](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/5)                                                                                                                       |
| GRSP0008 | PHP      | Avoid using relative path                        | We have to clarify and measure this rule for PHP before accepting the implementation  | [Github discussion - PR](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/6)                                                                                                                       |
|          | Java     | Avoid returning a JPA Entity in a RestController | We have to clarify and measure this rule for Java before accepting the implementation | [Github discussion - issue](https://github.com/green-code-initiative/creedengo-challenge/issues/58)<br/>[Github discussion - PR](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/138)             |

## Deprecated rules

This table lists rules proposed by the community but deprecated in creedengo plugins with the justification. These rules
will be completely deleted in next releases and moved to bottom deleted rules array.

| Rule key | Language   | Name                              | Description                                                                                               | Invalidation                                                                                                                                                                                               |
|----------|------------|-----------------------------------|-----------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| EC34     | Java / PHP | Using try...catch...finally calls | Implementation is too simple (only detection of presence of "try" statement) AND replaced by `GCI35` rule | Github discussion with measures : [general/java](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/128) / [php](https://github.com/green-code-initiative/creedengo-php/pull/10) |


## Refused / Deleted rules

This table lists rules proposed by the community but refused or/and deleted in creedengo plugins with the justification.

| Rule key | Language   | Name                                                  | Description                                                                                                                  | Invalidation                                                                                                                                                                                                    |
|----------|------------|-------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| CRDOM203 | HTML       | HTML page must contain a doctype tag                  | The difference in performance is negligible, this rule is more related to the user experience.                               | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/103)                                                                                            |
| CRPYT    | Python     | Use numpy array instead of standard list              | The use of numpy library to perform array manipulation is more energy efficient than the use of the standard list functions. | [Github discussion with measures](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/132)                                                                                           |
| EC4      | Java       | Avoid using global variables                          | Global variables do not exist in Java.                                                                                       | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/233)                                                                                            |
| EC8      | JavaScript | Avoid using high accuracy geolocation                 | The rule has been merged with the rule GCI523                                                                                | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/318)                                                                                            |
| EC34     | Python     | Using try...catch...finally calls                     | Implementation is too simple (only detection of presence of "try" statement) AND replaced by `GCI35` rule                    | Github discussion with measures : [general/java](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/128) / [python](https://github.com/green-code-initiative/creedengo-python/pull/6) |
| EC63     | Java       | Unnecessarily assigning values to variables           | There are already 3 native SonarQube rules for Java.                                                                         | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-rules-specifications/pull/258)                                                                                              |
| EC66     | Python     | Use single quote (') instead of quotation mark (")    | Finally, not applicable for Python                                                                                           | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-python/issues/4)                                                                                                            |
| EC69     | Python     | Calling a loop invariant function in a loop condition | Finally, not applicable for Python                                                                                           | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-python/issues/21)                                                                                                           |
| EC75     | Java       | Don't concatenate strings in loops                    | Optimizations on Java concatenation Strings are useless since JDK8                                                           | [Github discussion with sources](https://github.com/green-code-initiative/creedengo-rules-specifications/issues/246)                                                                                            |
