# Graphbrain

Graphbrain is an Artificial Intelligence open-source software library and scientific research tool. Its aim is to facilitate automated meaning extraction and text understanding, as well as the exploration and inference of knowledge. It is part of socsemics, a research project funded by the European Research Council and focused on the fragmentation in online public spaces.

The ambition of this project is not simply to contribute to advancing the state-of-the-art in AI, but principally to be an effective interdisciplinary research tool. More specifically, we are interested in advancing the possibilities of automated meaning extraction for research in fields such as Computational Social Sciences, Cognitive Science and the Humanities.

Graphbrain is built around a unifying concept: the Semantic Hypergraph (SH), which makes it possible to represent a natural language sentence such as “Einstein first published the theory of relativity in 1905” as an ordered, recursive hyperlink of the form:

<p align="center">
  <img src="http://graphbrain.net/_images/hyperedge-blocks.png" alt="Hyperedge example" width="75%"/>
</p>


The aim of SH and Graphbrain is to enable hybrid approaches, combining symbolic AI and statistical/connectionist Machine Learning methods. This is for two main reasons: to facilitate understandability and reproducibility for human researchers and to combine the strengths of both approaches.

Graphbrain is written in Python, to both take advantage and facilitate integration with the rich environment of scientific libraries available in this language. It is released under the highly permissive MIT open source license.

## Installation and manual

Installation instructions, the manual and more information can be found here: http://graphbrain.net.

## Contributing

Pull requests are welcome. For major changes, please open an issue first
to discuss what you would like to change.

Please make sure to update tests as appropriate.

## Funding

The creation of this software library and the associated research that made it possible were funded by CNRS and the ERC Consolidator
Grant [Socsemics](https://socsemics.huma-num.fr/) (grant #772743).

<a href="https://socsemics.huma-num.fr/" style="margin:0px">
  <img src="docs/source/_static/socsemics.png" width="200">
</a>

## License

[MIT](https://choosealicense.com/licenses/mit/)