CREATE (:`AnnotatedText` {`id`:"164448", `numTerms`:121});
CREATE (:`Sentence` {`hash`:"ed01a3dd13f95923c80efe1e5494af58", `id`:"164448_0", `sentenceNumber`:0, `text`:"A video clip lesson learned on the topic of Process Control."});
CREATE (:`Tag`:`NER_O` {`id`:"process_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VB", "NN"], `value`:"process"});
CREATE (:`Tag`:`NER_O` {`id`:"learn_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBD"], `value`:"learn"});
CREATE (:`Tag`:`NER_O` {`id`:"lesson_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"lesson"});
CREATE (:`Tag`:`NER_O` {`id`:"topic_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"topic"});
CREATE (:`Tag`:`NER_O` {`id`:"control_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"control"});
CREATE (:`Tag`:`NER_O` {`id`:"video_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"video"});
CREATE (:`Tag`:`NER_O` {`id`:"clip_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"clip"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:7, `ne`:["O"], `pos`:["NN"], `startPosition`:2, `value`:"video", `UNIQUE IMPORT ID`:121831});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:40, `ne`:["O"], `pos`:["NN"], `startPosition`:35, `value`:"topic", `UNIQUE IMPORT ID`:121832});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:27, `ne`:["O"], `pos`:["VBD"], `startPosition`:20, `value`:"learned", `UNIQUE IMPORT ID`:121833});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:59, `ne`:["O"], `pos`:["NN"], `startPosition`:52, `value`:"Control", `UNIQUE IMPORT ID`:121834});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:12, `ne`:["O"], `pos`:["NN"], `startPosition`:8, `value`:"clip", `UNIQUE IMPORT ID`:121835});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:51, `ne`:["O"], `pos`:["VB"], `startPosition`:44, `value`:"Process", `UNIQUE IMPORT ID`:121836});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:19, `ne`:["O"], `pos`:["NN"], `startPosition`:13, `value`:"lesson", `UNIQUE IMPORT ID`:121837});
CREATE (:`Sentence` {`hash`:"52dd4f4c956ac0b62e2ec8aaa1df3c5e", `id`:"164448_1", `sentenceNumber`:1, `text`:"Actuators inside the tail enable the rudder speed brake panels to steer and slow the Space Shuttle during descent and landing."});
CREATE (:`Tag`:`NER_O` {`id`:"tail_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"tail"});
CREATE (:`Tag`:`NER_O` {`id`:"inside_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["IN"], `value`:"inside"});
CREATE (:`Tag`:`NER_O` {`id`:"speed_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"speed"});
CREATE (:`Tag`:`NER_O` {`id`:"space_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"space"});
CREATE (:`Tag`:`NER_O` {`id`:"brake_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNP"], `value`:"brake"});
CREATE (:`Tag`:`NER_O` {`id`:"descent_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"descent"});
CREATE (:`Tag`:`NER_O` {`id`:"actuator_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"actuator"});
CREATE (:`Tag`:`NER_O` {`id`:"shuttle_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN", "NNP"], `value`:"shuttle"});
CREATE (:`Tag`:`NER_O` {`id`:"landing_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"landing"});
CREATE (:`Tag`:`NER_O` {`id`:"slow_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VB"], `value`:"slow"});
CREATE (:`Tag`:`NER_O` {`id`:"enable_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBP"], `value`:"enable"});
CREATE (:`Tag`:`NER_O` {`id`:"rudder_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"rudder"});
CREATE (:`Tag`:`NER_O` {`id`:"steer_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VB"], `value`:"steer"});
CREATE (:`Tag`:`NER_O` {`id`:"panel_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS"], `value`:"panel"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:104, `ne`:["O"], `pos`:["NN"], `startPosition`:98, `value`:"rudder", `UNIQUE IMPORT ID`:121853});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:77, `ne`:["O"], `pos`:["IN"], `startPosition`:71, `value`:"inside", `UNIQUE IMPORT ID`:121854});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:174, `ne`:["O"], `pos`:["NN"], `startPosition`:167, `value`:"descent", `UNIQUE IMPORT ID`:121855});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:110, `ne`:["O"], `pos`:["NN"], `startPosition`:105, `value`:"speed", `UNIQUE IMPORT ID`:121856});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:141, `ne`:["O"], `pos`:["VB"], `startPosition`:137, `value`:"slow", `UNIQUE IMPORT ID`:121857});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:116, `ne`:["O"], `pos`:["NNP"], `startPosition`:111, `value`:"brake", `UNIQUE IMPORT ID`:121858});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:86, `ne`:["O"], `pos`:["NN"], `startPosition`:82, `value`:"tail", `UNIQUE IMPORT ID`:121859});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:151, `ne`:["O"], `pos`:["NN"], `startPosition`:146, `value`:"Space", `UNIQUE IMPORT ID`:121860});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:186, `ne`:["O"], `pos`:["NN"], `startPosition`:179, `value`:"landing", `UNIQUE IMPORT ID`:121861});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:123, `ne`:["O"], `pos`:["NNS"], `startPosition`:117, `value`:"panels", `UNIQUE IMPORT ID`:121862});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:93, `ne`:["O"], `pos`:["VBP"], `startPosition`:87, `value`:"enable", `UNIQUE IMPORT ID`:121863});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:159, `ne`:["O"], `pos`:["NN"], `startPosition`:152, `value`:"Shuttle", `UNIQUE IMPORT ID`:121864});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:70, `ne`:["O"], `pos`:["NNS"], `startPosition`:61, `value`:"Actuators", `UNIQUE IMPORT ID`:121865});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:132, `ne`:["O"], `pos`:["VB"], `startPosition`:127, `value`:"steer", `UNIQUE IMPORT ID`:121866});
CREATE (:`Sentence` {`hash`:"fc30b97433f04eaf16e9ffe9994ddc10", `id`:"164448_2", `sentenceNumber`:2, `text`:"Unusual wear was found on the planet gears of the actuators during an inspection."});
CREATE (:`Tag`:`NER_O` {`id`:"find_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"find"});
CREATE (:`Tag`:`NER_O` {`id`:"planet_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"planet"});
CREATE (:`Tag`:`NER_O` {`id`:"wear_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"wear"});
CREATE (:`Tag`:`NER_O` {`id`:"unusual_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"unusual"});
CREATE (:`Tag`:`NER_O` {`id`:"gear_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"gear"});
CREATE (:`Tag`:`NER_O` {`id`:"inspection_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"inspection"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:230, `ne`:["O"], `pos`:["NNS"], `startPosition`:225, `value`:"gears", `UNIQUE IMPORT ID`:121874});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:268, `ne`:["O"], `pos`:["NN"], `startPosition`:258, `value`:"inspection", `UNIQUE IMPORT ID`:121875});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:200, `ne`:["O"], `pos`:["NN"], `startPosition`:196, `value`:"wear", `UNIQUE IMPORT ID`:121876});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:224, `ne`:["O"], `pos`:["NN"], `startPosition`:218, `value`:"planet", `UNIQUE IMPORT ID`:121877});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:195, `ne`:["O"], `pos`:["JJ"], `startPosition`:188, `value`:"Unusual", `UNIQUE IMPORT ID`:121878});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:210, `ne`:["O"], `pos`:["VBN"], `startPosition`:205, `value`:"found", `UNIQUE IMPORT ID`:121879});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:247, `ne`:["O"], `pos`:["NNS"], `startPosition`:238, `value`:"actuators", `UNIQUE IMPORT ID`:121880});
CREATE (:`Sentence` {`hash`:"55204ea78caa08421cfc34a67893487c", `id`:"164448_3", `sentenceNumber`:3, `text`:"This led to a discovery that when the Shuttle was built the gears were installed incorrectly a critical flight failure mode."});
CREATE (:`Tag`:`NER_O` {`id`:"incorrectly_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["RB"], `value`:"incorrectly"});
CREATE (:`Tag`:`NER_O` {`id`:"mode_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"mode"});
CREATE (:`Tag`:`NER_O` {`id`:"flight_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"flight"});
CREATE (:`Tag`:`NER_O` {`id`:"critical_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"critical"});
CREATE (:`Tag`:`NER_O` {`id`:"build_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"build"});
CREATE (:`Tag`:`NER_O` {`id`:"install_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"install"});
CREATE (:`Tag`:`NER_O` {`id`:"discovery_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"discovery"});
CREATE (:`Tag`:`NER_O` {`id`:"failure_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"failure"});
CREATE (:`Tag`:`NER_O` {`id`:"lead_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBD"], `value`:"lead"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:325, `ne`:["O"], `pos`:["VBN"], `startPosition`:320, `value`:"built", `UNIQUE IMPORT ID`:121891});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:278, `ne`:["O"], `pos`:["VBD"], `startPosition`:275, `value`:"led", `UNIQUE IMPORT ID`:121892});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:315, `ne`:["O"], `pos`:["NNP"], `startPosition`:308, `value`:"Shuttle", `UNIQUE IMPORT ID`:121893});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:350, `ne`:["O"], `pos`:["VBN"], `startPosition`:341, `value`:"installed", `UNIQUE IMPORT ID`:121894});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:393, `ne`:["O"], `pos`:["NN"], `startPosition`:389, `value`:"mode", `UNIQUE IMPORT ID`:121895});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:380, `ne`:["O"], `pos`:["NN"], `startPosition`:374, `value`:"flight", `UNIQUE IMPORT ID`:121896});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:335, `ne`:["O"], `pos`:["NNS"], `startPosition`:330, `value`:"gears", `UNIQUE IMPORT ID`:121897});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:293, `ne`:["O"], `pos`:["NN"], `startPosition`:284, `value`:"discovery", `UNIQUE IMPORT ID`:121898});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:373, `ne`:["O"], `pos`:["JJ"], `startPosition`:365, `value`:"critical", `UNIQUE IMPORT ID`:121899});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:388, `ne`:["O"], `pos`:["NN"], `startPosition`:381, `value`:"failure", `UNIQUE IMPORT ID`:121900});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:362, `ne`:["O"], `pos`:["RB"], `startPosition`:351, `value`:"incorrectly", `UNIQUE IMPORT ID`:121901});
CREATE (:`Sentence` {`hash`:"aae7f1d2f3cf3d0b64b31228f101c62e", `id`:"164448_4", `sentenceNumber`:4, `text`:"The installation error stemmed from the near identical appearance of component gears that had different design topographies."});
CREATE (:`Tag`:`NER_O` {`id`:"identical_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"identical"});
CREATE (:`Tag`:`NER_O` {`id`:"component_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"component"});
CREATE (:`Tag`:`NER_O` {`id`:"appearance_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"appearance"});
CREATE (:`Tag`:`NER_O` {`id`:"installation_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"installation"});
CREATE (:`Tag`:`NER_O` {`id`:"design_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"design"});
CREATE (:`Tag`:`NER_O` {`id`:"topography_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS"], `value`:"topography"});
CREATE (:`Tag`:`NER_O` {`id`:"near_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"near"});
CREATE (:`Tag`:`NER_O` {`id`:"error_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"error"});
CREATE (:`Tag`:`NER_O` {`id`:"different_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"different"});
CREATE (:`Tag`:`NER_O` {`id`:"stem_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBD"], `value`:"stem"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:473, `ne`:["O"], `pos`:["NN"], `startPosition`:464, `value`:"component", `UNIQUE IMPORT ID`:121913});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:425, `ne`:["O"], `pos`:["VBD"], `startPosition`:418, `value`:"stemmed", `UNIQUE IMPORT ID`:121914});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:460, `ne`:["O"], `pos`:["NN"], `startPosition`:450, `value`:"appearance", `UNIQUE IMPORT ID`:121915});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:439, `ne`:["O"], `pos`:["JJ"], `startPosition`:435, `value`:"near", `UNIQUE IMPORT ID`:121916});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:505, `ne`:["O"], `pos`:["NN"], `startPosition`:499, `value`:"design", `UNIQUE IMPORT ID`:121917});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:449, `ne`:["O"], `pos`:["JJ"], `startPosition`:440, `value`:"identical", `UNIQUE IMPORT ID`:121918});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:498, `ne`:["O"], `pos`:["JJ"], `startPosition`:489, `value`:"different", `UNIQUE IMPORT ID`:121919});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:479, `ne`:["O"], `pos`:["NNS"], `startPosition`:474, `value`:"gears", `UNIQUE IMPORT ID`:121920});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:518, `ne`:["O"], `pos`:["NNS"], `startPosition`:506, `value`:"topographies", `UNIQUE IMPORT ID`:121921});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:417, `ne`:["O"], `pos`:["NN"], `startPosition`:412, `value`:"error", `UNIQUE IMPORT ID`:121922});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:411, `ne`:["O"], `pos`:["NN"], `startPosition`:399, `value`:"installation", `UNIQUE IMPORT ID`:121923});
CREATE (:`Sentence` {`hash`:"029cd95e68e4eb700eed19b34877130c", `id`:"164448_5", `sentenceNumber`:5, `text`:"The robust actuators were able to operate for 20 years (approximately 30 missions) without failure."});
CREATE (:`Tag`:`NER_O` {`id`:"mission_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS"], `value`:"mission"});
CREATE (:`Tag`:`NER_O` {`id`:"robust_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"robust"});
CREATE (:`Tag`:`NER_O` {`id`:"operate_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VB"], `value`:"operate"});
CREATE (:`Tag`:`NER_O` {`id`:"approximately_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["RB"], `value`:"approximately"});
CREATE (:`Tag`:`NER_O` {`id`:"able_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"able"});
CREATE (:`Tag`:`NER_Duration` {`id`:"20 years_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["DURATION"], `pos`:[], `value`:"20 years"});
CREATE (:`Tag`:`NER_Number` {`id`:"30_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["NUMBER"], `pos`:[], `value`:"30"});
CREATE (:`Tag`:`NER_O` {`id`:"without_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["IN"], `value`:"without"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:589, `ne`:["O"], `pos`:["RB"], `startPosition`:576, `value`:"approximately", `UNIQUE IMPORT ID`:121933});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:601, `ne`:["O"], `pos`:["NNS"], `startPosition`:593, `value`:"missions", `UNIQUE IMPORT ID`:121934});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:550, `ne`:["O"], `pos`:["JJ"], `startPosition`:546, `value`:"able", `UNIQUE IMPORT ID`:121935});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:540, `ne`:["O"], `pos`:["NNS"], `startPosition`:531, `value`:"actuators", `UNIQUE IMPORT ID`:121936});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:618, `ne`:["O"], `pos`:["NN"], `startPosition`:611, `value`:"failure", `UNIQUE IMPORT ID`:121937});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:574, `ne`:["DURATION"], `pos`:[], `startPosition`:566, `value`:"20 years", `UNIQUE IMPORT ID`:121938});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:561, `ne`:["O"], `pos`:["VB"], `startPosition`:554, `value`:"operate", `UNIQUE IMPORT ID`:121939});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:610, `ne`:["O"], `pos`:["IN"], `startPosition`:603, `value`:"without", `UNIQUE IMPORT ID`:121940});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:530, `ne`:["O"], `pos`:["JJ"], `startPosition`:524, `value`:"robust", `UNIQUE IMPORT ID`:121941});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:592, `ne`:["NUMBER"], `pos`:[], `startPosition`:590, `value`:"30", `UNIQUE IMPORT ID`:121942});
CREATE (:`Sentence` {`hash`:"81a9c96be5e7cdcff666f831429b1574", `id`:"164448_6", `sentenceNumber`:6, `text`:"The mistake was not found sooner because the actuators were certified for the original flight life of the Shuttle 10 years or 100 missions."});
CREATE (:`Tag`:`NER_O` {`id`:"mistake_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"mistake"});
CREATE (:`Tag`:`NER_Number` {`id`:"100_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["NUMBER"], `pos`:[], `value`:"100"});
CREATE (:`Tag`:`NER_O` {`id`:"original_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"original"});
CREATE (:`Tag`:`NER_O` {`id`:"sooner_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["RBR"], `value`:"sooner"});
CREATE (:`Tag`:`NER_O` {`id`:"certify_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"certify"});
CREATE (:`Tag`:`NER_Duration` {`id`:"10 years_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["DURATION"], `pos`:[], `value`:"10 years"});
CREATE (:`Tag`:`NER_O` {`id`:"life_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"life"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:631, `ne`:["O"], `pos`:["NN"], `startPosition`:624, `value`:"mistake", `UNIQUE IMPORT ID`:121951});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:645, `ne`:["O"], `pos`:["VBN"], `startPosition`:640, `value`:"found", `UNIQUE IMPORT ID`:121952});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:713, `ne`:["O"], `pos`:["NN"], `startPosition`:707, `value`:"flight", `UNIQUE IMPORT ID`:121953});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:652, `ne`:["O"], `pos`:["RBR"], `startPosition`:646, `value`:"sooner", `UNIQUE IMPORT ID`:121954});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:733, `ne`:["O"], `pos`:["NNP"], `startPosition`:726, `value`:"Shuttle", `UNIQUE IMPORT ID`:121955});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:689, `ne`:["O"], `pos`:["VBN"], `startPosition`:680, `value`:"certified", `UNIQUE IMPORT ID`:121956});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:674, `ne`:["O"], `pos`:["NNS"], `startPosition`:665, `value`:"actuators", `UNIQUE IMPORT ID`:121957});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:706, `ne`:["O"], `pos`:["JJ"], `startPosition`:698, `value`:"original", `UNIQUE IMPORT ID`:121958});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:718, `ne`:["O"], `pos`:["NN"], `startPosition`:714, `value`:"life", `UNIQUE IMPORT ID`:121959});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:749, `ne`:["NUMBER"], `pos`:[], `startPosition`:746, `value`:"100", `UNIQUE IMPORT ID`:121960});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:742, `ne`:["DURATION"], `pos`:[], `startPosition`:734, `value`:"10 years", `UNIQUE IMPORT ID`:121961});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:758, `ne`:["O"], `pos`:["NNS"], `startPosition`:750, `value`:"missions", `UNIQUE IMPORT ID`:121962});
CREATE (:`Sentence` {`hash`:"a23536753124f9fd97e244e37e2d0032", `id`:"164448_7", `sentenceNumber`:7, `text`:"New gears were installed, and a process control was implemented that accommodates the demands of ground operations."});
CREATE (:`Tag`:`NER_O` {`id`:"new_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNP"], `value`:"new"});
CREATE (:`Tag`:`NER_O` {`id`:"accommodate_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBZ"], `value`:"accommodate"});
CREATE (:`Tag`:`NER_O` {`id`:"implement_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"implement"});
CREATE (:`Tag`:`NER_O` {`id`:"ground_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"ground"});
CREATE (:`Tag`:`NER_O` {`id`:"demand_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS"], `value`:"demand"});
CREATE (:`Tag`:`NER_O` {`id`:"operation_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS"], `value`:"operation"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:807, `ne`:["O"], `pos`:["NN"], `startPosition`:800, `value`:"control", `UNIQUE IMPORT ID`:121970});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:874, `ne`:["O"], `pos`:["NNS"], `startPosition`:864, `value`:"operations", `UNIQUE IMPORT ID`:121971});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:784, `ne`:["O"], `pos`:["VBN"], `startPosition`:775, `value`:"installed", `UNIQUE IMPORT ID`:121972});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:763, `ne`:["O"], `pos`:["NNP"], `startPosition`:760, `value`:"New", `UNIQUE IMPORT ID`:121973});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:799, `ne`:["O"], `pos`:["NN"], `startPosition`:792, `value`:"process", `UNIQUE IMPORT ID`:121974});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:863, `ne`:["O"], `pos`:["NN"], `startPosition`:857, `value`:"ground", `UNIQUE IMPORT ID`:121975});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:769, `ne`:["O"], `pos`:["NNS"], `startPosition`:764, `value`:"gears", `UNIQUE IMPORT ID`:121976});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:823, `ne`:["O"], `pos`:["VBN"], `startPosition`:812, `value`:"implemented", `UNIQUE IMPORT ID`:121977});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:841, `ne`:["O"], `pos`:["VBZ"], `startPosition`:829, `value`:"accommodates", `UNIQUE IMPORT ID`:121978});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:853, `ne`:["O"], `pos`:["NNS"], `startPosition`:846, `value`:"demands", `UNIQUE IMPORT ID`:121979});
CREATE (:`Sentence` {`hash`:"10929d5ad55baf527edbdc3235761dc9", `id`:"164448_8", `sentenceNumber`:8, `text`:"A dedicated fixture was fabricated for each actuator with physical features that prevent installation of the incorrect gear."});
CREATE (:`Tag`:`NER_O` {`id`:"fixture_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"fixture"});
CREATE (:`Tag`:`NER_O` {`id`:"prevent_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBP", "VB"], `value`:"prevent"});
CREATE (:`Tag`:`NER_O` {`id`:"dedicated_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"dedicated"});
CREATE (:`Tag`:`NER_O` {`id`:"feature_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNS"], `value`:"feature"});
CREATE (:`Tag`:`NER_O` {`id`:"incorrect_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"incorrect"});
CREATE (:`Tag`:`NER_O` {`id`:"fabricate_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"fabricate"});
CREATE (:`Tag`:`NER_O` {`id`:"physical_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"physical"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:999, `ne`:["O"], `pos`:["NN"], `startPosition`:995, `value`:"gear", `UNIQUE IMPORT ID`:121988});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:910, `ne`:["O"], `pos`:["VBN"], `startPosition`:900, `value`:"fabricated", `UNIQUE IMPORT ID`:121989});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:977, `ne`:["O"], `pos`:["NN"], `startPosition`:965, `value`:"installation", `UNIQUE IMPORT ID`:121990});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:942, `ne`:["O"], `pos`:["JJ"], `startPosition`:934, `value`:"physical", `UNIQUE IMPORT ID`:121991});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:895, `ne`:["O"], `pos`:["NN"], `startPosition`:888, `value`:"fixture", `UNIQUE IMPORT ID`:121992});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:928, `ne`:["O"], `pos`:["NN"], `startPosition`:920, `value`:"actuator", `UNIQUE IMPORT ID`:121993});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:994, `ne`:["O"], `pos`:["JJ"], `startPosition`:985, `value`:"incorrect", `UNIQUE IMPORT ID`:121994});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:964, `ne`:["O"], `pos`:["VBP"], `startPosition`:957, `value`:"prevent", `UNIQUE IMPORT ID`:121995});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:887, `ne`:["O"], `pos`:["JJ"], `startPosition`:878, `value`:"dedicated", `UNIQUE IMPORT ID`:121996});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:951, `ne`:["O"], `pos`:["NNS"], `startPosition`:943, `value`:"features", `UNIQUE IMPORT ID`:121997});
CREATE (:`Sentence` {`hash`:"d927275c3d2e9a72af4387313492d401", `id`:"164448_9", `sentenceNumber`:9, `text`:"Designs should be mistake-proofed so that components cannot be assembled incorrectly."});
CREATE (:`Tag`:`NER_O` {`id`:"mistake-proof_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"mistake-proof"});
CREATE (:`Tag`:`NER_O` {`id`:"assemble_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VBN"], `value`:"assemble"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1085, `ne`:["O"], `pos`:["RB"], `startPosition`:1074, `value`:"incorrectly", `UNIQUE IMPORT ID`:122001});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1053, `ne`:["O"], `pos`:["NNS"], `startPosition`:1043, `value`:"components", `UNIQUE IMPORT ID`:122002});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1073, `ne`:["O"], `pos`:["VBN"], `startPosition`:1064, `value`:"assembled", `UNIQUE IMPORT ID`:122003});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1008, `ne`:["O"], `pos`:["NNS"], `startPosition`:1001, `value`:"Designs", `UNIQUE IMPORT ID`:122004});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1034, `ne`:["O"], `pos`:["VBN"], `startPosition`:1019, `value`:"mistake-proofed", `UNIQUE IMPORT ID`:122005});
CREATE (:`Sentence` {`hash`:"6fec19812f283af1cb548bb02d12bb07", `id`:"164448_10", `sentenceNumber`:10, `text`:"This 4-minute, 33-second video is a product of the Space Shuttle Program and its Process Control Focus Group."});
CREATE (:`Tag`:`NER_Duration` {`id`:"33-second_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["DURATION"], `pos`:[], `value`:"33-second"});
CREATE (:`Tag`:`NER_O` {`id`:"product_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"product"});
CREATE (:`Tag`:`NER_O` {`id`:"program_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NNP"], `value`:"program"});
CREATE (:`Tag`:`NER_Date` {`id`:"This 4-minute_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["DATE"], `pos`:[], `value`:"This 4-minute"});
CREATE (:`Tag`:`NER_Organization` {`id`:"Process Control Focus Group_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["ORGANIZATION"], `pos`:[], `value`:"Process Control Focus Group"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1101, `ne`:["DATE"], `pos`:[], `startPosition`:1088, `value`:"This 4-minute", `UNIQUE IMPORT ID`:122012});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1160, `ne`:["O"], `pos`:["NNP"], `startPosition`:1153, `value`:"Program", `UNIQUE IMPORT ID`:122013});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1196, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:1169, `value`:"Process Control Focus Group", `UNIQUE IMPORT ID`:122014});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1144, `ne`:["O"], `pos`:["NN"], `startPosition`:1139, `value`:"Space", `UNIQUE IMPORT ID`:122015});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1131, `ne`:["O"], `pos`:["NN"], `startPosition`:1124, `value`:"product", `UNIQUE IMPORT ID`:122016});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1118, `ne`:["O"], `pos`:["NN"], `startPosition`:1113, `value`:"video", `UNIQUE IMPORT ID`:122017});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1152, `ne`:["O"], `pos`:["NNP"], `startPosition`:1145, `value`:"Shuttle", `UNIQUE IMPORT ID`:122018});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1112, `ne`:["DURATION"], `pos`:[], `startPosition`:1103, `value`:"33-second", `UNIQUE IMPORT ID`:122019});
CREATE (:`Sentence` {`hash`:"5ebba5b296f8e92fba65fb2a0139cb67", `id`:"164448_11", `sentenceNumber`:11, `text`:"Unless mechanical designs are mistake-proofed to prevent incorrect assembly, an assembly error that is not clearly evident from initial inspection may cause a critical flight failure."});
CREATE (:`Tag`:`NER_O` {`id`:"initial_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"initial"});
CREATE (:`Tag`:`NER_O` {`id`:"mechanical_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"mechanical"});
CREATE (:`Tag`:`NER_O` {`id`:"cause_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["VB"], `value`:"cause"});
CREATE (:`Tag`:`NER_O` {`id`:"clearly_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["RB"], `value`:"clearly"});
CREATE (:`Tag`:`NER_O` {`id`:"mistake-proofed_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"mistake-proofed"});
CREATE (:`Tag`:`NER_O` {`id`:"unless_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["IN"], `value`:"unless"});
CREATE (:`Tag`:`NER_O` {`id`:"assembly_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["NN"], `value`:"assembly"});
CREATE (:`Tag`:`NER_O` {`id`:"evident_en", `language`:"en", `lastTxId`:"1525877876469", `ne`:["O"], `pos`:["JJ"], `value`:"evident"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1223, `ne`:["O"], `pos`:["NNS"], `startPosition`:1216, `value`:"designs", `UNIQUE IMPORT ID`:122029});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1320, `ne`:["O"], `pos`:["JJ"], `startPosition`:1313, `value`:"evident", `UNIQUE IMPORT ID`:122030});
CREATE (:`Root`:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1354, `ne`:["O"], `pos`:["VB"], `startPosition`:1349, `value`:"cause", `UNIQUE IMPORT ID`:122031});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1264, `ne`:["O"], `pos`:["JJ"], `startPosition`:1255, `value`:"incorrect", `UNIQUE IMPORT ID`:122032});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1292, `ne`:["O"], `pos`:["NN"], `startPosition`:1287, `value`:"error", `UNIQUE IMPORT ID`:122033});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1243, `ne`:["O"], `pos`:["JJ"], `startPosition`:1228, `value`:"mistake-proofed", `UNIQUE IMPORT ID`:122034});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1365, `ne`:["O"], `pos`:["JJ"], `startPosition`:1357, `value`:"critical", `UNIQUE IMPORT ID`:122035});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1204, `ne`:["O"], `pos`:["IN"], `startPosition`:1198, `value`:"Unless", `UNIQUE IMPORT ID`:122036});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1333, `ne`:["O"], `pos`:["JJ"], `startPosition`:1326, `value`:"initial", `UNIQUE IMPORT ID`:122037});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1273, `ne`:["O"], `pos`:["NN"], `startPosition`:1265, `value`:"assembly", `UNIQUE IMPORT ID`:122038});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1215, `ne`:["O"], `pos`:["JJ"], `startPosition`:1205, `value`:"mechanical", `UNIQUE IMPORT ID`:122039});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1344, `ne`:["O"], `pos`:["NN"], `startPosition`:1334, `value`:"inspection", `UNIQUE IMPORT ID`:122040});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1372, `ne`:["O"], `pos`:["NN"], `startPosition`:1366, `value`:"flight", `UNIQUE IMPORT ID`:122041});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1312, `ne`:["O"], `pos`:["RB"], `startPosition`:1305, `value`:"clearly", `UNIQUE IMPORT ID`:122042});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1380, `ne`:["O"], `pos`:["NN"], `startPosition`:1373, `value`:"failure", `UNIQUE IMPORT ID`:122043});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1286, `ne`:["O"], `pos`:["NN"], `startPosition`:1278, `value`:"assembly", `UNIQUE IMPORT ID`:122044});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1254, `ne`:["O"], `pos`:["VB"], `startPosition`:1247, `value`:"prevent", `UNIQUE IMPORT ID`:122045});
CREATE (:`Lesson`:`UNIQUE IMPORT LABEL` {`abstract`:"A video clip lesson learned on the topic of Process Control. Actuators inside the tail enable the rudder speed brake panels to steer and slow the Space Shuttle during descent and landing. Unusual wear was found on the planet gears of the actuators during an inspection. This led to a discovery that when the Shuttle was built the gears were installed incorrectly a critical flight failure mode. The installation error stemmed from the near identical appearance of component gears that had different design topographies. The robust actuators were able to operate for 20 years (approximately 30 missions) without failure. The mistake was not found sooner because the actuators were certified for the original flight life of the Shuttle 10 years or 100 missions. New gears were installed, and a process control was implemented that accommodates the demands of ground operations. A dedicated fixture was fabricated for each actuator with physical features that prevent installation of the incorrect gear. Designs should be mistake-proofed so that components cannot be assembled incorrectly. \nThis 4-minute, 33-second video is a product of the Space Shuttle Program and its Process Control Focus Group.", `day`:28, `lesson`:"Unless mechanical designs are mistake-proofed to prevent incorrect assembly, an assembly error that is not clearly evident from initial inspection may cause a critical flight failure.", `month`:4, `name`:1760, `org`:"Exploration Systems, ", `safety`:"TRUE", `title`:"Process Control to Prevent Incorrect Assembly (Video Lesson)", `url`:"https://nen.nasa.gov/web/11/viewall/-/viewall/1760", `year`:2006, `UNIQUE IMPORT ID`:164448});
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"process_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"learn_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"lesson_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"topic_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"control_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"video_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Tag`{`id`:"clip_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121831}), (n2:`Tag`{`id`:"video_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121831}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121832}), (n2:`Tag`{`id`:"topic_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121832}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121833}), (n2:`Tag`{`id`:"learn_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121833}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121834}), (n2:`Tag`{`id`:"control_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121834}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121835}), (n2:`Tag`{`id`:"clip_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121835}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121836}), (n2:`Tag`{`id`:"process_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121836}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121837}), (n2:`Tag`{`id`:"lesson_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121837}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121833}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121833}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121837}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121831}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121837}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121835}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121833}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121837}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121833}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121832}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121834}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121836}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121832}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121834}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_0"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_0"}) CREATE (n1)-[r:`FIRST_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"tail_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"inside_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"speed_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"space_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"brake_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"descent_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"landing_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"slow_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"enable_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"rudder_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"steer_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Tag`{`id`:"panel_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121853}), (n2:`Tag`{`id`:"rudder_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121853}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121854}), (n2:`Tag`{`id`:"inside_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121854}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121855}), (n2:`Tag`{`id`:"descent_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121855}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121856}), (n2:`Tag`{`id`:"speed_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121856}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121857}), (n2:`Tag`{`id`:"slow_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121857}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121858}), (n2:`Tag`{`id`:"brake_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121858}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121859}), (n2:`Tag`{`id`:"tail_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121859}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121860}), (n2:`Tag`{`id`:"space_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121860}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121861}), (n2:`Tag`{`id`:"landing_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121861}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}), (n2:`Tag`{`id`:"panel_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}), (n2:`Tag`{`id`:"enable_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121864}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121864}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121865}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121865}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}), (n2:`Tag`{`id`:"steer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121865}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121859}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121854}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121865}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121859}) CREATE (n1)-[r:`NMOD` {`specific`:"inside"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121853}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121856}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121858}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121862}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121863}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121857}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121857}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121864}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121860}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121864}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121855}) CREATE (n1)-[r:`NMOD` {`specific`:"during"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121866}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121861}) CREATE (n1)-[r:`NMOD` {`specific`:"during"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121855}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121861}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_1"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_0"}), (n2:`Sentence`{`id`:"164448_1"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"find_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"planet_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"wear_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"unusual_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Tag`{`id`:"inspection_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121874}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121874}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121875}), (n2:`Tag`{`id`:"inspection_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121875}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121876}), (n2:`Tag`{`id`:"wear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121876}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121877}), (n2:`Tag`{`id`:"planet_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121877}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121878}), (n2:`Tag`{`id`:"unusual_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121878}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}), (n2:`Tag`{`id`:"find_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121880}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121880}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121876}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121878}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121876}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121874}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121877}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121874}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121874}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121880}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121879}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121875}) CREATE (n1)-[r:`NMOD` {`specific`:"during"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_2"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_1"}), (n2:`Sentence`{`id`:"164448_2"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"incorrectly_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"mode_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"flight_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"critical_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"build_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"install_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"discovery_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"failure_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"lead_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121891}), (n2:`Tag`{`id`:"build_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121891}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121892}), (n2:`Tag`{`id`:"lead_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121892}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121893}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121893}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121894}), (n2:`Tag`{`id`:"install_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121894}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}), (n2:`Tag`{`id`:"mode_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121896}), (n2:`Tag`{`id`:"flight_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121896}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121897}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121897}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121898}), (n2:`Tag`{`id`:"discovery_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121898}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121899}), (n2:`Tag`{`id`:"critical_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121899}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121900}), (n2:`Tag`{`id`:"failure_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121900}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121901}), (n2:`Tag`{`id`:"incorrectly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121901}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121892}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121892}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121892}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121898}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121891}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121893}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121894}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121891}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121894}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121897}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121898}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121894}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121901}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121899}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121896}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121900}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121894}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121895}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_3"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_2"}), (n2:`Sentence`{`id`:"164448_3"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"identical_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"component_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"appearance_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"installation_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"design_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"topography_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"near_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"error_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"different_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"stem_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121913}), (n2:`Tag`{`id`:"component_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121913}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121914}), (n2:`Tag`{`id`:"stem_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121914}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121915}), (n2:`Tag`{`id`:"appearance_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121915}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121916}), (n2:`Tag`{`id`:"near_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121916}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121917}), (n2:`Tag`{`id`:"design_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121917}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121918}), (n2:`Tag`{`id`:"identical_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121918}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121919}), (n2:`Tag`{`id`:"different_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121919}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121920}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121920}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121921}), (n2:`Tag`{`id`:"topography_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121921}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121922}), (n2:`Tag`{`id`:"error_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121922}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121923}), (n2:`Tag`{`id`:"installation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121923}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121914}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121914}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121922}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121923}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121914}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121922}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121915}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121916}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121915}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121918}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121914}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121915}) CREATE (n1)-[r:`NMOD` {`specific`:"from"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121920}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121913}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121915}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121920}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121921}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121919}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121921}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121917}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_4"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_3"}), (n2:`Sentence`{`id`:"164448_4"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"mission_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"robust_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"operate_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"approximately_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"failure_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"able_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"20 years_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"30_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Tag`{`id`:"without_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121933}), (n2:`Tag`{`id`:"approximately_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121933}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121934}), (n2:`Tag`{`id`:"mission_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121934}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121935}), (n2:`Tag`{`id`:"able_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121935}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121936}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121936}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121937}), (n2:`Tag`{`id`:"failure_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121937}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121938}), (n2:`Tag`{`id`:"20 years_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121938}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121939}), (n2:`Tag`{`id`:"operate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121939}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121940}), (n2:`Tag`{`id`:"without_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121940}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121941}), (n2:`Tag`{`id`:"robust_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121941}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121942}), (n2:`Tag`{`id`:"30_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121942}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121935}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121935}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121936}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121941}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121935}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121936}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121939}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121936}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121935}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121939}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121938}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121938}) CREATE (n1)-[r:`NUMMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121939}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121938}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121942}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121933}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121934}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121942}) CREATE (n1)-[r:`NUMMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121938}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121934}) CREATE (n1)-[r:`APPOS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121937}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121940}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121939}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121937}) CREATE (n1)-[r:`NMOD` {`specific`:"without"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_5"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_4"}), (n2:`Sentence`{`id`:"164448_5"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"mistake_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"flight_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"100_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"mission_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"original_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"sooner_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"find_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"certify_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"10 years_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Tag`{`id`:"life_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121951}), (n2:`Tag`{`id`:"mistake_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121951}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}), (n2:`Tag`{`id`:"find_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121953}), (n2:`Tag`{`id`:"flight_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121953}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121954}), (n2:`Tag`{`id`:"sooner_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121954}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121955}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121955}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}), (n2:`Tag`{`id`:"certify_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121957}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121957}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121958}), (n2:`Tag`{`id`:"original_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121958}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121959}), (n2:`Tag`{`id`:"life_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121959}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121960}), (n2:`Tag`{`id`:"100_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121960}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121961}), (n2:`Tag`{`id`:"10 years_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121961}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121962}), (n2:`Tag`{`id`:"mission_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121962}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121951}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121954}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121957}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121952}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}) CREATE (n1)-[r:`ADVCL` {`specific`:"because"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121959}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121958}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121959}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121953}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121959}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121959}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121955}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121961}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121961}) CREATE (n1)-[r:`NUMMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121961}) CREATE (n1)-[r:`NMOD:TMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121962}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121960}) CREATE (n1)-[r:`NUMMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121956}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121962}) CREATE (n1)-[r:`NMOD:TMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121961}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121962}) CREATE (n1)-[r:`CONJ` {`specific`:"or"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_6"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_5"}), (n2:`Sentence`{`id`:"164448_6"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"new_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"process_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"install_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"accommodate_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"control_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"implement_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"ground_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"demand_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"operation_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121970}), (n2:`Tag`{`id`:"control_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121970}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121971}), (n2:`Tag`{`id`:"operation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121971}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121972}), (n2:`Tag`{`id`:"install_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121972}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121973}), (n2:`Tag`{`id`:"new_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121973}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121974}), (n2:`Tag`{`id`:"process_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121974}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121975}), (n2:`Tag`{`id`:"ground_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121975}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121976}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121976}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121977}), (n2:`Tag`{`id`:"implement_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121977}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121978}), (n2:`Tag`{`id`:"accommodate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121978}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121979}), (n2:`Tag`{`id`:"demand_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121979}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121972}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121972}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121976}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121973}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121972}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121976}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121970}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121974}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121977}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121970}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121972}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121977}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121977}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121978}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121978}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121979}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121971}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121975}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121979}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121971}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_7"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_6"}), (n2:`Sentence`{`id`:"164448_7"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"fixture_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"prevent_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"dedicated_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"feature_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"incorrect_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"installation_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"fabricate_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"physical_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121988}), (n2:`Tag`{`id`:"gear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121988}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}), (n2:`Tag`{`id`:"fabricate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121990}), (n2:`Tag`{`id`:"installation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121990}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121991}), (n2:`Tag`{`id`:"physical_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121991}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121992}), (n2:`Tag`{`id`:"fixture_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121992}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121993}), (n2:`Tag`{`id`:"actuator_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121993}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121994}), (n2:`Tag`{`id`:"incorrect_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121994}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121995}), (n2:`Tag`{`id`:"prevent_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121995}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121996}), (n2:`Tag`{`id`:"dedicated_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121996}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121997}), (n2:`Tag`{`id`:"feature_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121997}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121992}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121996}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121992}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121993}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121997}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121991}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121989}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121997}) CREATE (n1)-[r:`NMOD` {`specific`:"with"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121995}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121997}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121997}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121995}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121995}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121990}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121988}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121994}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121990}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:121988}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_8"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_7"}), (n2:`Sentence`{`id`:"164448_8"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`Tag`{`id`:"mistake-proof_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`Tag`{`id`:"incorrectly_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`Tag`{`id`:"component_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`Tag`{`id`:"design_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`Tag`{`id`:"assemble_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122001}), (n2:`Tag`{`id`:"incorrectly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122001}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122002}), (n2:`Tag`{`id`:"component_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122002}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122003}), (n2:`Tag`{`id`:"assemble_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122003}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122004}), (n2:`Tag`{`id`:"design_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122004}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122005}), (n2:`Tag`{`id`:"mistake-proof_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122005}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122005}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122005}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122005}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122004}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122003}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122002}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122005}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122003}) CREATE (n1)-[r:`ADVCL` {`specific`:"so_that"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122003}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122001}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_9"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_8"}), (n2:`Sentence`{`id`:"164448_9"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"33-second_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"product_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"video_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"program_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"This 4-minute_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"Process Control Focus Group_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Tag`{`id`:"space_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122012}), (n2:`Tag`{`id`:"This 4-minute_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122012}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122013}), (n2:`Tag`{`id`:"program_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122013}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}), (n2:`Tag`{`id`:"Process Control Focus Group_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122015}), (n2:`Tag`{`id`:"space_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122015}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`Tag`{`id`:"product_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122017}), (n2:`Tag`{`id`:"video_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122017}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122018}), (n2:`Tag`{`id`:"shuttle_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122018}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122019}), (n2:`Tag`{`id`:"33-second_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122019}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122012}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122012}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122017}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122019}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122017}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122013}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122015}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122013}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122018}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122013}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122016}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122013}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122014}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_10"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_9"}), (n2:`Sentence`{`id`:"164448_10"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"flight_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"incorrect_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"critical_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"initial_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"mechanical_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"cause_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"clearly_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"error_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"prevent_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"mistake-proofed_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"unless_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"failure_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"design_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"assembly_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:2}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"evident_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`Tag`{`id`:"inspection_en"}) CREATE (n1)-[r:`HAS_TAG` {`tf`:1}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122029}), (n2:`Tag`{`id`:"design_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122029}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122030}), (n2:`Tag`{`id`:"evident_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122030}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}), (n2:`Tag`{`id`:"cause_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122032}), (n2:`Tag`{`id`:"incorrect_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122032}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122033}), (n2:`Tag`{`id`:"error_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122033}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122034}), (n2:`Tag`{`id`:"mistake-proofed_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122034}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122035}), (n2:`Tag`{`id`:"critical_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122035}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122036}), (n2:`Tag`{`id`:"unless_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122036}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122037}), (n2:`Tag`{`id`:"initial_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122037}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122038}), (n2:`Tag`{`id`:"assembly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122038}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122039}), (n2:`Tag`{`id`:"mechanical_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122039}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122040}), (n2:`Tag`{`id`:"inspection_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122040}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122041}), (n2:`Tag`{`id`:"flight_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122041}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122042}), (n2:`Tag`{`id`:"clearly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122042}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122043}), (n2:`Tag`{`id`:"failure_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122043}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122044}), (n2:`Tag`{`id`:"assembly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122044}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122045}), (n2:`Tag`{`id`:"prevent_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122045}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122034}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122036}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122029}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122039}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122034}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122029}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122045}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122029}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122034}) CREATE (n1)-[r:`ADVCL` {`specific`:"unless"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122034}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122045}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122038}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122032}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122045}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122038}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122033}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122044}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122030}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122033}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122033}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122030}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122042}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122033}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122030}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122040}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122037}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122030}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122040}) CREATE (n1)-[r:`NMOD` {`specific`:"from"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122043}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122035}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122043}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122041}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122031}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:122043}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"164448"}), (n2:`Sentence`{`id`:"164448_11"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Sentence`{`id`:"164448_10"}), (n2:`Sentence`{`id`:"164448_11"}) CREATE (n1)-[r:`NEXT_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:164448}), (n2:`AnnotatedText`{`id`:"164448"}) CREATE (n1)-[r:`HAS_ANNOTATED_TEXT`]->(n2);
MATCH (n:`UNIQUE IMPORT LABEL`)  WITH n LIMIT 20000 REMOVE n:`UNIQUE IMPORT LABEL` REMOVE n.`UNIQUE IMPORT ID`;
