CREATE (:`Document`:`Project_Article` {`author`:"Carl Hulse", `date`:"2016-12-31", `id`:"17283", `publication`:"New York Times", `text`:"WASHINGTON  —   Congressional Republicans have a new fear when it comes to their    health care lawsuit against the Obama administration: They might win. The incoming Trump administration could choose to no longer defend the executive branch against the suit, which challenges the administration’s authority to spend billions of dollars on health insurance subsidies for   and   Americans, handing House Republicans a big victory on    issues. But a sudden loss of the disputed subsidies could conceivably cause the health care program to implode, leaving millions of people without access to health insurance before Republicans have prepared a replacement. That could lead to chaos in the insurance market and spur a political backlash just as Republicans gain full control of the government. To stave off that outcome, Republicans could find themselves in the awkward position of appropriating huge sums to temporarily prop up the Obama health care law, angering conservative voters who have been demanding an end to the law for years. In another twist, Donald J. Trump’s administration, worried about preserving executive branch prerogatives, could choose to fight its Republican allies in the House on some central questions in the dispute. Eager to avoid an ugly political pileup, Republicans on Capitol Hill and the Trump transition team are gaming out how to handle the lawsuit, which, after the election, has been put in limbo until at least late February by the United States Court of Appeals for the District of Columbia Circuit. They are not yet ready to divulge their strategy. “Given that this pending litigation involves the Obama administration and Congress, it would be inappropriate to comment,” said Phillip J. Blando, a spokesman for the Trump transition effort. “Upon taking office, the Trump administration will evaluate this case and all related aspects of the Affordable Care Act. ” In a potentially   decision in 2015, Judge Rosemary M. Collyer ruled that House Republicans had the standing to sue the executive branch over a spending dispute and that the Obama administration had been distributing the health insurance subsidies, in violation of the Constitution, without approval from Congress. The Justice Department, confident that Judge Collyer’s decision would be reversed, quickly appealed, and the subsidies have remained in place during the appeal. In successfully seeking a temporary halt in the proceedings after Mr. Trump won, House Republicans last month told the court that they “and the  ’s transition team currently are discussing potential options for resolution of this matter, to take effect after the  ’s inauguration on Jan. 20, 2017. ” The suspension of the case, House lawyers said, will “provide the   and his future administration time to consider whether to continue prosecuting or to otherwise resolve this appeal. ” Republican leadership officials in the House acknowledge the possibility of “cascading effects” if the   payments, which have totaled an estimated $13 billion, are suddenly stopped. Insurers that receive the subsidies in exchange for paying    costs such as deductibles and   for eligible consumers could race to drop coverage since they would be losing money. Over all, the loss of the subsidies could destabilize the entire program and cause a lack of confidence that leads other insurers to seek a quick exit as well. Anticipating that the Trump administration might not be inclined to mount a vigorous fight against the House Republicans given the  ’s dim view of the health care law, a team of lawyers this month sought to intervene in the case on behalf of two participants in the health care program. In their request, the lawyers predicted that a deal between House Republicans and the new administration to dismiss or settle the case “will produce devastating consequences for the individuals who receive these reductions, as well as for the nation’s health insurance and health care systems generally. ” No matter what happens, House Republicans say, they want to prevail on two overarching concepts: the congressional power of the purse, and the right of Congress to sue the executive branch if it violates the Constitution regarding that spending power. House Republicans contend that Congress never appropriated the money for the subsidies, as required by the Constitution. In the suit, which was initially championed by John A. Boehner, the House speaker at the time, and later in House committee reports, Republicans asserted that the administration, desperate for the funding, had required the Treasury Department to provide it despite widespread internal skepticism that the spending was proper. The White House said that the spending was a permanent part of the law passed in 2010, and that no annual appropriation was required  —   even though the administration initially sought one. Just as important to House Republicans, Judge Collyer found that Congress had the standing to sue the White House on this issue  —   a ruling that many legal experts said was flawed  —   and they want that precedent to be set to restore congressional leverage over the executive branch. But on spending power and standing, the Trump administration may come under pressure from advocates of presidential authority to fight the House no matter their shared views on health care, since those precedents could have broad repercussions. It is a complicated set of dynamics illustrating how a quick legal victory for the House in the Trump era might come with costs that Republicans never anticipated when they took on the Obama White House."});
CREATE (:`AnnotatedText` {`id`:"0", `numTerms`:526});
CREATE (:`Sentence` {`hash`:"2b5451c80f197edc0b479a927b0140e5", `id`:"0_0", `sentenceNumber`:0, `text`:"WASHINGTON  —   Congressional Republicans have a new fear when it comes to their    health care lawsuit against the Obama administration: They might win."});
CREATE (:`Tag`:`NER_O` {`id`:"new_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"new_en", `ne`:["O"], `pos`:["JJ", "NNP", "NN"], `value`:"new"});
CREATE (:`Tag`:`NER_O` {`id`:"congressional_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"congressional_en", `ne`:["O"], `pos`:["NNP", "JJ"], `value`:"congressional"});
CREATE (:`Tag`:`NER_O` {`id`:"lawsuit_en", `language`:"en", `lastTxId`:"1524366562114", `lowercasedId`:"lawsuit_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"lawsuit"});
CREATE (:`Tag`:`NER_Organization`:`NER_Person` {`id`:"Obama_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"obama_en", `ne`:["PERSON", "ORGANIZATION"], `pos`:[], `value`:"Obama"});
CREATE (:`Tag`:`NER_Location` {`id`:"WASHINGTON_en", `language`:"en", `lastTxId`:"1524366416046", `lowercasedId`:"washington_en", `ne`:["LOCATION"], `pos`:[], `value`:"WASHINGTON"});
CREATE (:`Tag`:`NER_O` {`id`:"against_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"against_en", `ne`:["O"], `pos`:["IN", "NNP"], `value`:"against"});
CREATE (:`Tag`:`NER_O` {`id`:"administration_en", `language`:"en", `lastTxId`:"1524366579686", `lowercasedId`:"administration_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"administration"});
CREATE (:`Tag`:`NER_O` {`id`:"might_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"might_en", `ne`:["O"], `pos`:["MD", "NN", "JJ", "VBP", "NNP", "VB", "NNPS"], `value`:"might"});
CREATE (:`Tag`:`NER_O` {`id`:"health_en", `language`:"en", `lastTxId`:"1524366571492", `lowercasedId`:"health_en", `ne`:["O"], `pos`:["NN", "NNP"], `value`:"health"});
CREATE (:`Tag`:`NER_O` {`id`:"come_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"come_en", `ne`:["O"], `pos`:["VBZ", "VB", "VBD", "VBN", "VBG", "VBP", "NNP"], `value`:"come"});
CREATE (:`Tag`:`NER_O` {`id`:"when_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"when_en", `ne`:["O"], `pos`:["WRB", "VBZ"], `value`:"when"});
CREATE (:`Tag`:`NER_Misc`:`NER_Organization`:`NER_Person` {`id`:"Republicans_en", `language`:"en", `lastTxId`:"1524366590254", `lowercasedId`:"republicans_en", `ne`:["MISC", "ORGANIZATION", "PERSON"], `pos`:[], `value`:"Republicans"});
CREATE (:`Tag`:`NER_O` {`id`:"have_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"have_en", `ne`:["O"], `pos`:["VBP", "VBZ", "VBD", "VB", "VBG", "VBN", "NNP"], `value`:"have"});
CREATE (:`Tag`:`NER_O` {`id`:"win_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"win_en", `ne`:["O"], `pos`:["VB", "VBD", "VBN", "VBG", "NNS", "VBP", "VBZ", "NNP", "NN"], `value`:"win"});
CREATE (:`Tag`:`NER_O` {`id`:"fear_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"fear_en", `ne`:["O"], `pos`:["NN", "NNS", "VBP", "VBN", "VBG", "VBD", "VBZ", "VB"], `value`:"fear"});
CREATE (:`Tag`:`NER_O` {`id`:"care_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"care_en", `ne`:["O"], `pos`:["NN", "VB", "NNP", "VBD", "VBG", "VBP", "VBZ", "VBN", "NNS"], `value`:"care"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:10, `ne`:["LOCATION"], `pos`:[], `startPosition`:0, `value`:"WASHINGTON", `UNIQUE IMPORT ID`:50018});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:103, `ne`:["O"], `pos`:["NN"], `startPosition`:96, `value`:"lawsuit", `UNIQUE IMPORT ID`:50019});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:71, `ne`:["O"], `pos`:["VBZ"], `startPosition`:66, `value`:"comes", `UNIQUE IMPORT ID`:50020});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:111, `ne`:["O"], `pos`:["IN"], `startPosition`:104, `value`:"against", `UNIQUE IMPORT ID`:50021});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:46, `ne`:["O"], `pos`:["VBP"], `startPosition`:42, `value`:"have", `UNIQUE IMPORT ID`:50022});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:148, `ne`:["O"], `pos`:["MD"], `startPosition`:143, `value`:"might", `UNIQUE IMPORT ID`:50023});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:29, `ne`:["O"], `pos`:["NNP"], `startPosition`:16, `value`:"Congressional", `UNIQUE IMPORT ID`:50024});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:52, `ne`:["O"], `pos`:["JJ"], `startPosition`:49, `value`:"new", `UNIQUE IMPORT ID`:50025});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:90, `ne`:["O"], `pos`:["NN"], `startPosition`:84, `value`:"health", `UNIQUE IMPORT ID`:50026});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:121, `ne`:["PERSON"], `pos`:[], `startPosition`:116, `value`:"Obama", `UNIQUE IMPORT ID`:50027});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:57, `ne`:["O"], `pos`:["NN"], `startPosition`:53, `value`:"fear", `UNIQUE IMPORT ID`:50028});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:152, `ne`:["O"], `pos`:["VB"], `startPosition`:149, `value`:"win", `UNIQUE IMPORT ID`:50029});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:62, `ne`:["O"], `pos`:["WRB"], `startPosition`:58, `value`:"when", `UNIQUE IMPORT ID`:50030});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:136, `ne`:["O"], `pos`:["NN"], `startPosition`:122, `value`:"administration", `UNIQUE IMPORT ID`:50031});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:95, `ne`:["O"], `pos`:["NN"], `startPosition`:91, `value`:"care", `UNIQUE IMPORT ID`:50032});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:41, `ne`:["MISC"], `pos`:[], `startPosition`:30, `value`:"Republicans", `UNIQUE IMPORT ID`:50033});
CREATE (:`Sentence` {`hash`:"9051b76f30855238ad9f626584546a69", `id`:"0_1", `sentenceNumber`:1, `text`:"The incoming Trump administration could choose to no longer defend the executive branch against the suit, which challenges the administration’s authority to spend billions of dollars on health insurance subsidies for   and   Americans, handing House Republicans a big victory on    issues."});
CREATE (:`Tag`:`NER_O` {`id`:"insurance_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"insurance_en", `ne`:["O"], `pos`:["NN", "NNP", "NNS"], `value`:"insurance"});
CREATE (:`Tag`:`NER_O` {`id`:"big_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"big_en", `ne`:["O"], `pos`:["JJ", "NNP", "NNS"], `value`:"big"});
CREATE (:`Tag`:`NER_O` {`id`:"subsidy_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"subsidy_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP"], `value`:"subsidy"});
CREATE (:`Tag`:`NER_Money` {`id`:"billions of dollars_en", `language`:"en", `lastTxId`:"1524366252767", `lowercasedId`:"billions of dollars_en", `ne`:["MONEY"], `pos`:[], `value`:"billions of dollars"});
CREATE (:`Tag`:`NER_O` {`id`:"choose_en", `language`:"en", `lastTxId`:"1524366583918", `lowercasedId`:"choose_en", `ne`:["O"], `pos`:["VB", "VBD", "VBN", "VBG", "VBP", "VBZ"], `value`:"choose"});
CREATE (:`Tag`:`NER_O` {`id`:"branch_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"branch_en", `ne`:["O"], `pos`:["NN", "VBG", "NNS", "NNP", "VBD", "VB", "VBN", "VBP"], `value`:"branch"});
CREATE (:`Tag`:`NER_O` {`id`:"executive_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"executive_en", `ne`:["O"], `pos`:["JJ", "NN", "NNS", "NNP"], `value`:"executive"});
CREATE (:`Tag`:`NER_O` {`id`:"defend_en", `language`:"en", `lastTxId`:"1524366565432", `lowercasedId`:"defend_en", `ne`:["O"], `pos`:["VBP", "VB", "VBD", "VBG", "VBN", "VBZ"], `value`:"defend"});
CREATE (:`Tag`:`NER_O` {`id`:"spend_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"spend_en", `ne`:["O"], `pos`:["VB", "VBG", "VBD", "VBN", "VBP", "VBZ"], `value`:"spend"});
CREATE (:`Tag`:`NER_O` {`id`:"hand_en", `language`:"en", `lastTxId`:"1524366591844", `lowercasedId`:"hand_en", `ne`:["O"], `pos`:["VBG", "NNS", "NN", "VB", "VBN", "VBD", "VBZ", "VBP", "NNP"], `value`:"hand"});
CREATE (:`Tag`:`NER_O` {`id`:"which_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"which_en", `ne`:["O"], `pos`:["WDT", "WP"], `value`:"which"});
CREATE (:`Tag`:`NER_O` {`id`:"incoming_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"incoming_en", `ne`:["O"], `pos`:["JJ"], `value`:"incoming"});
CREATE (:`Tag`:`NER_O` {`id`:"issue_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"issue_en", `ne`:["O"], `pos`:["NNS", "NN", "VBD", "VBN", "VBP", "VBG", "VB", "VBZ", "NNP"], `value`:"issue"});
CREATE (:`Tag`:`NER_O` {`id`:"could_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"could_en", `ne`:["O"], `pos`:["MD", "VBP", "NNP"], `value`:"could"});
CREATE (:`Tag`:`NER_Misc`:`NER_Person` {`id`:"Americans_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"americans_en", `ne`:["MISC", "PERSON"], `pos`:[], `value`:"Americans"});
CREATE (:`Tag`:`NER_O` {`id`:"victory_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"victory_en", `ne`:["O"], `pos`:["NN", "NNP", "NNS"], `value`:"victory"});
CREATE (:`Tag`:`NER_Location`:`NER_Organization`:`NER_Person` {`id`:"House_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"house_en", `ne`:["ORGANIZATION", "PERSON", "LOCATION"], `pos`:[], `value`:"House"});
CREATE (:`Tag`:`NER_Location`:`NER_Misc`:`NER_Organization`:`NER_Person` {`id`:"Trump_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"trump_en", `ne`:["PERSON", "ORGANIZATION", "LOCATION", "MISC"], `pos`:[], `value`:"Trump"});
CREATE (:`Tag`:`NER_O` {`id`:"longer_en", `language`:"en", `lastTxId`:"1524366595488", `lowercasedId`:"longer_en", `ne`:["O"], `pos`:["JJR", "RB", "RBR", "NNP", "NN"], `value`:"longer"});
CREATE (:`Tag`:`NER_O` {`id`:"authority_en", `language`:"en", `lastTxId`:"1524366594848", `lowercasedId`:"authority_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"authority"});
CREATE (:`Tag`:`NER_O` {`id`:"challenge_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"challenge_en", `ne`:["O"], `pos`:["VBZ", "NNS", "NN", "VBN", "VBG", "VB", "VBD", "VBP", "NNP"], `value`:"challenge"});
CREATE (:`Tag`:`NER_O` {`id`:"suit_en", `language`:"en", `lastTxId`:"1524366597560", `lowercasedId`:"suit_en", `ne`:["O"], `pos`:["NN", "NNS", "VBN", "VBD", "NNP", "VBG", "VBZ", "VB", "VBP"], `value`:"suit"});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:200, `ne`:["O"], `pos`:["VB"], `startPosition`:194, `value`:"choose", `UNIQUE IMPORT ID`:50057});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:265, `ne`:["O"], `pos`:["WDT"], `startPosition`:260, `value`:"which", `UNIQUE IMPORT ID`:50058});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:397, `ne`:["O"], `pos`:["VBG"], `startPosition`:390, `value`:"handing", `UNIQUE IMPORT ID`:50059});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:276, `ne`:["O"], `pos`:["VBZ"], `startPosition`:266, `value`:"challenges", `UNIQUE IMPORT ID`:50060});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:403, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:398, `value`:"House", `UNIQUE IMPORT ID`:50061});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:213, `ne`:["O"], `pos`:["JJR"], `startPosition`:207, `value`:"longer", `UNIQUE IMPORT ID`:50062});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:346, `ne`:["O"], `pos`:["NN"], `startPosition`:340, `value`:"health", `UNIQUE IMPORT ID`:50063});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:415, `ne`:["MISC"], `pos`:[], `startPosition`:404, `value`:"Republicans", `UNIQUE IMPORT ID`:50064});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:220, `ne`:["O"], `pos`:["VBP"], `startPosition`:214, `value`:"defend", `UNIQUE IMPORT ID`:50065});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:295, `ne`:["O"], `pos`:["NN"], `startPosition`:281, `value`:"administration", `UNIQUE IMPORT ID`:50066});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:356, `ne`:["O"], `pos`:["NN"], `startPosition`:347, `value`:"insurance", `UNIQUE IMPORT ID`:50067});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:166, `ne`:["O"], `pos`:["JJ"], `startPosition`:158, `value`:"incoming", `UNIQUE IMPORT ID`:50068});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:234, `ne`:["O"], `pos`:["JJ"], `startPosition`:225, `value`:"executive", `UNIQUE IMPORT ID`:50069});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:421, `ne`:["O"], `pos`:["JJ"], `startPosition`:418, `value`:"big", `UNIQUE IMPORT ID`:50070});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:366, `ne`:["O"], `pos`:["NNS"], `startPosition`:357, `value`:"subsidies", `UNIQUE IMPORT ID`:50071});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:429, `ne`:["O"], `pos`:["NN"], `startPosition`:422, `value`:"victory", `UNIQUE IMPORT ID`:50072});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:172, `ne`:["PERSON"], `pos`:[], `startPosition`:167, `value`:"Trump", `UNIQUE IMPORT ID`:50073});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:307, `ne`:["O"], `pos`:["NN"], `startPosition`:298, `value`:"authority", `UNIQUE IMPORT ID`:50074});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:241, `ne`:["O"], `pos`:["NN"], `startPosition`:235, `value`:"branch", `UNIQUE IMPORT ID`:50075});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:187, `ne`:["O"], `pos`:["NN"], `startPosition`:173, `value`:"administration", `UNIQUE IMPORT ID`:50076});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:249, `ne`:["O"], `pos`:["IN"], `startPosition`:242, `value`:"against", `UNIQUE IMPORT ID`:50077});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:442, `ne`:["O"], `pos`:["NNS"], `startPosition`:436, `value`:"issues", `UNIQUE IMPORT ID`:50078});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:316, `ne`:["O"], `pos`:["VB"], `startPosition`:311, `value`:"spend", `UNIQUE IMPORT ID`:50079});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:388, `ne`:["MISC"], `pos`:[], `startPosition`:379, `value`:"Americans", `UNIQUE IMPORT ID`:50080});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:193, `ne`:["O"], `pos`:["MD"], `startPosition`:188, `value`:"could", `UNIQUE IMPORT ID`:50081});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:336, `ne`:["MONEY"], `pos`:[], `startPosition`:317, `value`:"billions of dollars", `UNIQUE IMPORT ID`:50082});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:258, `ne`:["O"], `pos`:["NN"], `startPosition`:254, `value`:"suit", `UNIQUE IMPORT ID`:50083});
CREATE (:`Sentence` {`hash`:"f8e9d4f6d8f1664209808e12ac1441e8", `id`:"0_2", `sentenceNumber`:2, `text`:"But a sudden loss of the disputed subsidies could conceivably cause the health care program to implode, leaving millions of people without access to health insurance before Republicans have prepared a replacement."});
CREATE (:`Tag`:`NER_O` {`id`:"dispute_en", `language`:"en", `lastTxId`:"1524366204804", `lowercasedId`:"dispute_en", `ne`:["O"], `pos`:["VBN", "NN", "NNS", "VBD", "VBP", "VBZ", "VB", "NNP", "VBG"], `value`:"dispute"});
CREATE (:`Tag`:`NER_O` {`id`:"prepare_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"prepare_en", `ne`:["O"], `pos`:["VBN", "VB", "VBG", "VBZ", "VBD", "VBP"], `value`:"prepare"});
CREATE (:`Tag`:`NER_O` {`id`:"access_en", `language`:"en", `lastTxId`:"1524366594848", `lowercasedId`:"access_en", `ne`:["O"], `pos`:["NN", "VB", "VBG", "VBN", "VBZ", "VBP", "VBD"], `value`:"access"});
CREATE (:`Tag`:`NER_Set`:`NER_Time`:`NER_O`:`NER_Date` {`id`:"before_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"before_en", `ne`:["O", "TIME", "SET", "DATE"], `pos`:["IN", "RB"], `value`:"before"});
CREATE (:`Tag`:`NER_O` {`id`:"cause_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"cause_en", `ne`:["O"], `pos`:["VB", "NN", "VBG", "VBN", "VBD", "NNS", "VBZ", "VBP", "NNP"], `value`:"cause"});
CREATE (:`Tag`:`NER_Misc`:`NER_O`:`NER_Money` {`id`:"program_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"program_en", `ne`:["O", "MISC", "MONEY"], `pos`:["NN", "NNS", "NNP", "VBN", "VBG", "VB", "VBP", "VBD"], `value`:"program"});
CREATE (:`Tag`:`NER_O` {`id`:"conceivably_en", `language`:"en", `lastTxId`:"1524364925594", `lowercasedId`:"conceivably_en", `ne`:["O"], `pos`:["RB"], `value`:"conceivably"});
CREATE (:`Tag`:`NER_O` {`id`:"people_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"people_en", `ne`:["O"], `pos`:["NNS", "NNP", "NNPS", "NN", "VBN"], `value`:"people"});
CREATE (:`Tag`:`NER_O` {`id`:"without_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"without_en", `ne`:["O"], `pos`:["IN"], `value`:"without"});
CREATE (:`Tag`:`NER_O` {`id`:"loss_en", `language`:"en", `lastTxId`:"1524366562114", `lowercasedId`:"loss_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"loss"});
CREATE (:`Tag`:`NER_Money`:`NER_O`:`NER_Number` {`id`:"million_en", `language`:"en", `lastTxId`:"1524366563377", `lowercasedId`:"million_en", `ne`:["O", "NUMBER", "MONEY"], `pos`:["NNS"], `value`:"million"});
CREATE (:`Tag`:`NER_O` {`id`:"sudden_en", `language`:"en", `lastTxId`:"1524366558235", `lowercasedId`:"sudden_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"sudden"});
CREATE (:`Tag`:`NER_O` {`id`:"leave_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"leave_en", `ne`:["O"], `pos`:["VBG", "VBD", "VBN", "VB", "VBP", "VBZ", "NN"], `value`:"leave"});
CREATE (:`Tag`:`NER_O` {`id`:"implode_en", `language`:"en", `lastTxId`:"1524365722672", `lowercasedId`:"implode_en", `ne`:["O"], `pos`:["VB", "VBG", "VBD", "VBN", "VBZ", "VBP"], `value`:"implode"});
CREATE (:`Tag`:`NER_O` {`id`:"replacement_en", `language`:"en", `lastTxId`:"1524366590254", `lowercasedId`:"replacement_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"replacement"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:456, `ne`:["O"], `pos`:["JJ"], `startPosition`:450, `value`:"sudden", `UNIQUE IMPORT ID`:50100});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:616, `ne`:["O"], `pos`:["IN"], `startPosition`:610, `value`:"before", `UNIQUE IMPORT ID`:50101});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:522, `ne`:["O"], `pos`:["NN"], `startPosition`:516, `value`:"health", `UNIQUE IMPORT ID`:50102});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:555, `ne`:["O"], `pos`:["VBG"], `startPosition`:548, `value`:"leaving", `UNIQUE IMPORT ID`:50103});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:656, `ne`:["O"], `pos`:["NN"], `startPosition`:645, `value`:"replacement", `UNIQUE IMPORT ID`:50104});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:589, `ne`:["O"], `pos`:["NN"], `startPosition`:583, `value`:"access", `UNIQUE IMPORT ID`:50105});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:493, `ne`:["O"], `pos`:["MD"], `startPosition`:488, `value`:"could", `UNIQUE IMPORT ID`:50106});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:461, `ne`:["O"], `pos`:["NN"], `startPosition`:457, `value`:"loss", `UNIQUE IMPORT ID`:50107});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:628, `ne`:["MISC"], `pos`:[], `startPosition`:617, `value`:"Republicans", `UNIQUE IMPORT ID`:50108});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:527, `ne`:["O"], `pos`:["NN"], `startPosition`:523, `value`:"care", `UNIQUE IMPORT ID`:50109});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:564, `ne`:["O"], `pos`:["NNS"], `startPosition`:556, `value`:"millions", `UNIQUE IMPORT ID`:50110});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:505, `ne`:["O"], `pos`:["RB"], `startPosition`:494, `value`:"conceivably", `UNIQUE IMPORT ID`:50111});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:535, `ne`:["O"], `pos`:["NN"], `startPosition`:528, `value`:"program", `UNIQUE IMPORT ID`:50112});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:599, `ne`:["O"], `pos`:["NN"], `startPosition`:593, `value`:"health", `UNIQUE IMPORT ID`:50113});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:477, `ne`:["O"], `pos`:["VBN"], `startPosition`:469, `value`:"disputed", `UNIQUE IMPORT ID`:50114});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:633, `ne`:["O"], `pos`:["VBP"], `startPosition`:629, `value`:"have", `UNIQUE IMPORT ID`:50115});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:574, `ne`:["O"], `pos`:["NNS"], `startPosition`:568, `value`:"people", `UNIQUE IMPORT ID`:50116});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:609, `ne`:["O"], `pos`:["NN"], `startPosition`:600, `value`:"insurance", `UNIQUE IMPORT ID`:50117});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:511, `ne`:["O"], `pos`:["VB"], `startPosition`:506, `value`:"cause", `UNIQUE IMPORT ID`:50118});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:642, `ne`:["O"], `pos`:["VBN"], `startPosition`:634, `value`:"prepared", `UNIQUE IMPORT ID`:50119});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:546, `ne`:["O"], `pos`:["VB"], `startPosition`:539, `value`:"implode", `UNIQUE IMPORT ID`:50120});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:487, `ne`:["O"], `pos`:["NNS"], `startPosition`:478, `value`:"subsidies", `UNIQUE IMPORT ID`:50121});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:582, `ne`:["O"], `pos`:["IN"], `startPosition`:575, `value`:"without", `UNIQUE IMPORT ID`:50122});
CREATE (:`Sentence` {`hash`:"a85b3e7573298b86a645e7ce76d978ef", `id`:"0_3", `sentenceNumber`:3, `text`:"That could lead to chaos in the insurance market and spur a political backlash just as Republicans gain full control of the government."});
CREATE (:`Tag`:`NER_O` {`id`:"chaos_en", `language`:"en", `lastTxId`:"1524366294474", `lowercasedId`:"chaos_en", `ne`:["O"], `pos`:["NN", "NNP"], `value`:"chaos"});
CREATE (:`Tag`:`NER_O` {`id`:"backlash_en", `language`:"en", `lastTxId`:"1524366367551", `lowercasedId`:"backlash_en", `ne`:["O"], `pos`:["NN"], `value`:"backlash"});
CREATE (:`Tag`:`NER_O` {`id`:"political_en", `language`:"en", `lastTxId`:"1524366592878", `lowercasedId`:"political_en", `ne`:["O"], `pos`:["JJ", "NNP", "NNS"], `value`:"political"});
CREATE (:`Tag`:`NER_O` {`id`:"control_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"control_en", `ne`:["O"], `pos`:["NN", "VBZ", "VBP", "VB", "VBN", "VBD", "NNS", "NNP", "VBG", "JJ"], `value`:"control"});
CREATE (:`Tag`:`NER_O` {`id`:"lead_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"lead_en", `ne`:["O"], `pos`:["VB", "VBZ", "VBG", "VBD", "NN", "JJ", "VBN", "NNS", "VBP", "NNP"], `value`:"lead"});
CREATE (:`Tag`:`NER_O` {`id`:"spur_en", `language`:"en", `lastTxId`:"1524366352833", `lowercasedId`:"spur_en", `ne`:["O"], `pos`:["VB", "VBZ", "VBD", "VBG", "NN", "VBN", "VBP"], `value`:"spur"});
CREATE (:`Tag`:`NER_O` {`id`:"gain_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"gain_en", `ne`:["O"], `pos`:["VB", "VBG", "NN", "VBD", "VBN", "NNS", "VBZ", "VBP", "NNP"], `value`:"gain"});
CREATE (:`Tag`:`NER_O` {`id`:"market_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"market_en", `ne`:["O"], `pos`:["NN", "NNS", "VBG", "VBN", "VB", "NNP", "VBP", "VBZ", "VBD"], `value`:"market"});
CREATE (:`Tag`:`NER_Organization`:`NER_Money`:`NER_O`:`NER_Person` {`id`:"government_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"government_en", `ne`:["O", "MONEY", "PERSON", "ORGANIZATION"], `pos`:["NN", "NNS", "NNP"], `value`:"government"});
CREATE (:`Tag`:`NER_Percent`:`NER_O` {`id`:"just_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"just_en", `ne`:["O", "PERCENT"], `pos`:["RB", "JJ"], `value`:"just"});
CREATE (:`Tag`:`NER_O` {`id`:"full_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"full_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"full"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:741, `ne`:["O"], `pos`:["RB"], `startPosition`:737, `value`:"just", `UNIQUE IMPORT ID`:50135});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:682, `ne`:["O"], `pos`:["NN"], `startPosition`:677, `value`:"chaos", `UNIQUE IMPORT ID`:50136});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:715, `ne`:["O"], `pos`:["VB"], `startPosition`:711, `value`:"spur", `UNIQUE IMPORT ID`:50137});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:756, `ne`:["MISC"], `pos`:[], `startPosition`:745, `value`:"Republicans", `UNIQUE IMPORT ID`:50138});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:727, `ne`:["O"], `pos`:["JJ"], `startPosition`:718, `value`:"political", `UNIQUE IMPORT ID`:50139});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:792, `ne`:["O"], `pos`:["NN"], `startPosition`:782, `value`:"government", `UNIQUE IMPORT ID`:50140});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:699, `ne`:["O"], `pos`:["NN"], `startPosition`:690, `value`:"insurance", `UNIQUE IMPORT ID`:50141});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:761, `ne`:["O"], `pos`:["VB"], `startPosition`:757, `value`:"gain", `UNIQUE IMPORT ID`:50142});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:668, `ne`:["O"], `pos`:["MD"], `startPosition`:663, `value`:"could", `UNIQUE IMPORT ID`:50143});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:736, `ne`:["O"], `pos`:["NN"], `startPosition`:728, `value`:"backlash", `UNIQUE IMPORT ID`:50144});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:766, `ne`:["O"], `pos`:["JJ"], `startPosition`:762, `value`:"full", `UNIQUE IMPORT ID`:50145});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:706, `ne`:["O"], `pos`:["NN"], `startPosition`:700, `value`:"market", `UNIQUE IMPORT ID`:50146});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:673, `ne`:["O"], `pos`:["VB"], `startPosition`:669, `value`:"lead", `UNIQUE IMPORT ID`:50147});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:774, `ne`:["O"], `pos`:["NN"], `startPosition`:767, `value`:"control", `UNIQUE IMPORT ID`:50148});
CREATE (:`Sentence` {`hash`:"05bea480a4157eb9998413f60989b04c", `id`:"0_4", `sentenceNumber`:4, `text`:"To stave off that outcome, Republicans could find themselves in the awkward position of appropriating huge sums to temporarily prop up the Obama health care law, angering conservative voters who have been demanding an end to the law for years."});
CREATE (:`Tag`:`NER_O` {`id`:"appropriate_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"appropriate_en", `ne`:["O"], `pos`:["VBG", "VBD", "JJ", "VBN", "VBZ"], `value`:"appropriate"});
CREATE (:`Tag`:`NER_O` {`id`:"conservative_en", `language`:"en", `lastTxId`:"1524366586637", `lowercasedId`:"conservative_en", `ne`:["O"], `pos`:["JJ", "NNS", "NN", "NNP"], `value`:"conservative"});
CREATE (:`Tag`:`NER_O` {`id`:"stave_en", `language`:"en", `lastTxId`:"1524365792814", `lowercasedId`:"stave_en", `ne`:["O"], `pos`:["VB", "VBD", "VBP", "VBG", "VBN"], `value`:"stave"});
CREATE (:`Tag`:`NER_O` {`id`:"sum_en", `language`:"en", `lastTxId`:"1524366359874", `lowercasedId`:"sum_en", `ne`:["O"], `pos`:["NNS", "NN", "VBZ", "VBD", "VB", "VBN", "VBG", "NNP", "VBP"], `value`:"sum"});
CREATE (:`Tag`:`NER_O` {`id`:"anger_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"anger_en", `ne`:["O"], `pos`:["VBG", "NN", "VBD", "VBN", "NNS", "VBZ", "NNP"], `value`:"anger"});
CREATE (:`Tag`:`NER_Duration`:`NER_Date` {`id`:"years_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"years_en", `ne`:["DURATION", "DATE"], `pos`:[], `value`:"years"});
CREATE (:`Tag`:`NER_O` {`id`:"find_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"find_en", `ne`:["O"], `pos`:["VB", "VBD", "VBP", "VBN", "VBG", "VBZ", "NNS"], `value`:"find"});
CREATE (:`Tag`:`NER_O` {`id`:"themselves_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"themselves_en", `ne`:["O"], `pos`:["PRP", "NNP"], `value`:"themselves"});
CREATE (:`Tag`:`NER_O` {`id`:"prop_en", `language`:"en", `lastTxId`:"1524366038624", `lowercasedId`:"prop_en", `ne`:["O"], `pos`:["VB", "VBD", "NNS", "VBN", "VBG", "VBP", "NNP"], `value`:"prop"});
CREATE (:`Tag`:`NER_O` {`id`:"awkward_en", `language`:"en", `lastTxId`:"1524366187616", `lowercasedId`:"awkward_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"awkward"});
CREATE (:`Tag`:`NER_O` {`id`:"huge_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"huge_en", `ne`:["O"], `pos`:["JJ", "NN", "NNP"], `value`:"huge"});
CREATE (:`Tag`:`NER_O`:`NER_Date` {`id`:"end_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"end_en", `ne`:["O", "DATE"], `pos`:["NN", "VBG", "VBD", "VBZ", "VBN", "VB", "NNS", "VBP", "NNP", "JJ"], `value`:"end"});
CREATE (:`Tag`:`NER_O` {`id`:"up_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"up_en", `ne`:["O"], `pos`:["RP", "RB", "IN", "NNS", "VBG", "VBN", "NN", "VBD"], `value`:"up"});
CREATE (:`Tag`:`NER_O` {`id`:"outcome_en", `language`:"en", `lastTxId`:"1524366590774", `lowercasedId`:"outcome_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"outcome"});
CREATE (:`Tag`:`NER_O`:`NER_Person` {`id`:"law_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"law_en", `ne`:["O", "PERSON"], `pos`:["NN", "NNS", "NNP", "VBZ"], `value`:"law"});
CREATE (:`Tag`:`NER_O` {`id`:"temporarily_en", `language`:"en", `lastTxId`:"1524366556210", `lowercasedId`:"temporarily_en", `ne`:["O"], `pos`:["RB"], `value`:"temporarily"});
CREATE (:`Tag`:`NER_O` {`id`:"demand_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"demand_en", `ne`:["O"], `pos`:["VBG", "NN", "VB", "NNS", "VBP", "VBD", "VBN", "VBZ"], `value`:"demand"});
CREATE (:`Tag`:`NER_O` {`id`:"off_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"off_en", `ne`:["O"], `pos`:["RP", "IN", "RB", "JJ", "NNP", "VBP", "NNS", "NN"], `value`:"off"});
CREATE (:`Tag`:`NER_Money`:`NER_O` {`id`:"position_en", `language`:"en", `lastTxId`:"1524366579686", `lowercasedId`:"position_en", `ne`:["O", "MONEY"], `pos`:["NN", "NNS", "VBG", "VBN", "VB", "VBD", "VBZ", "VBP"], `value`:"position"});
CREATE (:`Tag`:`NER_O` {`id`:"voter_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"voter_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP"], `value`:"voter"});
CREATE (:`Tag`:`NER_O` {`id`:"who_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"who_en", `ne`:["O"], `pos`:["WP", "NNS"], `value`:"who"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:900, `ne`:["O"], `pos`:["JJ"], `startPosition`:896, `value`:"huge", `UNIQUE IMPORT ID`:50171});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:838, `ne`:["O"], `pos`:["MD"], `startPosition`:833, `value`:"could", `UNIQUE IMPORT ID`:50172});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:905, `ne`:["O"], `pos`:["NNS"], `startPosition`:901, `value`:"sums", `UNIQUE IMPORT ID`:50173});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:977, `ne`:["O"], `pos`:["JJ"], `startPosition`:965, `value`:"conservative", `UNIQUE IMPORT ID`:50174});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:843, `ne`:["O"], `pos`:["VB"], `startPosition`:839, `value`:"find", `UNIQUE IMPORT ID`:50175});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1036, `ne`:["DURATION"], `pos`:[], `startPosition`:1031, `value`:"years", `UNIQUE IMPORT ID`:50176});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:854, `ne`:["O"], `pos`:["PRP"], `startPosition`:844, `value`:"themselves", `UNIQUE IMPORT ID`:50177});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:920, `ne`:["O"], `pos`:["RB"], `startPosition`:909, `value`:"temporarily", `UNIQUE IMPORT ID`:50178});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:984, `ne`:["O"], `pos`:["NNS"], `startPosition`:978, `value`:"voters", `UNIQUE IMPORT ID`:50179});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:925, `ne`:["O"], `pos`:["VB"], `startPosition`:921, `value`:"prop", `UNIQUE IMPORT ID`:50180});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:988, `ne`:["O"], `pos`:["WP"], `startPosition`:985, `value`:"who", `UNIQUE IMPORT ID`:50181});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:802, `ne`:["O"], `pos`:["VB"], `startPosition`:797, `value`:"stave", `UNIQUE IMPORT ID`:50182});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:993, `ne`:["O"], `pos`:["VBP"], `startPosition`:989, `value`:"have", `UNIQUE IMPORT ID`:50183});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:869, `ne`:["O"], `pos`:["JJ"], `startPosition`:862, `value`:"awkward", `UNIQUE IMPORT ID`:50184});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:928, `ne`:["O"], `pos`:["RP"], `startPosition`:926, `value`:"up", `UNIQUE IMPORT ID`:50185});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:806, `ne`:["O"], `pos`:["RP"], `startPosition`:803, `value`:"off", `UNIQUE IMPORT ID`:50186});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:938, `ne`:["PERSON"], `pos`:[], `startPosition`:933, `value`:"Obama", `UNIQUE IMPORT ID`:50187});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:878, `ne`:["O"], `pos`:["NN"], `startPosition`:870, `value`:"position", `UNIQUE IMPORT ID`:50188});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1008, `ne`:["O"], `pos`:["VBG"], `startPosition`:999, `value`:"demanding", `UNIQUE IMPORT ID`:50189});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:945, `ne`:["O"], `pos`:["NN"], `startPosition`:939, `value`:"health", `UNIQUE IMPORT ID`:50190});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:819, `ne`:["O"], `pos`:["NN"], `startPosition`:812, `value`:"outcome", `UNIQUE IMPORT ID`:50191});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:895, `ne`:["O"], `pos`:["VBG"], `startPosition`:882, `value`:"appropriating", `UNIQUE IMPORT ID`:50192});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:950, `ne`:["O"], `pos`:["NN"], `startPosition`:946, `value`:"care", `UNIQUE IMPORT ID`:50193});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1015, `ne`:["O"], `pos`:["NN"], `startPosition`:1012, `value`:"end", `UNIQUE IMPORT ID`:50194});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:832, `ne`:["MISC"], `pos`:[], `startPosition`:821, `value`:"Republicans", `UNIQUE IMPORT ID`:50195});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:954, `ne`:["O"], `pos`:["NN"], `startPosition`:951, `value`:"law", `UNIQUE IMPORT ID`:50196});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:964, `ne`:["O"], `pos`:["VBG"], `startPosition`:956, `value`:"angering", `UNIQUE IMPORT ID`:50197});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1026, `ne`:["O"], `pos`:["NN"], `startPosition`:1023, `value`:"law", `UNIQUE IMPORT ID`:50198});
CREATE (:`Sentence` {`hash`:"9cc7e6c0842cc91ec6d0b256f0306cb4", `id`:"0_5", `sentenceNumber`:5, `text`:"In another twist, Donald J. Trump’s administration, worried about preserving executive branch prerogatives, could choose to fight its Republican allies in the House on some central questions in the dispute."});
CREATE (:`Tag`:`NER_O` {`id`:"worry_en", `language`:"en", `lastTxId`:"1524366590774", `lowercasedId`:"worry_en", `ne`:["O"], `pos`:["VBN", "VBP", "NNS", "VB", "VBG", "VBZ", "VBD", "NN", "JJ"], `value`:"worry"});
CREATE (:`Tag`:`NER_O` {`id`:"some_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"some_en", `ne`:["O"], `pos`:["DT", "RB", "NNP"], `value`:"some"});
CREATE (:`Tag`:`NER_O` {`id`:"question_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"question_en", `ne`:["O"], `pos`:["NNS", "VBN", "NN", "VBD", "VB", "VBG", "VBP", "VBZ", "NNP"], `value`:"question"});
CREATE (:`Tag`:`NER_O`:`NER_Duration` {`id`:"another_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"another_en", `ne`:["O", "DURATION"], `pos`:["DT", "NNP"], `value`:"another"});
CREATE (:`Tag`:`NER_Date`:`NER_Time`:`NER_O`:`NER_Duration` {`id`:"about_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"about_en", `ne`:["O", "TIME", "DURATION", "DATE"], `pos`:["IN", "RB", "RP", "NNP"], `value`:"about"});
CREATE (:`Tag`:`NER_O` {`id`:"its_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"its_en", `ne`:["O"], `pos`:["PRP$", "NNP", "NNS", "VBZ"], `value`:"its"});
CREATE (:`Tag`:`NER_Misc`:`NER_Organization`:`NER_Person` {`id`:"Republican_en", `language`:"en", `lastTxId`:"1524366598829", `lowercasedId`:"republican_en", `ne`:["MISC", "ORGANIZATION", "PERSON"], `pos`:[], `value`:"Republican"});
CREATE (:`Tag`:`NER_O` {`id`:"preserve_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"preserve_en", `ne`:["O"], `pos`:["VBG", "VBN", "VB", "VBD", "VBZ", "VBP"], `value`:"preserve"});
CREATE (:`Tag`:`NER_Organization`:`NER_Person` {`id`:"Donald_en", `language`:"en", `lastTxId`:"1524366594848", `lowercasedId`:"donald_en", `ne`:["PERSON", "ORGANIZATION"], `pos`:[], `value`:"Donald"});
CREATE (:`Tag`:`NER_O` {`id`:"prerogative_en", `language`:"en", `lastTxId`:"1524365961871", `lowercasedId`:"prerogative_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"prerogative"});
CREATE (:`Tag`:`NER_O` {`id`:"central_en", `language`:"en", `lastTxId`:"1524366566227", `lowercasedId`:"central_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"central"});
CREATE (:`Tag`:`NER_O` {`id`:"ally_en", `language`:"en", `lastTxId`:"1524366453370", `lowercasedId`:"ally_en", `ne`:["O"], `pos`:["NNS", "NN", "VBN", "VBD", "NNP", "VBG", "VBP", "VB", "RB"], `value`:"ally"});
CREATE (:`Tag`:`NER_O` {`id`:"twist_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"twist_en", `ne`:["O"], `pos`:["NN", "VBG", "NNS", "VBN", "VBD", "VB", "VBP", "VBZ"], `value`:"twist"});
CREATE (:`Tag`:`NER_O` {`id`:"fight_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"fight_en", `ne`:["O"], `pos`:["VB", "NN", "NNS", "VBP", "VBD", "VBG", "VBN", "VBZ", "NNP"], `value`:"fight"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1062, `ne`:["PERSON"], `pos`:[], `startPosition`:1056, `value`:"Donald", `UNIQUE IMPORT ID`:50214});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:1158, `ne`:["O"], `pos`:["VB"], `startPosition`:1152, `value`:"choose", `UNIQUE IMPORT ID`:50215});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1097, `ne`:["O"], `pos`:["VBN"], `startPosition`:1090, `value`:"worried", `UNIQUE IMPORT ID`:50216});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1228, `ne`:["O"], `pos`:["NNS"], `startPosition`:1219, `value`:"questions", `UNIQUE IMPORT ID`:50217});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1131, `ne`:["O"], `pos`:["NN"], `startPosition`:1125, `value`:"branch", `UNIQUE IMPORT ID`:50218});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1071, `ne`:["PERSON"], `pos`:[], `startPosition`:1066, `value`:" Trump", `UNIQUE IMPORT ID`:50219});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1103, `ne`:["O"], `pos`:["IN"], `startPosition`:1098, `value`:"about", `UNIQUE IMPORT ID`:50220});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1167, `ne`:["O"], `pos`:["VB"], `startPosition`:1162, `value`:"fight", `UNIQUE IMPORT ID`:50221});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1144, `ne`:["O"], `pos`:["NNS"], `startPosition`:1132, `value`:"prerogatives", `UNIQUE IMPORT ID`:50222});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1202, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:1197, `value`:"House", `UNIQUE IMPORT ID`:50223});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1114, `ne`:["O"], `pos`:["VBG"], `startPosition`:1104, `value`:"preserving", `UNIQUE IMPORT ID`:50224});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1171, `ne`:["O"], `pos`:["PRP$"], `startPosition`:1168, `value`:"its", `UNIQUE IMPORT ID`:50225});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1048, `ne`:["O"], `pos`:["DT"], `startPosition`:1041, `value`:"another", `UNIQUE IMPORT ID`:50226});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1088, `ne`:["O"], `pos`:["NN"], `startPosition`:1074, `value`:"administration", `UNIQUE IMPORT ID`:50227});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1182, `ne`:["MISC"], `pos`:[], `startPosition`:1172, `value`:"Republican", `UNIQUE IMPORT ID`:50228});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1243, `ne`:["O"], `pos`:["NN"], `startPosition`:1236, `value`:"dispute", `UNIQUE IMPORT ID`:50229});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1210, `ne`:["O"], `pos`:["DT"], `startPosition`:1206, `value`:"some", `UNIQUE IMPORT ID`:50230});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1054, `ne`:["O"], `pos`:["NN"], `startPosition`:1049, `value`:"twist", `UNIQUE IMPORT ID`:50231});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1151, `ne`:["O"], `pos`:["MD"], `startPosition`:1146, `value`:"could", `UNIQUE IMPORT ID`:50232});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1124, `ne`:["O"], `pos`:["JJ"], `startPosition`:1115, `value`:"executive", `UNIQUE IMPORT ID`:50233});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1218, `ne`:["O"], `pos`:["JJ"], `startPosition`:1211, `value`:"central", `UNIQUE IMPORT ID`:50234});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1189, `ne`:["O"], `pos`:["NNS"], `startPosition`:1183, `value`:"allies", `UNIQUE IMPORT ID`:50235});
CREATE (:`Sentence` {`hash`:"5f0728595c5cde84eb207526f7ca154a", `id`:"0_6", `sentenceNumber`:6, `text`:"Eager to avoid an ugly political pileup, Republicans on Capitol Hill and the Trump transition team are gaming out how to handle the lawsuit, which, after the election, has been put in limbo until at least late February by the United States Court of Appeals for the District of Columbia Circuit."});
CREATE (:`Tag`:`NER_O` {`id`:"eager_en", `language`:"en", `lastTxId`:"1524366474538", `lowercasedId`:"eager_en", `ne`:["O"], `pos`:["NNP", "JJ"], `value`:"eager"});
CREATE (:`Tag`:`NER_Organization` {`id`:"United States Court of Appeals for the District of Columbia Circuit_en", `language`:"en", `lastTxId`:"1524358907332", `lowercasedId`:"united states court of appeals for the district of columbia circuit_en", `ne`:["ORGANIZATION"], `pos`:[], `value`:"United States Court of Appeals for the District of Columbia Circuit"});
CREATE (:`Tag`:`NER_O` {`id`:"least_en", `language`:"en", `lastTxId`:"1524366597560", `lowercasedId`:"least_en", `ne`:["O"], `pos`:["JJS", "RBS", "VB", "NNP"], `value`:"least"});
CREATE (:`Tag`:`NER_O` {`id`:"put_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"put_en", `ne`:["O"], `pos`:["VBN", "VBD", "VBG", "VB", "VBZ", "VBP", "NN", "NNP", "JJ"], `value`:"put"});
CREATE (:`Tag`:`NER_O` {`id`:"out_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"out_en", `ne`:["O"], `pos`:["IN", "RP", "RB", "VBN", "VBG", "JJ", "VBP", "NNP", "NNS", "VBZ", "NN", "VBD"], `value`:"out"});
CREATE (:`Tag`:`NER_O` {`id`:"how_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"how_en", `ne`:["O"], `pos`:["WRB", "NNP"], `value`:"how"});
CREATE (:`Tag`:`NER_O` {`id`:"pileup_en", `language`:"en", `lastTxId`:"1524361133946", `lowercasedId`:"pileup_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"pileup"});
CREATE (:`Tag`:`NER_O` {`id`:"after_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"after_en", `ne`:["O"], `pos`:["IN", "RB", "NN", "NNP"], `value`:"after"});
CREATE (:`Tag`:`NER_Location`:`NER_Organization`:`NER_Person` {`id`:"Capitol Hill_en", `language`:"en", `lastTxId`:"1524366421411", `lowercasedId`:"capitol hill_en", `ne`:["LOCATION", "ORGANIZATION", "PERSON"], `pos`:[], `value`:"Capitol Hill"});
CREATE (:`Tag`:`NER_Number`:`NER_O` {`id`:"gaming_en", `language`:"en", `lastTxId`:"1524366156327", `lowercasedId`:"gaming_en", `ne`:["O", "NUMBER"], `pos`:["NN"], `value`:"gaming"});
CREATE (:`Tag`:`NER_Date` {`id`:"late February_en", `language`:"en", `lastTxId`:"1524363518739", `lowercasedId`:"late february_en", `ne`:["DATE"], `pos`:[], `value`:"late February"});
CREATE (:`Tag`:`NER_O` {`id`:"election_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"election_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"election"});
CREATE (:`Tag`:`NER_O` {`id`:"ugly_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"ugly_en", `ne`:["O"], `pos`:["JJ", "NNP", "RB"], `value`:"ugly"});
CREATE (:`Tag`:`NER_O` {`id`:"handle_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"handle_en", `ne`:["O"], `pos`:["VB", "VBG", "VBD", "VBZ", "VBN", "VBP"], `value`:"handle"});
CREATE (:`Tag`:`NER_O` {`id`:"team_en", `language`:"en", `lastTxId`:"1524366567180", `lowercasedId`:"team_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP", "VBD", "VBG", "VBN", "VB", "VBP"], `value`:"team"});
CREATE (:`Tag`:`NER_O` {`id`:"transition_en", `language`:"en", `lastTxId`:"1524366562114", `lowercasedId`:"transition_en", `ne`:["O"], `pos`:["NN", "VBG", "NNS", "VBN", "VBD"], `value`:"transition"});
CREATE (:`Tag`:`NER_O` {`id`:"until_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"until_en", `ne`:["O"], `pos`:["IN", "NNP"], `value`:"until"});
CREATE (:`Tag`:`NER_O` {`id`:"avoid_en", `language`:"en", `lastTxId`:"1524366591844", `lowercasedId`:"avoid_en", `ne`:["O"], `pos`:["VB", "VBD", "VBP", "VBG", "VBN", "VBZ", "NN"], `value`:"avoid"});
CREATE (:`Tag`:`NER_O` {`id`:"limbo_en", `language`:"en", `lastTxId`:"1524365764920", `lowercasedId`:"limbo_en", `ne`:["O"], `pos`:["NN", "NNP"], `value`:"limbo"});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:1354, `ne`:["O"], `pos`:["NN"], `startPosition`:1348, `value`:"gaming", `UNIQUE IMPORT ID`:50256});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1416, `ne`:["O"], `pos`:["VBZ"], `startPosition`:1413, `value`:"has", `UNIQUE IMPORT ID`:50257});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1297, `ne`:["MISC"], `pos`:[], `startPosition`:1286, `value`:"Republicans", `UNIQUE IMPORT ID`:50258});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1358, `ne`:["O"], `pos`:["IN"], `startPosition`:1355, `value`:"out", `UNIQUE IMPORT ID`:50259});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1425, `ne`:["O"], `pos`:["VBN"], `startPosition`:1422, `value`:"put", `UNIQUE IMPORT ID`:50260});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1362, `ne`:["O"], `pos`:["WRB"], `startPosition`:1359, `value`:"how", `UNIQUE IMPORT ID`:50261});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1313, `ne`:["LOCATION"], `pos`:[], `startPosition`:1301, `value`:"Capitol Hill", `UNIQUE IMPORT ID`:50262});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1434, `ne`:["O"], `pos`:["NN"], `startPosition`:1429, `value`:"limbo", `UNIQUE IMPORT ID`:50263});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1372, `ne`:["O"], `pos`:["VB"], `startPosition`:1366, `value`:"handle", `UNIQUE IMPORT ID`:50264});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1440, `ne`:["O"], `pos`:["IN"], `startPosition`:1435, `value`:"until", `UNIQUE IMPORT ID`:50265});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1250, `ne`:["O"], `pos`:["NNP"], `startPosition`:1245, `value`:"Eager", `UNIQUE IMPORT ID`:50266});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1384, `ne`:["O"], `pos`:["NN"], `startPosition`:1377, `value`:"lawsuit", `UNIQUE IMPORT ID`:50267});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1449, `ne`:["O"], `pos`:["JJS"], `startPosition`:1444, `value`:"least", `UNIQUE IMPORT ID`:50268});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1259, `ne`:["O"], `pos`:["VB"], `startPosition`:1254, `value`:"avoid", `UNIQUE IMPORT ID`:50269});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1327, `ne`:["PERSON"], `pos`:[], `startPosition`:1322, `value`:"Trump", `UNIQUE IMPORT ID`:50270});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1391, `ne`:["O"], `pos`:["WDT"], `startPosition`:1386, `value`:"which", `UNIQUE IMPORT ID`:50271});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1463, `ne`:["DATE"], `pos`:[], `startPosition`:1450, `value`:"late February", `UNIQUE IMPORT ID`:50272});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1267, `ne`:["O"], `pos`:["JJ"], `startPosition`:1263, `value`:"ugly", `UNIQUE IMPORT ID`:50273});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1338, `ne`:["O"], `pos`:["NN"], `startPosition`:1328, `value`:"transition", `UNIQUE IMPORT ID`:50274});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1398, `ne`:["O"], `pos`:["IN"], `startPosition`:1393, `value`:"after", `UNIQUE IMPORT ID`:50275});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1277, `ne`:["O"], `pos`:["JJ"], `startPosition`:1268, `value`:"political", `UNIQUE IMPORT ID`:50276});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1343, `ne`:["O"], `pos`:["NN"], `startPosition`:1339, `value`:"team", `UNIQUE IMPORT ID`:50277});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1411, `ne`:["O"], `pos`:["NN"], `startPosition`:1403, `value`:"election", `UNIQUE IMPORT ID`:50278});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1284, `ne`:["O"], `pos`:["NN"], `startPosition`:1278, `value`:"pileup", `UNIQUE IMPORT ID`:50279});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1538, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:1471, `value`:"United States Court of Appeals for the District of Columbia Circuit", `UNIQUE IMPORT ID`:50280});
CREATE (:`Sentence` {`hash`:"302882aee6ebc214399874e8b7cea709", `id`:"0_7", `sentenceNumber`:7, `text`:"They are not yet ready to divulge their strategy."});
CREATE (:`Tag`:`NER_O` {`id`:"ready_en", `language`:"en", `lastTxId`:"1524366552212", `lowercasedId`:"ready_en", `ne`:["O"], `pos`:["JJ", "VBG", "NNP", "VBN", "VBD", "VBZ"], `value`:"ready"});
CREATE (:`Tag`:`NER_O` {`id`:"divulge_en", `language`:"en", `lastTxId`:"1524366386016", `lowercasedId`:"divulge_en", `ne`:["O"], `pos`:["VB", "VBG", "VBD", "VBN", "VBP", "VBZ"], `value`:"divulge"});
CREATE (:`Tag`:`NER_O` {`id`:"yet_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"yet_en", `ne`:["O"], `pos`:["RB", "CC"], `value`:"yet"});
CREATE (:`Tag`:`NER_O` {`id`:"strategy_en", `language`:"en", `lastTxId`:"1524366586637", `lowercasedId`:"strategy_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"strategy"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1556, `ne`:["O"], `pos`:["RB"], `startPosition`:1553, `value`:"yet", `UNIQUE IMPORT ID`:50286});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:1562, `ne`:["O"], `pos`:["JJ"], `startPosition`:1557, `value`:"ready", `UNIQUE IMPORT ID`:50287});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1588, `ne`:["O"], `pos`:["NN"], `startPosition`:1580, `value`:"strategy", `UNIQUE IMPORT ID`:50288});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1573, `ne`:["O"], `pos`:["VB"], `startPosition`:1566, `value`:"divulge", `UNIQUE IMPORT ID`:50289});
CREATE (:`Sentence` {`hash`:"0d763527b6f53e2ebedeab68b1ebab4f", `id`:"0_8", `sentenceNumber`:8, `text`:"“Given that this pending litigation involves the Obama administration and Congress, it would be inappropriate to comment,” said Phillip J. Blando, a spokesman for the Trump transition effort."});
CREATE (:`Tag`:`NER_Organization`:`NER_Person` {`id`:"Congress_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"congress_en", `ne`:["ORGANIZATION", "PERSON"], `pos`:[], `value`:"Congress"});
CREATE (:`Tag`:`NER_O` {`id`:"give_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"give_en", `ne`:["O"], `pos`:["VBN", "VB", "VBG", "VBD", "VBP", "VBZ"], `value`:"give"});
CREATE (:`Tag`:`NER_O` {`id`:"spokesman_en", `language`:"en", `lastTxId`:"1524366595488", `lowercasedId`:"spokesman_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"spokesman"});
CREATE (:`Tag`:`NER_O` {`id`:"say_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"say_en", `ne`:["O"], `pos`:["VBD", "VBP", "VB", "VBN", "VBG", "VBZ", "NN", "NNP"], `value`:"say"});
CREATE (:`Tag`:`NER_O` {`id`:"effort_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"effort_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"effort"});
CREATE (:`Tag`:`NER_O` {`id`:"involve_en", `language`:"en", `lastTxId`:"1524366562114", `lowercasedId`:"involve_en", `ne`:["O"], `pos`:["VBZ", "VBN", "VBG", "VB", "VBD", "VBP"], `value`:"involve"});
CREATE (:`Tag`:`NER_O` {`id`:"litigation_en", `language`:"en", `lastTxId`:"1524366017931", `lowercasedId`:"litigation_en", `ne`:["O"], `pos`:["NN"], `value`:"litigation"});
CREATE (:`Tag`:`NER_O` {`id`:"would_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"would_en", `ne`:["O"], `pos`:["MD", "VBD", "JJ", "NNP"], `value`:"would"});
CREATE (:`Tag`:`NER_O` {`id`:"inappropriate_en", `language`:"en", `lastTxId`:"1524366453370", `lowercasedId`:"inappropriate_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"inappropriate"});
CREATE (:`Tag`:`NER_O` {`id`:"comment_en", `language`:"en", `lastTxId`:"1524366598829", `lowercasedId`:"comment_en", `ne`:["O"], `pos`:["VB", "NNS", "NN", "VBG", "VBD", "VBN", "VBZ", "VBP"], `value`:"comment"});
CREATE (:`Tag`:`NER_Person` {`id`:"Phillip_en", `language`:"en", `lastTxId`:"1524365218983", `lowercasedId`:"phillip_en", `ne`:["PERSON"], `pos`:[], `value`:"Phillip"});
CREATE (:`Tag`:`NER_Person` {`id`:"Blando_en", `language`:"en", `lastTxId`:"1524355999331", `lowercasedId`:"blando_en", `ne`:["PERSON"], `pos`:[], `value`:"Blando"});
CREATE (:`Tag`:`NER_O` {`id`:"pend_en", `language`:"en", `lastTxId`:"1524366414773", `lowercasedId`:"pend_en", `ne`:["O"], `pos`:["VBG", "VBP", "VBZ"], `value`:"pend"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1672, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:1664, `value`:"Congress", `UNIQUE IMPORT ID`:50304});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1735, `ne`:["PERSON"], `pos`:[], `startPosition`:1729, `value`:" Blando", `UNIQUE IMPORT ID`:50305});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1773, `ne`:["O"], `pos`:["NN"], `startPosition`:1763, `value`:"transition", `UNIQUE IMPORT ID`:50306});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1614, `ne`:["O"], `pos`:["VBG"], `startPosition`:1607, `value`:"pending", `UNIQUE IMPORT ID`:50307});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1644, `ne`:["PERSON"], `pos`:[], `startPosition`:1639, `value`:"Obama", `UNIQUE IMPORT ID`:50308});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1710, `ne`:["O"], `pos`:["VB"], `startPosition`:1703, `value`:"comment", `UNIQUE IMPORT ID`:50309});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1748, `ne`:["O"], `pos`:["NN"], `startPosition`:1739, `value`:"spokesman", `UNIQUE IMPORT ID`:50310});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1659, `ne`:["O"], `pos`:["NN"], `startPosition`:1645, `value`:"administration", `UNIQUE IMPORT ID`:50311});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1682, `ne`:["O"], `pos`:["MD"], `startPosition`:1677, `value`:"would", `UNIQUE IMPORT ID`:50312});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1780, `ne`:["O"], `pos`:["NN"], `startPosition`:1774, `value`:"effort", `UNIQUE IMPORT ID`:50313});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1625, `ne`:["O"], `pos`:["NN"], `startPosition`:1615, `value`:"litigation", `UNIQUE IMPORT ID`:50314});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:1717, `ne`:["O"], `pos`:["VBD"], `startPosition`:1713, `value`:"said", `UNIQUE IMPORT ID`:50315});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1699, `ne`:["O"], `pos`:["JJ"], `startPosition`:1686, `value`:"inappropriate", `UNIQUE IMPORT ID`:50316});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1725, `ne`:["PERSON"], `pos`:[], `startPosition`:1718, `value`:"Phillip", `UNIQUE IMPORT ID`:50317});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1596, `ne`:["O"], `pos`:["VBN"], `startPosition`:1591, `value`:"Given", `UNIQUE IMPORT ID`:50318});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1634, `ne`:["O"], `pos`:["VBZ"], `startPosition`:1626, `value`:"involves", `UNIQUE IMPORT ID`:50319});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1762, `ne`:["PERSON"], `pos`:[], `startPosition`:1757, `value`:"Trump", `UNIQUE IMPORT ID`:50320});
CREATE (:`Sentence` {`hash`:"0ca37ca45c597aec2326f70591dd0a54", `id`:"0_9", `sentenceNumber`:9, `text`:"“Upon taking office, the Trump administration will evaluate this case and all related aspects of the Affordable Care Act. ”"});
CREATE (:`Tag`:`NER_O` {`id`:"all_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"all_en", `ne`:["O"], `pos`:["DT", "PDT", "RB", "NN", "NNP"], `value`:"all"});
CREATE (:`Tag`:`NER_O` {`id`:"take_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"take_en", `ne`:["O"], `pos`:["VBG", "VB", "VBD", "VBP", "VBN", "VBZ", "NN", "NNP"], `value`:"take"});
CREATE (:`Tag`:`NER_O` {`id`:"related_en", `language`:"en", `lastTxId`:"1524366402416", `lowercasedId`:"related_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"related"});
CREATE (:`Tag`:`NER_O` {`id`:"aspect_en", `language`:"en", `lastTxId`:"1524366474538", `lowercasedId`:"aspect_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"aspect"});
CREATE (:`Tag`:`NER_O` {`id`:"office_en", `language`:"en", `lastTxId`:"1524366552212", `lowercasedId`:"office_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"office"});
CREATE (:`Tag`:`NER_O` {`id`:"upon_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"upon_en", `ne`:["O"], `pos`:["IN", "RP"], `value`:"upon"});
CREATE (:`Tag`:`NER_O` {`id`:"evaluate_en", `language`:"en", `lastTxId`:"1524366276555", `lowercasedId`:"evaluate_en", `ne`:["O"], `pos`:["VB", "VBZ", "VBN", "VBP", "VBD", "VBG"], `value`:"evaluate"});
CREATE (:`Tag`:`NER_Misc` {`id`:"Affordable Care Act_en", `language`:"en", `lastTxId`:"1524366195720", `lowercasedId`:"affordable care act_en", `ne`:["MISC"], `pos`:[], `value`:"Affordable Care Act"});
CREATE (:`Tag`:`NER_O` {`id`:"case_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"case_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP", "VBN", "VBG", "VBD"], `value`:"case"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1859, `ne`:["O"], `pos`:["DT"], `startPosition`:1856, `value`:"all", `UNIQUE IMPORT ID`:50331});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1801, `ne`:["O"], `pos`:["NN"], `startPosition`:1795, `value`:"office", `UNIQUE IMPORT ID`:50332});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1867, `ne`:["O"], `pos`:["JJ"], `startPosition`:1860, `value`:"related", `UNIQUE IMPORT ID`:50333});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1827, `ne`:["O"], `pos`:["NN"], `startPosition`:1813, `value`:"administration", `UNIQUE IMPORT ID`:50334});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1787, `ne`:["O"], `pos`:["IN"], `startPosition`:1783, `value`:"Upon", `UNIQUE IMPORT ID`:50335});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1851, `ne`:["O"], `pos`:["NN"], `startPosition`:1847, `value`:"case", `UNIQUE IMPORT ID`:50336});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:1841, `ne`:["O"], `pos`:["VB"], `startPosition`:1833, `value`:"evaluate", `UNIQUE IMPORT ID`:50337});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1902, `ne`:["MISC"], `pos`:[], `startPosition`:1883, `value`:"Affordable Care Act", `UNIQUE IMPORT ID`:50338});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1794, `ne`:["O"], `pos`:["VBG"], `startPosition`:1788, `value`:"taking", `UNIQUE IMPORT ID`:50339});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1875, `ne`:["O"], `pos`:["NNS"], `startPosition`:1868, `value`:"aspects", `UNIQUE IMPORT ID`:50340});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1812, `ne`:["PERSON"], `pos`:[], `startPosition`:1807, `value`:"Trump", `UNIQUE IMPORT ID`:50341});
CREATE (:`Sentence` {`hash`:"39aabd66983cb8b40f0fae814c27d904", `id`:"0_10", `sentenceNumber`:10, `text`:"In a potentially   decision in 2015, Judge Rosemary M. Collyer ruled that House Republicans had the standing to sue the executive branch over a spending dispute and that the Obama administration had been distributing the health insurance subsidies, in violation of the Constitution, without approval from Congress."});
CREATE (:`Tag`:`NER_O` {`id`:"sue_en", `language`:"en", `lastTxId`:"1524366436170", `lowercasedId`:"sue_en", `ne`:["O"], `pos`:["VB", "VBG", "VBD", "VBN", "VBP", "VBZ", "NN"], `value`:"sue"});
CREATE (:`Tag`:`NER_O` {`id`:"constitution_en", `language`:"en", `lastTxId`:"1524366597560", `lowercasedId`:"constitution_en", `ne`:["O"], `pos`:["NNP", "NN", "NNS"], `value`:"constitution"});
CREATE (:`Tag`:`NER_O` {`id`:"rule_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"rule_en", `ne`:["O"], `pos`:["VBD", "VB", "VBN", "NNS", "NN", "VBG", "VBZ", "NNP", "VBP"], `value`:"rule"});
CREATE (:`Tag`:`NER_Person` {`id`:"Collyer_en", `language`:"en", `lastTxId`:"1524357880370", `lowercasedId`:"collyer_en", `ne`:["PERSON"], `pos`:[], `value`:"Collyer"});
CREATE (:`Tag`:`NER_Percent`:`NER_O` {`id`:"from_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"from_en", `ne`:["O", "PERCENT"], `pos`:["IN", "NNP", "NN"], `value`:"from"});
CREATE (:`Tag`:`NER_O` {`id`:"judge_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"judge_en", `ne`:["O"], `pos`:["NNP", "NN", "NNS", "VBN", "VBG", "VBD", "VB", "VBP"], `value`:"judge"});
CREATE (:`Tag`:`NER_O` {`id`:"distribute_en", `language`:"en", `lastTxId`:"1524366411699", `lowercasedId`:"distribute_en", `ne`:["O"], `pos`:["VBG", "VBN", "VB", "VBZ", "VBP", "VBD"], `value`:"distribute"});
CREATE (:`Tag`:`NER_O` {`id`:"over_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"over_en", `ne`:["O"], `pos`:["IN", "RP", "RB", "NNP", "JJ"], `value`:"over"});
CREATE (:`Tag`:`NER_O` {`id`:"decision_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"decision_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"decision"});
CREATE (:`Tag`:`NER_O` {`id`:"approval_en", `language`:"en", `lastTxId`:"1524366491011", `lowercasedId`:"approval_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"approval"});
CREATE (:`Tag`:`NER_O` {`id`:"standing_en", `language`:"en", `lastTxId`:"1524366409969", `lowercasedId`:"standing_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP", "JJ"], `value`:"standing"});
CREATE (:`Tag`:`NER_O` {`id`:"spending_en", `language`:"en", `lastTxId`:"1524366421411", `lowercasedId`:"spending_en", `ne`:["O"], `pos`:["NN"], `value`:"spending"});
CREATE (:`Tag`:`NER_Date` {`id`:"2015_en", `language`:"en", `lastTxId`:"1524366595488", `lowercasedId`:"2015_en", `ne`:["DATE"], `pos`:[], `value`:"2015"});
CREATE (:`Tag`:`NER_O` {`id`:"violation_en", `language`:"en", `lastTxId`:"1524366386016", `lowercasedId`:"violation_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"violation"});
CREATE (:`Tag`:`NER_Person` {`id`:"Rosemary_en", `language`:"en", `lastTxId`:"1524360243938", `lowercasedId`:"rosemary_en", `ne`:["PERSON"], `pos`:[], `value`:"Rosemary"});
CREATE (:`Tag`:`NER_O` {`id`:"potentially_en", `language`:"en", `lastTxId`:"1524366578183", `lowercasedId`:"potentially_en", `ne`:["O"], `pos`:["RB"], `value`:"potentially"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1997, `ne`:["MISC"], `pos`:[], `startPosition`:1986, `value`:"Republicans", `UNIQUE IMPORT ID`:50359});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2058, `ne`:["O"], `pos`:["NN"], `startPosition`:2050, `value`:"spending", `UNIQUE IMPORT ID`:50360});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1933, `ne`:["O"], `pos`:["NN"], `startPosition`:1925, `value`:"decision", `UNIQUE IMPORT ID`:50361});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2066, `ne`:["O"], `pos`:["NN"], `startPosition`:2059, `value`:"dispute", `UNIQUE IMPORT ID`:50362});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2196, `ne`:["O"], `pos`:["IN"], `startPosition`:2189, `value`:"without", `UNIQUE IMPORT ID`:50363});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2001, `ne`:["O"], `pos`:["VBD"], `startPosition`:1998, `value`:"had", `UNIQUE IMPORT ID`:50364});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2133, `ne`:["O"], `pos`:["NN"], `startPosition`:2127, `value`:"health", `UNIQUE IMPORT ID`:50365});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1941, `ne`:["DATE"], `pos`:[], `startPosition`:1937, `value`:"2015", `UNIQUE IMPORT ID`:50366});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2205, `ne`:["O"], `pos`:["NN"], `startPosition`:2197, `value`:"approval", `UNIQUE IMPORT ID`:50367});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2014, `ne`:["O"], `pos`:["NN"], `startPosition`:2006, `value`:"standing", `UNIQUE IMPORT ID`:50368});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2143, `ne`:["O"], `pos`:["NN"], `startPosition`:2134, `value`:"insurance", `UNIQUE IMPORT ID`:50369});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1948, `ne`:["O"], `pos`:["NNP"], `startPosition`:1943, `value`:"Judge", `UNIQUE IMPORT ID`:50370});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1957, `ne`:["PERSON"], `pos`:[], `startPosition`:1949, `value`:"Rosemary", `UNIQUE IMPORT ID`:50371});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2210, `ne`:["O"], `pos`:["IN"], `startPosition`:2206, `value`:"from", `UNIQUE IMPORT ID`:50372});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2085, `ne`:["PERSON"], `pos`:[], `startPosition`:2080, `value`:"Obama", `UNIQUE IMPORT ID`:50373});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2153, `ne`:["O"], `pos`:["NNS"], `startPosition`:2144, `value`:"subsidies", `UNIQUE IMPORT ID`:50374});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2021, `ne`:["O"], `pos`:["VB"], `startPosition`:2018, `value`:"sue", `UNIQUE IMPORT ID`:50375});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2219, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:2211, `value`:"Congress", `UNIQUE IMPORT ID`:50376});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2100, `ne`:["O"], `pos`:["NN"], `startPosition`:2086, `value`:"administration", `UNIQUE IMPORT ID`:50377});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1968, `ne`:["PERSON"], `pos`:[], `startPosition`:1961, `value`:" Collyer", `UNIQUE IMPORT ID`:50378});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2035, `ne`:["O"], `pos`:["JJ"], `startPosition`:2026, `value`:"executive", `UNIQUE IMPORT ID`:50379});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2167, `ne`:["O"], `pos`:["NN"], `startPosition`:2158, `value`:"violation", `UNIQUE IMPORT ID`:50380});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:1974, `ne`:["O"], `pos`:["VBD"], `startPosition`:1969, `value`:"ruled", `UNIQUE IMPORT ID`:50381});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2042, `ne`:["O"], `pos`:["NN"], `startPosition`:2036, `value`:"branch", `UNIQUE IMPORT ID`:50382});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2104, `ne`:["O"], `pos`:["VBD"], `startPosition`:2101, `value`:"had", `UNIQUE IMPORT ID`:50383});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1922, `ne`:["O"], `pos`:["RB"], `startPosition`:1911, `value`:"potentially", `UNIQUE IMPORT ID`:50384});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2047, `ne`:["O"], `pos`:["IN"], `startPosition`:2043, `value`:"over", `UNIQUE IMPORT ID`:50385});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:1985, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:1980, `value`:"House", `UNIQUE IMPORT ID`:50386});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2122, `ne`:["O"], `pos`:["VBG"], `startPosition`:2110, `value`:"distributing", `UNIQUE IMPORT ID`:50387});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2187, `ne`:["O"], `pos`:["NNP"], `startPosition`:2175, `value`:"Constitution", `UNIQUE IMPORT ID`:50388});
CREATE (:`Sentence` {`hash`:"ba35a98bd544137ab1e7f32e513b2cda", `id`:"0_11", `sentenceNumber`:11, `text`:"The Justice Department, confident that Judge Collyer’s decision would be reversed, quickly appealed, and the subsidies have remained in place during the appeal."});
CREATE (:`Tag`:`NER_Organization` {`id`:"Justice Department_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"justice department_en", `ne`:["ORGANIZATION"], `pos`:[], `value`:"Justice Department"});
CREATE (:`Tag`:`NER_O` {`id`:"remain_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"remain_en", `ne`:["O"], `pos`:["VBN", "VB", "VBZ", "VBD", "VBG", "VBP", "NNP"], `value`:"remain"});
CREATE (:`Tag`:`NER_O` {`id`:"confident_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"confident_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"confident"});
CREATE (:`Tag`:`NER_O` {`id`:"quickly_en", `language`:"en", `lastTxId`:"1524366564957", `lowercasedId`:"quickly_en", `ne`:["O"], `pos`:["RB"], `value`:"quickly"});
CREATE (:`Tag`:`NER_O` {`id`:"appeal_en", `language`:"en", `lastTxId`:"1524366586637", `lowercasedId`:"appeal_en", `ne`:["O"], `pos`:["VBD", "NN", "VB", "NNS", "VBG", "VBP", "VBN", "NNP"], `value`:"appeal"});
CREATE (:`Tag`:`NER_Money`:`NER_O` {`id`:"during_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"during_en", `ne`:["O", "MONEY"], `pos`:["IN", "NNP"], `value`:"during"});
CREATE (:`Tag`:`NER_O` {`id`:"reverse_en", `language`:"en", `lastTxId`:"1524366552212", `lowercasedId`:"reverse_en", `ne`:["O"], `pos`:["VBN", "VB", "JJ", "VBD", "NN", "VBG", "VBZ", "VBP"], `value`:"reverse"});
CREATE (:`Tag`:`NER_O` {`id`:"place_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"place_en", `ne`:["O"], `pos`:["NN", "VB", "NNS", "VBG", "VBN", "VBD", "VBZ", "VBP", "NNP"], `value`:"place"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2311, `ne`:["O"], `pos`:["RB"], `startPosition`:2304, `value`:"quickly", `UNIQUE IMPORT ID`:50398});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2284, `ne`:["O"], `pos`:["NN"], `startPosition`:2276, `value`:"decision", `UNIQUE IMPORT ID`:50399});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2344, `ne`:["O"], `pos`:["VBP"], `startPosition`:2340, `value`:"have", `UNIQUE IMPORT ID`:50400});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2254, `ne`:["O"], `pos`:["JJ"], `startPosition`:2245, `value`:"confident", `UNIQUE IMPORT ID`:50401});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2380, `ne`:["O"], `pos`:["VBD"], `startPosition`:2374, `value`:"appeal", `UNIQUE IMPORT ID`:50402});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:2320, `ne`:["O"], `pos`:["VBD"], `startPosition`:2312, `value`:"appealed", `UNIQUE IMPORT ID`:50403});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2353, `ne`:["O"], `pos`:["VBN"], `startPosition`:2345, `value`:"remained", `UNIQUE IMPORT ID`:50404});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2290, `ne`:["O"], `pos`:["MD"], `startPosition`:2285, `value`:"would", `UNIQUE IMPORT ID`:50405});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2243, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:2225, `value`:"Justice Department", `UNIQUE IMPORT ID`:50406});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2265, `ne`:["O"], `pos`:["NNP"], `startPosition`:2260, `value`:"Judge", `UNIQUE IMPORT ID`:50407});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2362, `ne`:["O"], `pos`:["NN"], `startPosition`:2357, `value`:"place", `UNIQUE IMPORT ID`:50408});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2302, `ne`:["O"], `pos`:["VBN"], `startPosition`:2294, `value`:"reversed", `UNIQUE IMPORT ID`:50409});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2273, `ne`:["PERSON"], `pos`:[], `startPosition`:2266, `value`:"Collyer", `UNIQUE IMPORT ID`:50410});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2339, `ne`:["O"], `pos`:["NNS"], `startPosition`:2330, `value`:"subsidies", `UNIQUE IMPORT ID`:50411});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2369, `ne`:["O"], `pos`:["IN"], `startPosition`:2363, `value`:"during", `UNIQUE IMPORT ID`:50412});
CREATE (:`Sentence` {`hash`:"2d84230a474e03ce0a892f8681a09f6c", `id`:"0_12", `sentenceNumber`:12, `text`:"In successfully seeking a temporary halt in the proceedings after Mr. Trump won, House Republicans last month told the court that they “and the  ’s transition team currently are discussing potential options for resolution of this matter, to take effect after the  ’s inauguration on Jan. 20, 2017. ”"});
CREATE (:`Tag`:`NER_O` {`id`:"temporary_en", `language`:"en", `lastTxId`:"1524366598829", `lowercasedId`:"temporary_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"temporary"});
CREATE (:`Tag`:`NER_Date` {`id`:"last month_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"last month_en", `ne`:["DATE"], `pos`:[], `value`:"last month"});
CREATE (:`Tag`:`NER_O` {`id`:"tell_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"tell_en", `ne`:["O"], `pos`:["VBD", "VBP", "VBG", "VBN", "VB", "VBZ"], `value`:"tell"});
CREATE (:`Tag`:`NER_O` {`id`:"matter_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"matter_en", `ne`:["O"], `pos`:["NN", "NNS", "VB", "VBD", "NNP", "VBN", "VBP", "VBZ", "VBG"], `value`:"matter"});
CREATE (:`Tag`:`NER_O` {`id`:"seek_en", `language`:"en", `lastTxId`:"1524366521231", `lowercasedId`:"seek_en", `ne`:["O"], `pos`:["VBG", "VB", "VBD", "VBN", "VBZ", "VBP"], `value`:"seek"});
CREATE (:`Tag`:`NER_O` {`id`:"resolution_en", `language`:"en", `lastTxId`:"1524366421411", `lowercasedId`:"resolution_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"resolution"});
CREATE (:`Tag`:`NER_O` {`id`:"proceedings_en", `language`:"en", `lastTxId`:"1524365982853", `lowercasedId`:"proceedings_en", `ne`:["O"], `pos`:["NNS", "NNP"], `value`:"proceedings"});
CREATE (:`Tag`:`NER_O` {`id`:"potential_en", `language`:"en", `lastTxId`:"1524366586637", `lowercasedId`:"potential_en", `ne`:["O"], `pos`:["JJ", "NN"], `value`:"potential"});
CREATE (:`Tag`:`NER_O` {`id`:"successfully_en", `language`:"en", `lastTxId`:"1524366561092", `lowercasedId`:"successfully_en", `ne`:["O"], `pos`:["RB"], `value`:"successfully"});
CREATE (:`Tag`:`NER_O` {`id`:"court_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"court_en", `ne`:["O"], `pos`:["NN", "NNS", "VBD", "VB", "VBG", "NNP", "VBN", "VBZ"], `value`:"court"});
CREATE (:`Tag`:`NER_O` {`id`:"inauguration_en", `language`:"en", `lastTxId`:"1524366377633", `lowercasedId`:"inauguration_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"inauguration"});
CREATE (:`Tag`:`NER_O` {`id`:"halt_en", `language`:"en", `lastTxId`:"1524366491011", `lowercasedId`:"halt_en", `ne`:["O"], `pos`:["NN", "VBD", "VBG", "VB", "VBN", "NNS", "NNP", "VBP", "VBZ"], `value`:"halt"});
CREATE (:`Tag`:`NER_Number`:`NER_Date` {`id`:"2017_en", `language`:"en", `lastTxId`:"1524366539686", `lowercasedId`:"2017_en", `ne`:["DATE", "NUMBER"], `pos`:[], `value`:"2017"});
CREATE (:`Tag`:`NER_O`:`NER_Date` {`id`:"currently_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"currently_en", `ne`:["DATE", "O"], `pos`:["RB"], `value`:"currently"});
CREATE (:`Tag`:`NER_O` {`id`:"effect_en", `language`:"en", `lastTxId`:"1524366592878", `lowercasedId`:"effect_en", `ne`:["O"], `pos`:["NN", "NNS", "VB", "VBG", "VBD", "VBN", "NNP"], `value`:"effect"});
CREATE (:`Tag`:`NER_Number`:`NER_Percent`:`NER_Money`:`NER_O`:`NER_Date` {`id`:"20_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"20_en", `ne`:["DATE", "NUMBER", "MONEY", "O", "PERCENT"], `pos`:["NNS"], `value`:"20"});
CREATE (:`Tag`:`NER_O` {`id`:"discuss_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"discuss_en", `ne`:["O"], `pos`:["VBG", "VBN", "VB", "VBP", "VBD", "VBZ"], `value`:"discuss"});
CREATE (:`Tag`:`NER_O` {`id`:"option_en", `language`:"en", `lastTxId`:"1524366444517", `lowercasedId`:"option_en", `ne`:["O"], `pos`:["NNS", "NN", "VBN", "VBD", "VBG"], `value`:"option"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2570, `ne`:["O"], `pos`:["VBG"], `startPosition`:2560, `value`:"discussing", `UNIQUE IMPORT ID`:50432});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2634, `ne`:["O"], `pos`:["NN"], `startPosition`:2628, `value`:"effect", `UNIQUE IMPORT ID`:50433});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2506, `ne`:["O"], `pos`:["NN"], `startPosition`:2501, `value`:"court", `UNIQUE IMPORT ID`:50434});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2447, `ne`:["O"], `pos`:["IN"], `startPosition`:2442, `value`:"after", `UNIQUE IMPORT ID`:50435});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2580, `ne`:["O"], `pos`:["JJ"], `startPosition`:2571, `value`:"potential", `UNIQUE IMPORT ID`:50436});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2640, `ne`:["O"], `pos`:["IN"], `startPosition`:2635, `value`:"after", `UNIQUE IMPORT ID`:50437});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2397, `ne`:["O"], `pos`:["RB"], `startPosition`:2385, `value`:"successfully", `UNIQUE IMPORT ID`:50438});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2457, `ne`:["PERSON"], `pos`:[], `startPosition`:2452, `value`:"Trump", `UNIQUE IMPORT ID`:50439});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2588, `ne`:["O"], `pos`:["NNS"], `startPosition`:2581, `value`:"options", `UNIQUE IMPORT ID`:50440});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2661, `ne`:["O"], `pos`:["NN"], `startPosition`:2649, `value`:"inauguration", `UNIQUE IMPORT ID`:50441});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2461, `ne`:["O"], `pos`:["VBD"], `startPosition`:2458, `value`:"won", `UNIQUE IMPORT ID`:50442});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2405, `ne`:["O"], `pos`:["VBG"], `startPosition`:2398, `value`:"seeking", `UNIQUE IMPORT ID`:50443});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2468, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:2463, `value`:"House", `UNIQUE IMPORT ID`:50444});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2603, `ne`:["O"], `pos`:["NN"], `startPosition`:2593, `value`:"resolution", `UNIQUE IMPORT ID`:50445});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2540, `ne`:["O"], `pos`:["NN"], `startPosition`:2530, `value`:"transition", `UNIQUE IMPORT ID`:50446});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2480, `ne`:["MISC"], `pos`:[], `startPosition`:2469, `value`:"Republicans", `UNIQUE IMPORT ID`:50447});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2417, `ne`:["O"], `pos`:["JJ"], `startPosition`:2408, `value`:"temporary", `UNIQUE IMPORT ID`:50448});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2545, `ne`:["O"], `pos`:["NN"], `startPosition`:2541, `value`:"team", `UNIQUE IMPORT ID`:50449});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2672, `ne`:["DATE"], `pos`:[], `startPosition`:2670, `value`:" 20", `UNIQUE IMPORT ID`:50450});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2491, `ne`:["DATE"], `pos`:[], `startPosition`:2481, `value`:"last month", `UNIQUE IMPORT ID`:50451});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2422, `ne`:["O"], `pos`:["NN"], `startPosition`:2418, `value`:"halt", `UNIQUE IMPORT ID`:50452});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2555, `ne`:["DATE"], `pos`:[], `startPosition`:2546, `value`:"currently", `UNIQUE IMPORT ID`:50453});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2678, `ne`:["DATE"], `pos`:[], `startPosition`:2674, `value`:" 2017", `UNIQUE IMPORT ID`:50454});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2618, `ne`:["O"], `pos`:["NN"], `startPosition`:2612, `value`:"matter", `UNIQUE IMPORT ID`:50455});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:2496, `ne`:["O"], `pos`:["VBD"], `startPosition`:2492, `value`:"told", `UNIQUE IMPORT ID`:50456});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2441, `ne`:["O"], `pos`:["NNS"], `startPosition`:2430, `value`:"proceedings", `UNIQUE IMPORT ID`:50457});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2627, `ne`:["O"], `pos`:["VB"], `startPosition`:2623, `value`:"take", `UNIQUE IMPORT ID`:50458});
CREATE (:`Sentence` {`hash`:"b50ad821fbd59b59de618c0f25460439", `id`:"0_13", `sentenceNumber`:13, `text`:"The suspension of the case, House lawyers said, will “provide the   and his future administration time to consider whether to continue prosecuting or to otherwise resolve this appeal. ”"});
CREATE (:`Tag`:`NER_O` {`id`:"otherwise_en", `language`:"en", `lastTxId`:"1524366398565", `lowercasedId`:"otherwise_en", `ne`:["O"], `pos`:["RB"], `value`:"otherwise"});
CREATE (:`Tag`:`NER_O` {`id`:"resolve_en", `language`:"en", `lastTxId`:"1524366415850", `lowercasedId`:"resolve_en", `ne`:["O"], `pos`:["VB", "NN", "VBD", "VBN", "VBG", "VBP", "VBZ", "NNP"], `value`:"resolve"});
CREATE (:`Tag`:`NER_O` {`id`:"prosecute_en", `language`:"en", `lastTxId`:"1524366444517", `lowercasedId`:"prosecute_en", `ne`:["O"], `pos`:["VBG", "VB", "VBD", "VBN", "VBP"], `value`:"prosecute"});
CREATE (:`Tag`:`NER_O` {`id`:"provide_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"provide_en", `ne`:["O"], `pos`:["VB", "VBG", "VBP", "VBZ", "VBN", "VBD"], `value`:"provide"});
CREATE (:`Tag`:`NER_O`:`NER_Date` {`id`:"future_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"future_en", `ne`:["DATE", "O"], `pos`:["NNS", "JJ"], `value`:"future"});
CREATE (:`Tag`:`NER_O` {`id`:"whether_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"whether_en", `ne`:["O"], `pos`:["IN", "CC", "NNP"], `value`:"whether"});
CREATE (:`Tag`:`NER_O` {`id`:"continue_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"continue_en", `ne`:["O"], `pos`:["VB", "VBD", "VBP", "VBZ", "VBN", "VBG", "NNP"], `value`:"continue"});
CREATE (:`Tag`:`NER_O`:`NER_Date` {`id`:"time_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"time_en", `ne`:["O", "DATE"], `pos`:["NN", "NNS", "NNP", "VBN", "VBG", "VBD", "VB", "VBZ"], `value`:"time"});
CREATE (:`Tag`:`NER_O` {`id`:"consider_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"consider_en", `ne`:["O"], `pos`:["VB", "VBN", "VBG", "VBZ", "VBD", "VBP", "NNP"], `value`:"consider"});
CREATE (:`Tag`:`NER_O`:`NER_Person` {`id`:"he_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"he_en", `ne`:["O", "PERSON"], `pos`:["PRP$", "PRP", "NNS"], `value`:"he"});
CREATE (:`Tag`:`NER_O` {`id`:"suspension_en", `language`:"en", `lastTxId`:"1524366108536", `lowercasedId`:"suspension_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"suspension"});
CREATE (:`Tag`:`NER_O` {`id`:"lawyer_en", `language`:"en", `lastTxId`:"1524366514217", `lowercasedId`:"lawyer_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP", "VBD"], `value`:"lawyer"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2828, `ne`:["O"], `pos`:["VBG"], `startPosition`:2817, `value`:"prosecuting", `UNIQUE IMPORT ID`:50472});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2757, `ne`:["O"], `pos`:["PRP$"], `startPosition`:2754, `value`:"his", `UNIQUE IMPORT ID`:50473});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2728, `ne`:["O"], `pos`:["VBD"], `startPosition`:2724, `value`:"said", `UNIQUE IMPORT ID`:50474});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2796, `ne`:["O"], `pos`:["VB"], `startPosition`:2788, `value`:"consider", `UNIQUE IMPORT ID`:50475});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2764, `ne`:["DATE"], `pos`:[], `startPosition`:2758, `value`:"future", `UNIQUE IMPORT ID`:50476});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2864, `ne`:["O"], `pos`:["NN"], `startPosition`:2858, `value`:"appeal", `UNIQUE IMPORT ID`:50477});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2779, `ne`:["O"], `pos`:["NN"], `startPosition`:2765, `value`:"administration", `UNIQUE IMPORT ID`:50478});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2804, `ne`:["O"], `pos`:["IN"], `startPosition`:2797, `value`:"whether", `UNIQUE IMPORT ID`:50479});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2708, `ne`:["O"], `pos`:["NN"], `startPosition`:2704, `value`:"case", `UNIQUE IMPORT ID`:50480});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:2743, `ne`:["O"], `pos`:["VB"], `startPosition`:2736, `value`:"provide", `UNIQUE IMPORT ID`:50481});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2844, `ne`:["O"], `pos`:["RB"], `startPosition`:2835, `value`:"otherwise", `UNIQUE IMPORT ID`:50482});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2715, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:2710, `value`:"House", `UNIQUE IMPORT ID`:50483});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2816, `ne`:["O"], `pos`:["VB"], `startPosition`:2808, `value`:"continue", `UNIQUE IMPORT ID`:50484});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2723, `ne`:["O"], `pos`:["NNS"], `startPosition`:2716, `value`:"lawyers", `UNIQUE IMPORT ID`:50485});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2784, `ne`:["O"], `pos`:["NN"], `startPosition`:2780, `value`:"time", `UNIQUE IMPORT ID`:50486});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2852, `ne`:["O"], `pos`:["VB"], `startPosition`:2845, `value`:"resolve", `UNIQUE IMPORT ID`:50487});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2696, `ne`:["O"], `pos`:["NN"], `startPosition`:2686, `value`:"suspension", `UNIQUE IMPORT ID`:50488});
CREATE (:`Sentence` {`hash`:"939d3666214d49153ac9c9d51fb01c76", `id`:"0_14", `sentenceNumber`:14, `text`:"Republican leadership officials in the House acknowledge the possibility of “cascading effects” if the   payments, which have totaled an estimated $13 billion, are suddenly stopped."});
CREATE (:`Tag`:`NER_O` {`id`:"cascade_en", `language`:"en", `lastTxId`:"1524365670222", `lowercasedId`:"cascade_en", `ne`:["O"], `pos`:["VBG", "NN", "VBD", "VBN", "NNS"], `value`:"cascade"});
CREATE (:`Tag`:`NER_O` {`id`:"official_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"official_en", `ne`:["O"], `pos`:["NNS", "NN", "JJ", "NNP"], `value`:"official"});
CREATE (:`Tag`:`NER_Money` {`id`:"13 billion_en", `language`:"en", `lastTxId`:"1524365872117", `lowercasedId`:"13 billion_en", `ne`:["MONEY"], `pos`:[], `value`:"13 billion"});
CREATE (:`Tag`:`NER_O` {`id`:"suddenly_en", `language`:"en", `lastTxId`:"1524366474538", `lowercasedId`:"suddenly_en", `ne`:["O"], `pos`:["RB"], `value`:"suddenly"});
CREATE (:`Tag`:`NER_O` {`id`:"total_en", `language`:"en", `lastTxId`:"1524366595488", `lowercasedId`:"total_en", `ne`:["O"], `pos`:["VBN", "NN", "JJ", "NNS", "VBG", "VBZ", "VBD", "VBP", "NNP", "VB"], `value`:"total"});
CREATE (:`Tag`:`NER_O` {`id`:"acknowledge_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"acknowledge_en", `ne`:["O"], `pos`:["VBP", "VBD", "VBN", "VBG", "VB", "VBZ", "NN"], `value`:"acknowledge"});
CREATE (:`Tag`:`NER_O` {`id`:"stop_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"stop_en", `ne`:["O"], `pos`:["VBN", "NNS", "VBZ", "VB", "VBD", "NN", "VBG", "VBP", "NNP"], `value`:"stop"});
CREATE (:`Tag`:`NER_O` {`id`:"leadership_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"leadership_en", `ne`:["O"], `pos`:["NN", "NNP", "NNS"], `value`:"leadership"});
CREATE (:`Tag`:`NER_O` {`id`:"estimate_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"estimate_en", `ne`:["O"], `pos`:["VBN", "NN", "VBZ", "VBD", "NNS", "VB", "VBG", "VBP", "NNP"], `value`:"estimate"});
CREATE (:`Tag`:`NER_O` {`id`:"payment_en", `language`:"en", `lastTxId`:"1524366491011", `lowercasedId`:"payment_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"payment"});
CREATE (:`Tag`:`NER_O` {`id`:"possibility_en", `language`:"en", `lastTxId`:"1524366567180", `lowercasedId`:"possibility_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"possibility"});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:2924, `ne`:["O"], `pos`:["VBP"], `startPosition`:2913, `value`:"acknowledge", `UNIQUE IMPORT ID`:50501});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2954, `ne`:["O"], `pos`:["VBG"], `startPosition`:2945, `value`:"cascading", `UNIQUE IMPORT ID`:50502});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3048, `ne`:["O"], `pos`:["VBN"], `startPosition`:3041, `value`:"stopped", `UNIQUE IMPORT ID`:50503});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2988, `ne`:["O"], `pos`:["WDT"], `startPosition`:2983, `value`:"which", `UNIQUE IMPORT ID`:50504});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3026, `ne`:["MONEY"], `pos`:[], `startPosition`:3016, `value`:"13 billion", `UNIQUE IMPORT ID`:50505});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2899, `ne`:["O"], `pos`:["NNS"], `startPosition`:2890, `value`:"officials", `UNIQUE IMPORT ID`:50506});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2962, `ne`:["O"], `pos`:["NNS"], `startPosition`:2955, `value`:"effects", `UNIQUE IMPORT ID`:50507});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2993, `ne`:["O"], `pos`:["VBP"], `startPosition`:2989, `value`:"have", `UNIQUE IMPORT ID`:50508});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2940, `ne`:["O"], `pos`:["NN"], `startPosition`:2929, `value`:"possibility", `UNIQUE IMPORT ID`:50509});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3001, `ne`:["O"], `pos`:["VBN"], `startPosition`:2994, `value`:"totaled", `UNIQUE IMPORT ID`:50510});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2878, `ne`:["MISC"], `pos`:[], `startPosition`:2868, `value`:"Republican", `UNIQUE IMPORT ID`:50511});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3040, `ne`:["O"], `pos`:["RB"], `startPosition`:3032, `value`:"suddenly", `UNIQUE IMPORT ID`:50512});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2912, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:2907, `value`:"House", `UNIQUE IMPORT ID`:50513});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2981, `ne`:["O"], `pos`:["NNS"], `startPosition`:2973, `value`:"payments", `UNIQUE IMPORT ID`:50514});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3014, `ne`:["O"], `pos`:["VBN"], `startPosition`:3005, `value`:"estimated", `UNIQUE IMPORT ID`:50515});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:2889, `ne`:["O"], `pos`:["NN"], `startPosition`:2879, `value`:"leadership", `UNIQUE IMPORT ID`:50516});
CREATE (:`Sentence` {`hash`:"6b0791f8c6abb1cb64b3ad754761adf2", `id`:"0_15", `sentenceNumber`:15, `text`:"Insurers that receive the subsidies in exchange for paying    costs such as deductibles and   for eligible consumers could race to drop coverage since they would be losing money."});
CREATE (:`Tag`:`NER_O` {`id`:"drop_en", `language`:"en", `lastTxId`:"1524366595488", `lowercasedId`:"drop_en", `ne`:["O"], `pos`:["VB", "VBN", "NN", "VBD", "VBG", "VBZ", "VBP", "NNS", "NNP"], `value`:"drop"});
CREATE (:`Tag`:`NER_O` {`id`:"coverage_en", `language`:"en", `lastTxId`:"1524366444517", `lowercasedId`:"coverage_en", `ne`:["O"], `pos`:["NN", "NNP", "NNS"], `value`:"coverage"});
CREATE (:`Tag`:`NER_O` {`id`:"receive_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"receive_en", `ne`:["O"], `pos`:["VBP", "VBD", "VBN", "VBG", "VB", "VBZ"], `value`:"receive"});
CREATE (:`Tag`:`NER_O` {`id`:"cost_en", `language`:"en", `lastTxId`:"1524366589740", `lowercasedId`:"cost_en", `ne`:["O"], `pos`:["NNS", "VBD", "VBG", "VB", "NN", "VBN", "VBZ", "VBP"], `value`:"cost"});
CREATE (:`Tag`:`NER_O` {`id`:"race_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"race_en", `ne`:["O"], `pos`:["NN", "VBG", "NNS", "VBN", "VBD", "NNP"], `value`:"race"});
CREATE (:`Tag`:`NER_O` {`id`:"lose_en", `language`:"en", `lastTxId`:"1524366571058", `lowercasedId`:"lose_en", `ne`:["O"], `pos`:["VBG", "VBN", "VBD", "VBP", "VBZ", "VB", "NNP"], `value`:"lose"});
CREATE (:`Tag`:`NER_O` {`id`:"pay_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"pay_en", `ne`:["O"], `pos`:["VBG", "VB", "VBD", "VBN", "NN", "VBP", "VBZ"], `value`:"pay"});
CREATE (:`Tag`:`NER_O` {`id`:"money_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"money_en", `ne`:["O"], `pos`:["NN", "NNP", "NNS"], `value`:"money"});
CREATE (:`Tag`:`NER_O` {`id`:"insurer_en", `language`:"en", `lastTxId`:"1524365197327", `lowercasedId`:"insurer_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"insurer"});
CREATE (:`Tag`:`NER_O` {`id`:"eligible_en", `language`:"en", `lastTxId`:"1524366478493", `lowercasedId`:"eligible_en", `ne`:["O"], `pos`:["JJ", "NN"], `value`:"eligible"});
CREATE (:`Tag`:`NER_O` {`id`:"deductible_en", `language`:"en", `lastTxId`:"1524366121361", `lowercasedId`:"deductible_en", `ne`:["O"], `pos`:["NNS", "JJ"], `value`:"deductible"});
CREATE (:`Tag`:`NER_O` {`id`:"exchange_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"exchange_en", `ne`:["O"], `pos`:["NN", "VBD", "VBG", "VBN", "NNS", "VB", "VBP", "NNP"], `value`:"exchange"});
CREATE (:`Tag`:`NER_O` {`id`:"consumer_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"consumer_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP"], `value`:"consumer"});
CREATE (:`Tag`:`NER_O` {`id`:"since_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"since_en", `ne`:["O"], `pos`:["IN", "RB"], `value`:"since"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3085, `ne`:["O"], `pos`:["NNS"], `startPosition`:3076, `value`:"subsidies", `UNIQUE IMPORT ID`:50532});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:3177, `ne`:["O"], `pos`:["NN"], `startPosition`:3173, `value`:"race", `UNIQUE IMPORT ID`:50533});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3211, `ne`:["O"], `pos`:["MD"], `startPosition`:3206, `value`:"would", `UNIQUE IMPORT ID`:50534});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3117, `ne`:["O"], `pos`:["NNS"], `startPosition`:3112, `value`:"costs", `UNIQUE IMPORT ID`:50535});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3058, `ne`:["O"], `pos`:["NNS"], `startPosition`:3050, `value`:"Insurers", `UNIQUE IMPORT ID`:50536});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3156, `ne`:["O"], `pos`:["JJ"], `startPosition`:3148, `value`:"eligible", `UNIQUE IMPORT ID`:50537});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3185, `ne`:["O"], `pos`:["VB"], `startPosition`:3181, `value`:"drop", `UNIQUE IMPORT ID`:50538});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3221, `ne`:["O"], `pos`:["VBG"], `startPosition`:3215, `value`:"losing", `UNIQUE IMPORT ID`:50539});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3097, `ne`:["O"], `pos`:["NN"], `startPosition`:3089, `value`:"exchange", `UNIQUE IMPORT ID`:50540});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3194, `ne`:["O"], `pos`:["NN"], `startPosition`:3186, `value`:"coverage", `UNIQUE IMPORT ID`:50541});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3166, `ne`:["O"], `pos`:["NNS"], `startPosition`:3157, `value`:"consumers", `UNIQUE IMPORT ID`:50542});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3137, `ne`:["O"], `pos`:["NNS"], `startPosition`:3126, `value`:"deductibles", `UNIQUE IMPORT ID`:50543});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3227, `ne`:["O"], `pos`:["NN"], `startPosition`:3222, `value`:"money", `UNIQUE IMPORT ID`:50544});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3071, `ne`:["O"], `pos`:["VBP"], `startPosition`:3064, `value`:"receive", `UNIQUE IMPORT ID`:50545});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3200, `ne`:["O"], `pos`:["IN"], `startPosition`:3195, `value`:"since", `UNIQUE IMPORT ID`:50546});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3108, `ne`:["O"], `pos`:["VBG"], `startPosition`:3102, `value`:"paying", `UNIQUE IMPORT ID`:50547});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3172, `ne`:["O"], `pos`:["MD"], `startPosition`:3167, `value`:"could", `UNIQUE IMPORT ID`:50548});
CREATE (:`Sentence` {`hash`:"e02866fa061d491c44452ed5548cf55c", `id`:"0_16", `sentenceNumber`:16, `text`:"Over all, the loss of the subsidies could destabilize the entire program and cause a lack of confidence that leads other insurers to seek a quick exit as well."});
CREATE (:`Tag`:`NER_O` {`id`:"other_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"other_en", `ne`:["O"], `pos`:["JJ", "NNS", "NNP"], `value`:"other"});
CREATE (:`Tag`:`NER_O` {`id`:"quick_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"quick_en", `ne`:["O"], `pos`:["JJ", "NNP", "RB"], `value`:"quick"});
CREATE (:`Tag`:`NER_O` {`id`:"confidence_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"confidence_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"confidence"});
CREATE (:`Tag`:`NER_O` {`id`:"destabilize_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"destabilize_en", `ne`:["O"], `pos`:["VB", "VBN", "VBZ", "VBD"], `value`:"destabilize"});
CREATE (:`Tag`:`NER_O` {`id`:"entire_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"entire_en", `ne`:["O"], `pos`:["JJ", "NN", "NNP"], `value`:"entire"});
CREATE (:`Tag`:`NER_O` {`id`:"lack_en", `language`:"en", `lastTxId`:"1524366558235", `lowercasedId`:"lack_en", `ne`:["O"], `pos`:["NN", "VBP", "VBD", "VBZ", "VBN", "VB", "VBG"], `value`:"lack"});
CREATE (:`Tag`:`NER_O` {`id`:"exit_en", `language`:"en", `lastTxId`:"1524366499219", `lowercasedId`:"exit_en", `ne`:["O"], `pos`:["NN", "NNS", "VB", "VBG", "VBD", "VBP", "VBN", "NNP"], `value`:"exit"});
CREATE (:`Tag`:`NER_O` {`id`:"well_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"well_en", `ne`:["O"], `pos`:["RB", "NN", "NNS", "UH", "VBD", "NNP", "VBN", "VBG"], `value`:"well"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3270, `ne`:["O"], `pos`:["MD"], `startPosition`:3265, `value`:"could", `UNIQUE IMPORT ID`:50558});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3237, `ne`:["O"], `pos`:["DT"], `startPosition`:3234, `value`:"all", `UNIQUE IMPORT ID`:50559});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3366, `ne`:["O"], `pos`:["VB"], `startPosition`:3362, `value`:"seek", `UNIQUE IMPORT ID`:50560});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:3282, `ne`:["O"], `pos`:["VB"], `startPosition`:3271, `value`:"destabilize", `UNIQUE IMPORT ID`:50561});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3374, `ne`:["O"], `pos`:["JJ"], `startPosition`:3369, `value`:"quick", `UNIQUE IMPORT ID`:50562});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3311, `ne`:["O"], `pos`:["VB"], `startPosition`:3306, `value`:"cause", `UNIQUE IMPORT ID`:50563});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3343, `ne`:["O"], `pos`:["VBZ"], `startPosition`:3338, `value`:"leads", `UNIQUE IMPORT ID`:50564});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3247, `ne`:["O"], `pos`:["NN"], `startPosition`:3243, `value`:"loss", `UNIQUE IMPORT ID`:50565});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3379, `ne`:["O"], `pos`:["NN"], `startPosition`:3375, `value`:"exit", `UNIQUE IMPORT ID`:50566});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3349, `ne`:["O"], `pos`:["JJ"], `startPosition`:3344, `value`:"other", `UNIQUE IMPORT ID`:50567});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3318, `ne`:["O"], `pos`:["NN"], `startPosition`:3314, `value`:"lack", `UNIQUE IMPORT ID`:50568});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3358, `ne`:["O"], `pos`:["NNS"], `startPosition`:3350, `value`:"insurers", `UNIQUE IMPORT ID`:50569});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3264, `ne`:["O"], `pos`:["NNS"], `startPosition`:3255, `value`:"subsidies", `UNIQUE IMPORT ID`:50570});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3293, `ne`:["O"], `pos`:["JJ"], `startPosition`:3287, `value`:"entire", `UNIQUE IMPORT ID`:50571});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3387, `ne`:["O"], `pos`:["RB"], `startPosition`:3383, `value`:"well", `UNIQUE IMPORT ID`:50572});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3332, `ne`:["O"], `pos`:["NN"], `startPosition`:3322, `value`:"confidence", `UNIQUE IMPORT ID`:50573});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3233, `ne`:["O"], `pos`:["IN"], `startPosition`:3229, `value`:"Over", `UNIQUE IMPORT ID`:50574});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3301, `ne`:["O"], `pos`:["NN"], `startPosition`:3294, `value`:"program", `UNIQUE IMPORT ID`:50575});
CREATE (:`Sentence` {`hash`:"90687e1fb6c731f83a56281d06360f53", `id`:"0_17", `sentenceNumber`:17, `text`:"Anticipating that the Trump administration might not be inclined to mount a vigorous fight against the House Republicans given the  ’s dim view of the health care law, a team of lawyers this month sought to intervene in the case on behalf of two participants in the health care program."});
CREATE (:`Tag`:`NER_O` {`id`:"dim_en", `language`:"en", `lastTxId`:"1524365904269", `lowercasedId`:"dim_en", `ne`:["O"], `pos`:["JJ", "VBN", "NN", "VBD", "VBG", "VB", "VBP", "RB"], `value`:"dim"});
CREATE (:`Tag`:`NER_O` {`id`:"behalf_en", `language`:"en", `lastTxId`:"1524366509829", `lowercasedId`:"behalf_en", `ne`:["O"], `pos`:["NN"], `value`:"behalf"});
CREATE (:`Tag`:`NER_Number` {`id`:"two_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"two_en", `ne`:["NUMBER"], `pos`:[], `value`:"two"});
CREATE (:`Tag`:`NER_O` {`id`:"participant_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"participant_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"participant"});
CREATE (:`Tag`:`NER_O` {`id`:"view_en", `language`:"en", `lastTxId`:"1524366591844", `lowercasedId`:"view_en", `ne`:["O"], `pos`:["NN", "NNS", "VBD", "VBG", "VBN", "VB", "NNP", "VBP", "VBZ"], `value`:"view"});
CREATE (:`Tag`:`NER_Date` {`id`:"this month_en", `language`:"en", `lastTxId`:"1524366349463", `lowercasedId`:"this month_en", `ne`:["DATE"], `pos`:[], `value`:"this month"});
CREATE (:`Tag`:`NER_O` {`id`:"incline_en", `language`:"en", `lastTxId`:"1524366113296", `lowercasedId`:"incline_en", `ne`:["O"], `pos`:["VBN", "NNS", "VBG", "NN"], `value`:"incline"});
CREATE (:`Tag`:`NER_O` {`id`:"mount_en", `language`:"en", `lastTxId`:"1524366595488", `lowercasedId`:"mount_en", `ne`:["O"], `pos`:["VB", "VBG", "VBN", "VBD", "VBZ", "NNP", "JJ", "VBP"], `value`:"mount"});
CREATE (:`Tag`:`NER_O` {`id`:"anticipate_en", `language`:"en", `lastTxId`:"1524366586637", `lowercasedId`:"anticipate_en", `ne`:["O"], `pos`:["VBG", "VBN", "VBZ", "VBD", "VBP", "VB"], `value`:"anticipate"});
CREATE (:`Tag`:`NER_O` {`id`:"vigorous_en", `language`:"en", `lastTxId`:"1524366278446", `lowercasedId`:"vigorous_en", `ne`:["O"], `pos`:["JJ"], `value`:"vigorous"});
CREATE (:`Tag`:`NER_O` {`id`:"intervene_en", `language`:"en", `lastTxId`:"1524366344171", `lowercasedId`:"intervene_en", `ne`:["O"], `pos`:["VB", "VBG", "VBD", "VBN", "VBZ", "VBP"], `value`:"intervene"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3462, `ne`:["O"], `pos`:["VB"], `startPosition`:3457, `value`:"mount", `UNIQUE IMPORT ID`:50588});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:3592, `ne`:["O"], `pos`:["VBD"], `startPosition`:3586, `value`:"sought", `UNIQUE IMPORT ID`:50589});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3527, `ne`:["O"], `pos`:["JJ"], `startPosition`:3524, `value`:"dim", `UNIQUE IMPORT ID`:50590});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3661, `ne`:["O"], `pos`:["NN"], `startPosition`:3655, `value`:"health", `UNIQUE IMPORT ID`:50591});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3532, `ne`:["O"], `pos`:["NN"], `startPosition`:3528, `value`:"view", `UNIQUE IMPORT ID`:50592});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3473, `ne`:["O"], `pos`:["JJ"], `startPosition`:3465, `value`:"vigorous", `UNIQUE IMPORT ID`:50593});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3605, `ne`:["O"], `pos`:["VB"], `startPosition`:3596, `value`:"intervene", `UNIQUE IMPORT ID`:50594});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3666, `ne`:["O"], `pos`:["NN"], `startPosition`:3662, `value`:"care", `UNIQUE IMPORT ID`:50595});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3479, `ne`:["O"], `pos`:["NN"], `startPosition`:3474, `value`:"fight", `UNIQUE IMPORT ID`:50596});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3416, `ne`:["PERSON"], `pos`:[], `startPosition`:3411, `value`:"Trump", `UNIQUE IMPORT ID`:50597});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3674, `ne`:["O"], `pos`:["NN"], `startPosition`:3667, `value`:"program", `UNIQUE IMPORT ID`:50598});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3546, `ne`:["O"], `pos`:["NN"], `startPosition`:3540, `value`:"health", `UNIQUE IMPORT ID`:50599});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3487, `ne`:["O"], `pos`:["IN"], `startPosition`:3480, `value`:"against", `UNIQUE IMPORT ID`:50600});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3431, `ne`:["O"], `pos`:["NN"], `startPosition`:3417, `value`:"administration", `UNIQUE IMPORT ID`:50601});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3551, `ne`:["O"], `pos`:["NN"], `startPosition`:3547, `value`:"care", `UNIQUE IMPORT ID`:50602});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3617, `ne`:["O"], `pos`:["NN"], `startPosition`:3613, `value`:"case", `UNIQUE IMPORT ID`:50603});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3555, `ne`:["O"], `pos`:["NN"], `startPosition`:3552, `value`:"law", `UNIQUE IMPORT ID`:50604});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3497, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:3492, `value`:"House", `UNIQUE IMPORT ID`:50605});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3627, `ne`:["O"], `pos`:["NN"], `startPosition`:3621, `value`:"behalf", `UNIQUE IMPORT ID`:50606});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3563, `ne`:["O"], `pos`:["NN"], `startPosition`:3559, `value`:"team", `UNIQUE IMPORT ID`:50607});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3437, `ne`:["O"], `pos`:["MD"], `startPosition`:3432, `value`:"might", `UNIQUE IMPORT ID`:50608});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3509, `ne`:["MISC"], `pos`:[], `startPosition`:3498, `value`:"Republicans", `UNIQUE IMPORT ID`:50609});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3574, `ne`:["O"], `pos`:["NNS"], `startPosition`:3567, `value`:"lawyers", `UNIQUE IMPORT ID`:50610});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3634, `ne`:["NUMBER"], `pos`:[], `startPosition`:3631, `value`:"two", `UNIQUE IMPORT ID`:50611});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3647, `ne`:["O"], `pos`:["NNS"], `startPosition`:3635, `value`:"participants", `UNIQUE IMPORT ID`:50612});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3453, `ne`:["O"], `pos`:["VBN"], `startPosition`:3445, `value`:"inclined", `UNIQUE IMPORT ID`:50613});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3515, `ne`:["O"], `pos`:["VBN"], `startPosition`:3510, `value`:"given", `UNIQUE IMPORT ID`:50614});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3585, `ne`:["DATE"], `pos`:[], `startPosition`:3575, `value`:"this month", `UNIQUE IMPORT ID`:50615});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3401, `ne`:["O"], `pos`:["VBG"], `startPosition`:3389, `value`:"Anticipating", `UNIQUE IMPORT ID`:50616});
CREATE (:`Sentence` {`hash`:"358c5de76fcc14a779cf2203343e5715", `id`:"0_18", `sentenceNumber`:18, `text`:"In their request, the lawyers predicted that a deal between House Republicans and the new administration to dismiss or settle the case “will produce devastating consequences for the individuals who receive these reductions, as well as for the nation’s health insurance and health care systems generally. ”"});
CREATE (:`Tag`:`NER_O` {`id`:"request_en", `language`:"en", `lastTxId`:"1524366594848", `lowercasedId`:"request_en", `ne`:["O"], `pos`:["NN", "NNS", "VBN", "VBD", "VBG", "VBP", "VB", "NNP"], `value`:"request"});
CREATE (:`Tag`:`NER_O` {`id`:"deal_en", `language`:"en", `lastTxId`:"1524366586637", `lowercasedId`:"deal_en", `ne`:["O"], `pos`:["NN", "VBG", "VB", "NNS", "VBD", "VBZ", "VBN", "NNP", "VBP"], `value`:"deal"});
CREATE (:`Tag`:`NER_O` {`id`:"nation_en", `language`:"en", `lastTxId`:"1524366573302", `lowercasedId`:"nation_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"nation"});
CREATE (:`Tag`:`NER_O` {`id`:"settle_en", `language`:"en", `lastTxId`:"1524366436170", `lowercasedId`:"settle_en", `ne`:["O"], `pos`:["VB", "VBD", "VBN", "VBZ", "VBG", "VBP"], `value`:"settle"});
CREATE (:`Tag`:`NER_O` {`id`:"predict_en", `language`:"en", `lastTxId`:"1524366589740", `lowercasedId`:"predict_en", `ne`:["O"], `pos`:["VBD", "VBN", "VB", "VBG", "VBP", "VBZ"], `value`:"predict"});
CREATE (:`Tag`:`NER_O` {`id`:"between_en", `language`:"en", `lastTxId`:"1524366597560", `lowercasedId`:"between_en", `ne`:["O"], `pos`:["IN", "NNP"], `value`:"between"});
CREATE (:`Tag`:`NER_O` {`id`:"consequence_en", `language`:"en", `lastTxId`:"1524366579686", `lowercasedId`:"consequence_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"consequence"});
CREATE (:`Tag`:`NER_O` {`id`:"individual_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"individual_en", `ne`:["O"], `pos`:["NNS", "JJ", "NN", "NNP"], `value`:"individual"});
CREATE (:`Tag`:`NER_O` {`id`:"dismiss_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"dismiss_en", `ne`:["O"], `pos`:["VB", "VBD", "VBN", "VBP", "VBG", "VBZ"], `value`:"dismiss"});
CREATE (:`Tag`:`NER_O` {`id`:"produce_en", `language`:"en", `lastTxId`:"1524366597560", `lowercasedId`:"produce_en", `ne`:["O"], `pos`:["VB", "VBN", "VBD", "VBZ", "NN", "VBG", "VBP"], `value`:"produce"});
CREATE (:`Tag`:`NER_O` {`id`:"generally_en", `language`:"en", `lastTxId`:"1524366444517", `lowercasedId`:"generally_en", `ne`:["O"], `pos`:["RB"], `value`:"generally"});
CREATE (:`Tag`:`NER_O` {`id`:"system_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"system_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP"], `value`:"system"});
CREATE (:`Tag`:`NER_O` {`id`:"devastating_en", `language`:"en", `lastTxId`:"1524366429538", `lowercasedId`:"devastating_en", `ne`:["O"], `pos`:["JJ"], `value`:"devastating"});
CREATE (:`Tag`:`NER_O` {`id`:"reduction_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"reduction_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP"], `value`:"reduction"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3978, `ne`:["O"], `pos`:["RB"], `startPosition`:3969, `value`:"generally", `UNIQUE IMPORT ID`:50632});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3791, `ne`:["O"], `pos`:["VB"], `startPosition`:3784, `value`:"dismiss", `UNIQUE IMPORT ID`:50633});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3727, `ne`:["O"], `pos`:["NN"], `startPosition`:3723, `value`:"deal", `UNIQUE IMPORT ID`:50634});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3925, `ne`:["O"], `pos`:["NN"], `startPosition`:3919, `value`:"nation", `UNIQUE IMPORT ID`:50635});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3735, `ne`:["O"], `pos`:["IN"], `startPosition`:3728, `value`:"between", `UNIQUE IMPORT ID`:50636});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3869, `ne`:["O"], `pos`:["NNS"], `startPosition`:3858, `value`:"individuals", `UNIQUE IMPORT ID`:50637});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3801, `ne`:["O"], `pos`:["VB"], `startPosition`:3795, `value`:"settle", `UNIQUE IMPORT ID`:50638});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3741, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:3736, `value`:"House", `UNIQUE IMPORT ID`:50639});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3934, `ne`:["O"], `pos`:["NN"], `startPosition`:3928, `value`:"health", `UNIQUE IMPORT ID`:50640});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3753, `ne`:["MISC"], `pos`:[], `startPosition`:3742, `value`:"Republicans", `UNIQUE IMPORT ID`:50641});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3810, `ne`:["O"], `pos`:["NN"], `startPosition`:3806, `value`:"case", `UNIQUE IMPORT ID`:50642});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3873, `ne`:["O"], `pos`:["WP"], `startPosition`:3870, `value`:"who", `UNIQUE IMPORT ID`:50643});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3944, `ne`:["O"], `pos`:["NN"], `startPosition`:3935, `value`:"insurance", `UNIQUE IMPORT ID`:50644});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3881, `ne`:["O"], `pos`:["VBP"], `startPosition`:3874, `value`:"receive", `UNIQUE IMPORT ID`:50645});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3692, `ne`:["O"], `pos`:["NN"], `startPosition`:3685, `value`:"request", `UNIQUE IMPORT ID`:50646});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3824, `ne`:["O"], `pos`:["VB"], `startPosition`:3817, `value`:"produce", `UNIQUE IMPORT ID`:50647});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3955, `ne`:["O"], `pos`:["NN"], `startPosition`:3949, `value`:"health", `UNIQUE IMPORT ID`:50648});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3898, `ne`:["O"], `pos`:["NNS"], `startPosition`:3888, `value`:"reductions", `UNIQUE IMPORT ID`:50649});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3836, `ne`:["O"], `pos`:["JJ"], `startPosition`:3825, `value`:"devastating", `UNIQUE IMPORT ID`:50650});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3705, `ne`:["O"], `pos`:["NNS"], `startPosition`:3698, `value`:"lawyers", `UNIQUE IMPORT ID`:50651});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3765, `ne`:["O"], `pos`:["JJ"], `startPosition`:3762, `value`:"new", `UNIQUE IMPORT ID`:50652});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3960, `ne`:["O"], `pos`:["NN"], `startPosition`:3956, `value`:"care", `UNIQUE IMPORT ID`:50653});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3780, `ne`:["O"], `pos`:["NN"], `startPosition`:3766, `value`:"administration", `UNIQUE IMPORT ID`:50654});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3968, `ne`:["O"], `pos`:["NNS"], `startPosition`:3961, `value`:"systems", `UNIQUE IMPORT ID`:50655});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:3715, `ne`:["O"], `pos`:["VBD"], `startPosition`:3706, `value`:"predicted", `UNIQUE IMPORT ID`:50656});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3849, `ne`:["O"], `pos`:["NNS"], `startPosition`:3837, `value`:"consequences", `UNIQUE IMPORT ID`:50657});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3907, `ne`:["O"], `pos`:["RB"], `startPosition`:3903, `value`:"well", `UNIQUE IMPORT ID`:50658});
CREATE (:`Sentence` {`hash`:"07dc8667dfd628f4f44996edd2ee1110", `id`:"0_19", `sentenceNumber`:19, `text`:"No matter what happens, House Republicans say, they want to prevail on two overarching concepts: the congressional power of the purse, and the right of Congress to sue the executive branch if it violates the Constitution regarding that spending power."});
CREATE (:`Tag`:`NER_O` {`id`:"happen_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"happen_en", `ne`:["O"], `pos`:["VBZ", "VBG", "VBN", "VBD", "VB", "VBP", "NNP"], `value`:"happen"});
CREATE (:`Tag`:`NER_O` {`id`:"want_en", `language`:"en", `lastTxId`:"1524366598829", `lowercasedId`:"want_en", `ne`:["O"], `pos`:["VBP", "VBD", "VB", "VBZ", "NN", "VBN", "VBG", "NNP", "JJ", "NNS"], `value`:"want"});
CREATE (:`Tag`:`NER_O` {`id`:"concept_en", `language`:"en", `lastTxId`:"1524366495785", `lowercasedId`:"concept_en", `ne`:["O"], `pos`:["NNS", "NN", "NNP"], `value`:"concept"});
CREATE (:`Tag`:`NER_O` {`id`:"overarching_en", `language`:"en", `lastTxId`:"1524364503226", `lowercasedId`:"overarching_en", `ne`:["O"], `pos`:["JJ"], `value`:"overarching"});
CREATE (:`Tag`:`NER_O` {`id`:"right_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"right_en", `ne`:["O"], `pos`:["NN", "JJ", "RB", "VBG", "NNP", "VBD", "VBN"], `value`:"right"});
CREATE (:`Tag`:`NER_O` {`id`:"what_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"what_en", `ne`:["O"], `pos`:["WDT", "WP", "NNS"], `value`:"what"});
CREATE (:`Tag`:`NER_O` {`id`:"regard_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"regard_en", `ne`:["O"], `pos`:["VBG", "VBN", "VBD", "VBP", "NN", "VBZ", "VB"], `value`:"regard"});
CREATE (:`Tag`:`NER_O` {`id`:"violate_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"violate_en", `ne`:["O"], `pos`:["VBZ", "VBG", "VBN", "VBP", "VB", "VBD"], `value`:"violate"});
CREATE (:`Tag`:`NER_O` {`id`:"prevail_en", `language`:"en", `lastTxId`:"1524366415850", `lowercasedId`:"prevail_en", `ne`:["O"], `pos`:["VB", "VBZ", "VBD", "VBG", "VBP", "VBN"], `value`:"prevail"});
CREATE (:`Tag`:`NER_O` {`id`:"power_en", `language`:"en", `lastTxId`:"1524366589740", `lowercasedId`:"power_en", `ne`:["O"], `pos`:["NN", "NNS", "VBN", "NNP", "VBD", "VBG", "FW"], `value`:"power"});
CREATE (:`Tag`:`NER_O` {`id`:"purse_en", `language`:"en", `lastTxId`:"1524366165425", `lowercasedId`:"purse_en", `ne`:["O"], `pos`:["NN", "VBD", "NNS", "VBG", "VBN"], `value`:"purse"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4102, `ne`:["O"], `pos`:["NN"], `startPosition`:4097, `value`:"power", `UNIQUE IMPORT ID`:50671});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:4038, `ne`:["O"], `pos`:["VBP"], `startPosition`:4034, `value`:"want", `UNIQUE IMPORT ID`:50672});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4232, `ne`:["O"], `pos`:["NN"], `startPosition`:4227, `value`:"power", `UNIQUE IMPORT ID`:50673});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4170, `ne`:["O"], `pos`:["NN"], `startPosition`:4164, `value`:"branch", `UNIQUE IMPORT ID`:50674});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4077, `ne`:["O"], `pos`:["NNS"], `startPosition`:4069, `value`:"concepts", `UNIQUE IMPORT ID`:50675});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4011, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4006, `value`:"House", `UNIQUE IMPORT ID`:50676});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4142, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4134, `value`:"Congress", `UNIQUE IMPORT ID`:50677});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4049, `ne`:["O"], `pos`:["VB"], `startPosition`:4042, `value`:"prevail", `UNIQUE IMPORT ID`:50678});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4212, `ne`:["O"], `pos`:["VBG"], `startPosition`:4203, `value`:"regarding", `UNIQUE IMPORT ID`:50679});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4023, `ne`:["MISC"], `pos`:[], `startPosition`:4012, `value`:"Republicans", `UNIQUE IMPORT ID`:50680});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4115, `ne`:["O"], `pos`:["NN"], `startPosition`:4110, `value`:"purse", `UNIQUE IMPORT ID`:50681});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3991, `ne`:["O"], `pos`:["NN"], `startPosition`:3985, `value`:"matter", `UNIQUE IMPORT ID`:50682});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4185, `ne`:["O"], `pos`:["VBZ"], `startPosition`:4177, `value`:"violates", `UNIQUE IMPORT ID`:50683});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4149, `ne`:["O"], `pos`:["VB"], `startPosition`:4146, `value`:"sue", `UNIQUE IMPORT ID`:50684});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4096, `ne`:["O"], `pos`:["JJ"], `startPosition`:4083, `value`:"congressional", `UNIQUE IMPORT ID`:50685});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4056, `ne`:["NUMBER"], `pos`:[], `startPosition`:4053, `value`:"two", `UNIQUE IMPORT ID`:50686});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:3996, `ne`:["O"], `pos`:["WDT"], `startPosition`:3992, `value`:"what", `UNIQUE IMPORT ID`:50687});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4027, `ne`:["O"], `pos`:["VBP"], `startPosition`:4024, `value`:"say", `UNIQUE IMPORT ID`:50688});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4068, `ne`:["O"], `pos`:["JJ"], `startPosition`:4057, `value`:"overarching", `UNIQUE IMPORT ID`:50689});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4163, `ne`:["O"], `pos`:["JJ"], `startPosition`:4154, `value`:"executive", `UNIQUE IMPORT ID`:50690});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4226, `ne`:["O"], `pos`:["VBG"], `startPosition`:4218, `value`:"spending", `UNIQUE IMPORT ID`:50691});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4004, `ne`:["O"], `pos`:["VBZ"], `startPosition`:3997, `value`:"happens", `UNIQUE IMPORT ID`:50692});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4130, `ne`:["O"], `pos`:["NN"], `startPosition`:4125, `value`:"right", `UNIQUE IMPORT ID`:50693});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4202, `ne`:["O"], `pos`:["NNP"], `startPosition`:4190, `value`:"Constitution", `UNIQUE IMPORT ID`:50694});
CREATE (:`Sentence` {`hash`:"89b7ee25380230a50350d4b5bff1002e", `id`:"0_20", `sentenceNumber`:20, `text`:"House Republicans contend that Congress never appropriated the money for the subsidies, as required by the Constitution."});
CREATE (:`Tag`:`NER_O` {`id`:"never_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"never_en", `ne`:["O"], `pos`:["RB", "NNP", "VBP", "NN"], `value`:"never"});
CREATE (:`Tag`:`NER_O` {`id`:"require_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"require_en", `ne`:["O"], `pos`:["VBN", "VBP", "VBD", "VBZ", "VB", "VBG"], `value`:"require"});
CREATE (:`Tag`:`NER_O` {`id`:"contend_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"contend_en", `ne`:["O"], `pos`:["VBP", "VBD", "VBZ", "VB", "VBG", "VBN"], `value`:"contend"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4251, `ne`:["MISC"], `pos`:[], `startPosition`:4240, `value`:"Republicans", `UNIQUE IMPORT ID`:50699});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4279, `ne`:["O"], `pos`:["RB"], `startPosition`:4274, `value`:"never", `UNIQUE IMPORT ID`:50700});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4333, `ne`:["O"], `pos`:["VBN"], `startPosition`:4325, `value`:"required", `UNIQUE IMPORT ID`:50701});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4353, `ne`:["O"], `pos`:["NNP"], `startPosition`:4341, `value`:"Constitution", `UNIQUE IMPORT ID`:50702});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4320, `ne`:["O"], `pos`:["NNS"], `startPosition`:4311, `value`:"subsidies", `UNIQUE IMPORT ID`:50703});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4292, `ne`:["O"], `pos`:["VBD"], `startPosition`:4280, `value`:"appropriated", `UNIQUE IMPORT ID`:50704});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4273, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4265, `value`:"Congress", `UNIQUE IMPORT ID`:50705});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4302, `ne`:["O"], `pos`:["NN"], `startPosition`:4297, `value`:"money", `UNIQUE IMPORT ID`:50706});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4239, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4234, `value`:"House", `UNIQUE IMPORT ID`:50707});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:4259, `ne`:["O"], `pos`:["VBP"], `startPosition`:4252, `value`:"contend", `UNIQUE IMPORT ID`:50708});
CREATE (:`Sentence` {`hash`:"8fa686565eb242d61c873a6cf1e82a04", `id`:"0_21", `sentenceNumber`:21, `text`:"In the suit, which was initially championed by John A. Boehner, the House speaker at the time, and later in House committee reports, Republicans asserted that the administration, desperate for the funding, had required the Treasury Department to provide it despite widespread internal skepticism that the spending was proper."});
CREATE (:`Tag`:`NER_O` {`id`:"internal_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"internal_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"internal"});
CREATE (:`Tag`:`NER_O` {`id`:"desperate_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"desperate_en", `ne`:["O"], `pos`:["JJ"], `value`:"desperate"});
CREATE (:`Tag`:`NER_Location`:`NER_Organization`:`NER_Person` {`id`:"John_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"john_en", `ne`:["PERSON", "ORGANIZATION", "LOCATION"], `pos`:[], `value`:"John"});
CREATE (:`Tag`:`NER_O` {`id`:"proper_en", `language`:"en", `lastTxId`:"1524366556210", `lowercasedId`:"proper_en", `ne`:["O"], `pos`:["JJ"], `value`:"proper"});
CREATE (:`Tag`:`NER_Person` {`id`:"Boehner_en", `language`:"en", `lastTxId`:"1524365424875", `lowercasedId`:"boehner_en", `ne`:["PERSON"], `pos`:[], `value`:"Boehner"});
CREATE (:`Tag`:`NER_Time`:`NER_O`:`NER_Date` {`id`:"later_en", `language`:"en", `lastTxId`:"1524366588999", `lowercasedId`:"later_en", `ne`:["O", "DATE", "TIME"], `pos`:["RB", "JJ", "RBR", "JJR", "NN", "NNP"], `value`:"later"});
CREATE (:`Tag`:`NER_Organization` {`id`:"Treasury Department_en", `language`:"en", `lastTxId`:"1524366515480", `lowercasedId`:"treasury department_en", `ne`:["ORGANIZATION"], `pos`:[], `value`:"Treasury Department"});
CREATE (:`Tag`:`NER_O` {`id`:"assert_en", `language`:"en", `lastTxId`:"1524366589740", `lowercasedId`:"assert_en", `ne`:["O"], `pos`:["VBD", "VB", "VBP", "VBG", "VBZ", "VBN"], `value`:"assert"});
CREATE (:`Tag`:`NER_O` {`id`:"widespread_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"widespread_en", `ne`:["O"], `pos`:["JJ"], `value`:"widespread"});
CREATE (:`Tag`:`NER_O` {`id`:"funding_en", `language`:"en", `lastTxId`:"1524366491011", `lowercasedId`:"funding_en", `ne`:["O"], `pos`:["NN", "NNP"], `value`:"funding"});
CREATE (:`Tag`:`NER_O` {`id`:"committee_en", `language`:"en", `lastTxId`:"1524366596515", `lowercasedId`:"committee_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"committee"});
CREATE (:`Tag`:`NER_O` {`id`:"skepticism_en", `language`:"en", `lastTxId`:"1524366375293", `lowercasedId`:"skepticism_en", `ne`:["O"], `pos`:["NN"], `value`:"skepticism"});
CREATE (:`Tag`:`NER_O` {`id`:"despite_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"despite_en", `ne`:["O"], `pos`:["IN"], `value`:"despite"});
CREATE (:`Tag`:`NER_O` {`id`:"speaker_en", `language`:"en", `lastTxId`:"1524366599892", `lowercasedId`:"speaker_en", `ne`:["O"], `pos`:["NN", "NNP", "NNS"], `value`:"speaker"});
CREATE (:`Tag`:`NER_O` {`id`:"report_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"report_en", `ne`:["O"], `pos`:["NNS", "NN", "VBD", "VB", "VBG", "VBN", "VBZ", "VBP", "NNP"], `value`:"report"});
CREATE (:`Tag`:`NER_O` {`id`:"initially_en", `language`:"en", `lastTxId`:"1524366497987", `lowercasedId`:"initially_en", `ne`:["O"], `pos`:["RB"], `value`:"initially"});
CREATE (:`Tag`:`NER_O` {`id`:"champion_en", `language`:"en", `lastTxId`:"1524366556210", `lowercasedId`:"champion_en", `ne`:["O"], `pos`:["VBN", "NN", "NNS", "VBP", "VB", "VBD", "VBG", "JJ", "NNP"], `value`:"champion"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4679, `ne`:["O"], `pos`:["JJ"], `startPosition`:4673, `value`:"proper", `UNIQUE IMPORT ID`:50727});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4619, `ne`:["O"], `pos`:["IN"], `startPosition`:4612, `value`:"despite", `UNIQUE IMPORT ID`:50728});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4428, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4423, `value`:"House", `UNIQUE IMPORT ID`:50729});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4499, `ne`:["MISC"], `pos`:[], `startPosition`:4488, `value`:"Republicans", `UNIQUE IMPORT ID`:50730});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4559, `ne`:["O"], `pos`:["NN"], `startPosition`:4552, `value`:"funding", `UNIQUE IMPORT ID`:50731});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4366, `ne`:["O"], `pos`:["NN"], `startPosition`:4362, `value`:"suit", `UNIQUE IMPORT ID`:50732});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4630, `ne`:["O"], `pos`:["JJ"], `startPosition`:4620, `value`:"widespread", `UNIQUE IMPORT ID`:50733});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4436, `ne`:["O"], `pos`:["NN"], `startPosition`:4429, `value`:"speaker", `UNIQUE IMPORT ID`:50734});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4373, `ne`:["O"], `pos`:["WDT"], `startPosition`:4368, `value`:"which", `UNIQUE IMPORT ID`:50735});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4564, `ne`:["O"], `pos`:["VBD"], `startPosition`:4561, `value`:"had", `UNIQUE IMPORT ID`:50736});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:4508, `ne`:["O"], `pos`:["VBD"], `startPosition`:4500, `value`:"asserted", `UNIQUE IMPORT ID`:50737});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4573, `ne`:["O"], `pos`:["VBN"], `startPosition`:4565, `value`:"required", `UNIQUE IMPORT ID`:50738});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4639, `ne`:["O"], `pos`:["JJ"], `startPosition`:4631, `value`:"internal", `UNIQUE IMPORT ID`:50739});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4387, `ne`:["O"], `pos`:["RB"], `startPosition`:4378, `value`:"initially", `UNIQUE IMPORT ID`:50740});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4448, `ne`:["DATE"], `pos`:[], `startPosition`:4444, `value`:"time", `UNIQUE IMPORT ID`:50741});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4650, `ne`:["O"], `pos`:["NN"], `startPosition`:4640, `value`:"skepticism", `UNIQUE IMPORT ID`:50742});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4597, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4578, `value`:"Treasury Department", `UNIQUE IMPORT ID`:50743});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4398, `ne`:["O"], `pos`:["VBN"], `startPosition`:4388, `value`:"championed", `UNIQUE IMPORT ID`:50744});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4459, `ne`:["O"], `pos`:["RB"], `startPosition`:4454, `value`:"later", `UNIQUE IMPORT ID`:50745});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4532, `ne`:["O"], `pos`:["NN"], `startPosition`:4518, `value`:"administration", `UNIQUE IMPORT ID`:50746});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4468, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4463, `value`:"House", `UNIQUE IMPORT ID`:50747});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4406, `ne`:["PERSON"], `pos`:[], `startPosition`:4402, `value`:"John", `UNIQUE IMPORT ID`:50748});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4668, `ne`:["O"], `pos`:["NN"], `startPosition`:4660, `value`:"spending", `UNIQUE IMPORT ID`:50749});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4478, `ne`:["O"], `pos`:["NN"], `startPosition`:4469, `value`:"committee", `UNIQUE IMPORT ID`:50750});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4543, `ne`:["O"], `pos`:["JJ"], `startPosition`:4534, `value`:"desperate", `UNIQUE IMPORT ID`:50751});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4608, `ne`:["O"], `pos`:["VB"], `startPosition`:4601, `value`:"provide", `UNIQUE IMPORT ID`:50752});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4417, `ne`:["PERSON"], `pos`:[], `startPosition`:4410, `value`:" Boehner", `UNIQUE IMPORT ID`:50753});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4486, `ne`:["O"], `pos`:["NNS"], `startPosition`:4479, `value`:"reports", `UNIQUE IMPORT ID`:50754});
CREATE (:`Sentence` {`hash`:"ed0950af40a38882903b755699b71452", `id`:"0_22", `sentenceNumber`:22, `text`:"The White House said that the spending was a permanent part of the law passed in 2010, and that no annual appropriation was required  —   even though the administration initially sought one."});
CREATE (:`Tag`:`NER_O` {`id`:"though_en", `language`:"en", `lastTxId`:"1524366583918", `lowercasedId`:"though_en", `ne`:["O"], `pos`:["IN", "RB", "NNP"], `value`:"though"});
CREATE (:`Tag`:`NER_O` {`id`:"pass_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"pass_en", `ne`:["O"], `pos`:["VBN", "VBD", "VBG", "VB", "NN", "VBP", "VBZ", "NNS"], `value`:"pass"});
CREATE (:`Tag`:`NER_O` {`id`:"part_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"part_en", `ne`:["O"], `pos`:["NN", "NNS", "VBD", "NNP", "VBN", "VBG", "VB", "VBP"], `value`:"part"});
CREATE (:`Tag`:`NER_Number`:`NER_O` {`id`:"one_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"one_en", `ne`:["NUMBER", "O"], `pos`:["NNS"], `value`:"one"});
CREATE (:`Tag`:`NER_Location`:`NER_Organization` {`id`:"White House_en", `language`:"en", `lastTxId`:"1524366600629", `lowercasedId`:"white house_en", `ne`:["ORGANIZATION", "LOCATION"], `pos`:[], `value`:"White House"});
CREATE (:`Tag`:`NER_Date` {`id`:"2010_en", `language`:"en", `lastTxId`:"1524366571492", `lowercasedId`:"2010_en", `ne`:["DATE"], `pos`:[], `value`:"2010"});
CREATE (:`Tag`:`NER_O` {`id`:"even_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"even_en", `ne`:["O"], `pos`:["RB", "JJ", "VB", "VBZ", "VBD"], `value`:"even"});
CREATE (:`Tag`:`NER_O` {`id`:"permanent_en", `language`:"en", `lastTxId`:"1524366598829", `lowercasedId`:"permanent_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"permanent"});
CREATE (:`Tag`:`NER_Set`:`NER_O`:`NER_Date` {`id`:"annual_en", `language`:"en", `lastTxId`:"1524366598829", `lowercasedId`:"annual_en", `ne`:["SET", "O", "DATE"], `pos`:["NNS"], `value`:"annual"});
CREATE (:`Tag`:`NER_O` {`id`:"appropriation_en", `language`:"en", `lastTxId`:"1524365554907", `lowercasedId`:"appropriation_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"appropriation"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4740, `ne`:["O"], `pos`:["NN"], `startPosition`:4736, `value`:"part", `UNIQUE IMPORT ID`:50766});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4849, `ne`:["O"], `pos`:["NN"], `startPosition`:4835, `value`:"administration", `UNIQUE IMPORT ID`:50767});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4870, `ne`:["NUMBER"], `pos`:[], `startPosition`:4867, `value`:"one", `UNIQUE IMPORT ID`:50768});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4813, `ne`:["O"], `pos`:["VBN"], `startPosition`:4805, `value`:"required", `UNIQUE IMPORT ID`:50769});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4719, `ne`:["O"], `pos`:["NN"], `startPosition`:4711, `value`:"spending", `UNIQUE IMPORT ID`:50770});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4751, `ne`:["O"], `pos`:["NN"], `startPosition`:4748, `value`:"law", `UNIQUE IMPORT ID`:50771});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4786, `ne`:["SET"], `pos`:[], `startPosition`:4780, `value`:"annual", `UNIQUE IMPORT ID`:50772});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4696, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4685, `value`:"White House", `UNIQUE IMPORT ID`:50773});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4758, `ne`:["O"], `pos`:["VBN"], `startPosition`:4752, `value`:"passed", `UNIQUE IMPORT ID`:50774});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4859, `ne`:["O"], `pos`:["RB"], `startPosition`:4850, `value`:"initially", `UNIQUE IMPORT ID`:50775});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4800, `ne`:["O"], `pos`:["NN"], `startPosition`:4787, `value`:"appropriation", `UNIQUE IMPORT ID`:50776});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4823, `ne`:["O"], `pos`:["RB"], `startPosition`:4819, `value`:"even", `UNIQUE IMPORT ID`:50777});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4735, `ne`:["O"], `pos`:["JJ"], `startPosition`:4726, `value`:"permanent", `UNIQUE IMPORT ID`:50778});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4830, `ne`:["O"], `pos`:["IN"], `startPosition`:4824, `value`:"though", `UNIQUE IMPORT ID`:50779});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:4701, `ne`:["O"], `pos`:["VBD"], `startPosition`:4697, `value`:"said", `UNIQUE IMPORT ID`:50780});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4766, `ne`:["DATE"], `pos`:[], `startPosition`:4762, `value`:"2010", `UNIQUE IMPORT ID`:50781});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4866, `ne`:["O"], `pos`:["VBD"], `startPosition`:4860, `value`:"sought", `UNIQUE IMPORT ID`:50782});
CREATE (:`Sentence` {`hash`:"a4c41b72621638fe0523405500e02ba7", `id`:"0_23", `sentenceNumber`:23, `text`:"Just as important to House Republicans, Judge Collyer found that Congress had the standing to sue the White House on this issue  —   a ruling that many legal experts said was flawed  —   and they want that precedent to be set to restore congressional leverage over the executive branch."});
CREATE (:`Tag`:`NER_O` {`id`:"leverage_en", `language`:"en", `lastTxId`:"1524366392978", `lowercasedId`:"leverage_en", `ne`:["O"], `pos`:["NN", "VBN", "VBD", "VBG", "VBZ", "NNS"], `value`:"leverage"});
CREATE (:`Tag`:`NER_O` {`id`:"expert_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"expert_en", `ne`:["O"], `pos`:["NNS", "NN", "JJ", "NNP"], `value`:"expert"});
CREATE (:`Tag`:`NER_O` {`id`:"ruling_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"ruling_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"ruling"});
CREATE (:`Tag`:`NER_O` {`id`:"flaw_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"flaw_en", `ne`:["O"], `pos`:["VBN", "NNS", "NN", "VBD"], `value`:"flaw"});
CREATE (:`Tag`:`NER_O` {`id`:"legal_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"legal_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"legal"});
CREATE (:`Tag`:`NER_O` {`id`:"set_en", `language`:"en", `lastTxId`:"1524366598162", `lowercasedId`:"set_en", `ne`:["O"], `pos`:["VBN", "NN", "VBD", "VBZ", "VB", "VBG", "VBP", "NNS", "NNP", "JJ"], `value`:"set"});
CREATE (:`Tag`:`NER_O` {`id`:"restore_en", `language`:"en", `lastTxId`:"1524366459936", `lowercasedId`:"restore_en", `ne`:["O"], `pos`:["VB", "VBD", "VBN", "VBG", "NNP", "VBZ", "VBP"], `value`:"restore"});
CREATE (:`Tag`:`NER_O` {`id`:"many_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"many_en", `ne`:["O"], `pos`:["JJ", "NN", "VB", "RB", "DT", "NNP"], `value`:"many"});
CREATE (:`Tag`:`NER_O` {`id`:"important_en", `language`:"en", `lastTxId`:"1524366577094", `lowercasedId`:"important_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"important"});
CREATE (:`Tag`:`NER_O` {`id`:"precedent_en", `language`:"en", `lastTxId`:"1524366517684", `lowercasedId`:"precedent_en", `ne`:["O"], `pos`:["NN", "NNS"], `value`:"precedent"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4999, `ne`:["O"], `pos`:["NN"], `startPosition`:4994, `value`:"issue", `UNIQUE IMPORT ID`:50794});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5131, `ne`:["O"], `pos`:["NN"], `startPosition`:5123, `value`:"leverage", `UNIQUE IMPORT ID`:50795});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4876, `ne`:["O"], `pos`:["RB"], `startPosition`:4872, `value`:"Just", `UNIQUE IMPORT ID`:50796});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4945, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4937, `value`:"Congress", `UNIQUE IMPORT ID`:50797});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5072, `ne`:["O"], `pos`:["VBP"], `startPosition`:5068, `value`:"want", `UNIQUE IMPORT ID`:50798});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5136, `ne`:["O"], `pos`:["IN"], `startPosition`:5132, `value`:"over", `UNIQUE IMPORT ID`:50799});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5013, `ne`:["O"], `pos`:["NN"], `startPosition`:5007, `value`:"ruling", `UNIQUE IMPORT ID`:50800});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4889, `ne`:["O"], `pos`:["JJ"], `startPosition`:4880, `value`:"important", `UNIQUE IMPORT ID`:50801});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4949, `ne`:["O"], `pos`:["VBD"], `startPosition`:4946, `value`:"had", `UNIQUE IMPORT ID`:50802});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5150, `ne`:["O"], `pos`:["JJ"], `startPosition`:5141, `value`:"executive", `UNIQUE IMPORT ID`:50803});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5087, `ne`:["O"], `pos`:["NN"], `startPosition`:5078, `value`:"precedent", `UNIQUE IMPORT ID`:50804});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4962, `ne`:["O"], `pos`:["NN"], `startPosition`:4954, `value`:"standing", `UNIQUE IMPORT ID`:50805});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5023, `ne`:["O"], `pos`:["JJ"], `startPosition`:5019, `value`:"many", `UNIQUE IMPORT ID`:50806});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4898, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:4893, `value`:"House", `UNIQUE IMPORT ID`:50807});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5157, `ne`:["O"], `pos`:["NN"], `startPosition`:5151, `value`:"branch", `UNIQUE IMPORT ID`:50808});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5029, `ne`:["O"], `pos`:["JJ"], `startPosition`:5024, `value`:"legal", `UNIQUE IMPORT ID`:50809});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4910, `ne`:["MISC"], `pos`:[], `startPosition`:4899, `value`:"Republicans", `UNIQUE IMPORT ID`:50810});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4969, `ne`:["O"], `pos`:["VB"], `startPosition`:4966, `value`:"sue", `UNIQUE IMPORT ID`:50811});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5037, `ne`:["O"], `pos`:["NNS"], `startPosition`:5030, `value`:"experts", `UNIQUE IMPORT ID`:50812});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5097, `ne`:["O"], `pos`:["VBN"], `startPosition`:5094, `value`:"set", `UNIQUE IMPORT ID`:50813});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5108, `ne`:["O"], `pos`:["VB"], `startPosition`:5101, `value`:"restore", `UNIQUE IMPORT ID`:50814});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4985, `ne`:["LOCATION"], `pos`:[], `startPosition`:4974, `value`:"White House", `UNIQUE IMPORT ID`:50815});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5042, `ne`:["O"], `pos`:["VBD"], `startPosition`:5038, `value`:"said", `UNIQUE IMPORT ID`:50816});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4917, `ne`:["O"], `pos`:["NNP"], `startPosition`:4912, `value`:"Judge", `UNIQUE IMPORT ID`:50817});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5122, `ne`:["O"], `pos`:["JJ"], `startPosition`:5109, `value`:"congressional", `UNIQUE IMPORT ID`:50818});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:4925, `ne`:["PERSON"], `pos`:[], `startPosition`:4918, `value`:"Collyer", `UNIQUE IMPORT ID`:50819});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5053, `ne`:["O"], `pos`:["VBN"], `startPosition`:5047, `value`:"flawed", `UNIQUE IMPORT ID`:50820});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:4931, `ne`:["O"], `pos`:["VBD"], `startPosition`:4926, `value`:"found", `UNIQUE IMPORT ID`:50821});
CREATE (:`Sentence` {`hash`:"d3b11d3d719825af21011cb955b4453f", `id`:"0_24", `sentenceNumber`:24, `text`:"But on spending power and standing, the Trump administration may come under pressure from advocates of presidential authority to fight the House no matter their shared views on health care, since those precedents could have broad repercussions."});
CREATE (:`Tag`:`NER_O` {`id`:"shared_en", `language`:"en", `lastTxId`:"1524366491011", `lowercasedId`:"shared_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"shared"});
CREATE (:`Tag`:`NER_O` {`id`:"advocate_en", `language`:"en", `lastTxId`:"1524366569729", `lowercasedId`:"advocate_en", `ne`:["O"], `pos`:["NNS", "NN", "VBD", "VBN", "VBG", "VBZ", "VB", "VBP", "NNP"], `value`:"advocate"});
CREATE (:`Tag`:`NER_O` {`id`:"broad_en", `language`:"en", `lastTxId`:"1524366338020", `lowercasedId`:"broad_en", `ne`:["O"], `pos`:["JJ", "NNP", "NNS"], `value`:"broad"});
CREATE (:`Tag`:`NER_O` {`id`:"repercussion_en", `language`:"en", `lastTxId`:"1524365868112", `lowercasedId`:"repercussion_en", `ne`:["O"], `pos`:["NNS", "NN"], `value`:"repercussion"});
CREATE (:`Tag`:`NER_O` {`id`:"those_en", `language`:"en", `lastTxId`:"1524366597560", `lowercasedId`:"those_en", `ne`:["O"], `pos`:["DT"], `value`:"those"});
CREATE (:`Tag`:`NER_O`:`NER_Date` {`id`:"may_en", `language`:"en", `lastTxId`:"1524366594322", `lowercasedId`:"may_en", `ne`:["O", "DATE"], `pos`:["MD"], `value`:"may"});
CREATE (:`Tag`:`NER_O` {`id`:"pressure_en", `language`:"en", `lastTxId`:"1524366602772", `lowercasedId`:"pressure_en", `ne`:["O"], `pos`:["NN", "VBN", "VB", "VBG", "NNS", "VBD", "VBP"], `value`:"pressure"});
CREATE (:`Tag`:`NER_O` {`id`:"presidential_en", `language`:"en", `lastTxId`:"1524366601642", `lowercasedId`:"presidential_en", `ne`:["O"], `pos`:["JJ", "NNP"], `value`:"presidential"});
CREATE (:`Tag`:`NER_O` {`id`:"under_en", `language`:"en", `lastTxId`:"1524366604352", `lowercasedId`:"under_en", `ne`:["O"], `pos`:["IN"], `value`:"under"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5193, `ne`:["O"], `pos`:["NN"], `startPosition`:5185, `value`:"standing", `UNIQUE IMPORT ID`:50832});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5258, `ne`:["O"], `pos`:["NNS"], `startPosition`:5249, `value`:"advocates", `UNIQUE IMPORT ID`:50833});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5382, `ne`:["O"], `pos`:["VB"], `startPosition`:5378, `value`:"have", `UNIQUE IMPORT ID`:50834});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5388, `ne`:["O"], `pos`:["JJ"], `startPosition`:5383, `value`:"broad", `UNIQUE IMPORT ID`:50835});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5326, `ne`:["O"], `pos`:["JJ"], `startPosition`:5320, `value`:"shared", `UNIQUE IMPORT ID`:50836});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5402, `ne`:["O"], `pos`:["NNS"], `startPosition`:5389, `value`:"repercussions", `UNIQUE IMPORT ID`:50837});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5274, `ne`:["O"], `pos`:["JJ"], `startPosition`:5262, `value`:"presidential", `UNIQUE IMPORT ID`:50838});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5204, `ne`:["PERSON"], `pos`:[], `startPosition`:5199, `value`:"Trump", `UNIQUE IMPORT ID`:50839});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5332, `ne`:["O"], `pos`:["NNS"], `startPosition`:5327, `value`:"views", `UNIQUE IMPORT ID`:50840});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5219, `ne`:["O"], `pos`:["NN"], `startPosition`:5205, `value`:"administration", `UNIQUE IMPORT ID`:50841});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5342, `ne`:["O"], `pos`:["NN"], `startPosition`:5336, `value`:"health", `UNIQUE IMPORT ID`:50842});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5284, `ne`:["O"], `pos`:["NN"], `startPosition`:5275, `value`:"authority", `UNIQUE IMPORT ID`:50843});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5347, `ne`:["O"], `pos`:["NN"], `startPosition`:5343, `value`:"care", `UNIQUE IMPORT ID`:50844});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5223, `ne`:["O"], `pos`:["MD"], `startPosition`:5220, `value`:"may", `UNIQUE IMPORT ID`:50845});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5354, `ne`:["O"], `pos`:["IN"], `startPosition`:5349, `value`:"since", `UNIQUE IMPORT ID`:50846});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:5228, `ne`:["O"], `pos`:["VB"], `startPosition`:5224, `value`:"come", `UNIQUE IMPORT ID`:50847});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5293, `ne`:["O"], `pos`:["VB"], `startPosition`:5288, `value`:"fight", `UNIQUE IMPORT ID`:50848});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5360, `ne`:["O"], `pos`:["DT"], `startPosition`:5355, `value`:"those", `UNIQUE IMPORT ID`:50849});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5234, `ne`:["O"], `pos`:["IN"], `startPosition`:5229, `value`:"under", `UNIQUE IMPORT ID`:50850});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5174, `ne`:["O"], `pos`:["NN"], `startPosition`:5166, `value`:"spending", `UNIQUE IMPORT ID`:50851});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5371, `ne`:["O"], `pos`:["NNS"], `startPosition`:5361, `value`:"precedents", `UNIQUE IMPORT ID`:50852});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5303, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:5298, `value`:"House", `UNIQUE IMPORT ID`:50853});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5243, `ne`:["O"], `pos`:["NN"], `startPosition`:5235, `value`:"pressure", `UNIQUE IMPORT ID`:50854});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5180, `ne`:["O"], `pos`:["NN"], `startPosition`:5175, `value`:"power", `UNIQUE IMPORT ID`:50855});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5313, `ne`:["O"], `pos`:["NN"], `startPosition`:5307, `value`:"matter", `UNIQUE IMPORT ID`:50856});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5248, `ne`:["O"], `pos`:["IN"], `startPosition`:5244, `value`:"from", `UNIQUE IMPORT ID`:50857});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5377, `ne`:["O"], `pos`:["MD"], `startPosition`:5372, `value`:"could", `UNIQUE IMPORT ID`:50858});
CREATE (:`Sentence` {`hash`:"6dbf8a6e742893eff925c6b8e087ff60", `id`:"0_25", `sentenceNumber`:25, `text`:"It is a complicated set of dynamics illustrating how a quick legal victory for the House in the Trump era might come with costs that Republicans never anticipated when they took on the Obama White House."});
CREATE (:`Tag`:`NER_O` {`id`:"illustrate_en", `language`:"en", `lastTxId`:"1524366561092", `lowercasedId`:"illustrate_en", `ne`:["O"], `pos`:["VBG", "VBZ", "VBN", "VB", "VBP", "VBD"], `value`:"illustrate"});
CREATE (:`Tag`:`NER_O` {`id`:"dynamics_en", `language`:"en", `lastTxId`:"1524366179691", `lowercasedId`:"dynamics_en", `ne`:["O"], `pos`:["NNS", "NNP"], `value`:"dynamics"});
CREATE (:`Tag`:`NER_O` {`id`:"era_en", `language`:"en", `lastTxId`:"1524366209187", `lowercasedId`:"era_en", `ne`:["O"], `pos`:["NN", "NNS", "NNP"], `value`:"era"});
CREATE (:`Tag`:`NER_O` {`id`:"complicated_en", `language`:"en", `lastTxId`:"1524365855941", `lowercasedId`:"complicated_en", `ne`:["O"], `pos`:["JJ", "IN"], `value`:"complicated"});
CREATE (:`Tag`:`NER_Location`:`NER_Organization` {`id`:"Obama White House_en", `language`:"en", `lastTxId`:"1524366444517", `lowercasedId`:"obama white house_en", `ne`:["ORGANIZATION", "LOCATION"], `pos`:[], `value`:"Obama White House"});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5452, `ne`:["O"], `pos`:["VBG"], `startPosition`:5440, `value`:"illustrating", `UNIQUE IMPORT ID`:50865});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5548, `ne`:["MISC"], `pos`:[], `startPosition`:5537, `value`:"Republicans", `UNIQUE IMPORT ID`:50866});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5509, `ne`:["O"], `pos`:["NN"], `startPosition`:5506, `value`:"era", `UNIQUE IMPORT ID`:50867});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5423, `ne`:["O"], `pos`:["JJ"], `startPosition`:5412, `value`:"complicated", `UNIQUE IMPORT ID`:50868});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5515, `ne`:["O"], `pos`:["MD"], `startPosition`:5510, `value`:"might", `UNIQUE IMPORT ID`:50869});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5581, `ne`:["O"], `pos`:["VBD"], `startPosition`:5577, `value`:"took", `UNIQUE IMPORT ID`:50870});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5520, `ne`:["O"], `pos`:["VB"], `startPosition`:5516, `value`:"come", `UNIQUE IMPORT ID`:50871});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5456, `ne`:["O"], `pos`:["WRB"], `startPosition`:5453, `value`:"how", `UNIQUE IMPORT ID`:50872});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5554, `ne`:["O"], `pos`:["RB"], `startPosition`:5549, `value`:"never", `UNIQUE IMPORT ID`:50873});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5492, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:5487, `value`:"House", `UNIQUE IMPORT ID`:50874});
CREATE (:`TagOccurrence`:`Root`:`UNIQUE IMPORT LABEL` {`endPosition`:5427, `ne`:["O"], `pos`:["NN"], `startPosition`:5424, `value`:"set", `UNIQUE IMPORT ID`:50875});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5464, `ne`:["O"], `pos`:["JJ"], `startPosition`:5459, `value`:"quick", `UNIQUE IMPORT ID`:50876});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5566, `ne`:["O"], `pos`:["VBN"], `startPosition`:5555, `value`:"anticipated", `UNIQUE IMPORT ID`:50877});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5606, `ne`:["ORGANIZATION"], `pos`:[], `startPosition`:5589, `value`:"Obama White House", `UNIQUE IMPORT ID`:50878});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5531, `ne`:["O"], `pos`:["NNS"], `startPosition`:5526, `value`:"costs", `UNIQUE IMPORT ID`:50879});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5439, `ne`:["O"], `pos`:["NNS"], `startPosition`:5431, `value`:"dynamics", `UNIQUE IMPORT ID`:50880});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5470, `ne`:["O"], `pos`:["JJ"], `startPosition`:5465, `value`:"legal", `UNIQUE IMPORT ID`:50881});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5505, `ne`:["PERSON"], `pos`:[], `startPosition`:5500, `value`:"Trump", `UNIQUE IMPORT ID`:50882});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5478, `ne`:["O"], `pos`:["NN"], `startPosition`:5471, `value`:"victory", `UNIQUE IMPORT ID`:50883});
CREATE (:`TagOccurrence`:`UNIQUE IMPORT LABEL` {`endPosition`:5571, `ne`:["O"], `pos`:["WRB"], `startPosition`:5567, `value`:"when", `UNIQUE IMPORT ID`:50884});
CREATE INDEX ON :`Tag`(`value`);
CREATE CONSTRAINT ON (node:`Document`) ASSERT node.`id` IS UNIQUE;
CREATE CONSTRAINT ON (node:`AnnotatedText`) ASSERT node.`id` IS UNIQUE;
CREATE CONSTRAINT ON (node:`Tag`) ASSERT node.`id` IS UNIQUE;
CREATE CONSTRAINT ON (node:`Sentence`) ASSERT node.`id` IS UNIQUE;
CREATE CONSTRAINT ON (node:`UNIQUE IMPORT LABEL`) ASSERT node.`UNIQUE IMPORT ID` IS UNIQUE;
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50018}), (n2:`Tag`{`id`:"WASHINGTON_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50018}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50019}), (n2:`Tag`{`id`:"lawsuit_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50019}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50020}), (n2:`Tag`{`id`:"come_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50020}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50021}), (n2:`Tag`{`id`:"against_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50021}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50022}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50022}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50023}), (n2:`Tag`{`id`:"might_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50023}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50024}), (n2:`Tag`{`id`:"congressional_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50024}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50025}), (n2:`Tag`{`id`:"new_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50025}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50026}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50026}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50027}), (n2:`Tag`{`id`:"Obama_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50027}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50028}), (n2:`Tag`{`id`:"fear_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50028}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}), (n2:`Tag`{`id`:"win_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50030}), (n2:`Tag`{`id`:"when_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50030}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50031}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50031}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50032}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50032}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50033}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_0"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50033}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50018}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50033}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50024}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50022}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50033}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50022}) CREATE (n1)-[r:`PARATAXIS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50028}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50025}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50022}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50028}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50020}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50030}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50022}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50020}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50019}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50026}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50019}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50032}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50020}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50019}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50031}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50021}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50031}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50027}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50019}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50031}) CREATE (n1)-[r:`NMOD` {`specific`:"against"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50029}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50023}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_0"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}), (n2:`Tag`{`id`:"choose_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50058}), (n2:`Tag`{`id`:"which_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50058}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50059}), (n2:`Tag`{`id`:"hand_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50059}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50060}), (n2:`Tag`{`id`:"challenge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50060}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50061}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50061}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50062}), (n2:`Tag`{`id`:"longer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50062}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50063}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50063}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50064}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50064}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50065}), (n2:`Tag`{`id`:"defend_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50065}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50066}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50066}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50067}), (n2:`Tag`{`id`:"insurance_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50067}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50068}), (n2:`Tag`{`id`:"incoming_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50068}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50069}), (n2:`Tag`{`id`:"executive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50069}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50070}), (n2:`Tag`{`id`:"big_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50070}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50071}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50071}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50072}), (n2:`Tag`{`id`:"victory_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50072}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50073}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50073}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50074}), (n2:`Tag`{`id`:"authority_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50074}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50075}), (n2:`Tag`{`id`:"branch_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50075}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50076}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50076}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50077}), (n2:`Tag`{`id`:"against_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50077}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50078}), (n2:`Tag`{`id`:"issue_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50078}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50079}), (n2:`Tag`{`id`:"spend_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50079}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50080}), (n2:`Tag`{`id`:"Americans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50080}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50081}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50081}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}), (n2:`Tag`{`id`:"billions of dollars_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}), (n2:`Tag`{`id`:"suit_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_1"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50076}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50068}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50076}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50073}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50076}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50081}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50057}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50062}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50062}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50065}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50075}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50069}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50065}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50075}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50077}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50065}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}) CREATE (n1)-[r:`NMOD` {`specific`:"against"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50060}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50058}) CREATE (n1)-[r:`REF`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50083}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50060}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50074}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50066}) CREATE (n1)-[r:`NMOD:POSS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50060}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50074}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50074}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50079}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50079}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50082}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50071}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50063}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50071}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50067}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50079}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50071}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50071}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50080}) CREATE (n1)-[r:`ACL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50064}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50061}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50059}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50064}) CREATE (n1)-[r:`IOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50072}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50070}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50059}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50072}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50072}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50078}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_1"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50100}), (n2:`Tag`{`id`:"sudden_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50100}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50101}), (n2:`Tag`{`id`:"before_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50101}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50102}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50102}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50103}), (n2:`Tag`{`id`:"leave_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50103}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50104}), (n2:`Tag`{`id`:"replacement_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50104}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50105}), (n2:`Tag`{`id`:"access_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50105}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50106}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50106}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50107}), (n2:`Tag`{`id`:"loss_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50107}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50108}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50108}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50109}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50109}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50110}), (n2:`Tag`{`id`:"million_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50110}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50111}), (n2:`Tag`{`id`:"conceivably_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50111}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50112}), (n2:`Tag`{`id`:"program_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50112}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50113}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50113}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50114}), (n2:`Tag`{`id`:"dispute_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50114}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50115}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50115}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50116}), (n2:`Tag`{`id`:"people_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50116}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50117}), (n2:`Tag`{`id`:"insurance_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50117}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`Tag`{`id`:"cause_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}), (n2:`Tag`{`id`:"prepare_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50120}), (n2:`Tag`{`id`:"implode_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50120}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50121}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50121}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50122}), (n2:`Tag`{`id`:"without_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_2"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50122}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50107}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50100}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50107}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50121}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50114}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50107}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50121}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50106}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50111}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50112}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50102}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50112}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50109}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50112}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50112}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50120}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50118}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50103}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50103}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50110}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50110}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50116}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50105}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50122}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50103}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50105}) CREATE (n1)-[r:`NMOD` {`specific`:"without"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50117}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50113}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50105}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50117}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50101}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50108}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50115}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50105}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}) CREATE (n1)-[r:`ACL` {`specific`:"before"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50119}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50104}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_2"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50135}), (n2:`Tag`{`id`:"just_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50135}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50136}), (n2:`Tag`{`id`:"chaos_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50136}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50137}), (n2:`Tag`{`id`:"spur_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50137}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50138}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50138}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50139}), (n2:`Tag`{`id`:"political_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50139}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50140}), (n2:`Tag`{`id`:"government_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50140}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50141}), (n2:`Tag`{`id`:"insurance_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50141}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50142}), (n2:`Tag`{`id`:"gain_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50142}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50143}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50143}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50144}), (n2:`Tag`{`id`:"backlash_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50144}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50145}), (n2:`Tag`{`id`:"full_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50145}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50146}), (n2:`Tag`{`id`:"market_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50146}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}), (n2:`Tag`{`id`:"lead_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50148}), (n2:`Tag`{`id`:"control_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_3"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50148}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50143}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50136}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50146}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50141}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50136}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50146}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50147}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50137}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50144}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50139}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50137}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50144}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50142}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50135}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50142}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50138}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50137}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50142}) CREATE (n1)-[r:`ADVCL` {`specific`:"as"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50148}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50145}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50142}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50148}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50148}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50140}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_3"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50171}), (n2:`Tag`{`id`:"huge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50171}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50172}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50172}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50173}), (n2:`Tag`{`id`:"sum_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50173}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50174}), (n2:`Tag`{`id`:"conservative_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50174}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`Tag`{`id`:"find_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50176}), (n2:`Tag`{`id`:"years_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50176}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50177}), (n2:`Tag`{`id`:"themselves_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50177}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50178}), (n2:`Tag`{`id`:"temporarily_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50178}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}), (n2:`Tag`{`id`:"voter_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50180}), (n2:`Tag`{`id`:"prop_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50180}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50181}), (n2:`Tag`{`id`:"who_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50181}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50182}), (n2:`Tag`{`id`:"stave_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50182}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50183}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50183}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50184}), (n2:`Tag`{`id`:"awkward_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50184}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50185}), (n2:`Tag`{`id`:"up_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50185}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50186}), (n2:`Tag`{`id`:"off_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50186}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50187}), (n2:`Tag`{`id`:"Obama_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50187}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50188}), (n2:`Tag`{`id`:"position_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50188}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}), (n2:`Tag`{`id`:"demand_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50190}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50190}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50191}), (n2:`Tag`{`id`:"outcome_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50191}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50192}), (n2:`Tag`{`id`:"appropriate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50192}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50193}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50193}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50194}), (n2:`Tag`{`id`:"end_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50194}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50195}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50195}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50196}), (n2:`Tag`{`id`:"law_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50196}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50197}), (n2:`Tag`{`id`:"anger_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50197}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50198}), (n2:`Tag`{`id`:"law_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_4"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50198}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50182}) CREATE (n1)-[r:`ADVCL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50182}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50186}) CREATE (n1)-[r:`COMPOUND:PRT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50182}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50191}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50195}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50172}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50177}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50188}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50184}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50188}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50188}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50192}) CREATE (n1)-[r:`ACL` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50173}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50171}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50192}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50173}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50180}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50178}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50192}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50180}) CREATE (n1)-[r:`ADVCL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50180}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50185}) CREATE (n1)-[r:`COMPOUND:PRT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50196}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50187}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50196}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50190}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50196}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50193}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50180}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50196}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50175}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50197}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50174}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50197}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50181}) CREATE (n1)-[r:`REF`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50183}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50179}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50194}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50194}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50198}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50189}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50176}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_4"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50214}), (n2:`Tag`{`id`:"Donald_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50214}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}), (n2:`Tag`{`id`:"choose_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50216}), (n2:`Tag`{`id`:"worry_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50216}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50217}), (n2:`Tag`{`id`:"question_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50217}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50218}), (n2:`Tag`{`id`:"branch_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50218}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50219}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50219}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50220}), (n2:`Tag`{`id`:"about_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50220}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50221}), (n2:`Tag`{`id`:"fight_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50221}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50222}), (n2:`Tag`{`id`:"prerogative_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50222}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50223}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50223}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50224}), (n2:`Tag`{`id`:"preserve_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50224}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50225}), (n2:`Tag`{`id`:"its_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50225}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50226}), (n2:`Tag`{`id`:"another_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50226}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50227}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50227}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50228}), (n2:`Tag`{`id`:"Republican_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50228}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50229}), (n2:`Tag`{`id`:"dispute_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50229}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50230}), (n2:`Tag`{`id`:"some_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50230}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50231}), (n2:`Tag`{`id`:"twist_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50231}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50232}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50232}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50233}), (n2:`Tag`{`id`:"executive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50233}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50234}), (n2:`Tag`{`id`:"central_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50234}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50235}), (n2:`Tag`{`id`:"ally_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_5"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50235}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50231}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50226}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50231}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50219}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50214}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50227}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50219}) CREATE (n1)-[r:`NMOD:POSS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50227}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50221}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50227}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50227}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50216}) CREATE (n1)-[r:`ACL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50224}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50220}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50216}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50224}) CREATE (n1)-[r:`ADVCL` {`specific`:"about"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50222}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50233}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50222}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50218}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50224}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50222}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50232}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50215}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50221}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50235}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50225}) CREATE (n1)-[r:`NMOD:POSS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50235}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50228}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50221}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50235}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50235}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50223}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50217}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50230}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50217}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50234}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50221}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50217}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50217}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50229}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_5"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}), (n2:`Tag`{`id`:"gaming_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50257}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50257}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50258}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50258}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50259}), (n2:`Tag`{`id`:"out_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50259}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`Tag`{`id`:"put_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50261}), (n2:`Tag`{`id`:"how_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50261}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50262}), (n2:`Tag`{`id`:"Capitol Hill_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50262}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50263}), (n2:`Tag`{`id`:"limbo_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50263}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50264}), (n2:`Tag`{`id`:"handle_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50264}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50265}), (n2:`Tag`{`id`:"until_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50265}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50266}), (n2:`Tag`{`id`:"eager_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50266}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50267}), (n2:`Tag`{`id`:"lawsuit_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50267}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50268}), (n2:`Tag`{`id`:"least_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50268}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50269}), (n2:`Tag`{`id`:"avoid_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50269}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50270}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50270}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50271}), (n2:`Tag`{`id`:"which_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50271}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}), (n2:`Tag`{`id`:"late February_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50273}), (n2:`Tag`{`id`:"ugly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50273}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50274}), (n2:`Tag`{`id`:"transition_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50274}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50275}), (n2:`Tag`{`id`:"after_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50275}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50276}), (n2:`Tag`{`id`:"political_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50276}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50277}), (n2:`Tag`{`id`:"team_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50277}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50278}), (n2:`Tag`{`id`:"election_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50278}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50279}), (n2:`Tag`{`id`:"pileup_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50279}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`Tag`{`id`:"United States Court of Appeals for the District of Columbia Circuit_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_6"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50266}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50266}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50269}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50279}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50273}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50279}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50276}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50269}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50279}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50266}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50258}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50258}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50262}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50262}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50258}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50262}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50277}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50270}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50277}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50274}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50266}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50277}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50277}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50264}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50259}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50264}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50261}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50256}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50264}) CREATE (n1)-[r:`ADVCL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50264}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50267}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50267}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50267}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50271}) CREATE (n1)-[r:`REF`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50278}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50275}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50278}) CREATE (n1)-[r:`NMOD` {`specific`:"after"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50257}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50267}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50263}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50265}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50268}) CREATE (n1)-[r:`NMOD:NPMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50272}) CREATE (n1)-[r:`NMOD` {`specific`:"until"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`NMOD` {`specific`:"agent"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50260}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50280}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_6"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50286}), (n2:`Tag`{`id`:"yet_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50286}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50287}), (n2:`Tag`{`id`:"ready_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50287}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50288}), (n2:`Tag`{`id`:"strategy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50288}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50289}), (n2:`Tag`{`id`:"divulge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_7"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50289}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50287}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50287}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50287}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50286}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50287}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50289}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50289}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50288}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_7"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50304}), (n2:`Tag`{`id`:"Congress_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50304}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50305}), (n2:`Tag`{`id`:"Blando_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50305}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50306}), (n2:`Tag`{`id`:"transition_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50306}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50307}), (n2:`Tag`{`id`:"pend_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50307}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50308}), (n2:`Tag`{`id`:"Obama_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50308}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50309}), (n2:`Tag`{`id`:"comment_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50309}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50310}), (n2:`Tag`{`id`:"spokesman_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50310}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50311}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50311}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50312}), (n2:`Tag`{`id`:"would_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50312}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50313}), (n2:`Tag`{`id`:"effort_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50313}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50314}), (n2:`Tag`{`id`:"litigation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50314}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50315}), (n2:`Tag`{`id`:"say_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50315}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50316}), (n2:`Tag`{`id`:"inappropriate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50316}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50317}), (n2:`Tag`{`id`:"Phillip_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50317}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50318}), (n2:`Tag`{`id`:"give_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50318}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50319}), (n2:`Tag`{`id`:"involve_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50319}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50320}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_8"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50320}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50315}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50315}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50316}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50318}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50314}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50307}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50319}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50314}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50318}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50319}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50311}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50308}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50319}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50311}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50319}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50304}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50311}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50304}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50316}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50312}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50315}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50316}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50316}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50309}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50305}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50317}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50315}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50305}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50305}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50310}) CREATE (n1)-[r:`APPOS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50313}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50320}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50313}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50306}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50310}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50313}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_8"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50331}), (n2:`Tag`{`id`:"all_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50331}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50332}), (n2:`Tag`{`id`:"office_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50332}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50333}), (n2:`Tag`{`id`:"related_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50333}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50334}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50334}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50335}), (n2:`Tag`{`id`:"upon_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50335}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50336}), (n2:`Tag`{`id`:"case_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50336}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}), (n2:`Tag`{`id`:"evaluate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}), (n2:`Tag`{`id`:"Affordable Care Act_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50339}), (n2:`Tag`{`id`:"take_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50339}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50340}), (n2:`Tag`{`id`:"aspect_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50340}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50341}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_9"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50341}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50339}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50335}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50339}) CREATE (n1)-[r:`ADVCL` {`specific`:"upon"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50339}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50332}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50334}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50341}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50334}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50336}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50340}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50331}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50340}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50333}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50337}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50340}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50340}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50338}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_9"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50359}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50359}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50360}), (n2:`Tag`{`id`:"spending_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50360}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50361}), (n2:`Tag`{`id`:"decision_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50361}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50362}), (n2:`Tag`{`id`:"dispute_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50362}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50363}), (n2:`Tag`{`id`:"without_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50363}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50364}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50364}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50365}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50365}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50366}), (n2:`Tag`{`id`:"2015_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50366}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50367}), (n2:`Tag`{`id`:"approval_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50367}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50368}), (n2:`Tag`{`id`:"standing_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50368}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50369}), (n2:`Tag`{`id`:"insurance_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50369}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50370}), (n2:`Tag`{`id`:"judge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50370}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50371}), (n2:`Tag`{`id`:"Rosemary_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50371}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50372}), (n2:`Tag`{`id`:"from_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50372}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50373}), (n2:`Tag`{`id`:"Obama_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50373}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50374}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50374}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50375}), (n2:`Tag`{`id`:"sue_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50375}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50376}), (n2:`Tag`{`id`:"Congress_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50376}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50377}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50377}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50378}), (n2:`Tag`{`id`:"Collyer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50378}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50379}), (n2:`Tag`{`id`:"executive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50379}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50380}), (n2:`Tag`{`id`:"violation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50380}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}), (n2:`Tag`{`id`:"rule_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50382}), (n2:`Tag`{`id`:"branch_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50382}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50383}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50383}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50384}), (n2:`Tag`{`id`:"potentially_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50384}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50385}), (n2:`Tag`{`id`:"over_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50385}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50386}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50386}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}), (n2:`Tag`{`id`:"distribute_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50388}), (n2:`Tag`{`id`:"constitution_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_10"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50388}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50361}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50384}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50361}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50361}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50366}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50378}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50370}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50378}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50371}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50378}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50359}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50386}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50364}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50359}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50364}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50364}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50368}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50368}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50375}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50382}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50379}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50375}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50382}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50362}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50385}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50362}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50360}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50375}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50362}) CREATE (n1)-[r:`NMOD` {`specific`:"over"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50377}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50373}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50377}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50383}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50381}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50364}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50374}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50365}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50374}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50369}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50374}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50380}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50380}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50388}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50367}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50363}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50387}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50367}) CREATE (n1)-[r:`NMOD` {`specific`:"without"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50376}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50372}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50367}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50376}) CREATE (n1)-[r:`NMOD` {`specific`:"from"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_10"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50398}), (n2:`Tag`{`id`:"quickly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50398}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50399}), (n2:`Tag`{`id`:"decision_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50399}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50400}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50400}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50401}), (n2:`Tag`{`id`:"confident_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50401}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50402}), (n2:`Tag`{`id`:"appeal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50402}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}), (n2:`Tag`{`id`:"appeal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}), (n2:`Tag`{`id`:"remain_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50405}), (n2:`Tag`{`id`:"would_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50405}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50406}), (n2:`Tag`{`id`:"Justice Department_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50406}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50407}), (n2:`Tag`{`id`:"judge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50407}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50408}), (n2:`Tag`{`id`:"place_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50408}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50409}), (n2:`Tag`{`id`:"reverse_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50409}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50410}), (n2:`Tag`{`id`:"Collyer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50410}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50411}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50411}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50412}), (n2:`Tag`{`id`:"during_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_11"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50412}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50406}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50406}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50406}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50406}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50401}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50410}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50407}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50399}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50410}) CREATE (n1)-[r:`NMOD:POSS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50409}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50399}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50409}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50405}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50401}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50409}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50398}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50411}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50400}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50403}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50408}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50402}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50412}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50404}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50402}) CREATE (n1)-[r:`NMOD` {`specific`:"during"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_11"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}), (n2:`Tag`{`id`:"discuss_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50433}), (n2:`Tag`{`id`:"effect_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50433}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50434}), (n2:`Tag`{`id`:"court_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50434}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50435}), (n2:`Tag`{`id`:"after_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50435}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50436}), (n2:`Tag`{`id`:"potential_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50436}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50437}), (n2:`Tag`{`id`:"after_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50437}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50438}), (n2:`Tag`{`id`:"successfully_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50438}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50439}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50439}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50440}), (n2:`Tag`{`id`:"option_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50440}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50441}), (n2:`Tag`{`id`:"inauguration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50441}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50442}), (n2:`Tag`{`id`:"win_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50442}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50443}), (n2:`Tag`{`id`:"seek_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50443}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50444}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50444}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50445}), (n2:`Tag`{`id`:"resolution_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50445}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50446}), (n2:`Tag`{`id`:"transition_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50446}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50447}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50447}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50448}), (n2:`Tag`{`id`:"temporary_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50448}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50449}), (n2:`Tag`{`id`:"team_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50449}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50450}), (n2:`Tag`{`id`:"20_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50450}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50451}), (n2:`Tag`{`id`:"last month_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50451}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50452}), (n2:`Tag`{`id`:"halt_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50452}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50453}), (n2:`Tag`{`id`:"currently_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50453}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50454}), (n2:`Tag`{`id`:"2017_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50454}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50455}), (n2:`Tag`{`id`:"matter_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50455}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`Tag`{`id`:"tell_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50457}), (n2:`Tag`{`id`:"proceedings_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50457}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50458}), (n2:`Tag`{`id`:"take_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_12"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50458}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50443}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50438}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50443}) CREATE (n1)-[r:`ADVCL` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50452}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50448}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50443}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50452}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50452}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50457}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50442}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50435}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50442}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50439}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50443}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50442}) CREATE (n1)-[r:`ADVCL` {`specific`:"after"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50447}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50444}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50447}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50451}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50451}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50451}) CREATE (n1)-[r:`NMOD:TMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50434}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50449}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50446}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50449}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50453}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50456}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50440}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50436}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50440}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50440}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50445}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50445}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50455}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50432}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50458}) CREATE (n1)-[r:`ADVCL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50458}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50433}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50441}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50437}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50458}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50441}) CREATE (n1)-[r:`NMOD` {`specific`:"after"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_12"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50472}), (n2:`Tag`{`id`:"prosecute_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50472}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50473}), (n2:`Tag`{`id`:"he_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50473}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50474}), (n2:`Tag`{`id`:"say_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50474}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50475}), (n2:`Tag`{`id`:"consider_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50475}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50476}), (n2:`Tag`{`id`:"future_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50476}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50477}), (n2:`Tag`{`id`:"appeal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50477}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50478}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50478}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50479}), (n2:`Tag`{`id`:"whether_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50479}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50480}), (n2:`Tag`{`id`:"case_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50480}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}), (n2:`Tag`{`id`:"provide_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50482}), (n2:`Tag`{`id`:"otherwise_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50482}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50483}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50483}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50484}), (n2:`Tag`{`id`:"continue_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50484}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50485}), (n2:`Tag`{`id`:"lawyer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50485}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}), (n2:`Tag`{`id`:"time_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50487}), (n2:`Tag`{`id`:"resolve_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50487}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50488}), (n2:`Tag`{`id`:"suspension_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_13"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50488}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50488}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50488}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50480}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50485}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50483}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50474}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50485}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50474}) CREATE (n1)-[r:`PARATAXIS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50473}) CREATE (n1)-[r:`NMOD:POSS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50476}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50478}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50475}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50486}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50481}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50475}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50484}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50479}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50475}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50484}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50484}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50472}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50487}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50482}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50484}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50487}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50472}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50487}) CREATE (n1)-[r:`CONJ` {`specific`:"or"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50487}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50477}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_13"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}), (n2:`Tag`{`id`:"acknowledge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50502}), (n2:`Tag`{`id`:"cascade_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50502}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50503}), (n2:`Tag`{`id`:"stop_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50503}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50504}), (n2:`Tag`{`id`:"which_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50504}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50505}), (n2:`Tag`{`id`:"13 billion_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50505}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50506}), (n2:`Tag`{`id`:"official_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50506}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50507}), (n2:`Tag`{`id`:"effect_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50507}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50508}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50508}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50509}), (n2:`Tag`{`id`:"possibility_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50509}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50510}), (n2:`Tag`{`id`:"total_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50510}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50511}), (n2:`Tag`{`id`:"Republican_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50511}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50512}), (n2:`Tag`{`id`:"suddenly_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50512}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50513}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50513}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50514}), (n2:`Tag`{`id`:"payment_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50514}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50515}), (n2:`Tag`{`id`:"estimate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50515}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50516}), (n2:`Tag`{`id`:"leadership_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_14"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50516}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50506}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50511}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50506}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50516}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50506}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50506}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50513}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50509}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50507}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50502}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50509}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50507}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50510}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50514}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50503}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50514}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50514}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50504}) CREATE (n1)-[r:`REF`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50510}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50508}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50514}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50510}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50505}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50505}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50503}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50512}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50501}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50503}) CREATE (n1)-[r:`ADVCL` {`specific`:"if"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_14"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50532}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50532}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}), (n2:`Tag`{`id`:"race_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50534}), (n2:`Tag`{`id`:"would_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50534}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50535}), (n2:`Tag`{`id`:"cost_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50535}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50536}), (n2:`Tag`{`id`:"insurer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50536}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50537}), (n2:`Tag`{`id`:"eligible_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50537}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50538}), (n2:`Tag`{`id`:"drop_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50538}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50539}), (n2:`Tag`{`id`:"lose_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50539}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50540}), (n2:`Tag`{`id`:"exchange_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50540}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50541}), (n2:`Tag`{`id`:"coverage_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50541}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50542}), (n2:`Tag`{`id`:"consumer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50542}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50543}), (n2:`Tag`{`id`:"deductible_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50543}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50544}), (n2:`Tag`{`id`:"money_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50544}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50545}), (n2:`Tag`{`id`:"receive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50545}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50546}), (n2:`Tag`{`id`:"since_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50546}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50547}), (n2:`Tag`{`id`:"pay_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50547}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50548}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_15"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50548}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50545}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50536}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50536}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50536}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50545}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50545}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50532}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50532}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50540}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50540}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50547}) CREATE (n1)-[r:`ACL` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50547}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50535}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50535}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50543}) CREATE (n1)-[r:`NMOD` {`specific`:"such_as"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50542}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50537}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50535}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50542}) CREATE (n1)-[r:`NMOD` {`specific`:"such_as"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50543}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50542}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50548}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50538}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50538}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50541}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50539}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50546}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50539}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50534}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50533}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50539}) CREATE (n1)-[r:`ADVCL` {`specific`:"since"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50539}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50544}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_15"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50558}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50558}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50559}), (n2:`Tag`{`id`:"all_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50559}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50560}), (n2:`Tag`{`id`:"seek_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50560}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`Tag`{`id`:"destabilize_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50562}), (n2:`Tag`{`id`:"quick_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50562}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50563}), (n2:`Tag`{`id`:"cause_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50563}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50564}), (n2:`Tag`{`id`:"lead_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50564}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50565}), (n2:`Tag`{`id`:"loss_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50565}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50566}), (n2:`Tag`{`id`:"exit_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50566}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50567}), (n2:`Tag`{`id`:"other_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50567}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50568}), (n2:`Tag`{`id`:"lack_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50568}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50569}), (n2:`Tag`{`id`:"insurer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50569}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50570}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50570}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50571}), (n2:`Tag`{`id`:"entire_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50571}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50572}), (n2:`Tag`{`id`:"well_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50572}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50573}), (n2:`Tag`{`id`:"confidence_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50573}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50574}), (n2:`Tag`{`id`:"over_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50574}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50575}), (n2:`Tag`{`id`:"program_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_16"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50575}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50559}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50574}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50559}) CREATE (n1)-[r:`NMOD` {`specific`:"over"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50565}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50563}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50565}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50565}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50570}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50558}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50575}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50571}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50575}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50561}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50563}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50563}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50568}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50568}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50573}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50564}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50573}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50573}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50564}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50569}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50567}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50564}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50569}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50560}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50569}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50564}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50560}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50566}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50562}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50560}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50566}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_16"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50588}), (n2:`Tag`{`id`:"mount_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50588}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}), (n2:`Tag`{`id`:"seek_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50590}), (n2:`Tag`{`id`:"dim_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50590}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50591}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50591}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50592}), (n2:`Tag`{`id`:"view_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50592}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50593}), (n2:`Tag`{`id`:"vigorous_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50593}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50594}), (n2:`Tag`{`id`:"intervene_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50594}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50595}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50595}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50596}), (n2:`Tag`{`id`:"fight_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50596}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50597}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50597}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50598}), (n2:`Tag`{`id`:"program_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50598}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50599}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50599}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50600}), (n2:`Tag`{`id`:"against_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50600}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50601}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50601}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50602}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50602}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50603}), (n2:`Tag`{`id`:"case_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50603}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50604}), (n2:`Tag`{`id`:"law_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50604}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50605}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50605}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50606}), (n2:`Tag`{`id`:"behalf_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50606}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50607}), (n2:`Tag`{`id`:"team_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50607}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50608}), (n2:`Tag`{`id`:"might_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50608}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50609}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50609}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50610}), (n2:`Tag`{`id`:"lawyer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50610}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50611}), (n2:`Tag`{`id`:"two_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50611}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50612}), (n2:`Tag`{`id`:"participant_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50612}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50613}), (n2:`Tag`{`id`:"incline_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50613}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50614}), (n2:`Tag`{`id`:"give_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50614}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50615}), (n2:`Tag`{`id`:"this month_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50615}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50616}), (n2:`Tag`{`id`:"anticipate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_17"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50616}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50616}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50601}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50597}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50613}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50601}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50588}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50601}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50613}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50608}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50616}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50613}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50613}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50588}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50596}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50593}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50588}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50596}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50609}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50600}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50609}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50605}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50596}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50609}) CREATE (n1)-[r:`NMOD` {`specific`:"against"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50592}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50614}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50592}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50590}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50596}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50592}) CREATE (n1)-[r:`NMOD` {`specific`:"given"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50604}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50599}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50604}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50602}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50592}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50604}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50607}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50594}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50607}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50607}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50610}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50615}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50615}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50615}) CREATE (n1)-[r:`NMOD:TMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50589}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50594}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50594}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50603}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50594}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50606}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50612}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50611}) CREATE (n1)-[r:`NUMMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50606}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50612}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50598}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50591}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50598}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50595}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50612}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50598}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_17"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50632}), (n2:`Tag`{`id`:"generally_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50632}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50633}), (n2:`Tag`{`id`:"dismiss_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50633}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50634}), (n2:`Tag`{`id`:"deal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50634}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50635}), (n2:`Tag`{`id`:"nation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50635}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50636}), (n2:`Tag`{`id`:"between_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50636}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50637}), (n2:`Tag`{`id`:"individual_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50637}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50638}), (n2:`Tag`{`id`:"settle_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50638}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50639}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50639}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50640}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50640}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50641}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50641}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50642}), (n2:`Tag`{`id`:"case_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50642}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50643}), (n2:`Tag`{`id`:"who_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50643}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}), (n2:`Tag`{`id`:"insurance_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50645}), (n2:`Tag`{`id`:"receive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50645}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50646}), (n2:`Tag`{`id`:"request_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50646}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50647}), (n2:`Tag`{`id`:"produce_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50647}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50648}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50648}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50649}), (n2:`Tag`{`id`:"reduction_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50649}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50650}), (n2:`Tag`{`id`:"devastating_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50650}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50651}), (n2:`Tag`{`id`:"lawyer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50651}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50652}), (n2:`Tag`{`id`:"new_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50652}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50653}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50653}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50655}), (n2:`Tag`{`id`:"system_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50655}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}), (n2:`Tag`{`id`:"predict_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}), (n2:`Tag`{`id`:"consequence_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50658}), (n2:`Tag`{`id`:"well_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_18"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50658}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50646}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50651}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50647}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50634}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50641}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50636}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50641}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50639}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50634}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50641}) CREATE (n1)-[r:`NMOD` {`specific`:"between"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50652}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50634}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}) CREATE (n1)-[r:`NMOD` {`specific`:"between"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50641}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50633}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50654}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50638}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50633}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50638}) CREATE (n1)-[r:`CONJ` {`specific`:"or"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50633}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50642}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50656}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50647}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50650}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50647}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50637}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50645}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50637}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50637}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50643}) CREATE (n1)-[r:`REF`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50637}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50645}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50645}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50649}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50635}) CREATE (n1)-[r:`NMOD:POSS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50640}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50647}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50655}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50648}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50655}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50653}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50657}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50655}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50655}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50644}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50632}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_18"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50671}), (n2:`Tag`{`id`:"power_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50671}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}), (n2:`Tag`{`id`:"want_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50673}), (n2:`Tag`{`id`:"power_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50673}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50674}), (n2:`Tag`{`id`:"branch_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50674}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}), (n2:`Tag`{`id`:"concept_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50676}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50676}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50677}), (n2:`Tag`{`id`:"Congress_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50677}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50678}), (n2:`Tag`{`id`:"prevail_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50678}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50679}), (n2:`Tag`{`id`:"regard_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50679}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50680}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50680}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50681}), (n2:`Tag`{`id`:"purse_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50681}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50682}), (n2:`Tag`{`id`:"matter_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50682}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50683}), (n2:`Tag`{`id`:"violate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50683}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50684}), (n2:`Tag`{`id`:"sue_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50684}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50685}), (n2:`Tag`{`id`:"congressional_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50685}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50686}), (n2:`Tag`{`id`:"two_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50686}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50687}), (n2:`Tag`{`id`:"what_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50687}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50688}), (n2:`Tag`{`id`:"say_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50688}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50689}), (n2:`Tag`{`id`:"overarching_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50689}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50690}), (n2:`Tag`{`id`:"executive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50690}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50691}), (n2:`Tag`{`id`:"spend_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50691}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50692}), (n2:`Tag`{`id`:"happen_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50692}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50693}), (n2:`Tag`{`id`:"right_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50693}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50694}), (n2:`Tag`{`id`:"constitution_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_19"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50694}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50682}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50692}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50687}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50682}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50692}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50680}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50676}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50688}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50680}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50688}) CREATE (n1)-[r:`PARATAXIS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50672}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50678}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50686}) CREATE (n1)-[r:`NUMMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50689}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50678}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50671}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50685}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50671}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50671}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50681}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50675}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50693}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50671}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50693}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50693}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50677}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50693}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50684}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50674}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50690}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50684}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50674}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50684}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50683}) CREATE (n1)-[r:`ADVCL` {`specific`:"if"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50683}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50694}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50683}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50679}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50691}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50673}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_19"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50699}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50699}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50700}), (n2:`Tag`{`id`:"never_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50700}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50701}), (n2:`Tag`{`id`:"require_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50701}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50702}), (n2:`Tag`{`id`:"constitution_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50702}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50703}), (n2:`Tag`{`id`:"subsidy_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50703}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}), (n2:`Tag`{`id`:"appropriate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50705}), (n2:`Tag`{`id`:"Congress_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50705}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50706}), (n2:`Tag`{`id`:"money_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50706}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50707}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50707}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50708}), (n2:`Tag`{`id`:"contend_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_20"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50708}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50708}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50708}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50699}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50707}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50708}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50699}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50705}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50700}) CREATE (n1)-[r:`NEG`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50708}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50706}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50706}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50703}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50704}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50701}) CREATE (n1)-[r:`ADVCL` {`specific`:"as"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50701}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50702}) CREATE (n1)-[r:`NMOD` {`specific`:"by"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_20"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50727}), (n2:`Tag`{`id`:"proper_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50727}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50728}), (n2:`Tag`{`id`:"despite_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50728}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50729}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50729}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50730}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50730}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50731}), (n2:`Tag`{`id`:"funding_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50731}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50732}), (n2:`Tag`{`id`:"suit_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50732}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50733}), (n2:`Tag`{`id`:"widespread_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50733}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50734}), (n2:`Tag`{`id`:"speaker_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50734}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50735}), (n2:`Tag`{`id`:"which_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50735}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50736}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50736}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}), (n2:`Tag`{`id`:"assert_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}), (n2:`Tag`{`id`:"require_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50739}), (n2:`Tag`{`id`:"internal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50739}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50740}), (n2:`Tag`{`id`:"initially_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50740}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50741}), (n2:`Tag`{`id`:"time_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50741}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}), (n2:`Tag`{`id`:"skepticism_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50743}), (n2:`Tag`{`id`:"Treasury Department_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50743}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}), (n2:`Tag`{`id`:"champion_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50745}), (n2:`Tag`{`id`:"later_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50745}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50746}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50746}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50747}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50747}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50748}), (n2:`Tag`{`id`:"John_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50748}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50749}), (n2:`Tag`{`id`:"spending_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50749}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50750}), (n2:`Tag`{`id`:"committee_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50750}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50751}), (n2:`Tag`{`id`:"desperate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50751}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50752}), (n2:`Tag`{`id`:"provide_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50752}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50753}), (n2:`Tag`{`id`:"Boehner_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50753}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}), (n2:`Tag`{`id`:"report_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_21"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50732}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50732}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50732}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50735}) CREATE (n1)-[r:`REF`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50740}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50732}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50753}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50748}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50753}) CREATE (n1)-[r:`NMOD` {`specific`:"agent"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50734}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50729}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50753}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50734}) CREATE (n1)-[r:`APPOS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50734}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50741}) CREATE (n1)-[r:`NMOD` {`specific`:"at"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50745}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50747}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50750}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50744}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}) CREATE (n1)-[r:`NMOD` {`specific`:"agent"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50753}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50754}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50730}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50746}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50746}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50751}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50751}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50731}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50736}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50737}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50743}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50743}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50743}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50752}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50743}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50738}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50752}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50728}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50733}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50739}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50752}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}) CREATE (n1)-[r:`NMOD` {`specific`:"despite"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50727}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50749}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50742}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50727}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_21"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}), (n2:`Tag`{`id`:"part_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50767}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50767}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50768}), (n2:`Tag`{`id`:"one_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50768}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50769}), (n2:`Tag`{`id`:"require_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50769}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50770}), (n2:`Tag`{`id`:"spending_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50770}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50771}), (n2:`Tag`{`id`:"law_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50771}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50772}), (n2:`Tag`{`id`:"annual_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50772}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50773}), (n2:`Tag`{`id`:"White House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50773}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50774}), (n2:`Tag`{`id`:"pass_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50774}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50775}), (n2:`Tag`{`id`:"initially_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50775}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50776}), (n2:`Tag`{`id`:"appropriation_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50776}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50777}), (n2:`Tag`{`id`:"even_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50777}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50778}), (n2:`Tag`{`id`:"permanent_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50778}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50779}), (n2:`Tag`{`id`:"though_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50779}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}), (n2:`Tag`{`id`:"say_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50781}), (n2:`Tag`{`id`:"2010_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50781}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}), (n2:`Tag`{`id`:"seek_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_22"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50773}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50773}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50773}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50770}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50778}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50771}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50771}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50774}) CREATE (n1)-[r:`ACL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50774}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50781}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50776}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50772}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50769}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50776}) CREATE (n1)-[r:`NSUBJPASS`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50780}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50769}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50766}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50769}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50777}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50779}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50767}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50775}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50769}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}) CREATE (n1)-[r:`ADVCL` {`specific`:"though"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50782}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50768}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_22"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50794}), (n2:`Tag`{`id`:"issue_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50794}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50795}), (n2:`Tag`{`id`:"leverage_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50795}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50796}), (n2:`Tag`{`id`:"just_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50796}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50797}), (n2:`Tag`{`id`:"Congress_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50797}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50798}), (n2:`Tag`{`id`:"want_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50798}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50799}), (n2:`Tag`{`id`:"over_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50799}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50800}), (n2:`Tag`{`id`:"ruling_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50800}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50801}), (n2:`Tag`{`id`:"important_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50801}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50802}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50802}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50803}), (n2:`Tag`{`id`:"executive_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50803}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50804}), (n2:`Tag`{`id`:"precedent_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50804}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50805}), (n2:`Tag`{`id`:"standing_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50805}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50806}), (n2:`Tag`{`id`:"many_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50806}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50807}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50807}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50808}), (n2:`Tag`{`id`:"branch_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50808}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50809}), (n2:`Tag`{`id`:"legal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50809}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50810}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50810}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50811}), (n2:`Tag`{`id`:"sue_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50811}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50812}), (n2:`Tag`{`id`:"expert_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50812}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50813}), (n2:`Tag`{`id`:"set_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50813}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50814}), (n2:`Tag`{`id`:"restore_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50814}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50815}), (n2:`Tag`{`id`:"White House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50815}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}), (n2:`Tag`{`id`:"say_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50817}), (n2:`Tag`{`id`:"judge_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50817}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50818}), (n2:`Tag`{`id`:"congressional_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50818}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50819}), (n2:`Tag`{`id`:"Collyer_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50819}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50820}), (n2:`Tag`{`id`:"flaw_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50820}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}), (n2:`Tag`{`id`:"find_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_23"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50801}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50796}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50801}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50810}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50807}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50801}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50810}) CREATE (n1)-[r:`NMOD` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50819}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50817}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50819}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50802}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50797}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50821}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50802}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50802}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50805}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50805}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50811}) CREATE (n1)-[r:`ACL` {`specific`:"to"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50815}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50815}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50811}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50815}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50811}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50794}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50805}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50800}) CREATE (n1)-[r:`DEP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50800}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50812}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50806}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50812}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50809}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50812}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50800}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50820}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50816}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50798}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50820}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50798}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50798}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50804}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50813}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50804}) CREATE (n1)-[r:`NSUBJPASS:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50798}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50813}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50813}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50814}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50795}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50818}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50814}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50795}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50808}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50799}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50808}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50803}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50814}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50808}) CREATE (n1)-[r:`NMOD` {`specific`:"over"}]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_23"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50832}), (n2:`Tag`{`id`:"standing_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50832}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50833}), (n2:`Tag`{`id`:"advocate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50833}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}), (n2:`Tag`{`id`:"have_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50835}), (n2:`Tag`{`id`:"broad_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50835}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50836}), (n2:`Tag`{`id`:"shared_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50836}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50837}), (n2:`Tag`{`id`:"repercussion_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50837}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50838}), (n2:`Tag`{`id`:"presidential_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50838}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50839}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50839}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50840}), (n2:`Tag`{`id`:"view_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50840}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50841}), (n2:`Tag`{`id`:"administration_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50841}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50842}), (n2:`Tag`{`id`:"health_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50842}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50843}), (n2:`Tag`{`id`:"authority_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50843}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50844}), (n2:`Tag`{`id`:"care_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50844}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50845}), (n2:`Tag`{`id`:"may_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50845}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50846}), (n2:`Tag`{`id`:"since_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50846}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`Tag`{`id`:"come_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50848}), (n2:`Tag`{`id`:"fight_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50848}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50849}), (n2:`Tag`{`id`:"those_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50849}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50850}), (n2:`Tag`{`id`:"under_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50850}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50851}), (n2:`Tag`{`id`:"spending_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50851}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50852}), (n2:`Tag`{`id`:"precedent_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50852}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50853}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50853}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50854}), (n2:`Tag`{`id`:"pressure_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50854}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50855}), (n2:`Tag`{`id`:"power_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50855}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50856}), (n2:`Tag`{`id`:"matter_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50856}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50857}), (n2:`Tag`{`id`:"from_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50857}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50858}), (n2:`Tag`{`id`:"could_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_24"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50858}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50855}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50851}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50855}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50855}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50832}) CREATE (n1)-[r:`CONJ` {`specific`:"and"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50832}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50841}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50839}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50841}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50848}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50841}) CREATE (n1)-[r:`NSUBJ:XSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50845}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50854}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50850}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50854}) CREATE (n1)-[r:`NMOD` {`specific`:"under"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50833}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50857}) CREATE (n1)-[r:`CASE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50854}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50833}) CREATE (n1)-[r:`NMOD` {`specific`:"from"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50843}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50838}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50833}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50843}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50848}) CREATE (n1)-[r:`XCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50848}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50853}) CREATE (n1)-[r:`IOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50848}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50856}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50840}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50836}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50856}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50840}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50844}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50842}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50840}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50844}) CREATE (n1)-[r:`NMOD` {`specific`:"on"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50846}) CREATE (n1)-[r:`MARK`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50852}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50849}) CREATE (n1)-[r:`DET`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50852}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50858}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50847}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}) CREATE (n1)-[r:`ADVCL` {`specific`:"since"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50837}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50835}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50834}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50837}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_24"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50865}), (n2:`Tag`{`id`:"illustrate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50865}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50866}), (n2:`Tag`{`id`:"Republicans_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50866}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50867}), (n2:`Tag`{`id`:"era_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50867}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50868}), (n2:`Tag`{`id`:"complicated_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50868}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50869}), (n2:`Tag`{`id`:"might_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50869}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50870}), (n2:`Tag`{`id`:"take_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50870}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}), (n2:`Tag`{`id`:"come_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50872}), (n2:`Tag`{`id`:"how_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50872}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50873}), (n2:`Tag`{`id`:"never_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50873}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50874}), (n2:`Tag`{`id`:"House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50874}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50875}), (n2:`Tag`{`id`:"set_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50875}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50876}), (n2:`Tag`{`id`:"quick_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50876}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}), (n2:`Tag`{`id`:"anticipate_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}), (n2:`Tag`{`id`:"Obama White House_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50879}), (n2:`Tag`{`id`:"cost_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50879}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50880}), (n2:`Tag`{`id`:"dynamics_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50880}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50881}), (n2:`Tag`{`id`:"legal_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50881}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50882}), (n2:`Tag`{`id`:"Trump_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50882}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}), (n2:`Tag`{`id`:"victory_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50884}), (n2:`Tag`{`id`:"when_en"}) CREATE (n1)-[r:`TAG_OCCURRENCE_TAG`]->(n2);
MATCH (n1:`Sentence`{`id`:"0_25"}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50884}) CREATE (n1)-[r:`SENTENCE_TAG_OCCURRENCE`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50875}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50875}) CREATE (n1)-[r:`ROOT`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50875}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50868}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50875}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50880}) CREATE (n1)-[r:`NMOD` {`specific`:"of"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50880}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50865}) CREATE (n1)-[r:`ACL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50872}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50876}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50881}) CREATE (n1)-[r:`AMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50874}) CREATE (n1)-[r:`NMOD` {`specific`:"for"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50867}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50882}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50883}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50867}) CREATE (n1)-[r:`NMOD` {`specific`:"in"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50869}) CREATE (n1)-[r:`AUX`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50865}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}) CREATE (n1)-[r:`CCOMP`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50871}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50879}) CREATE (n1)-[r:`NMOD` {`specific`:"with"}]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50879}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50866}) CREATE (n1)-[r:`NSUBJ`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50873}) CREATE (n1)-[r:`NEG`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50879}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}) CREATE (n1)-[r:`ACL:RELCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50870}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50884}) CREATE (n1)-[r:`ADVMOD`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50877}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50870}) CREATE (n1)-[r:`ADVCL`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}) CREATE (n1)-[r:`COMPOUND`]->(n2);
MATCH (n1:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50870}), (n2:`UNIQUE IMPORT LABEL`{`UNIQUE IMPORT ID`:50878}) CREATE (n1)-[r:`DOBJ`]->(n2);
MATCH (n1:`AnnotatedText`{`id`:"0"}), (n2:`Sentence`{`id`:"0_25"}) CREATE (n1)-[r:`CONTAINS_SENTENCE`]->(n2);
MATCH (n1:`Document`{`id`:"17283"}), (n2:`AnnotatedText`{`id`:"0"}) CREATE (n1)-[r:`HAS_ANNOTATED_TEXT`]->(n2);
MATCH (n:`UNIQUE IMPORT LABEL`)  WITH n LIMIT 20000 REMOVE n:`UNIQUE IMPORT LABEL` REMOVE n.`UNIQUE IMPORT ID`;
DROP CONSTRAINT ON (node:`UNIQUE IMPORT LABEL`) ASSERT node.`UNIQUE IMPORT ID` IS UNIQUE;
