This resource was made by the Go community and wouldn't be possible without you! We appreciate and recognize [all contributors](https://github.com/avelino/awesome-go/graphs/contributors).

Join us on IRC at **#awesome-go** on freenode [web access](http://webchat.freenode.net/?channels=awesome-go)


# Contribution Guidelines

- **To add, remove, or change things on the list:** Submit a pull request

To set this list apart from and compliment the excellent [Go wiki Projects page](https://golang.org/wiki/Projects), awesome-go is a specially curated list for high-quality, actively maintained Go packages and resources.

- List items should be sorted *alphabetically*.
- Each item should be limited to one link
- The link should be the name of the package or project
- Descriptions should be clear, concise, and non-promotional
- Descriptions should follow the link, on the same line
- Needs library 3 (minimum) to create a new category.

Please contribute links to packages/projects you have used or are familiar with. This will help ensure high-quality entries.

If you removed our PR template you can find it [here](https://github.com/avelino/awesome-go/blob/master/.github/PULL_REQUEST_TEMPLATE.md).


## Quality standard

To be on the list, project repositories should adhere to these quality standards (http://goreportcard.com/report/**github_user**/**github_repo**):

- Code functions as documented and expected
- Generally useful to the wider community of Go programmers
- Actively maintained
  - Regular, recent commits
  - Or, for finished projects, issues and pull requests are responded to
- Stable or progressing toward stable
- Thoroughly documented (README, godoc comments, etc.)
- Tests, where practical. If library/program testable, than coverage should be >= 80% for non-data-related packages and >=90% for data related packages. **Notice**: the tests will be reviewed too. We will check your coverage manually if your package's coverage is just a benchmark results.


## Reporting issues

Please open an issue if you would like to discuss anything that could be improved or have suggestions for making the list a more valuable resource. We realize sometimes packages fall into abandonment or have breaking builds for extended periods of time, so if you see that, feel free to change its listing or let us know. We also realize that sometimes projects are just going through transitions or are more experimental in nature. These can still be cool, but we can indicate them as transitory or experimental.

Removal changes will not be applied until they have been pending for a minimum of 1 week (7 days). This grace window benefits projects that may be going through a temporary transition but are otherwise worthy of being on the list.

Thanks everyone!
