# Example Patent Seed Sets
This directory contains example seed sets for use in automated patent landscaping as described in the corresponding paper.

## Hair Dryer seed set
The first, [hair_dryer_large.seed.csv](hair_dryer_large.seed.csv), contains seed patents related to hair dryers. Use this seed set to build a patent landscaping model and apply it to any text snippet to see whether it is likely to be a hair dryer patent.

## Video Codec seed set
The second, [video_codec.seed.csv](video_codec.seed.csv), we have used publicly available data to provide a seed set of patents related to video codecs.

**DISCLAIMER AND SOURCING FOR video_codec.seed.csv**

The file video_codec.seed.csv provides a list of patents for a video codec seed set.  The list is composed of US patents identified by MPEG LA for HEVC, MPEG2, MPEG4, and AVC in the PDFs linked below.  The authors have not reviewed the contents of the patents contained in the list and some of the listed patents may not actually relate to video codecs. The inclusion of this file should not be construed as an acknowledgement that any of the listed patents actually cover any video codec standard.

[http://www.mpegla.com/main/programs/M4v/Documents/m4v-att1.pdf](http://www.mpegla.com/main/programs/M4v/Documents/m4v-att1.pdf)
[http://www.mpegla.com/main/programs/HEVC/Documents/hevc-att1.pdf](http://www.mpegla.com/main/programs/HEVC/Documents/hevc-att1.pdf)
[http://www.mpegla.com/main/programs/M2/Documents/m2-att1.pdf](http://www.mpegla.com/main/programs/M2/Documents/m2-att1.pdf)
[http://www.mpegla.com/main/programs/AVC/Documents/avc-att1.pdf](http://www.mpegla.com/main/programs/AVC/Documents/avc-att1.pdf)
