// @license
// Copyright The Closure Library Authors.
// SPDX-License-Identifier: Apache-2.0

/**
 * @fileoverview List formatting symbols for all locales.
 *
 * This file is autogenerated by a script.
 * File generated from CLDR ver. 43
 *
 * To reduce the file size (which may cause issues in some JS
 * developing environments), this file will only contain locales
 * that are usually supported by Google products. It is a super
 * set of 40 languages. The rest of the data can be found in another file
 * named "listsymbolsext.js", which will be generated at the same
 * time as this file.
 *
 */

// clang-format off

goog.module('goog.i18n.ListFormatSymbols');


/**
 * Collection of List formatting symbols symbols for each locale
 *   Each is an array for styles LONG, SHORT, NARROW.
 * @typedef{{
 *   AND_START: !Array<string>,
 *   AND_TWO: (!Array<string>|undefined),
 *   AND_MIDDLE: (!Array<string>|undefined),
 *   AND_END: (!Array<string>|undefined),
 *   OR_START: (!Array<string>|undefined),
 *   OR_TWO: (!Array<string>|undefined),
 *   OR_MIDDLE: (!Array<string>|undefined),
 *   OR_END: (!Array<string>|undefined),
 *   UNIT_START: (!Array<string>|undefined),
 *   UNIT_TWO: (!Array<string>|undefined),
 *   UNIT_MIDDLE: (!Array<string>|undefined),
 *   UNIT_END: (!Array<string>|undefined)
 *  }}
 */
let ListFormatSymbols;

/**
 * @typedef {!ListFormatSymbols}
 */
exports.ListFormatSymbols;

/**
 * List formatting symbols for locale af.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_af = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} en {1}', '{0} en {1}', '{0} en {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0}, {1}'],
  OR_TWO: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0} en {1}', '{0} en {1}']
};

/**
 * List formatting symbols for locale am.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_am = {
  AND_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}, {1}'],
  AND_TWO: ['{0} እና {1}', '{0} እና {1}', '{0} እና {1}'],
  AND_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  AND_END: ['{0}, እና {1}', '{0}, እና {1}', '{0}, እና {1}'],
  OR_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_TWO: ['{0} ወይም {1}﻿', '{0} ወይም {1}﻿', '{0} ወይም {1}﻿'],
  OR_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  OR_END: ['{0}፣ ወይም {1}', '{0}፣ ወይም {1}', '{0}፣ ወይም {1}'],
  UNIT_START: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  UNIT_MIDDLE: ['{0}፣ {1}', '{0}፣ {1}', '{0}፣ {1}'],
  UNIT_END: ['{0}፣ {1}', '{0}፣ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ar.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_DZ.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_DZ = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale ar_EG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ar_EG = {
  AND_START: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  AND_END: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  OR_START: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_MIDDLE: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  OR_END: ['{0} أو {1}', '{0} أو {1}', '{0} أو {1}'],
  UNIT_START: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_TWO: ['{0} و{1}', '{0} و{1}', '{0} و{1}'],
  UNIT_MIDDLE: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}'],
  UNIT_END: ['{0}، و{1}', '{0}، و{1}', '{0} و{1}']
};

/**
 * List formatting symbols for locale az.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_az = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} və {1}', '{0} və {1}', '{0}, {1}'],
  OR_END: ['{0}, yaxud {1}', '{0}, yaxud {1}', '{0}, yaxud {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale be.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_be = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} і {1}', '{0} і {1}', '{0} і {1}'],
  OR_END: ['{0} ці {1}', '{0} ці {1}', '{0} ці {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale bg.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bg = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  OR_TWO: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_TWO: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  UNIT_END: ['{0} и {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} এবং {1}', '{0} এবং {1}', '{0}, {1}'],
  OR_END: ['{0}, বা {1}', '{0}, বা {1}', '{0}, বা {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale br.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_br = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ha {1}', '{0} & {1}', '{0} & {1}'],
  OR_END: ['{0} pe {1}', '{0} pe {1}', '{0} pe {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale bs.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_bs = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale ca.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ca = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale chr.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_chr = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ᎠᎴ {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, ᎠᎴ {1}', '{0}, & {1}', '{0}, & {1}'],
  OR_TWO: ['{0} ᎠᎴᏱᎩ {1}', '{0} ᎠᎴᏱᎩ {1}', '{0} ᎠᎴᏱᎩ {1}'],
  OR_END: ['{0}, ᎠᎴᏱᎩ {1}', '{0}, ᎠᎴᏱᎩ {1}', '{0}, ᎠᎴᏱᎩ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale cs.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cs = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} a {1}', '{0} a {1}', '{0}, {1}'],
  OR_END: ['{0} nebo {1}', '{0} nebo {1}', '{0} nebo {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} a {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} a {1}', '{0} a {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale cy.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_cy = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} a(c) {1}', '{0} a(c) {1}', '{0}, {1}'],
  AND_END: ['{0}, a(c) {1}', '{0}, a(c) {1}', '{0}, {1}'],
  OR_TWO: ['{0} neu {1}', '{0} neu {1}', '{0} neu {1}'],
  OR_END: ['{0} neu {1}', '{0} neu {1}', '{0} neu {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale da.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_da = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}']
};

/**
 * List formatting symbols for locale de.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale de_AT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_AT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale de_CH.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_de_CH = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}'],
  OR_END: ['{0} oder {1}', '{0} oder {1}', '{0} oder {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0} und {1}', '{0} und {1}', '{0} und {1}']
};

/**
 * List formatting symbols for locale el.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_el = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} και {1}', '{0} και {1}', '{0}, {1}'],
  OR_END: ['{0} ή {1}', '{0} ή {1}', '{0} ή {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_AU.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_AU = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_CA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_CA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_GB.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_GB = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_IE.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_IE = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_IN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_IN = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, and {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_SG.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_SG = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_US.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_US = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} and {1}', '{0} & {1}', '{0}, {1}'],
  AND_END: ['{0}, and {1}', '{0}, & {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale en_ZA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_en_ZA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} and {1}', '{0} and {1}', '{0}, {1}'],
  OR_END: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_419.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_419 = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_ES.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_ES = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_MX.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_MX = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} y {1}', '{0} y {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale es_US.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_es_US = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} y {1}', '{0} y {1}', '{0} y {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} y {1}', '{0} y {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale et.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_et = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0} ja {1}', '{0}, {1}'],
  OR_END: ['{0} või {1}', '{0} või {1}', '{0} või {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale eu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_eu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} eta {1}', '{0} eta {1}', '{0}, {1}'],
  OR_END: ['{0} edo {1}', '{0} edo {1}', '{0} edo {1}'],
  UNIT_END: ['{0} eta {1}', '{0} eta {1}', '{0} eta {1}']
};

/**
 * List formatting symbols for locale fa.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fa = {
  AND_START: ['{0}،‏ {1}', '{0}،‏ {1}', '{0}،‏ {1}'],
  AND_TWO: ['{0} و {1}', '{0} و {1}', '{0}،‏ {1}'],
  AND_END: ['{0}، و {1}', '{0}، و {1}', '{0}،‏ {1}'],
  OR_TWO: ['{0} یا {1}', '{0} یا {1}', '{0} یا {1}'],
  OR_END: ['{0}، یا {1}', '{0}، یا {1}', '{0}، یا {1}'],
  UNIT_START: ['{0}،‏ {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_TWO: ['{0} و {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}،‏ {1}', '{0}،‏ {1}', '{0} {1}'],
  UNIT_END: ['{0}، و {1}', '{0}، و {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ja {1}', '{0} ja {1}', '{0} ja {1}'],
  OR_END: ['{0} tai {1}', '{0} tai {1}', '{0} tai {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} ja {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fil.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fil = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} at {1}', '{0} at {1}', '{0}, {1}'],
  AND_END: ['{0}, at {1}', '{0}, at {1}', '{0}, {1}'],
  OR_TWO: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  OR_END: ['{0}, o {1}', '{0}, o {1}', '{0}, o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale fr_CA.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_fr_CA = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} et {1}', '{0} et {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} et {1}', '{0} et {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ga.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ga = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} agus {1}', '{0} agus {1}', '{0}, {1}'],
  OR_END: ['{0} nó {1}', '{0} nó {1}', '{0} nó {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} agus {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale gl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gsw.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gsw = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} und {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale gu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_gu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} અને {1}', '{0} અને {1}', '{0}, {1}'],
  OR_END: ['{0}, અથવા {1}', '{0}, અથવા {1}', '{0}, અથવા {1}'],
  UNIT_TWO: ['{0} અને {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale haw.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_haw = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale he.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_he = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ו{1}', '{0} ו{1}', '{0} ו{1}'],
  OR_END: ['{0} או {1}', '{0} או {1}', '{0} או {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} ו-{1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} और {1}', '{0} और {1}', '{0} और {1}'],
  AND_END: ['{0}, और {1}', '{0} और {1}', '{0} और {1}'],
  OR_TWO: ['{0} या {1}', '{0} या {1}', '{0} या {1}'],
  OR_END: ['{0} या {1}', '{0} या {1}', '{0} या {1}'],
  UNIT_TWO: ['{0} और {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, और {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hr.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hr = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale hu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} és {1}', '{0} és {1}', '{0} és {1}'],
  OR_END: ['{0} vagy {1}', '{0} vagy {1}', '{0} vagy {1}'],
  UNIT_END: ['{0} és {1}', '{0} és {1}', '{0} és {1}']
};

/**
 * List formatting symbols for locale hy.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_hy = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} և {1}', '{0} և {1}', '{0}, {1}'],
  OR_END: ['{0} կամ {1}', '{0} կամ {1}', '{0} կամ {1}'],
  UNIT_START: ['{0}, {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} և {1}', '{0} և {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale id.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_id = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  AND_END: ['{0}, dan {1}', '{0}, dan {1}', '{0}, {1}'],
  OR_TWO: ['{0} atau {1}', '{0} atau {1}', '{0} atau {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale in.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_in = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  AND_END: ['{0}, dan {1}', '{0}, dan {1}', '{0}, {1}'],
  OR_TWO: ['{0} atau {1}', '{0} atau {1}', '{0} atau {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale is.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_is = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0}, {1}'],
  OR_END: ['{0} eða {1}', '{0} eða {1}', '{0} eða {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}']
};

/**
 * List formatting symbols for locale it.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_it = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}'],
  OR_END: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale iw.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_iw = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ו{1}', '{0} ו{1}', '{0} ו{1}'],
  OR_END: ['{0} או {1}', '{0} או {1}', '{0} או {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} ו-{1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ja.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ja = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  OR_END: ['{0}、または{1}', '{0}、または{1}', '{0}、または{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale ka.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ka = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} და {1}', '{0} და {1}', '{0} და {1}'],
  OR_END: ['{0} ან {1}', '{0} ან {1}', '{0} ან {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale kk.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kk = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} және {1}', '{0} және {1}', '{0} және {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} не {1}', '{0} не {1}', '{0} не {1}'],
  OR_END: ['{0}, не болмаса {1}', '{0}, не болмаса {1}', '{0}, не болмаса {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale km.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_km = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} និង​{1}', '{0} និង {1}', '{0}, {1}'],
  AND_END: ['{0} និង {1}', '{0} និង {1}', '{0}, {1}'],
  OR_TWO: ['{0} ឬ {1}', '{0} ឬ {1}', '{0} ឬ {1}'],
  OR_END: ['{0} ឬ {1}', '{0} ឬ {1}', '{0} ឬ {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale kn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_kn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ಮತ್ತು {1}', '{0} ಮತ್ತು {1}', '{0}, {1}'],
  AND_END: ['{0}, ಮತ್ತು {1}', '{0}, ಮತ್ತು {1}', '{0}, {1}'],
  OR_TWO: ['{0} ಅಥವಾ {1}', '{0} ಅಥವಾ {1}', '{0} ಅಥವಾ {1}'],
  OR_END: ['{0}, ಅಥವಾ {1}', '{0}, ಅಥವಾ {1}', '{0}, ಅಥವಾ {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ko.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ko = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} 및 {1}', '{0} 및 {1}', '{0} 및 {1}'],
  OR_END: ['{0} 또는 {1}', '{0} 또는 {1}', '{0} 또는 {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ky.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ky = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} жана {1}', '{0} жана {1}', '{0} жана {1}'],
  OR_END: ['{0} же {1}', '{0} же {1}', '{0} же {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ln.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ln = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale lo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ແລະ {1}', '{0} ແລະ {1}', '{0} ແລະ {1}'],
  AND_END: ['{0}, {1}', '{0} ແລະ {1}', '{0}, {1}'],
  OR_TWO: ['{0} ຫຼື {1}', '{0} ຫຼື {1}', '{0} ຫຼື {1}'],
  OR_END: ['{0} ຫຼື {1}', '{0} ຫຼື {1}', '{0} ຫຼື {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lt.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lt = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ir {1}', '{0} ir {1}', '{0} ir {1}'],
  OR_END: ['{0} ar {1}', '{0} ar {1}', '{0} ar {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} ir {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale lv.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_lv = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} un {1}', '{0} un {1}', '{0} un {1}'],
  OR_END: ['{0} vai {1}', '{0} vai {1}', '{0} vai {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} un {1}', '{0} un {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mk.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mk = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale ml.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ml = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} കൂടാതെ {1}', '{0} കൂടാതെ {1}', '{0}, {1} എന്നിവ'],
  AND_END: ['{0}, {1} എന്നിവ', '{0}, {1} എന്നിവ', '{0}, {1} എന്നിവ'],
  OR_TWO: ['{0} അല്ലെങ്കിൽ {1}', '{0} അല്ലെങ്കിൽ {1}', '{0} അല്ലെങ്കിൽ {1}'],
  OR_END: ['{0}, അല്ലെങ്കിൽ {1}', '{0}, അല്ലെങ്കിൽ {1}', '{0}, അല്ലെങ്കിൽ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_TWO: ['{0} കൂടാതെ {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, {1} зэргийн аль нэг', '{0}, {1} зэргийн аль нэг', '{0}, {1} зэргийн аль нэг'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mo.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mo = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} și {1}', '{0} și {1}', '{0}, {1}'],
  OR_END: ['{0} sau {1}', '{0} sau {1}', '{0} sau {1}'],
  UNIT_TWO: ['{0} și {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale mr.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mr = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} आणि {1}', '{0} आणि {1}', '{0} आणि {1}'],
  OR_END: ['{0}, किंवा {1}', '{0}, किंवा {1}', '{0}, किंवा {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale ms.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ms = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dan {1}', '{0} dan {1}', '{0}, {1}'],
  OR_END: ['{0}, atau {1}', '{0}, atau {1}', '{0}, atau {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0} dan {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale mt.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_mt = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} u {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0}, u {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0} u {1}', '{0} u {1}', '{0}, {1}'],
  UNIT_END: ['{0}, u {1}', '{0}, u {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale my.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_my = {
  AND_START: ['{0} - {1}', '{0} - {1}', '{0} - {1}'],
  AND_END: ['{0}နှင့် {1}', '{0}နှင့် {1}', '{0}နှင့် {1}'],
  OR_END: ['{0} သို့မဟုတ် {1}', '{0} သို့မဟုတ် {1}', '{0} သို့မဟုတ် {1}'],
  UNIT_START: ['{0}- {1}', '{0}- {1}', '{0} {1}'],
  UNIT_TWO: ['{0}နှင့်{1}', '{0}နှင့် {1}', '{0}နှင့် {1}'],
  UNIT_MIDDLE: ['{0}- {1}', '{0}- {1}', '{0} {1}'],
  UNIT_END: ['{0}နှင့် {1}', '{0}နှင့် {1}', '{0}နှင့် {1}']
};

/**
 * List formatting symbols for locale nb.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nb = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ne.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ne = {
  AND_START: ['{0},{1}', '{0},{1}', '{0},{1}'],
  AND_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} र {1}', '{0} र {1}', '{0}, {1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0}, वा {1}', '{0}, वा {1}', '{0}, वा {1}'],
  UNIT_START: ['{0},{1}', '{0},{1}', '{0} {1}'],
  UNIT_TWO: ['{0},{1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}{1}'],
  UNIT_END: ['{0},{1}', '{0},{1}', '{0} {1}']
};

/**
 * List formatting symbols for locale nl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_nl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} en {1}', '{0} en {1}', '{0} en {1}'],
  OR_END: ['{0} of {1}', '{0} of {1}', '{0} of {1}'],
  UNIT_END: ['{0} en {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale no.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_no = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale no_NO.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_no_NO = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} og {1}', '{0} og {1}', '{0} og {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_END: ['{0} og {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale or.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_or = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ଓ {1}', '{0} ଓ {1}', '{0} ଓ {1}'],
  AND_END: ['{0}, ଓ {1}', '{0}, ଓ {1}', '{0}, ଓ {1}'],
  OR_TWO: ['{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}'],
  OR_END: ['{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}', '{0} କିମ୍ବା {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pa.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pa = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ਅਤੇ {1}', '{0} ਅਤੇ {1}', '{0}, {1}'],
  OR_END: ['{0} ਜਾਂ {1}', '{0} ਜਾਂ {1}', '{0} ਜਾਂ {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} lub {1}', '{0} lub {1}', '{0} lub {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale pt.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pt_BR.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_BR = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale pt_PT.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_pt_PT = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} e {1}', '{0} e {1}', '{0}, {1}'],
  OR_END: ['{0} ou {1}', '{0} ou {1}', '{0} ou {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale ro.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ro = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} și {1}', '{0} și {1}', '{0}, {1}'],
  OR_END: ['{0} sau {1}', '{0} sau {1}', '{0} sau {1}'],
  UNIT_TWO: ['{0} și {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale ru.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ru = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0}, {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sh = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale si.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_si = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} සහ {1}', '{0} සහ {1}', '{0} සහ {1}'],
  AND_END: ['{0}, සහ {1}', '{0}, සහ {1}', '{0}, සහ {1}'],
  OR_TWO: ['{0} හෝ {1}', '{0} හෝ {1}', '{0} හෝ {1}'],
  OR_END: ['{0}, හෝ {1}', '{0}, හෝ {1}', '{0}, හෝ {1}'],
  UNIT_TWO: ['{0} සහ {1}', '{0} සහ {1}', '{0} සහ {1}'],
  UNIT_END: ['{0}, සහ {1}', '{0}, සහ {1}', '{0}, සහ {1}']
};

/**
 * List formatting symbols for locale sk.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sk = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} a {1}', '{0} a {1}', '{0} a {1}'],
  AND_END: ['{0} a {1}', '{0} a {1}', '{0} a {1}'],
  OR_TWO: ['{0} alebo {1}', '{0} alebo {1}', '{0} alebo {1}'],
  OR_END: ['{0} alebo {1}', '{0} alebo {1}', '{0} alebo {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale sl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} in {1}', '{0} in {1}', '{0} in {1}'],
  OR_END: ['{0} ali {1}', '{0} ali {1}', '{0} ali {1}'],
  UNIT_END: ['{0} in {1}', '{0} in {1}', '{0} in {1}']
};

/**
 * List formatting symbols for locale sq.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sq = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} dhe {1}', '{0} dhe {1}', '{0} dhe {1}'],
  OR_END: ['{0} ose {1}', '{0} ose {1}', '{0} ose {1}'],
  UNIT_END: ['{0} e {1}', '{0} e {1}', '{0} e {1}']
};

/**
 * List formatting symbols for locale sr.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}'],
  OR_END: ['{0} или {1}', '{0} или {1}', '{0} или {1}'],
  UNIT_END: ['{0} и {1}', '{0} и {1}', '{0} и {1}']
};

/**
 * List formatting symbols for locale sr_Latn.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sr_Latn = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}'],
  OR_END: ['{0} ili {1}', '{0} ili {1}', '{0} ili {1}'],
  UNIT_END: ['{0} i {1}', '{0} i {1}', '{0} i {1}']
};

/**
 * List formatting symbols for locale sv.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sv = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} och {1}', '{0} och {1}', '{0}, {1}'],
  OR_END: ['{0} eller {1}', '{0} eller {1}', '{0} eller {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale sw.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_sw = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} na {1}', '{0} na {1}', '{0}, {1}'],
  AND_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}'],
  OR_TWO: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  OR_END: ['{0} au {1}', '{0} au {1}', '{0} au {1}'],
  UNIT_END: ['{0} na {1}', '{0} na {1}', '{0} na {1}']
};

/**
 * List formatting symbols for locale ta.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ta = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} மற்றும் {1}', '{0} மற்றும் {1}', '{0} மற்றும் {1}'],
  OR_END: ['{0} அல்லது {1}', '{0} அல்லது {1}', '{0} அல்லது {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale te.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_te = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} మరియు {1}', '{0} మరియు {1}', '{0}, {1}'],
  OR_END: ['{0} లేదా {1}', '{0} లేదా {1}', '{0} లేదా {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0}, {1}']
};

/**
 * List formatting symbols for locale th.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_th = {
  AND_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  AND_TWO: ['{0}และ{1}', '{0}และ{1}', '{0}และ{1}'],
  AND_END: ['{0} และ{1}', '{0} และ{1}', '{0} และ{1}'],
  OR_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_TWO: ['{0} หรือ {1}', '{0} หรือ {1}', '{0} หรือ {1}'],
  OR_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  OR_END: ['{0} หรือ {1}', '{0} หรือ {1}', '{0} หรือ {1}'],
  UNIT_TWO: ['{0} และ {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} และ {1}', '{0} และ {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale tl.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tl = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} at {1}', '{0} at {1}', '{0}, {1}'],
  AND_END: ['{0}, at {1}', '{0}, at {1}', '{0}, {1}'],
  OR_TWO: ['{0} o {1}', '{0} o {1}', '{0} o {1}'],
  OR_END: ['{0}, o {1}', '{0}, o {1}', '{0}, o {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale tr.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_tr = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} ve {1}', '{0} ve {1}', '{0}, {1}'],
  OR_END: ['{0} veya {1}', '{0} veya {1}', '{0} veya {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale uk.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uk = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} і {1}', '{0} і {1}', '{0}, {1}'],
  OR_END: ['{0} або {1}', '{0} або {1}', '{0} або {1}'],
  UNIT_END: ['{0} і {1}', '{0} і {1}', '{0} і {1}']
};

/**
 * List formatting symbols for locale ur.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_ur = {
  AND_START: ['{0}، {1}', '{0}، {1}', '{0}، {1}'],
  AND_TWO: ['{0} اور {1}', '{0} اور {1}', '{0}، {1}'],
  AND_END: ['{0}، اور {1}', '{0}، اور {1}', '{0}، {1}'],
  OR_TWO: ['{0} یا {1}', '{0} یا {1}', '{0} یا {1}'],
  OR_END: ['{0}، یا {1}', '{0}، یا {1}', '{0}، یا {1}'],
  UNIT_START: ['{0}, {1}', '{0}، {1}', '{0}، {1}'],
  UNIT_TWO: ['{0}، {1}', '{0} اور {1}', '{0} اور {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}، {1}', '{0}، {1}'],
  UNIT_END: ['{0}، اور {1}', '{0}، اور {1}', '{0}، اور {1}']
};

/**
 * List formatting symbols for locale uz.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_uz = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} va {1}', '{0} va {1}', '{0}, {1}'],
  OR_END: ['{0} yoki {1}', '{0} yoki {1}', '{0} yoki {1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0} {1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale vi.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_vi = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_END: ['{0} và {1}', '{0} và {1}', '{0}, {1}'],
  OR_END: ['{0} hoặc {1}', '{0} hoặc {1}', '{0} hoặc {1}'],
  UNIT_START: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_MIDDLE: ['{0}, {1}', '{0}, {1}', '{0} {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * List formatting symbols for locale zh.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_CN.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_CN = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}、{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0}{1}', '{0}{1}', '{0}{1}'],
  UNIT_END: ['{0}{1}', '{0}{1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_HK.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_HK = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}及{1}', '{0}及{1}', '{0}及{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zh_TW.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zh_TW = {
  AND_START: ['{0}、{1}', '{0}、{1}', '{0}、{1}'],
  AND_END: ['{0}和{1}', '{0}和{1}', '{0}和{1}'],
  OR_END: ['{0}或{1}', '{0}或{1}', '{0}或{1}'],
  UNIT_START: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_MIDDLE: ['{0} {1}', '{0} {1}', '{0}{1}'],
  UNIT_END: ['{0} {1}', '{0} {1}', '{0}{1}']
};

/**
 * List formatting symbols for locale zu.
 * @const ListFormatSymbols
 */
exports.ListFormatSymbols_zu = {
  AND_START: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  AND_TWO: ['{0} ne-{1}', '{0} ne-{1}', '{0}, {1}'],
  AND_END: ['{0}, ne-{1}', '{0}, ne-{1}', '{0}, {1}'],
  OR_TWO: ['{0} or {1}', '{0} or {1}', '{0} or {1}'],
  OR_END: ['{0}, or {1}', '{0}, or {1}', '{0}, or {1}'],
  UNIT_TWO: ['{0}, {1}', '{0}, {1}', '{0}, {1}'],
  UNIT_END: ['{0}, {1}', '{0}, {1}', '{0} {1}']
};

/**
 * Default value, in case nothing else matches
 * @type  {!ListFormatSymbols}
 */
let defaultSymbols = exports.ListFormatSymbols_en;


/**
 * Returns the default ListFormatSymbols
 * @return {!ListFormatSymbols}
 */
exports.getListFormatSymbols = function() {
  return defaultSymbols;
};

/**
 * Sets the default ListFormatSymbols
 * @param {!ListFormatSymbols} symbols
 */
exports.setListFormatSymbols = function(symbols) {
  defaultSymbols = symbols;
};

/**
 * Selecting symbols by locale.
 */
switch (goog.LOCALE) {
  case 'af':
    defaultSymbols = exports.ListFormatSymbols_af;
    break;
  case 'am':
    defaultSymbols = exports.ListFormatSymbols_am;
    break;
  case 'ar':
    defaultSymbols = exports.ListFormatSymbols_ar;
    break;
  case 'ar_DZ':
  case 'ar-DZ':
    defaultSymbols = exports.ListFormatSymbols_ar_DZ;
    break;
  case 'ar_EG':
  case 'ar-EG':
    defaultSymbols = exports.ListFormatSymbols_ar_EG;
    break;
  case 'az':
    defaultSymbols = exports.ListFormatSymbols_az;
    break;
  case 'be':
    defaultSymbols = exports.ListFormatSymbols_be;
    break;
  case 'bg':
    defaultSymbols = exports.ListFormatSymbols_bg;
    break;
  case 'bn':
    defaultSymbols = exports.ListFormatSymbols_bn;
    break;
  case 'br':
    defaultSymbols = exports.ListFormatSymbols_br;
    break;
  case 'bs':
    defaultSymbols = exports.ListFormatSymbols_bs;
    break;
  case 'ca':
    defaultSymbols = exports.ListFormatSymbols_ca;
    break;
  case 'chr':
    defaultSymbols = exports.ListFormatSymbols_chr;
    break;
  case 'cs':
    defaultSymbols = exports.ListFormatSymbols_cs;
    break;
  case 'cy':
    defaultSymbols = exports.ListFormatSymbols_cy;
    break;
  case 'da':
    defaultSymbols = exports.ListFormatSymbols_da;
    break;
  case 'de':
    defaultSymbols = exports.ListFormatSymbols_de;
    break;
  case 'de_AT':
  case 'de-AT':
    defaultSymbols = exports.ListFormatSymbols_de_AT;
    break;
  case 'de_CH':
  case 'de-CH':
    defaultSymbols = exports.ListFormatSymbols_de_CH;
    break;
  case 'el':
    defaultSymbols = exports.ListFormatSymbols_el;
    break;
  case 'en':
    defaultSymbols = exports.ListFormatSymbols_en;
    break;
  case 'en_AU':
  case 'en-AU':
    defaultSymbols = exports.ListFormatSymbols_en_AU;
    break;
  case 'en_CA':
  case 'en-CA':
    defaultSymbols = exports.ListFormatSymbols_en_CA;
    break;
  case 'en_GB':
  case 'en-GB':
    defaultSymbols = exports.ListFormatSymbols_en_GB;
    break;
  case 'en_IE':
  case 'en-IE':
    defaultSymbols = exports.ListFormatSymbols_en_IE;
    break;
  case 'en_IN':
  case 'en-IN':
    defaultSymbols = exports.ListFormatSymbols_en_IN;
    break;
  case 'en_SG':
  case 'en-SG':
    defaultSymbols = exports.ListFormatSymbols_en_SG;
    break;
  case 'en_US':
  case 'en-US':
    defaultSymbols = exports.ListFormatSymbols_en_US;
    break;
  case 'en_ZA':
  case 'en-ZA':
    defaultSymbols = exports.ListFormatSymbols_en_ZA;
    break;
  case 'es':
    defaultSymbols = exports.ListFormatSymbols_es;
    break;
  case 'es_419':
  case 'es-419':
    defaultSymbols = exports.ListFormatSymbols_es_419;
    break;
  case 'es_ES':
  case 'es-ES':
    defaultSymbols = exports.ListFormatSymbols_es_ES;
    break;
  case 'es_MX':
  case 'es-MX':
    defaultSymbols = exports.ListFormatSymbols_es_MX;
    break;
  case 'es_US':
  case 'es-US':
    defaultSymbols = exports.ListFormatSymbols_es_US;
    break;
  case 'et':
    defaultSymbols = exports.ListFormatSymbols_et;
    break;
  case 'eu':
    defaultSymbols = exports.ListFormatSymbols_eu;
    break;
  case 'fa':
    defaultSymbols = exports.ListFormatSymbols_fa;
    break;
  case 'fi':
    defaultSymbols = exports.ListFormatSymbols_fi;
    break;
  case 'fil':
    defaultSymbols = exports.ListFormatSymbols_fil;
    break;
  case 'fr':
    defaultSymbols = exports.ListFormatSymbols_fr;
    break;
  case 'fr_CA':
  case 'fr-CA':
    defaultSymbols = exports.ListFormatSymbols_fr_CA;
    break;
  case 'ga':
    defaultSymbols = exports.ListFormatSymbols_ga;
    break;
  case 'gl':
    defaultSymbols = exports.ListFormatSymbols_gl;
    break;
  case 'gsw':
    defaultSymbols = exports.ListFormatSymbols_gsw;
    break;
  case 'gu':
    defaultSymbols = exports.ListFormatSymbols_gu;
    break;
  case 'haw':
    defaultSymbols = exports.ListFormatSymbols_haw;
    break;
  case 'he':
    defaultSymbols = exports.ListFormatSymbols_he;
    break;
  case 'hi':
    defaultSymbols = exports.ListFormatSymbols_hi;
    break;
  case 'hr':
    defaultSymbols = exports.ListFormatSymbols_hr;
    break;
  case 'hu':
    defaultSymbols = exports.ListFormatSymbols_hu;
    break;
  case 'hy':
    defaultSymbols = exports.ListFormatSymbols_hy;
    break;
  case 'id':
    defaultSymbols = exports.ListFormatSymbols_id;
    break;
  case 'in':
    defaultSymbols = exports.ListFormatSymbols_in;
    break;
  case 'is':
    defaultSymbols = exports.ListFormatSymbols_is;
    break;
  case 'it':
    defaultSymbols = exports.ListFormatSymbols_it;
    break;
  case 'iw':
    defaultSymbols = exports.ListFormatSymbols_iw;
    break;
  case 'ja':
    defaultSymbols = exports.ListFormatSymbols_ja;
    break;
  case 'ka':
    defaultSymbols = exports.ListFormatSymbols_ka;
    break;
  case 'kk':
    defaultSymbols = exports.ListFormatSymbols_kk;
    break;
  case 'km':
    defaultSymbols = exports.ListFormatSymbols_km;
    break;
  case 'kn':
    defaultSymbols = exports.ListFormatSymbols_kn;
    break;
  case 'ko':
    defaultSymbols = exports.ListFormatSymbols_ko;
    break;
  case 'ky':
    defaultSymbols = exports.ListFormatSymbols_ky;
    break;
  case 'ln':
    defaultSymbols = exports.ListFormatSymbols_ln;
    break;
  case 'lo':
    defaultSymbols = exports.ListFormatSymbols_lo;
    break;
  case 'lt':
    defaultSymbols = exports.ListFormatSymbols_lt;
    break;
  case 'lv':
    defaultSymbols = exports.ListFormatSymbols_lv;
    break;
  case 'mk':
    defaultSymbols = exports.ListFormatSymbols_mk;
    break;
  case 'ml':
    defaultSymbols = exports.ListFormatSymbols_ml;
    break;
  case 'mn':
    defaultSymbols = exports.ListFormatSymbols_mn;
    break;
  case 'mo':
    defaultSymbols = exports.ListFormatSymbols_mo;
    break;
  case 'mr':
    defaultSymbols = exports.ListFormatSymbols_mr;
    break;
  case 'ms':
    defaultSymbols = exports.ListFormatSymbols_ms;
    break;
  case 'mt':
    defaultSymbols = exports.ListFormatSymbols_mt;
    break;
  case 'my':
    defaultSymbols = exports.ListFormatSymbols_my;
    break;
  case 'nb':
    defaultSymbols = exports.ListFormatSymbols_nb;
    break;
  case 'ne':
    defaultSymbols = exports.ListFormatSymbols_ne;
    break;
  case 'nl':
    defaultSymbols = exports.ListFormatSymbols_nl;
    break;
  case 'no':
    defaultSymbols = exports.ListFormatSymbols_no;
    break;
  case 'no_NO':
  case 'no-NO':
    defaultSymbols = exports.ListFormatSymbols_no_NO;
    break;
  case 'or':
    defaultSymbols = exports.ListFormatSymbols_or;
    break;
  case 'pa':
    defaultSymbols = exports.ListFormatSymbols_pa;
    break;
  case 'pl':
    defaultSymbols = exports.ListFormatSymbols_pl;
    break;
  case 'pt':
    defaultSymbols = exports.ListFormatSymbols_pt;
    break;
  case 'pt_BR':
  case 'pt-BR':
    defaultSymbols = exports.ListFormatSymbols_pt_BR;
    break;
  case 'pt_PT':
  case 'pt-PT':
    defaultSymbols = exports.ListFormatSymbols_pt_PT;
    break;
  case 'ro':
    defaultSymbols = exports.ListFormatSymbols_ro;
    break;
  case 'ru':
    defaultSymbols = exports.ListFormatSymbols_ru;
    break;
  case 'sh':
    defaultSymbols = exports.ListFormatSymbols_sh;
    break;
  case 'si':
    defaultSymbols = exports.ListFormatSymbols_si;
    break;
  case 'sk':
    defaultSymbols = exports.ListFormatSymbols_sk;
    break;
  case 'sl':
    defaultSymbols = exports.ListFormatSymbols_sl;
    break;
  case 'sq':
    defaultSymbols = exports.ListFormatSymbols_sq;
    break;
  case 'sr':
    defaultSymbols = exports.ListFormatSymbols_sr;
    break;
  case 'sr_Latn':
  case 'sr-Latn':
    defaultSymbols = exports.ListFormatSymbols_sr_Latn;
    break;
  case 'sv':
    defaultSymbols = exports.ListFormatSymbols_sv;
    break;
  case 'sw':
    defaultSymbols = exports.ListFormatSymbols_sw;
    break;
  case 'ta':
    defaultSymbols = exports.ListFormatSymbols_ta;
    break;
  case 'te':
    defaultSymbols = exports.ListFormatSymbols_te;
    break;
  case 'th':
    defaultSymbols = exports.ListFormatSymbols_th;
    break;
  case 'tl':
    defaultSymbols = exports.ListFormatSymbols_tl;
    break;
  case 'tr':
    defaultSymbols = exports.ListFormatSymbols_tr;
    break;
  case 'uk':
    defaultSymbols = exports.ListFormatSymbols_uk;
    break;
  case 'ur':
    defaultSymbols = exports.ListFormatSymbols_ur;
    break;
  case 'uz':
    defaultSymbols = exports.ListFormatSymbols_uz;
    break;
  case 'vi':
    defaultSymbols = exports.ListFormatSymbols_vi;
    break;
  case 'zh':
    defaultSymbols = exports.ListFormatSymbols_zh;
    break;
  case 'zh_CN':
  case 'zh-CN':
    defaultSymbols = exports.ListFormatSymbols_zh_CN;
    break;
  case 'zh_HK':
  case 'zh-HK':
    defaultSymbols = exports.ListFormatSymbols_zh_HK;
    break;
  case 'zh_TW':
  case 'zh-TW':
    defaultSymbols = exports.ListFormatSymbols_zh_TW;
    break;
  case 'zu':
    defaultSymbols = exports.ListFormatSymbols_zu;
    break;
}
