/**
 * @license
 * Copyright The Closure Library Authors.
 * SPDX-License-Identifier: Apache-2.0
 */


goog.provide('goog.dom.Attr');


/**
 * Enum of all html attribute names specified by the HTML specifications.
 * @enum {string}
 */
goog.dom.Attr = {
  ACCEPT: 'accept',
  ACCEPT_CHARSET: 'accept-charset',
  ACCESSKEY: 'accesskey',
  ACTION: 'action',
  ALIGN: 'align',
  ALT: 'alt',
  ARIA_ACTIVEDESCENDANT: 'aria-activedescendant',
  ARIA_ATOMIC: 'aria-atomic',
  ARIA_AUTOCOMPLETE: 'aria-autocomplete',
  ARIA_BUSY: 'aria-busy',
  ARIA_CHECKED: 'aria-checked',
  ARIA_COLCOUNT: 'aria-colcount',
  ARIA_COLINDEX: 'aria-colindex',
  ARIA_COLSPAN: 'aria-colspan',
  ARIA_CONTROLS: 'aria-controls',
  ARIA_CURRENT: 'aria-current',
  ARIA_DESCRIBEDBY: 'aria-describedby',
  ARIA_DETAILS: 'aria-details',
  ARIA_DISABLED: 'aria-disabled',
  ARIA_DROPEFFECT: 'aria-dropeffect',
  ARIA_ERRORMESSAGE: 'aria-errormessage',
  ARIA_EXPANDED: 'aria-expanded',
  ARIA_FLOWTO: 'aria-flowto',
  ARIA_GRABBED: 'aria-grabbed',
  ARIA_HASPOPUP: 'aria-haspopup',
  ARIA_HIDDEN: 'aria-hidden',
  ARIA_INVALID: 'aria-invalid',
  ARIA_KEYSHORTCUTS: 'aria-keyshortcuts',
  ARIA_LABEL: 'aria-label',
  ARIA_LABELLEDBY: 'aria-labelledby',
  ARIA_LEVEL: 'aria-level',
  ARIA_LIVE: 'aria-live',
  ARIA_MODAL: 'aria-modal',
  ARIA_MULTILINE: 'aria-multiline',
  ARIA_MULTISELECTABLE: 'aria-multiselectable',
  ARIA_ORIENTATION: 'aria-orientation',
  ARIA_OWNS: 'aria-owns',
  ARIA_PLACEHOLDER: 'aria-placeholder',
  ARIA_POSINSET: 'aria-posinset',
  ARIA_PRESSED: 'aria-pressed',
  ARIA_READONLY: 'aria-readonly',
  ARIA_RELEVANT: 'aria-relevant',
  ARIA_REQUIRED: 'aria-required',
  ARIA_ROLEDESCRIPTION: 'aria-roledescription',
  ARIA_ROWCOUNT: 'aria-rowcount',
  ARIA_ROWINDEX: 'aria-rowindex',
  ARIA_ROWSPAN: 'aria-rowspan',
  ARIA_SELECTED: 'aria-selected',
  ARIA_SETSIZE: 'aria-setsize',
  ARIA_SORT: 'aria-sort',
  ARIA_VALUEMAX: 'aria-valuemax',
  ARIA_VALUEMIN: 'aria-valuemin',
  ARIA_VALUENOW: 'aria-valuenow',
  ARIA_VALUETEXT: 'aria-valuetext',
  ASYNC: 'async',
  AUTOCOMPLETE: 'autocomplete',
  AUTOFOCUS: 'autofocus',
  AUTOPLAY: 'autoplay',
  AUTOSAVE: 'autosave',
  BGCOLOR: 'bgcolor',
  BORDER: 'border',
  BUFFERED: 'buffered',
  CHALLENGE: 'challenge',
  CELLPADDING: 'cellpadding',
  CELLSPACING: 'cellspacing',
  CHARSET: 'charset',
  CHECKED: 'checked',
  CITE: 'cite',
  CLASS: 'class',
  CODE: 'code',
  CODEBASE: 'codebase',
  COLOR: 'color',
  COLS: 'cols',
  COLSPAN: 'colspan',
  CONTENT: 'content',
  CONTENTEDITABLE: 'contenteditable',
  CONTEXTMENU: 'contextmenu',
  CONTROLS: 'controls',
  COORDS: 'coords',
  DATA: 'data',
  DATETIME: 'datetime',
  DEFAULT: 'default',
  DEFER: 'defer',
  DIR: 'dir',
  DIRNAME: 'dirname',
  DISABLED: 'disabled',
  DOWNLOAD: 'download',
  DRAGGABLE: 'draggable',
  DROPZONE: 'dropzone',
  ENCTYPE: 'enctype',
  FOR: 'for',
  FORM: 'form',
  FORMACTION: 'formaction',
  HEADERS: 'headers',
  HEIGHT: 'height',
  HIDDEN: 'hidden',
  HIGH: 'high',
  HREF: 'href',
  HREFLANG: 'hreflang',
  HTTP_EQUIV: 'http-equiv',
  ICON: 'icon',
  ID: 'id',
  ISMAP: 'ismap',
  ITEMPROP: 'itemprop',
  KEYTYPE: 'keytype',
  KIND: 'kind',
  LABEL: 'label',
  LANG: 'lang',
  LANGUAGE: 'language',
  LIST: 'list',
  LOOP: 'loop',
  LOW: 'low',
  MANIFEST: 'manifest',
  MAX: 'max',
  MAXLENGTH: 'maxlength',
  MEDIA: 'media',
  METHOD: 'method',
  MIN: 'min',
  MULTIPLE: 'multiple',
  MUTED: 'muted',
  NAME: 'name',
  NOVALIDATE: 'novalidate',
  ONBLUR: 'onblur',
  ONCHANGE: 'onchange',
  ONCLICK: 'onclick',
  ONDBLCLICK: 'ondblclick',
  ONFOCUS: 'onfocus',
  ONKEYDOWN: 'onkeydown',
  ONKEYPRESS: 'onkeypress',
  ONKEYUP: 'onkeyup',
  ONLOAD: 'onload',
  ONMOUSEDOWN: 'onmousedown',
  ONMOUSEMOVE: 'onmousemove',
  ONMOUSEOUT: 'onmouseout',
  ONMOUSEOVER: 'onmouseover',
  ONMOUSEUP: 'onmouseup',
  ONRESET: 'onreset',
  ONSELECT: 'onselect',
  ONSUBMIT: 'onsubmit',
  ONUNLOAD: 'onunload',
  OPEN: 'open',
  OPTIMUM: 'optimum',
  PATTERN: 'pattern',
  PING: 'ping',
  PLACEHOLDER: 'placeholder',
  POSTER: 'poster',
  PRELOAD: 'preload',
  RADIOGROUP: 'radiogroup',
  READONLY: 'readonly',
  REL: 'rel',
  REQUIRED: 'required',
  REVERSED: 'reversed',
  ROLE: 'role',
  ROWS: 'rows',
  ROWSPAN: 'rowspan',
  SANDBOX: 'sandbox',
  SCOPE: 'scope',
  SCOPED: 'scoped',
  SEAMLESS: 'seamless',
  SELECTED: 'selected',
  SHAPE: 'shape',
  SIZE: 'size',
  SIZES: 'sizes',
  SPAN: 'span',
  SPELLCHECK: 'spellcheck',
  SRC: 'src',
  SRCDOC: 'srcdoc',
  SRCLANG: 'srclang',
  SRCSET: 'srcset',
  START: 'start',
  STEP: 'step',
  STYLE: 'style',
  SUMMARY: 'summary',
  TABINDEX: 'tabindex',
  TARGET: 'target',
  TITLE: 'title',
  TRANSLATE: 'translate',
  TYPE: 'type',
  USEMAP: 'usemap',
  VALUE: 'value',
  WIDTH: 'width',
  WRAP: 'wrap'
};
