package com.gojek.chuckmqtt.internal.presentation.base

import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider

internal class MqttChuckViewModelFactory(
    private val creators: Map<Class<out Any>, Provider<ViewModel>>
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        val creator = creators[modelClass] ?: creators.entries.firstOrNull {
            modelClass.isAssignableFrom(it.key)
        }?.value ?: throw IllegalArgumentException("unknown model class $modelClass")
        try {
            @Suppress("UNCHECKED_CAST")
            return creator.get() as T
        } catch (e: Exception) {
            throw RuntimeException(e)
        }
    }
}
