
# Contribution Guide

We love your input and we want to make contributions to this project simple and easy. This document contains information and guidelines about contributing to this project. Please read it before you start participating.

## How can I contribute?

- Reporting a bug or submitting a fix
- Proposing new features or future enhancements
- Discussing the current state of the code
- Becoming a maintainer


## Issue reporting

We prefer using RFCs and GitHub issues to report a bug, propose new features, or communicate ideas. Before reporting an issue please make sure of the following things

- Check that the issue has not already been reported.
- Be clear, concise, and precise in your description of the problem.
- Open an issue with a descriptive title and a summary in grammatically correct, complete sentences.
- Include any relevant code to the issue summary.

## We use [Github Flow](https://docs.github.com/en), so all code changes happen through pull requests

Pull requests are the best way to propose changes to the codebase (we use Github Flow). We actively welcome your pull requests:
- Fork the repo and create your branch from master.
- If you've added code that should be tested, add tests.
- If you've changed APIs, update the documentation.
- Ensure the test suite passes.
- Make sure your code lints.
- Issue that pull request!

After the code submission, it requires review and approval from maintainers or code owners. Once the build is passed, community members will help to review the pull request and merge changes.

## Becoming a maintainer

We are always interested in adding new maintainers. What we look for is a series of contributions, good taste, and an ongoing interest in the project.

- Maintainers will have write access to the Dagger repositories.
- There is no strict protocol for becoming a maintainer or PMC member. Candidates for new maintainers are typically people that are active contributors and community members.
- Candidates for new maintainers can also be suggested by current maintainers or PMC members.
- If you would like to become a maintainer, you should start contributing to Dagger in any of the ways mentioned. You might also want to talk to other maintainers and ask for their advice and guidance.

Thanks! ❤ ❤ ❤ ❤ ❤

GO-JEK Tech