package clickstream.health.model

/**
 * Stream of Health events generated by Clickstream which a client can listen and
 * send it to any third party analytics tracker. This can be used to measure
 * the Clickstream SDK event drop rate, socket failure or any other backend issues.
 */
public data class CSHealthEvent(
    val eventName: String,
    val failureReason: String?,
    val timeToConnection: Long?,
    val eventGuids: List<String>?,
    val eventBatchGuids: List<String>?,
    val sessionId: String?,
    val eventCount: Int?
)