/*
 * Universidade Federal do Rio de Janeiro
 * Escola Politecnica
 * Departamento de Eletronica e de Computacao
 * Prof. Marcelo Luiz Drumond Lanza
 * EEL 270 - Computacao II - Turma 2017/2
 *
 * $Author: gabriel.tavora $
 * $Date: 2017/12/21 22:04:50 $
 * $Log: gmtUmlCgiShowWebHelp.c,v $
 * Revision 1.1  2017/12/21 22:04:50  gabriel.tavora
 * Initial revision
 *
 *
 */

#include<stdlib.h>
#include<stdio.h>
#include<string.h>

#include "gmtUmlConst.h"
#include "gmtUmlTypes.h"
#include "./Libraries/mlcgi.h"
#include "gmtUmlErrors.h"
#include "gmtUmlFunctions.h"
#include "gmtUmlWebUserInterface.h"

int
main (int argc, char **argv)
{
  char gmtUmlConfigurationFileName [GMT_UML_MAX_FILE_NAME_LENGTH+1];
  char gmtUmlLanguageName [GMT_UML_MAX_LANGUAGE_LENGTH+1];
  unsigned gmtUmlValidation;
  environmentType gmtUmlEnvironment;
  gmtUmlLanguageType gmtUmlLanguage = gmtUmlEnglish;
  
  memset (gmtUmlConfigurationFileName, 0x00, GMT_UML_MAX_FILE_NAME_LENGTH+1);
  memset (gmtUmlLanguageName, 0x00, GMT_UML_MAX_LANGUAGE_LENGTH+1);
  
  if (mlCgiInitialize(&gmtUmlEnvironment))
    exit (ML_CGI_OK);
  
  if (gmtUmlEnvironment == commandLine)
  {
    switch (gmtUmlLanguage)
    {
      default:
      case gmtUmlEnglish:
      printf ("ERROR: Invalid environment.\n");
      break;
      
      case gmtUmlPortuguese:
      printf ("ERRO: Ambiente invalido.\n");
      break;
    }
    
    exit (gmtUmlErrorInvalidEnvironment);
  }
  
  if ((gmtUmlValidation = mlCgiGetFormStringNoNewLines ("gmtUmlConfigurationFileName", gmtUmlConfigurationFileName, GMT_UML_MAX_FILE_NAME_LENGTH+1)))
  {
    strcpy (gmtUmlConfigurationFileName, GMT_UML_DEFAULT_CONFIG_FILE);
  }
  
  if ((gmtUmlValidation = mlCgiGetFormStringNoNewLines ("gmtUmlLanguage", gmtUmlLanguageName, GMT_UML_MAX_FILE_NAME_LENGTH + 1)))
  {
    strcpy (gmtUmlLanguageName, "english");
  }
  
  gmtUmlLanguage = GmtUmlGetLanguageIndex (gmtUmlLanguageName);
  
  /* HTML HEADER */
  
  mlCgiBeginHttpHeader ("text/html");
  mlCgiEndHttpHeader ();
  
  /* HTML BODY */
  
  printf ("<!DOCTYPE html>");
printf ("<html>");
printf ("<head>");
printf ("	<meta charset=\"utf-8\">");
printf ("	<meta name=\"viewport\" content=\"width=device-width, initial-scale=1, shrink-to-fit=no\">");
printf ("	<link rel=\"icon\" href=\"favicon.ico\">");
printf ("	<link rel=\"stylesheet\" type=\"text/css\" href=\"bootstrap/css/bootstrap.min.css\">");
printf ("	<link rel=\"stylesheet\" href=\"style.css\">");
printf ("	<title>%s</title>", GmtUmlGetWebUserInterface (gmtUmlPageTitle, gmtUmlLanguage));
printf ("</head>");
printf ("<body>");
printf ("	<nav class=\"navbar navbar-expand-lg navbar-light bg-light\">");
printf ("	  <a class=\"navbar-brand\" href=\"/~gabriel.tavora/index.html\">%s</a>", GmtUmlGetWebUserInterface (gmtUmlProjectName, gmtUmlLanguage));
printf ("	  <button class=\"navbar-toggler\" type=\"button\" data-toggle=\"collapse\" data-target=\"#navbarNavAltMarkup\" aria-controls=\"navbarNavAltMarkup\" aria-expanded=\"false\" aria-label=\"Toggle navigation\">");
printf ("	  	<span class=\"navbar-toggler-icon\"></span>");
printf ("	  </button>");
printf ("	  <div class=\"collapse navbar-collapse\" id=\"navbarNavAltMarkup\">");
printf ("	    <div class=\"navbar-nav\">");
printf ("	    	<a class=\"nav-item nav-link\" href=\"gmtUmlMain.cgi?gmtUmlLanguage=%s&gmtUmlConfigurationFileName=%s\">%s</a>", gmtUmlLanguageName, gmtUmlConfigurationFileName, GmtUmlGetWebUserInterface (gmtUmlHome, gmtUmlLanguage));
printf ("	    	<a class=\"nav-item nav-link\" href=\"gmtUmlShowRequestRegistrationForm.cgi?gmtUmlLanguage=%s&gmtUmlConfigurationFileName=%s\">%s</a>", gmtUmlLanguageName, gmtUmlConfigurationFileName, GmtUmlGetWebUserInterface (gmtUmlRegister, gmtUmlLanguage));
printf ("	    	<a class=\"nav-item nav-link\" href=\"gmtUmlShowRequestPasswordResetForm.cgi?gmtUmlLanguage=%s&gmtUmlConfigurationFileName=%s\">%s</a>", gmtUmlLanguageName, gmtUmlConfigurationFileName, GmtUmlGetWebUserInterface (gmtUmlResetPassword, gmtUmlLanguage));
printf ("	    	<a class=\"nav-item nav-link\" href=\"gmtUmlShowWebHelp.cgi?gmtUmlLanguage=%s&gmtUmlConfigurationFileName=%s\">%s</a>", gmtUmlLanguageName, gmtUmlConfigurationFileName, GmtUmlGetWebUserInterface (gmtUmlHelp, gmtUmlLanguage));
printf ("	    	<a class=\"nav-item nav-link\" href=\"gmtUmlShowLicense.cgi?gmtUmlLanguage=%s&gmtUmlConfigurationFileName=%s\">%s</a>", gmtUmlLanguageName, gmtUmlConfigurationFileName, GmtUmlGetWebUserInterface (gmtUmlLicense, gmtUmlLanguage));
printf ("    		<div class=\"nav-item dropdown\">");
printf ("	    		<a class=\"nav-link dropdown-toggle\" href=\"#\" id=\"navbarDropdown\" role=\"button\" data-toggle=\"dropdown\" aria-haspopup=\"true\" aria-expanded=\"false\">");
printf ("     				%s", GmtUmlGetWebUserInterface (gmtUmlLanguageSelect, gmtUmlLanguage));
printf ("    			</a>");
printf ("    			<div class=\"dropdown-menu\" aria-labelledby=\"navbarDropdown\">");
printf ("	      			<a class=\"dropdown-item\" href=\"gmtUmlShowWebHelp.cgi?gmtUmlLanguage=english&gmtUmlConfigurationFileName=%s\"><img src=\"/~gabriel.tavora/images/en-us.png\"> English</a>", gmtUmlConfigurationFileName);
printf ("      				<a class=\"dropdown-item\" href=\"gmtUmlShowWebHelp.cgi?gmtUmlLanguage=portuguese&gmtUmlConfigurationFileName=%s\"><img src=\"/~gabriel.tavora/images/pt-br.png\"> Portuguese</a>", gmtUmlConfigurationFileName);
printf ("      				<a class=\"dropdown-item disabled\" href=\"#\"><img src=\"/~gabriel.tavora/images/de.png\"> German</a>");
printf ("      			</div>");
printf ("	    </div>");
printf ("	  </div>");
printf ("	</nav>");

/* Content */

switch (gmtUmlLanguage)
{
  default:
  case gmtUmlEnglish:
  printf ("	<div class=\"container\">");
printf ("		<div class=\"card content\">");
printf ("			<h4>Help Topics</h4>");
printf ("			<ol>");
printf ("				<li><a href=\"#c1\">About</a></li>");
printf ("				<li><a href=\"#c2\">Version and update log</a></li>");
printf ("				<li><a href=\"#c3\">Functionalities</a>");
printf ("					<ol type=\"I\">");
printf ("						<li><a href=\"#c3.1\">Blablabla</a></li>");
printf ("						<li><a href=\"#c3.2\">Blablabla</a></li>");
printf ("						<li><a href=\"#c3.3\">Blablabla</a></li>");
printf ("					</ol>");
printf ("				</li>");
printf ("				<li><a href=\"#c4\">License</a></li>");
printf ("			</ol>");
printf ("			<div id=\"c1\">");
printf ("				<h5>1. About</h5>");
printf ("				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("			</div>");
printf ("			<div id=\"c2\">");
printf ("				<h5>2. Version and update logs</h5>");
printf ("				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("			</div>");
printf ("			<div id=\"c3\">");
printf ("				<h5>3. Functionalities</h5>");
printf ("				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("				<div>");
printf ("					<h5 id=\"c3.1\">3.1 Blablabla</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("					<h5 id=\"c3.2\">3.2 Blablabla</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("					<h5 id=\"3.3\">3.3 Blablabla</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("				</div>");
printf ("				<h5 id=\"c4\">4. License</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("			</div>");
printf ("			<a href=\"javascript:history.back()\" class=\"forgot-password\">%s</a>", GmtUmlGetWebUserInterface (gmtUmlBack, gmtUmlLanguage));
printf ("		</div>");
printf ("	</div>");
break;

  case gmtUmlPortuguese:
  printf ("	<div class=\"container\">");
printf ("		<div class=\"card content\">");
printf ("			<h4>Topicos de Ajuda</h4>");
printf ("			<ol>");
printf ("				<li><a href=\"#c1\">Sobre</a></li>");
printf ("				<li><a href=\"#c2\">Versao e log de atualizacoes</a></li>");
printf ("				<li><a href=\"#c3\">Funcionalidades</a>");
printf ("					<ol type=\"I\">");
printf ("						<li><a href=\"#c3.1\">Blablabla</a></li>");
printf ("						<li><a href=\"#c3.2\">Blablabla</a></li>");
printf ("						<li><a href=\"#c3.3\">Blablabla</a></li>");
printf ("					</ol>");
printf ("				</li>");
printf ("				<li><a href=\"#c4\">Licenca</a></li>");
printf ("			</ol>");
printf ("			<div id=\"c1\">");
printf ("				<h5>1. Sobre</h5>");
printf ("				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("			</div>");
printf ("			<div id=\"c2\">");
printf ("				<h5>2. Versao e log de atualizacoes</h5>");
printf ("				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("			</div>");
printf ("			<div id=\"c3\">");
printf ("				<h5>3. Funcionalidades</h5>");
printf ("				<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("				tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("				quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("				consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("				cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("				proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("				<div>");
printf ("					<h5 id=\"c3.1\">3.1 Blablabla</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("					<h5 id=\"c3.2\">3.2 Blablabla</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("					<h5 id=\"3.3\">3.3 Blablabla</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("				</div>");
printf ("				<h5 id=\"c4\">4. Licenca</h5>");
printf ("					<p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod");
printf ("					tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam,");
printf ("					quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo");
printf ("					consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse");
printf ("					cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non");
printf ("					proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>");
printf ("			</div>");
printf ("			<a href=\"javascript:history.back()\" class=\"forgot-password\">Retornar</a>");
printf ("		</div>");
printf ("	</div>");
break;
}

printf ("	<div class=\"footer\">");
printf ("		<a href=\"mailto:gabriel.tavora@poli.ufrj.br\">© 2017 Gabriel Montenegro Tavora.</a>");
printf ("	</div>");
printf ("	<script src=\"jquery-3.2.1.js\"></script>");
printf ("	<script src=\"bootstrap/js/bootstrap.bundle.min.js\"></script>");
printf ("</body>");

  mlCgiFreeResources ();
  return ML_CGI_OK;
}

/* $RCSfile: gmtUmlCgiShowWebHelp.c,v $ */
