
# `awesome-llvm-security`

[![GitHub license](https://img.shields.io/github/license/gmh5225/awesome-llvm-security)](https://github.com/gmh5225/awesome-llvm-security/blob/main/LICENSE)

## How to contribute?
- https://github.com/HyunCafe/contribute-practice
- https://docs.github.com/en/get-started/quickstart/contributing-to-projects

## Guide
- https://llvm.org/docs
- https://github.com/rice7th/compilers-resources [A list of compiler related resources]
- https://github.com/learn-llvm/awesome-llvm
- https://github.com/DoctorWkt/acwj
- https://github.com/aalhour/awesome-compilers
- https://github.com/gmh5225/compiler-class
- https://www.llvm.org/docs/tutorial/MyFirstLanguageFrontend/index.html
- https://github.com/true-grue/Compiler-Development
- https://github.com/rust-hosted-langs/book [Writing Interpreters in Rust]
- https://github.com/0xSh4dy/learning_llvm [Learning LLVM]

## Papers
- [SATURN: Software Deobfuscation Framework Based on LLVM](https://arxiv.org/pdf/1909.01752)
- [Modern Obfuscation Techniques](https://is.muni.cz/th/v1f9y/Modern_obfuscation_techniques.pdf)

## IDE Configuration
- https://github.com/gmh5225/Clion-llvm_build [Clion]

## Toolchain 
- https://github.com/Kenvyra/llvm-android [Android LLVM toolchain build scripts]
- https://github.com/swift-nav/swift-toolchains [toolchains used at Swift]

## OLLVM
- https://github.com/obfuscator-llvm/obfuscator
- https://github.com/Cobalt-Strike/obfuscator-llvm
- https://github.com/isrc-cas/flounder
- https://github.com/romangol/Armariries
- https://github.com/amimo/goron
- https://github.com/Ylarod/goron [ndk21]
- https://github.com/emc2314/YANSOllvm
- https://github.com/HikariObfuscator/Hikari
- https://github.com/Lessica/HikariSummer
- https://github.com/61bcdefg/Hikari-LLVM15
- https://github.com/HakonHarnes/emcc-obf [Hikari]
- https://github.com/lich4/llvm-pass-hikari [Independent Hikari]
- https://github.com/WYK15/swift-Ollvm11 [apple llvm 11 (swift-llvm 5.4)]
- https://github.com/DeNA/DeClang
- https://github.com/0x3f97/ollvm-12.x
- https://github.com/kk-laoguo/ollvm-13
- https://github.com/redheart923/ollvm-ext
- https://github.com/sterling0x1/android-ndk-aarch64-host-LLVM6.0-Ollvm-Armariris [ndk17]
- https://github.com/o2e/OLLVM-9.0.1 [ndk-r21d]
- https://github.com/Ant-tree/ObfuscatorNDK [ndk23]
- https://github.com/s3team/gdop
- https://github.com/wolfm/extended-gdop
- https://github.com/bigBestWay/CodeObfs
- https://github.com/SheLLVM/SheLLVM
- https://github.com/amdx1254/capstone-design1-llvm-obfuscation
- https://github.com/Deniskore/llvm
- https://github.com/samdspeare/othread
- https://github.com/NudistBeaaach/Chained-CFG-obfuscation-pass
- https://github.com/veritas501/ToyObfuscator
- https://github.com/tsarpaul/llvm-string-obfuscator
- https://github.com/crvvdev/obfuscator
- https://github.com/zzrcxb/fusor
- https://github.com/bluesadi/Pluto-Obfuscator
- https://github.com/MaxXor/obfuscator-llvm
- https://github.com/svv232/1nsanity
- https://github.com/nlykkei/llvm-ir-obfuscation
- https://github.com/scrt/avcleaner [Based Clang]
- https://github.com/za233/LLVMMyPass
- https://github.com/GoSSIP-SJTU/Armariris
- https://github.com/heroims/obfuscator
- https://github.com/HikariRebooted/HikariCore
- https://github.com/tsarpaul/llvm-string-obfuscator
- https://github.com/SsageParuders/SsagePass
- https://github.com/eshard/obfuscator-llvm
- https://github.com/KpwnZ/sllvm
- https://github.com/open-obfuscator/o-mvll
- https://github.com/trustdecision/td-ollvm
- https://github.com/GANGE666/xVMP
- https://github.com/KomiMoe/Arkari
- https://github.com/thomasxm/Akira-obfuscator 
- https://github.com/Yuerino/obfuscator-pass
- https://github.com/Slattz/ObfusC
- https://github.com/Colerar/labyrinth
- https://github.com/aiglematth/simple_obfuscator
- https://github.com/Despire/llvm-obfuscator
- https://github.com/DrShabulaji/Paper_Obfs
- https://github.com/janoglezcampos/llvm-yx-callobfuscator
- https://github.com/leetonidas/linearize
- https://github.com/jonpalmisc/limoncello
- https://github.com/cainiao1992/ollvm-mingw [mingw-w64 toolchain]
- https://github.com/0xlane/ollvm-rust [rust toolchain]
- https://github.com/Brythzz/cfg-flattening-pass [CFG Flattening for LLVM 17]
- https://github.com/DSusan/LLVM_Obfuscation_Pass [CFG Flattening for LLVM 18]
- https://github.com/dwuid/chenxification [OLLVM 4]
- https://github.com/joaovarelas/Obfuscator-LLVM-16.0 [OLLVM 16]
- https://github.com/MustangYM/ShelbyObfuscator [OLLVM 16]
- https://github.com/AimiP02/BronyaObfus [OLLVM 16]
- https://github.com/wwh1004/ollvm-16 [OLLVM 16]
- https://github.com/za233/Polaris-Obfuscator [OLLVM 16]
- https://github.com/killvxk/llvm-msvc-ex [OLLVM 18]
- https://github.com/can1357/selene/tree/master/apollo-linker [DIY obfuscation linker]

## MSVC Warbird
- https://github.com/gmh5225/warbird-obfuscator
- https://github.com/gmh5225/warbird-runtime
- https://github.com/gmh5225/warbirdvm
- https://github.com/DownWithUp/WarbirdExamples
- https://github.com/gmh5225/warbird-example

## LIFT
- https://github.com/avast/retdec
- https://github.com/lifting-bits/mcsema
- https://github.com/revng/revng
- https://github.com/LLVMParty/TicklingVMProtect
- https://github.com/microsoft/llvm-mctoll
- https://github.com/sh4m2hwz/triton_ast_llvm_ir_translator
- https://github.com/aengelke/rellume
- https://github.com/andybalholm/leaven [IR->GO]
- https://github.com/JonathanSalwan/Triton/issues/1078
- https://github.com/DCNick3/rusty-x86
- https://github.com/nevillegrech/gigahorse-toolchain [EVM]
- https://github.com/balayette/saphIR-project
- https://github.com/JonathanSalwan/Triton/wiki
- https://github.com/JonathanSalwan/Triton/issues/1085
- https://github.com/JonathanSalwan/Triton/commit/0753a0c097fe637beb25b428ff2f0983f14f96d9
- https://github.com/JonathanSalwan/Triton/commit/7af202df2064a6dc95d7fa4bd0dbe5635e5a44fa
- https://github.com/JonathanSalwan/Triton/commit/4e42a22c7a4d970c81875f6474adf284187b452b
- [Triton:Dead Store Elimination](https://github.com/JonathanSalwan/Triton/issues/1130)
- [Triton:Solution of the Hack.lu 2021 OLLVM challenge](https://github.com/JonathanSalwan/Triton/commit/9e6eb2492c7b66e8e1ccc14d75eb89705d108746)
- https://github.com/ergo720/lib86cpu
- https://github.com/fvrmatteo/TritonASTLLVMIRTranslator
- https://github.com/toor-de-force/Ghidra-to-LLVM
- https://github.com/cbwang505/llvmanalyzer [Retdec Example]
- https://github.com/GaloisInc/reopt
- https://github.com/LLVMParty/UnsupportedInstructionsLiftingToLLVM
- https://github.com/JuliaComputingOSS/llvm-cbe [C Backend]
- https://github.com/praeclarum/Iril [LLVM IR to IL]
- https://github.com/trailofbits/binrec-tob [Dynamic Binary Lifting and Recompilation]
- https://github.com/fay59/fcd
- https://github.com/relyze-ltd/LibTCGTranslate [TCG]
- https://github.com/katrinafyi/llvm-translator
- https://github.com/cojocar/bin2llvm
- https://github.com/staticafi/llvm2c [IR->C]
- https://github.com/sunfishcode/llvm2cranelift [LLVM IR to Cranelift IR]
- https://github.com/trailofbits/circuitous [binary->LLVM->circuits]
- https://github.com/superblaubeere27/masxinlingvonta [JVM->LLVM IR]
- https://github.com/jagv091205/Python_to_C_converter [Python->C]
- https://github.com/TBSI-RIOS-Lab/elf-lifter [RISC-V Binary Lifting]
- https://github.com/jeremy-rifkin/wyrm [GCC GIMPLE to LLVM IR]
- https://github.com/loyaltypollution/ida2llvm [IDA to LLVM]
- https://github.com/metalift/metalift [A program synthesis framework for verified lifting applications]

## libcxx
- https://github.com/topjohnwu/libcxx [Without Exception and RTTI]

## libunwind 
- https://github.com/nidefawl/slowstacktrace

## Android Kernel
- https://github.com/nathanchance/android-kernel-clang

## trace
- https://github.com/microsoft/spoor

## JIT
- https://github.com/spencertipping/jit-tutorial
- https://github.com/hfinkel/llvm-project-cxxjit
- https://github.com/vnmakarov/mir
- https://discourse.llvm.org/t/write-jitlink-support-for-a-new-format-architecture/60322 [Jitlink]
- https://github.com/jmmartinez/easy-just-in-time [just-in-time compiler for C++]
- https://github.com/YutaroOrikasa/ljf-project [LLVM based JIT Framework]
- https://github.com/JLLVM/JLLVM [JVM implementation using LLVM as a JIT]
- https://github.com/Themaister/MIPS-LLVM-Jitter [MIPS to LLVM IR recompiler]
- https://github.com/dstogov/ir [Lightweight JIT Compilation Framework]

## Rust Manipulation
- https://github.com/jauhien/iron-kaleidoscope [LLVM tutorial in Rust language]
- https://github.com/maekawatoshiki/vicis
- https://github.com/TheDan64/inkwell
- https://github.com/jamesmth/llvm-plugin-rs [Out-of-tree LLVM passes in Rust]

## Intermediate Representation
- https://github.com/vnmakarov/mir

## Monitor
- https://github.com/trailofbits/monitoring_linux_events
- https://github.com/AndHager/SysCallStubber

## eBPF
- https://github.com/elastic/bpfcov

## WASM
- https://github.com/leaningtech/cheerp-compiler
- https://github.com/wasmerio/wasmer
- https://github.com/bytecodealliance/wasmtime

## Dynamic Binary Instrumentation
- https://github.com/aengelke/instrew
- https://github.com/aengelke/binopt
- https://github.com/QBDI/QBDI

## Assembly Engine
- https://github.com/gmh5225/LLVM-ASM-Engine-cheater

## Symbolic Execution
- https://github.com/insufficiently-caffeinated/caffeine
- https://github.com/R-Fuzz/symsan
- https://github.com/PLSysSec/haybale
- https://github.com/eurecom-s3/symcc

## SMT solving
- https://github.com/mikekben/SLOT [SMT-LLVM Optimizing Translation]

## Runtime Check
- https://github.com/danteisalive/llvm-typecheking

## Mathematics related
- https://github.com/vgvassilev/clad

## Memory Leak Detector
- https://github.com/hygoni/precise-leak-sanitizer

## Sanitizer
- https://github.com/google/sanitizers
- https://github.com/tudasc/TypeART [LLVM-based type and memory allocation tracking sanitizer]

## Static Analysis
- https://github.com/secure-software-engineering/phasar
- https://github.com/JohannesLiu/LLVM-Pass-Analysis-Collection
- https://github.com/andreasfertig/cppinsights
- https://github.com/SCRT/avcleaner
- https://github.com/Ericsson/codechecker
- https://github.com/franchiotta/taintchecker
- https://github.com/mchalupa/dg
- https://github.com/fadyosman/LLVMTaintAnalysis
- https://github.com/llvm/llvm-project/commit/34a7387986a68835680a8b7bef0ea091d57d28b0 [Taint analysis]
- https://github.com/joernio/joern
- https://github.com/enochii/simple-pointer-analysis [Pointer analysis]
- https://github.com/grievejia/andersen [Pointer analysis]
- https://github.com/GaloisInc/yapall [Pointer analysis]
- https://github.com/shivin101/Compiler-Pass [Liveness analysis]
- https://github.com/seahorn/clam
- https://github.com/Veridise/Vanguard [Smart Contracts]
- https://github.com/KDE/clazy [Qt]
- https://github.com/GoSSIP-SJTU/TripleDoggy
- https://github.com/seclab-ucr/SUTURE
- https://github.com/viktormalik/diffkemp [Static analysis of Linux kernel]
- [Lightweight static analysis for many languages. Find bug variants with patterns that look like source code](https://github.com/returntocorp/semgrep)
- https://github.com/satya-das/cppparser [A library to parse C/C++ source as AST]
- [Static analysis tool based on clang, which detects source-to-binary information leaks in C and C++ projects](https://github.com/ergrelet/cpplumber)
- https://github.com/CryptoExperts/wyverse [White-box analytic framework based on LLVM ]
- https://github.com/LLVM-but-worse/maple-ir [Java]

## Clang Build Analysis
- https://github.com/aras-p/ClangBuildAnalyzer

## Crash Analysis
- https://github.com/cisco-open/llvm-crash-analyzer

## DirectX Shader Compiler
- https://github.com/EpicGames/DirectXShaderCompiler

## Virtual Machine 
- https://github.com/jakogut/tinyvm
- https://github.com/gmh5225/tinyvm-msvc
- https://github.com/RodrigoDornelles/3bc-lang
- https://github.com/EladB1/vmPrototype
- https://github.com/marcosantos98/llvm-test
- https://github.com/thesecretclub/riscy-business [RISC-V]
- https://github.com/MaxXSoft/sigma-vm [Sigma]

## DIY Compiler
- https://github.com/ethereum/solidity
- https://github.com/gleam-lang/gleam [type-safe]
- https://github.com/microsoft/checkedc-clang
- https://github.com/RealNeGate/Cuik [Modern C11]
- https://github.com/tylerweston/ccc
- https://github.com/kumachan-mis/umlcc [C]
- https://github.com/lcompilers/lc [C++]
- https://github.com/greydevv/cpp-compiler
- https://github.com/stardust95/TinyCompiler
- https://github.com/drop-stones/Tiny-C
- https://github.com/Kingtous/WebC-llvm-compiler
- https://github.com/tamphi/CompilerDesign-LLVM
- https://github.com/PLC-lang/rusty
- https://github.com/henne90gen/Neon
- https://github.com/tinygo-org/tinygo [GO]
- https://github.com/go-llvm/llgo [GO]
- https://github.com/ab25cq/comelang
- https://github.com/sleirsgoevy/ps4-rop-8cc
- https://github.com/keiichiw/constexpr-8cc
- https://github.com/egunnarsson/llfp
- https://github.com/mirkosertic/Bytecoder [JAVA]
- https://github.com/evanacox/honors-forum-project
- https://github.com/rui314/chibicc
- https://github.com/gmh5225/chibicc-riscv64
- https://github.com/gmh5225/chibicc-riscv
- https://github.com/Nicholas-Baron/little-lang
- https://github.com/tj/luna
- https://github.com/fanx-dev/fanx
- https://github.com/PipeRift/rift
- https://github.com/JuliaLang/julia
- https://github.com/crystal-lang/crystal
- https://github.com/lotabout/write-a-C-interpreter
- https://github.com/foonathan/clauf [C interpreter]
- https://github.com/root-project/cling [C++ interpreter]
- https://github.com/alinalihassan/Lesma
- https://github.com/RoryBrennan1999/PythonCompiler
- https://github.com/skvadrik/re2c [Lexer]
- https://github.com/SimplyDanny/bitsy-llvm
- https://github.com/mikelma/oktac
- https://github.com/One-Language/One
- https://github.com/adorad/adorad
- https://github.com/jfecher/ante
- https://github.com/arcsysu/SYsU-lang
- https://github.com/skyzluo/CS143-Compilers-Stanford
- https://github.com/TinyCC/tinycc [tcc]
- https://github.com/alekmaul/tcc [tcc]
- https://github.com/rochus-keller/TccGen [tcc]
- https://github.com/rswier/c4 [c4]
- https://github.com/EarlGray/c4 [c4 jit]
- https://bellard.org/otcc [otcc-c4]
- https://github.com/sand-lang/sand
- https://github.com/fly-lang/fly
- https://github.com/RainingComputers/ShnooTalk
- https://github.com/spicelang/spice
- https://github.com/Spencer-Comin/Fern
- https://github.com/savi-lang/savi
- https://github.com/artagnon/rhine
- https://github.com/beefytech/Beef
- https://github.com/ValeLang/Vale
- https://github.com/NilFoundation/zkLLVM [zk]
- https://github.com/MoritzGoeckel/MLang
- https://github.com/SjVer/Evi-Lang
- https://github.com/greydevv/mango-compiler
- https://github.com/rems-project/sail
- https://github.com/Fedjmike/mini-c [C]
- https://github.com/masyagin1998/CSC [C]
- https://github.com/larmel/lacc [C]
- https://github.com/SerenityOS/jakt [memory-safe]
- https://github.com/ziglang/zig
- https://github.com/li-script/lightning
- https://github.com/alinalihassan/Lesma
- https://github.com/gmh5225/Tiny
- https://github.com/carbon-language/carbon-lang
- https://github.com/Omyyyy/pycom [python]
- https://github.com/zero9178/Pylir [python]
- https://github.com/rakudo/rakudo [Raku]
- https://github.com/agraef/pure-lang
- https://github.com/Xeouz/vire
- https://github.com/Sokolmish/cw39
- https://github.com/lethalbit/clank [A C++ Front-end based on LLVM's clang]
- https://github.com/Juicestus/Capstone
- https://github.com/ange-yaghi/piranha
- https://github.com/leanprover/lean4
- https://github.com/krispybyte/virtual-machine [A virtual machine with an included lexer]
- https://github.com/glouw/c8c [compiler, assembler, and virtual machine]
- https://github.com/NVIDIA/MDL-SDK [NVIDIA Material Definition Language SDK]
- https://github.com/spicelang/spice
- https://github.com/yume-lang/yume
- https://github.com/Nicholas-Baron/little-lang
- https://github.com/kamkow1/yup
- https://github.com/brwhale/KataScript [Script]
- https://github.com/XChy/XSharp
- https://github.com/alan123piano/functional-lang
- https://github.com/KCreate/charly-vm [Bytecode virtual machine]
- https://github.com/xinyu-evolutruster/CsGo-Compiler
- https://github.com/thradams/cake [Cake a C23 front end and transpiler written in C]
- https://github.com/garc0/GachiC
- https://github.com/Retr0Wawe/STXA
- https://github.com/eokas/eokas-lang
- https://github.com/parsabee/Quack-v2
- https://github.com/darealvenum/Flare
- https://github.com/jzimmerman/langcc [A Next-Generation Compiler Compiler]
- https://github.com/objeck/objeck-lang [Modern object-oriented and functional programming language]
- https://github.com/Kindelia/Kind2 [A next-gen functional language]
- https://github.com/phate/jlm [A research compiler based on the RVSDG IR]
- https://github.com/memoryleak47/lua2llvm
- https://github.com/KianShepherd/dusk
- https://github.com/f0xeri/SlangCompiler
- https://github.com/davidgiven/calculon
- https://github.com/epoll-reactor/weak_compiler
- https://github.com/JuliaPoo/Artfuscator [Art compiler]
- https://github.com/Ma11ock/holyc [C variant]
- https://github.com/ianfun/xcc [Small C Compiler written in C++]
- https://github.com/tjysdsg/tan
- https://github.com/One-Language/One
- https://github.com/1whatleytay/kara [Easy-to-use, blazing-fast]
- https://github.com/forrestchang/gptlang [ChatGPT]
- https://github.com/exaloop/codon [python]
- https://github.com/ASDAlexander77/TypeScriptCompiler [TypeScript]
- https://github.com/PaddlePaddle/CINN [Neural Networks]
- https://github.com/momentarylapse/kaba
- https://github.com/viper-org/viper-lang [C]
- https://github.com/ab25cq/neo-c
- https://github.com/cgsdfc/simplecc [C]
- https://github.com/WerWolv/PatternLanguage [ImHex]
- https://github.com/DavidPH/GDCC [Game Data Compiler Collection]
- https://github.com/jephthai/EvilVM [Information security research tools]
- https://github.com/tathanhdinh/tocc [A untyped C compiler]
- https://github.com/AmrDeveloper/Jot
- https://github.com/pducklin/minimalisti-C [A stripped-downTiny CC for 64-bit Windows]
- https://github.com/AdamOron/LightweightCompiler
- https://github.com/wangyu-/mycc [C]
- https://github.com/swetanjal/MiniC-Compiler [C]
- https://github.com/mixr26/mxrlang
- https://github.com/pflynn157/orka
- https://github.com/drmortalwombat/oscar64
- https://github.com/GregorGullwi/FlashCpp
- https://github.com/BrandonKi/BF-Compiler [Compiler for Brainfuck]
- https://github.com/project-type/type-c
- https://github.com/thepowersgang/mrustc [rust]
- https://github.com/acd1034/try-rust [C Compiler Frontend in Rust]
- https://github.com/x8xx/p4c-s4 [Backend for the P4 compiler targeting S4]
- https://github.com/inko-lang/inko [A language for building concurrent software with confidence]
- https://github.com/grassator/mass [Compile-time execution]
- https://github.com/dtcxzyw/cmmc [CPP]
- https://github.com/ArthurPV/lily
- https://github.com/leaningtech/cheerp-compiler [C++ compiler for Web]
- https://github.com/raustin9/ThunderBirdCompiler
- https://github.com/c3lang/c3c [compatibility with C]
- https://github.com/zourenDevote/KaleidoscopeLanguage [Kaleidoscope]
- https://github.com/gmh5225/PJDCc [PJDC]
- https://github.com/arnetheduck/nlvm [Nim]
- https://github.com/brymer-meneses/lev-lang [rust style]
- https://github.com/gmh5225/synthex-lang/tree/master [rust style]
- https://github.com/edg-l/edlang [rust style]
- https://github.com/Baleg00/tau-lang [rust style]
- https://github.com/zuojianfa/ca-lang [rust style]
- https://github.com/Ttimofeyka/Rave
- https://github.com/sasalla23/ni
- https://github.com/agentcooper/eye [Syntax inspired by TypeScript]
- https://github.com/OsamaAhmad00/Dua [Antlr4]
- https://github.com/lang-vulpi/vulpi [Algebraic effects]
- https://github.com/andyyu2004/l-lang [Rust-inspired]
- https://github.com/techie-mike/compiler-for-vm [IR for VM]
- https://github.com/gmh5225/minir [IR written in Zig]
- https://github.com/grachale/llvm_frontend [Inspired by Pasca]
- https://github.com/red/red [Inspired by Rebol]
- https://github.com/vvaltchev/mylang [Inspired by Python, JavaScript and C]
- https://github.com/candy-lang/candy [robust, minimalistic, and expressive]
- https://github.com/SamoZ256/lvslang [LVSL]
- https://github.com/debugx-x/HighLevel-Compiler [Java-Based Compiler]
- https://github.com/mathieudelehaye/JavaToLLVMIRCompiler [Java-Based Compiler]
- https://github.com/ianw3214/velvet [With VSC extension]
- https://github.com/rochus-keller/Micron [Micron]
- https://github.com/IITH-Compilers/P4LLVM [P4]
- https://github.com/wandvvs/dust-lang [Imperative programming]
- https://github.com/elixir-lang/elixir [Dynamic, functional language]
- https://github.com/mlang-dev/m [For WebAssembly]
- https://github.com/Vinz2008/C. [C-like]
- https://github.com/eckertliam/newc [C-like]
- https://github.com/JohnMitchell04/toy-langauge [C-like]
- https://github.com/michael-lehn/abc-llvm [A Bloody Compiler with llvm backend]
- https://github.com/VKCOM/kphp [PHP compiler]
- https://github.com/c2lang/c2compiler [c2 compiler]

## Clang Plugins
- https://chromium.googlesource.com/chromium/src/tools/clang/+/refs/heads/master/plugins/FindBadConstructsAction.h
- https://github.com/theuni/bitcoin-tidy
- https://github.com/gwangmu/clang-ast-plugin-template
- https://github.com/foonathan/cppast
- https://github.com/llvm/llvm-project/blob/main/clang/tools/clang-check/ClangCheck.cpp
- https://chromium.googlesource.com/chromium/src/+/refs/heads/main/tools/clang/rewrite_to_chrome_style/RewriteToChromeStyle.cpp
- https://github.com/vgvassilev/clad [Math]
- [Rewrite C++ code to automatically apply `constexpr` where possible](https://github.com/gmh5225/constexpr-everything)
- [A clang tool for happy refactoring without source-code gymnastics ](https://github.com/goldsborough/clang-expand)
- [Clang-based tool to dump type information (enums, records, vtables) from a C++ codebase and optionally import it into IDA](https://github.com/leoetlino/classgen)
- https://github.com/KDE/clazy [Allows clang to understand Qt semantics]

## CIR
- https://discourse.llvm.org/t/rfc-an-mlir-based-clang-ir-cir/63319
- https://github.com/llvm/clangir
- https://github.com/facebookincubator/clangir

## MLIR
- https://github.com/j2kun/mlir-tutorial [MLIR For Beginners]
- https://github.com/gmh5225/mlir-cf-pass [out-of-tree pass]
- https://github.com/llvm/torch-mlir [PyTorch MLIR]
- https://github.com/openxla/iree [MLIR compiler]
- https://github.com/openxla/xla [MLIR compiler]
- https://github.com/Lewuathe/mlir-hello [MLIR Sample dialect]
- https://github.com/llvm/Polygeist [C/C++ frontend for MLIR]

## Clangd/Language Server
- https://github.com/clangd/vscode-clangd
- https://github.com/clice-project/clice [new language server]

## LLD
- https://github.com/llvm/llvm-project/commit/9dd2d50984f5b02e19d3576812dc9b09ddcc9483 [COFF]
- https://github.com/llvm/llvm-project/commit/98bc304e9faded44f1d8988ffa4c5d8b50c759ec [COFF]

## LLDB
- https://github.com/endoli/lldb-sys.rs [LLDB bindings for Rust]
- https://github.com/tetsuo-cpp/visual-lldb [A GUI frontend for LLDB]
- https://github.com/ant4g0nist/vegvisir [A browser based GUI for LLDB Debugger]
- https://github.com/zmeadows/lldbg [A lightweight native GUI for LLDB]
- https://github.com/plasma-umass/ChatDBG [LLDB with chatGPT]
- https://github.com/teemu-hakala/debugging-masterclass [Debugging with LLDB on VSCode GUI]
- https://github.com/vadimcn/codelldb [A native debugger extension for VSCode based on LLDB]
- https://github.com/facebookarchive/ds2 [Debug server for lldb]
- https://github.com/yangyss/lldb-trace

## Transfer
- https://github.com/sbip-sg/tsll
- https://github.com/Acmodeus/O2M_LLVM

## Bundler
- https://github.com/oToToT/CppBundler


## Security Features
- https://github.com/llvm/llvm-project/commit/82af95029ec947fed8b9c516f04d4f217bd87930
- https://github.com/llvm/llvm-project/issues/48474#issuecomment-1022431702


## MSVC Features
- https://github.com/llvm/llvm-project/commit/37d1d02200b9472082304c191f396f0489d00e05
- https://github.com/llvm/llvm-project/commit/3e19ba36fca9fa0b6aba0de2767f26dfd463cb5a
- https://reviews.llvm.org/D80344 [SEH]
- https://reviews.llvm.org/D102817 [SEH]
- https://github.com/MicrosoftDocs/cpp-docs/tree/main/docs/intrinsics [intrinsics]
- https://github.com/llvm/llvm-project/commit/8cd8bd4a5ca702024b9df53a9c7984bb700488a0 [intrinsics]
- https://github.com/llvm/llvm-project/commit/67d9276b16024bae66dfc2fcb739d947637b8c52

## X86
- [Add WRMSRNS instructions](https://github.com/llvm/llvm-project/commit/3ee58e2f355f8fdb8e0fe29dc366c8833fafa7d3#diff-9b86f2920663e81557799fbbd887a211dfd3358e91f671a767b3786fbd802045)
- [Support PREFETCHI instructions](https://github.com/NewWorldComingSoon/llvm-msvc/commit/62ca79102cf9646aa9ed0dac7f018432a68eedf1)

## Optimization
- https://discourse.llvm.org/t/rfc-cmov-vs-branch-optimization/6040
- https://github.com/llvm/llvm-project/commit/0b7669f33331b7af157be4de02ab9dcbc2590dc2
- https://github.com/llvm/llvm-project/commit/eb1ff70fc5fc166fa67dc1cfd5854fc6f51e0b17
- https://github.com/llvm/llvm-project/commit/e03d216c28dfbda52afe7e1f6606cc5dafb3235e
- https://github.com/llvm/llvm-project/commit/75c4a9270649020710ca86c00e4a89788661b067
- https://github.com/llvm/llvm-project/commit/c1b9667148105d99f4792b46805b6a4d2aea4a6e
- https://github.com/llvm/llvm-project/commit/940d7cd59f88d78af443091e75a33a39ce098fbe
- https://github.com/wlingze/llvm_opt
- https://github.com/llvm/llvm-project/commit/e3deb7d88b0cd6d15a7b5a345d94c37ff6262bb4
- https://github.com/llvm/llvm-project/commit/2c4e38fa6f33d371f9169715f97046343095bba0
- https://github.com/llvm/llvm-project/commit/4e4f839ac2a9002df504f1bed8383c2d7d72e86e
- https://github.com/llvm/llvm-project/commit/0af3e6a22da2eda5021b5fad656d0b9db7702e0a
- https://github.com/llvm/llvm-project/commit/c7ba5a9affbcabb0d05301e5417c203274667572
- https://github.com/llvm/llvm-project/commit/b90478d4220ce5c13b8c8e613e23300cea2fd8b1
- https://reviews.llvm.org/D122084
- https://github.com/NewWorldComingSoon/llvm-msvc/commit/5fd945166862377be390948c9ab7dab2f47df217
- https://github.com/llvm/llvm-project/commit/a5f637bcbb7d1e08ce637f113fc117c3f4b2b110
- https://github.com/llvm/llvm-project/commit/ffe0cc82dbaecde4fd1bb2bca5c6aea59be698a6
- https://github.com/NewWorldComingSoon/llvm-msvc/commit/ca33d74ca5cefdad929d5c2759f7d80faa6be539
- https://github.com/kai-franz/dbds [Based DT]
- https://github.com/d4rk-kn1gh7/llvm-optimization-pass
- https://github.com/UofT-EcoSystem/CSCD70 [CSCD70 Compiler Optimization]
- https://github.com/AliveToolkit/alive2 [Automatic verification of LLVM optimizations]


## Testing Tools
- https://godbolt.org/
- https://github.com/llvm/llvm-test-suite
- https://github.com/NewWorldComingSoon/llvm-msvc-build [Testing Windows Driver]
- https://github.com/crosire/blink
- https://github.com/ykfre/BsodSurvivor [Debugging Windows Driver]
- https://github.com/LouisJenkinsCS/LLVM-Simple-GUI [View DT&CFG]
- https://github.com/trailofbits/DomTreSat [Testing DT]
- https://github.com/CAST-projects/Clang-ast-viewer
- https://github.com/NewWorldComingSoon/UnknownField [Testing Obfuscated Field]
- https://github.com/vaivaswatha/debugir [Debugging IR]
- https://github.com/grotius-cnc/Qt_LLVM_App [Testing CPP2IR]


## LLVM Tutorial
- https://llvm.discourse.group/t/beginner-resources-documentation/5872 [LLVM Community]
- https://github.com/mikeroyal/LLVM-Guide
- https://github.com/banach-space/llvm-tutor
- https://github.com/xiaoweiChen/Learn-LLVM-12
- https://github.com/xiaoweiChen/LLVM-Techniques-Tips-and-Best-Practies
- https://github.com/Enna1/LLVM-Clang-Study-Notes
- https://github.com/duduWang20/llvmbooks
- https://github.com/hunterzju/llvm-tutorial
- https://github.com/KCreate/llvm-learning
- https://github.com/danbev/learning-llvm
- https://blog.csdn.net/wuhui_gdnt/article/details/61194221
- https://blog.csdn.net/dreammeard/article/details/19493599 [LLVM Metadata]
- https://blog.csdn.net/dreammeard/article/details/19827141 [LLVM DominatorTree]
- https://www.youtube.com/watch?v=d1Y4EZOFfkQ [LLVM DominatorTree]
- https://blog.csdn.net/weixin_46222091/article/details/105420409 [LLVM Callgraph]
- https://github.com/Evian-Zhang/llvm-ir-tutorial [LLVM IR]
- https://github.com/Virtual-Machine/llvm-tutorial-book
- https://github.com/Virtual-Machine/ir-examples [LLVM IR]
- https://github.com/ronnie88597/Notes/tree/f206fa9998b1f6288193cb40e667e32165cf9f2b/llvm
- https://github.com/objwyh/Formatv [LLVM Formatv]
- https://github.com/lahiri-phdworks/LLVM-Examples
- https://github.com/michelou/llvm-examples/tree/master/examples
- https://llvm.org/docs/MIRLangRef.html [LLVM MIR]
- https://llvm.org/docs/PDB/index.html [LLVM PDB]
- https://github.com/bigconvience/llvm-ir-in-action [LLVM IR Examples]
- https://github.com/alexjung/Writing-an-LLVM-Pass-using-the-new-PassManager [New Pass]
- https://github.com/sepy97/newPM_LLVM_pass [New Pass]
- https://github.com/jvstech/windows-gpt-transform [New Pass]
- https://github.com/Radon10043/LLVMDFGPass [LLVM DFG]
- https://github.com/zslwyuan/LLVM-11-Tutorials
- https://github.com/wuzhanglin/llvm-IR-examples [LLVM IR]
- https://github.com/smlnj/smlnj-llvm [Calling Convention]
- https://github.com/Jonathan2251/lbd [backend]
- https://github.com/lac-dcc/llvm-course
- https://github.com/vhiribarren/llvm-tuto-kaleidoscope-rust [Kaleidoscope rust]
- https://github.com/xLox-x/llvm-pass-manager-demos [llvm pass demos by using new pas manager]

## Clang Tutorial
- https://github.com/banach-space/clang-tutor
- https://github.com/ingve/awesome-clang
- https://github.com/lahiri-phdworks/LLVM-Examples/tree/master/ClangAST
- https://github.com/ronnie88597/Notes/tree/master/clang
- https://github.com/lijiansong/clang-llvm-tutorial
- https://blog.quarkslab.com/implementing-a-custom-directive-handler-in-clang.html
- https://clang.llvm.org/docs/LibASTMatchersReference.html [AST Matcher]

## CPP Tutorial
- https://github.com/andreasfertig/programming-with-cpp20
- https://github.com/AnthonyCalandra/modern-cpp-features
- https://github.com/xiaoweiChen/CPP-Move-Semantics

## Security Book
- https://github.com/llsoftsec/llsoftsecbook

## Compiler Book
- http://www.craftinginterpreters.com/contents.html
- https://github.com/GuoYaxiang/craftinginterpreters_zh
- https://github.com/tuoxie007/play_with_llvm [CN]

## Jobs
- https://github.com/mgaudet/CompilerJobs


