#ifndef __LORA_COMISSIONING_H__
#define __LORA_COMISSIONING_H__

#ifdef __cplusplus
 extern "C" {
#endif

#define LORAWAN_DEVICE_ADDRESS 0

/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION 1

/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK 1

/*!
 * When set to 1 DevEui is LORAWAN_DEVICE_EUI
 * When set to 0 DevEui is automatically generated by calling
 *         BoardGetUniqueId function
 */
#define STATIC_DEVICE_EUI 0

/*!
 * Mote device IEEE EUI (big endian)
 *
 * \remark see STATIC_DEVICE_EUI comments
 */
#define LORAWAN_DEVICE_EUI { 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01 }


/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI { 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7 }

/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY { 0x0, 0x1, 0x2, 0x3, 0x4, 0x5, 0x6, 0x7, 0x8, 0x9, 0xA, 0xB, 0xC, 0xD, 0xE, 0xF }

#ifdef __cplusplus
}
#endif

#endif /* __LORA_COMISSIONING_H__ */
