package vulnerability

import "github.com/google/uuid"

// Vulnerability is the struct that stores all vulnerability information.
type Vulnerability struct {
	ID             string `bson:"id" json:"id"`
	Language       string `bson:"language" json:"language,omitempty"`
	SecurityTest   string `bson:"securityTest" json:"securityTest,omitempty"`
	Severity       string `bson:"severity,omitempty" json:"severity,omitempty"`
	Confidence     string `bson:"confidence,omitempty" json:"confidence,omitempty"`
	File           string `bson:"file,omitempty" json:"file,omitempty"`
	Line           string `bson:"line,omitempty" json:"line,omitempty"`
	Code           string `bson:"code,omitempty" json:"code,omitempty"`
	Details        string `bson:"details" json:"details,omitempty"`
	Type           string `bson:"type,omitempty" json:"type,omitempty"`
	VunerableBelow string `bson:"vulnerablebelow,omitempty" json:"vulnerablebelow,omitempty"`
	Version        string `bson:"version,omitempty" json:"version,omitempty"`
	Nosec          bool   `bson:"nosec" json:"nosec"`
	Occurrences    int    `bson:"occurrences,omitempty" json:"occurrences,omitempty"`
}

// New creates a new vulnerability and sets its ID
func New() *Vulnerability {
	return &Vulnerability{
		ID: uuid.New().String(),
	}
}
