# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

require 'spec_helper'

describe SessionsController, "and users" do
  #before(:each) do
  #  @quentin = Factory(:quentin)
  #end

  #it 'logins and redirects' do
  #  post :create, :login => 'quentin', :password => 'test'
  #  session[:user_id].should_not be_nil
  #  response.should be_redirect
  #end

  #it 'fails login and does not redirect' do
  #  post :create, :login => 'quentin', :password => 'bad password'
  #  session[:user_id].should be_nil
  #  response.should be_success
  #end

  #it 'logs out' do
  #  login_as @quentin
  #  get :destroy
  #  session[:user_id].should be_nil
  #  response.should be_redirect
  #end

  #it 'remembers me' do
  #  post :create, :login => 'quentin', :password => 'test', :remember_me => "1"
  #  response.cookies["auth_token"].should_not be_nil
  #end

  #it 'does not remember me' do
  #  post :create, :login => 'quentin', :password => 'test', :remember_me => "0"
  #  response.cookies["auth_token"].should be_nil
  #end

  #it 'deletes token on logout' do
  #  login_as @quentin
  #  get :destroy
  #  response.cookies["auth_token"].should be_nil
  #end

  #it 'logs in with cookie' do
  #  @quentin.remember_me
  #  request.cookies["auth_token"] = cookie_for(@quentin)
  #  get :new
  #  controller.send(:logged_in?).should be_true
  #end

  #it 'fails expired cookie login' do
  #  @quentin.remember_me
  #  @quentin.update_attribute :remember_token_expires_at, 5.minutes.ago
  #  request.cookies["auth_token"] = cookie_for(@quentin)
  #  get :new
  #  controller.send(:logged_in?).should_not be_true
  #end

  #it 'fails cookie login' do
  #  @quentin.remember_me
  #  request.cookies["auth_token"] = auth_token('invalid_auth_token')
  #  get :new
  #  controller.send(:logged_in?).should_not be_true
  #end

  #def auth_token(token)
  #  CGI::Cookie.new('name' => 'auth_token', 'value' => token)
  #end

  #def cookie_for(user)
  #  auth_token user.remember_token
  #end
end

describe SessionsController, "and auth tokens" do

  before(:each) do
    @domain = Factory(:domain)
    @user = Factory(:admin)
    @token = Factory(:auth_token, :domain => @domain, :user => @user)
  end

  xit 'accepts and redirects' do
    post :token, :token => '5zuld3g9dv76yosy'
    session[:token_id].should_not be_nil
    controller.send(:token_user?).should be_true
    response.should be_redirect
    response.should redirect_to( domain_path( @domain ) )
  end

  xit 'fails login and does not redirect' do
    post :token, :token => 'bad_token'
    session[:token_id].should be_nil
    response.should be_success
  end

  xit 'logs out' do
    tokenize_as(@token)
    get :destroy
    session[:token_id].should be_nil
    response.should redirect_to( session_path )
  end

  xit 'fails expired cookie login' do
    @token.update_attribute :expires_at, 5.minutes.ago
    get :new
    controller.send(:token_user?).should_not be_true
  end

end
