# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Autogenerated from a Treetop grammar. Edits may be lost.


require File.expand_path('../../../../config/environment', __FILE__)
require File.expand_path('../util', __FILE__)

module NamedConf
  include Treetop::Runtime

  def root
    @root ||= :file
  end

  module File0
    def space1
      elements[0]
    end

    def top_level_directive
      elements[1]
    end

    def space2
      elements[2]
    end
  end

  module File1
    attr_accessor :chroot_dir

    def named_conf
      view_keys = views.collect(&:key_name)
      str       = ''

      elements.each do |element|
        next unless element.respond_to?(:top_level_directive)
        top_level = element.top_level_directive

        # skip zones and views
        next if is_rule?(top_level, 'zone') ||
          is_rule?(top_level, 'view') ||
          is_rule?(top_level, 'key') && top_level.respond_to?(:key_name) && view_keys.include?(top_level.key_name.to_s)

        str << top_level.text_value << "\n\n"
      end
      str
    end

    def views
      @views ||= get_views_recursively
    end

    def domains
      @domains ||= get_domains_recursively
    end

    def directory_option
      @directory_option ||= get_directory_option_recursively
    end

    private

    def is_rule?(node, rule_name)
      node.extension_modules.include?("NamedConf::#{rule_name.camelize}0".constantize)
    end

    def get_views_recursively(node = self, views = Array.new)
      views << node.view if node.respond_to?(:view)
      node.elements.each do |child|
        get_views_recursively(child, views) unless child.terminal?
      end
      views
    end

    def get_domains_recursively(node = self, domains = Array.new)
      node.respond_to?(:view)   and return domains
      node.respond_to?(:domain) and domains << node.domain

      node.elements.each do |child|
        get_domains_recursively(child, domains) unless child.terminal?
      end
      domains
    end

    def get_directory_option_recursively(node = self)
      top_level = elements.find{|e| e.respond_to?(:top_level_directive) && is_rule?(e.top_level_directive, 'options')}
      top_level and top_level.top_level_directive.options_statements.elements.find{|e| e.respond_to?(:directory_option)}.try(:directory_option)
    end
  end

  def _nt_file
    start_index = index
    if node_cache[:file].has_key?(index)
      cached = node_cache[:file][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      i1, s1 = index, []
      r2 = _nt_space
      s1 << r2
      if r2
        r3 = _nt_top_level_directive
        s1 << r3
        if r3
          r4 = _nt_space
          s1 << r4
        end
      end
      if s1.last
        r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
        r1.extend(File0)
      else
        @index = i1
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    if s0.empty?
      @index = i0
      r0 = nil
    else
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(File1)
    end

    node_cache[:file][start_index] = r0

    r0
  end

  module TopLevelDirective0
  end

  def _nt_top_level_directive
    start_index = index
    if node_cache[:top_level_directive].has_key?(index)
      cached = node_cache[:top_level_directive][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    r1 = _nt_acl
    if r1
      r0 = r1
      r0.extend(TopLevelDirective0)
    else
      r2 = _nt_controls
      if r2
        r0 = r2
        r0.extend(TopLevelDirective0)
      else
        r3 = _nt_include_
        if r3
          r0 = r3
          r0.extend(TopLevelDirective0)
        else
          r4 = _nt_key
          if r4
            r0 = r4
            r0.extend(TopLevelDirective0)
          else
            r5 = _nt_logging
            if r5
              r0 = r5
              r0.extend(TopLevelDirective0)
            else
              r6 = _nt_lwres
              if r6
                r0 = r6
                r0.extend(TopLevelDirective0)
              else
                r7 = _nt_masters
                if r7
                  r0 = r7
                  r0.extend(TopLevelDirective0)
                else
                  r8 = _nt_options
                  if r8
                    r0 = r8
                    r0.extend(TopLevelDirective0)
                  else
                    r9 = _nt_server
                    if r9
                      r0 = r9
                      r0.extend(TopLevelDirective0)
                    else
                      r10 = _nt_statistics_channels
                      if r10
                        r0 = r10
                        r0.extend(TopLevelDirective0)
                      else
                        r11 = _nt_trusted_keys
                        if r11
                          r0 = r11
                          r0.extend(TopLevelDirective0)
                        else
                          r12 = _nt_managed_keys
                          if r12
                            r0 = r12
                            r0.extend(TopLevelDirective0)
                          else
                            r13 = _nt_view
                            if r13
                              r0 = r13
                              r0.extend(TopLevelDirective0)
                            else
                              r14 = _nt_zone
                              if r14
                                r0 = r14
                                r0.extend(TopLevelDirective0)
                              else
                                @index = i0
                                r0 = nil
                              end
                            end
                          end
                        end
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end

    node_cache[:top_level_directive][start_index] = r0

    r0
  end

  module Acl0
    def space1
      elements[1]
    end

    def acl_name
      elements[2]
    end

    def space2
      elements[3]
    end

    def space3
      elements[5]
    end

    def acl_statements
      elements[6]
    end

    def space4
      elements[7]
    end

    def space5
      elements[9]
    end

  end

  module Acl1
  end

  def _nt_acl
    start_index = index
    if node_cache[:acl].has_key?(index)
      cached = node_cache[:acl][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('acl', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 3))
      @index += 3
    else
      terminal_parse_failure('acl')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_acl_name
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            if has_terminal?('{', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure('{')
              r5 = nil
            end
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                r7 = _nt_acl_statements
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?('}', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure('}')
                      r9 = nil
                    end
                    s0 << r9
                    if r9
                      r10 = _nt_space
                      s0 << r10
                      if r10
                        if has_terminal?(';', false, index)
                          r11 = instantiate_node(SyntaxNode,input, index...(index + 1))
                          @index += 1
                        else
                          terminal_parse_failure(';')
                          r11 = nil
                        end
                        s0 << r11
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Acl0)
      r0.extend(Acl1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:acl][start_index] = r0

    r0
  end

  module Controls0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def controls_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module Controls1
  end

  def _nt_controls
    start_index = index
    if node_cache[:controls].has_key?(index)
      cached = node_cache[:controls][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('controls', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 8))
      @index += 8
    else
      terminal_parse_failure('controls')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_controls_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Controls0)
      r0.extend(Controls1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:controls][start_index] = r0

    r0
  end

  module Include_0
    def space1
      elements[1]
    end

    def filename
      elements[2]
    end

    def space2
      elements[3]
    end

  end

  def _nt_include_
    start_index = index
    if node_cache[:include_].has_key?(index)
      cached = node_cache[:include_][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('include', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 7))
      @index += 7
    else
      terminal_parse_failure('include')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_filename
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            if has_terminal?(';', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure(';')
              r5 = nil
            end
            s0 << r5
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Include_0)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:include_][start_index] = r0

    r0
  end

  module Key0
    def space1
      elements[1]
    end

    def key_name
      elements[2]
    end

    def space2
      elements[3]
    end

    def space3
      elements[5]
    end

    def key_statements
      elements[6]
    end

    def space4
      elements[7]
    end

    def space5
      elements[9]
    end

  end

  module Key1
  end

  def _nt_key
    start_index = index
    if node_cache[:key].has_key?(index)
      cached = node_cache[:key][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('key', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 3))
      @index += 3
    else
      terminal_parse_failure('key')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_key_name
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            if has_terminal?('{', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure('{')
              r5 = nil
            end
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                r7 = _nt_key_statements
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?('}', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure('}')
                      r9 = nil
                    end
                    s0 << r9
                    if r9
                      r10 = _nt_space
                      s0 << r10
                      if r10
                        if has_terminal?(';', false, index)
                          r11 = instantiate_node(SyntaxNode,input, index...(index + 1))
                          @index += 1
                        else
                          terminal_parse_failure(';')
                          r11 = nil
                        end
                        s0 << r11
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Key0)
      r0.extend(Key1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:key][start_index] = r0

    r0
  end

  module Logging0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def logging_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module Logging1
  end

  def _nt_logging
    start_index = index
    if node_cache[:logging].has_key?(index)
      cached = node_cache[:logging][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('logging', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 7))
      @index += 7
    else
      terminal_parse_failure('logging')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_logging_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Logging0)
      r0.extend(Logging1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:logging][start_index] = r0

    r0
  end

  module Lwres0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def lwres_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module Lwres1
  end

  def _nt_lwres
    start_index = index
    if node_cache[:lwres].has_key?(index)
      cached = node_cache[:lwres][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('lwres', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 5))
      @index += 5
    else
      terminal_parse_failure('lwres')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_lwres_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Lwres0)
      r0.extend(Lwres1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:lwres][start_index] = r0

    r0
  end

  module Masters0
    def space1
      elements[1]
    end

    def masters_name
      elements[2]
    end

    def space2
      elements[3]
    end

    def space3
      elements[5]
    end

    def masters_statements
      elements[6]
    end

    def space4
      elements[7]
    end

    def space5
      elements[9]
    end

  end

  module Masters1
  end

  def _nt_masters
    start_index = index
    if node_cache[:masters].has_key?(index)
      cached = node_cache[:masters][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('masters', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 7))
      @index += 7
    else
      terminal_parse_failure('masters')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_masters_name
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            if has_terminal?('{', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure('{')
              r5 = nil
            end
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                r7 = _nt_masters_statements
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?('}', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure('}')
                      r9 = nil
                    end
                    s0 << r9
                    if r9
                      r10 = _nt_space
                      s0 << r10
                      if r10
                        if has_terminal?(';', false, index)
                          r11 = instantiate_node(SyntaxNode,input, index...(index + 1))
                          @index += 1
                        else
                          terminal_parse_failure(';')
                          r11 = nil
                        end
                        s0 << r11
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Masters0)
      r0.extend(Masters1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:masters][start_index] = r0

    r0
  end

  module Options0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def options_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module Options1
  end

  def _nt_options
    start_index = index
    if node_cache[:options].has_key?(index)
      cached = node_cache[:options][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('options', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 7))
      @index += 7
    else
      terminal_parse_failure('options')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_options_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Options0)
      r0.extend(Options1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:options][start_index] = r0

    r0
  end

  module Server0
    def ipaddr_prefix_length
      elements[1]
    end
  end

  module Server1
    def space1
      elements[1]
    end

    def server_ipaddr
      elements[2]
    end

    def space2
      elements[4]
    end

    def space3
      elements[6]
    end

    def server_statements
      elements[7]
    end

    def space4
      elements[8]
    end

    def space5
      elements[10]
    end

  end

  module Server2
  end

  def _nt_server
    start_index = index
    if node_cache[:server].has_key?(index)
      cached = node_cache[:server][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('server', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 6))
      @index += 6
    else
      terminal_parse_failure('server')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_server_ipaddr
        s0 << r3
        if r3
          i5, s5 = index, []
          if has_terminal?('/', false, index)
            r6 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure('/')
            r6 = nil
          end
          s5 << r6
          if r6
            r7 = _nt_ipaddr_prefix_length
            s5 << r7
          end
          if s5.last
            r5 = instantiate_node(SyntaxNode,input, i5...index, s5)
            r5.extend(Server0)
          else
            @index = i5
            r5 = nil
          end
          if r5
            r4 = r5
          else
            r4 = instantiate_node(SyntaxNode,input, index...index)
          end
          s0 << r4
          if r4
            r8 = _nt_space
            s0 << r8
            if r8
              if has_terminal?('{', false, index)
                r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure('{')
                r9 = nil
              end
              s0 << r9
              if r9
                r10 = _nt_space
                s0 << r10
                if r10
                  r11 = _nt_server_statements
                  s0 << r11
                  if r11
                    r12 = _nt_space
                    s0 << r12
                    if r12
                      if has_terminal?('}', false, index)
                        r13 = instantiate_node(SyntaxNode,input, index...(index + 1))
                        @index += 1
                      else
                        terminal_parse_failure('}')
                        r13 = nil
                      end
                      s0 << r13
                      if r13
                        r14 = _nt_space
                        s0 << r14
                        if r14
                          if has_terminal?(';', false, index)
                            r15 = instantiate_node(SyntaxNode,input, index...(index + 1))
                            @index += 1
                          else
                            terminal_parse_failure(';')
                            r15 = nil
                          end
                          s0 << r15
                        end
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Server1)
      r0.extend(Server2)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:server][start_index] = r0

    r0
  end

  module StatisticsChannels0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def statistics_channels_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module StatisticsChannels1
  end

  def _nt_statistics_channels
    start_index = index
    if node_cache[:statistics_channels].has_key?(index)
      cached = node_cache[:statistics_channels][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('statistics-channels', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 19))
      @index += 19
    else
      terminal_parse_failure('statistics-channels')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_statistics_channels_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(StatisticsChannels0)
      r0.extend(StatisticsChannels1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:statistics_channels][start_index] = r0

    r0
  end

  module TrustedKeys0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def trusted_keys_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module TrustedKeys1
  end

  def _nt_trusted_keys
    start_index = index
    if node_cache[:trusted_keys].has_key?(index)
      cached = node_cache[:trusted_keys][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('trusted-keys', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 12))
      @index += 12
    else
      terminal_parse_failure('trusted-keys')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_trusted_keys_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(TrustedKeys0)
      r0.extend(TrustedKeys1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:trusted_keys][start_index] = r0

    r0
  end

  module ManagedKeys0
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def managed_keys_statements
      elements[4]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

  end

  module ManagedKeys1
  end

  def _nt_managed_keys
    start_index = index
    if node_cache[:managed_keys].has_key?(index)
      cached = node_cache[:managed_keys][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('managed-keys', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 12))
      @index += 12
    else
      terminal_parse_failure('managed-keys')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r5 = _nt_managed_keys_statements
            s0 << r5
            if r5
              r6 = _nt_space
              s0 << r6
              if r6
                if has_terminal?('}', false, index)
                  r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('}')
                  r7 = nil
                end
                s0 << r7
                if r7
                  r8 = _nt_space
                  s0 << r8
                  if r8
                    if has_terminal?(';', false, index)
                      r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure(';')
                      r9 = nil
                    end
                    s0 << r9
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(ManagedKeys0)
      r0.extend(ManagedKeys1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:managed_keys][start_index] = r0

    r0
  end

  module View0
    def space1
      elements[1]
    end

    def view_name
      elements[2]
    end

    def space2
      elements[3]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

    def view_statements
      elements[8]
    end

    def space5
      elements[9]
    end

    def space6
      elements[11]
    end

  end

  module View1
    def view
      unless @view
        @view              = View.new(:name => view_name.text_value.strip_quotes)
        @view.domains      = get_domains_recursively
        @view.clients      = view_statements.elements.find{|e| e.respond_to?(:match_clients)}.try(:match_clients).try(:to_s)
        @view.destinations = view_statements.elements.find{|e| e.respond_to?(:match_destinations)}.try(:match_destinations).try(:to_s)
      end
      @view
    end

    private

    def get_domains_recursively(node = self, domains = Array.new)
      domains << node.domain(self.view) if node.respond_to?(:domain)
      node.elements.each do |child|
        get_domains_recursively(child, domains) unless child.terminal?
      end
      domains
    end
  end

  def _nt_view
    start_index = index
    if node_cache[:view].has_key?(index)
      cached = node_cache[:view][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('view', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 4))
      @index += 4
    else
      terminal_parse_failure('view')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_view_name
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r6 = _nt_dns_class
            if r6
              r5 = r6
            else
              r5 = instantiate_node(SyntaxNode,input, index...index)
            end
            s0 << r5
            if r5
              r7 = _nt_space
              s0 << r7
              if r7
                if has_terminal?('{', false, index)
                  r8 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('{')
                  r8 = nil
                end
                s0 << r8
                if r8
                  r9 = _nt_space
                  s0 << r9
                  if r9
                    r10 = _nt_view_statements
                    s0 << r10
                    if r10
                      r11 = _nt_space
                      s0 << r11
                      if r11
                        if has_terminal?('}', false, index)
                          r12 = instantiate_node(SyntaxNode,input, index...(index + 1))
                          @index += 1
                        else
                          terminal_parse_failure('}')
                          r12 = nil
                        end
                        s0 << r12
                        if r12
                          r13 = _nt_space
                          s0 << r13
                          if r13
                            if has_terminal?(';', false, index)
                              r14 = instantiate_node(SyntaxNode,input, index...(index + 1))
                              @index += 1
                            else
                              terminal_parse_failure(';')
                              r14 = nil
                            end
                            s0 << r14
                          end
                        end
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(View0)
      r0.extend(View1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:view][start_index] = r0

    r0
  end

  module Zone0
    def space1
      elements[1]
    end

    def zone_name
      elements[2]
    end

    def space2
      elements[3]
    end

    def space3
      elements[5]
    end

    def space4
      elements[7]
    end

    def zone_statements
      elements[8]
    end

    def space5
      elements[9]
    end

    def space6
      elements[11]
    end

  end

  module Zone1
    def domain(view = nil)
      # STDERR.puts "[INFO] calling 'zone' method of rule 'zone'"
      @domain ||= begin
        name   = zone_name.text_value.strip_quotes
        type   = zone_statements.elements.find{|zs| zs.respond_to?(:zone_type)}.try(:zone_type)
        file   = zone_statements.elements.find{|zs| zs.respond_to?(:zone_file)}.try(:zone_file)
        master = zone_statements.elements.find{|zs| zs.respond_to?(:zone_masters)}.try(:zone_masters)

        if type == 'master'
          directory_option = find_directory_in_parents
          chroot_dir       = find_chroot_dir_in_parents
          chroot_file_path = Pathname.new(file).absolute? ? File.join(chroot_dir, file) : File.join(chroot_dir, directory_option, file)
          File.exists?(chroot_file_path) or raise Exception.new("[ERROR] zone file not found: \"#{chroot_file_path}\"")
          zone_file        = Zonefile.from_file(chroot_file_path, name, chroot_dir, directory_option)

          _domain = Domain.new(:name             => zone_file.origin,
                               :view             => view,
                               :authority_type   => Domain::MASTER,
                               :ttl              => zone_file.ttl,
                               :import_file_name => chroot_file_path)

          _domain.soa_record = SOA.new(:name       => zone_file.soa[:origin],
                                       :ttl        => zone_file.soa[:ttl],
                                       :primary_ns => zone_file.soa[:primary],
                                       :contact    => zone_file.soa[:email],
                                       :serial     => zone_file.soa[:serial],
                                       :refresh    => zone_file.soa[:refresh],
                                       :retry      => zone_file.soa[:retry],
                                       :expire     => zone_file.soa[:expire],
                                       :minimum    => zone_file.soa[:minimumTTL])
          puts "[Zonefile] parsing file #{chroot_file_path} (name: #{name}) (object_id: #{_domain.object_id}) (inspect: #{_domain.inspect})"
          _domain.soa_record.serial = zone_file.soa[:serial]

          zone_file.all_records.each do |record|
            next if record[:type].upcase == 'SOA'
            _domain.records << record[:type].constantize.new(:name    => record[:name],
                                                             :ttl     => record[:ttl],
                                                             :prio    => record[:pri],
                                                             :content => record[:host])
          end
        else
          _domain = Domain.new(:name             => name,
                               :view             => view,
                               :authority_type   => Domain::const_get(type.upcase),
                               :master           => master,
                               :import_file_name => chroot_file_path)
        end

        _domain
      end
    end

    def find_chroot_dir_in_parents
      p = parent
      while p
        return p.chroot_dir if p.respond_to?(:chroot_dir)
        p = p.parent
      end
      raise Exception.new('[ERROR] unable to find "chroot_dir" attribute on parent nodes')
    end

    def find_directory_in_parents
      @directory_option ||= begin
        dir = nil
        p   = parent
        while p
          if p.respond_to?(:directory_option)
            dir = p.directory_option
            break
          end
          p = p.parent
        end
        dir
      end
    end
  end

  def _nt_zone
    start_index = index
    if node_cache[:zone].has_key?(index)
      cached = node_cache[:zone][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('zone', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 4))
      @index += 4
    else
      terminal_parse_failure('zone')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_zone_name
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            r6 = _nt_dns_class
            if r6
              r5 = r6
            else
              r5 = instantiate_node(SyntaxNode,input, index...index)
            end
            s0 << r5
            if r5
              r7 = _nt_space
              s0 << r7
              if r7
                if has_terminal?('{', false, index)
                  r8 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure('{')
                  r8 = nil
                end
                s0 << r8
                if r8
                  r9 = _nt_space
                  s0 << r9
                  if r9
                    r10 = _nt_zone_statements
                    s0 << r10
                    if r10
                      r11 = _nt_space
                      s0 << r11
                      if r11
                        if has_terminal?('}', false, index)
                          r12 = instantiate_node(SyntaxNode,input, index...(index + 1))
                          @index += 1
                        else
                          terminal_parse_failure('}')
                          r12 = nil
                        end
                        s0 << r12
                        if r12
                          r13 = _nt_space
                          s0 << r13
                          if r13
                            if has_terminal?(';', false, index)
                              r14 = instantiate_node(SyntaxNode,input, index...(index + 1))
                              @index += 1
                            else
                              terminal_parse_failure(';')
                              r14 = nil
                            end
                            s0 << r14
                          end
                        end
                      end
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Zone0)
      r0.extend(Zone1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:zone][start_index] = r0

    r0
  end

  def _nt_acl_name
    start_index = index
    if node_cache[:acl_name].has_key?(index)
      cached = node_cache[:acl_name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    r0 = _nt_name

    node_cache[:acl_name][start_index] = r0

    r0
  end

  module AclStatements0
  end

  def _nt_acl_statements
    start_index = index
    if node_cache[:acl_statements].has_key?(index)
      cached = node_cache[:acl_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(AclStatements0)

    node_cache[:acl_statements][start_index] = r0

    r0
  end

  module ControlsStatements0
  end

  def _nt_controls_statements
    start_index = index
    if node_cache[:controls_statements].has_key?(index)
      cached = node_cache[:controls_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(ControlsStatements0)

    node_cache[:controls_statements][start_index] = r0

    r0
  end

  module KeyStatements0
  end

  def _nt_key_statements
    start_index = index
    if node_cache[:key_statements].has_key?(index)
      cached = node_cache[:key_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(KeyStatements0)

    node_cache[:key_statements][start_index] = r0

    r0
  end

  module LoggingStatements0
  end

  def _nt_logging_statements
    start_index = index
    if node_cache[:logging_statements].has_key?(index)
      cached = node_cache[:logging_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(LoggingStatements0)

    node_cache[:logging_statements][start_index] = r0

    r0
  end

  module LwresStatements0
  end

  def _nt_lwres_statements
    start_index = index
    if node_cache[:lwres_statements].has_key?(index)
      cached = node_cache[:lwres_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(LwresStatements0)

    node_cache[:lwres_statements][start_index] = r0

    r0
  end

  def _nt_masters_name
    start_index = index
    if node_cache[:masters_name].has_key?(index)
      cached = node_cache[:masters_name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    r0 = _nt_name

    node_cache[:masters_name][start_index] = r0

    r0
  end

  module MastersStatements0
    def space1
      elements[0]
    end

    def space2
      elements[2]
    end

    def port
      elements[3]
    end
  end

  module MastersStatements1
    def space1
      elements[0]
    end

    def space2
      elements[2]
    end

    def key_name
      elements[3]
    end
  end

  module MastersStatements2
    def ipaddr
      elements[0]
    end

    def space1
      elements[3]
    end

    def space2
      elements[5]
    end
  end

  module MastersStatements3
    def to_s
      # hack: there may be multiple masters, but we only select the first
      # one as the DB currently expects a single IP addr value
      ipaddr = elements.select{|el| el.respond_to?(:ipaddr)}.collect{|el| el.ipaddr.text_value}.first
      port   = elements.select{|el| el.respond_to?(:port)  }.collect{|el| el.port.text_value}.first
      (port ? "#{ipaddr}/#{port}" : ipaddr)
    end
  end

  def _nt_masters_statements
    start_index = index
    if node_cache[:masters_statements].has_key?(index)
      cached = node_cache[:masters_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      i1, s1 = index, []
      r2 = _nt_ipaddr
      s1 << r2
      if r2
        i4, s4 = index, []
        r5 = _nt_space
        s4 << r5
        if r5
          if has_terminal?('port', false, index)
            r6 = instantiate_node(SyntaxNode,input, index...(index + 4))
            @index += 4
          else
            terminal_parse_failure('port')
            r6 = nil
          end
          s4 << r6
          if r6
            r7 = _nt_space
            s4 << r7
            if r7
              r8 = _nt_port
              s4 << r8
            end
          end
        end
        if s4.last
          r4 = instantiate_node(SyntaxNode,input, i4...index, s4)
          r4.extend(MastersStatements0)
        else
          @index = i4
          r4 = nil
        end
        if r4
          r3 = r4
        else
          r3 = instantiate_node(SyntaxNode,input, index...index)
        end
        s1 << r3
        if r3
          i10, s10 = index, []
          r11 = _nt_space
          s10 << r11
          if r11
            if has_terminal?('key', false, index)
              r12 = instantiate_node(SyntaxNode,input, index...(index + 3))
              @index += 3
            else
              terminal_parse_failure('key')
              r12 = nil
            end
            s10 << r12
            if r12
              r13 = _nt_space
              s10 << r13
              if r13
                r14 = _nt_key_name
                s10 << r14
              end
            end
          end
          if s10.last
            r10 = instantiate_node(SyntaxNode,input, i10...index, s10)
            r10.extend(MastersStatements1)
          else
            @index = i10
            r10 = nil
          end
          if r10
            r9 = r10
          else
            r9 = instantiate_node(SyntaxNode,input, index...index)
          end
          s1 << r9
          if r9
            r15 = _nt_space
            s1 << r15
            if r15
              if has_terminal?(';', false, index)
                r16 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure(';')
                r16 = nil
              end
              s1 << r16
              if r16
                r17 = _nt_space
                s1 << r17
              end
            end
          end
        end
      end
      if s1.last
        r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
        r1.extend(MastersStatements2)
      else
        @index = i1
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(MastersStatements3)

    node_cache[:masters_statements][start_index] = r0

    r0
  end

  module OptionsStatements0
  end

  def _nt_options_statements
    start_index = index
    if node_cache[:options_statements].has_key?(index)
      cached = node_cache[:options_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      i1 = index
      r2 = _nt_directory_statement
      if r2
        r1 = r2
      else
        r3 = _nt_statement
        if r3
          r1 = r3
        else
          @index = i1
          r1 = nil
        end
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(OptionsStatements0)

    node_cache[:options_statements][start_index] = r0

    r0
  end

  module DirectoryStatement0
    def space1
      elements[1]
    end

    def filename
      elements[2]
    end

    def space2
      elements[3]
    end

  end

  module DirectoryStatement1
    def directory_option
      filename.text_value.strip_quotes
    end
  end

  def _nt_directory_statement
    start_index = index
    if node_cache[:directory_statement].has_key?(index)
      cached = node_cache[:directory_statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('directory', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 9))
      @index += 9
    else
      terminal_parse_failure('directory')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_filename
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            if has_terminal?(';', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure(';')
              r5 = nil
            end
            s0 << r5
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(DirectoryStatement0)
      r0.extend(DirectoryStatement1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:directory_statement][start_index] = r0

    r0
  end

  def _nt_server_ipaddr
    start_index = index
    if node_cache[:server_ipaddr].has_key?(index)
      cached = node_cache[:server_ipaddr][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    r0 = _nt_ipaddr

    node_cache[:server_ipaddr][start_index] = r0

    r0
  end

  module ServerStatements0
  end

  def _nt_server_statements
    start_index = index
    if node_cache[:server_statements].has_key?(index)
      cached = node_cache[:server_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(ServerStatements0)

    node_cache[:server_statements][start_index] = r0

    r0
  end

  module StatisticsChannelsStatements0
  end

  def _nt_statistics_channels_statements
    start_index = index
    if node_cache[:statistics_channels_statements].has_key?(index)
      cached = node_cache[:statistics_channels_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(StatisticsChannelsStatements0)

    node_cache[:statistics_channels_statements][start_index] = r0

    r0
  end

  module TrustedKeysStatements0
  end

  def _nt_trusted_keys_statements
    start_index = index
    if node_cache[:trusted_keys_statements].has_key?(index)
      cached = node_cache[:trusted_keys_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(TrustedKeysStatements0)

    node_cache[:trusted_keys_statements][start_index] = r0

    r0
  end

  module ManagedKeysStatements0
  end

  def _nt_managed_keys_statements
    start_index = index
    if node_cache[:managed_keys_statements].has_key?(index)
      cached = node_cache[:managed_keys_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      r1 = _nt_statement
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(ManagedKeysStatements0)

    node_cache[:managed_keys_statements][start_index] = r0

    r0
  end

  def _nt_view_name
    start_index = index
    if node_cache[:view_name].has_key?(index)
      cached = node_cache[:view_name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    r0 = _nt_name

    node_cache[:view_name][start_index] = r0

    r0
  end

  module DnsClass0
    def to_s
      text_value
    end
  end

  def _nt_dns_class
    start_index = index
    if node_cache[:dns_class].has_key?(index)
      cached = node_cache[:dns_class][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    if has_terminal?('IN', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 2))
      @index += 2
    else
      terminal_parse_failure('IN')
      r1 = nil
    end
    if r1
      r0 = r1
      r0.extend(DnsClass0)
    else
      if has_terminal?('in', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 2))
        @index += 2
      else
        terminal_parse_failure('in')
        r2 = nil
      end
      if r2
        r0 = r2
        r0.extend(DnsClass0)
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:dns_class][start_index] = r0

    r0
  end

  module ViewStatements0
    def match_clients
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module ViewStatements1
    def match_destinations
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module ViewStatements2
    def zone
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module ViewStatements3
    def attach_cache_statement
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module ViewStatements4
  end

  def _nt_view_statements
    start_index = index
    if node_cache[:view_statements].has_key?(index)
      cached = node_cache[:view_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      i1 = index
      i2, s2 = index, []
      r3 = _nt_match_clients
      s2 << r3
      if r3
        r4 = _nt_space
        s2 << r4
      end
      if s2.last
        r2 = instantiate_node(SyntaxNode,input, i2...index, s2)
        r2.extend(ViewStatements0)
      else
        @index = i2
        r2 = nil
      end
      if r2
        r1 = r2
      else
        i5, s5 = index, []
        r6 = _nt_match_destinations
        s5 << r6
        if r6
          r7 = _nt_space
          s5 << r7
        end
        if s5.last
          r5 = instantiate_node(SyntaxNode,input, i5...index, s5)
          r5.extend(ViewStatements1)
        else
          @index = i5
          r5 = nil
        end
        if r5
          r1 = r5
        else
          i8, s8 = index, []
          r9 = _nt_zone
          s8 << r9
          if r9
            r10 = _nt_space
            s8 << r10
          end
          if s8.last
            r8 = instantiate_node(SyntaxNode,input, i8...index, s8)
            r8.extend(ViewStatements2)
          else
            @index = i8
            r8 = nil
          end
          if r8
            r1 = r8
          else
            i11, s11 = index, []
            r12 = _nt_attach_cache_statement
            s11 << r12
            if r12
              r13 = _nt_space
              s11 << r13
            end
            if s11.last
              r11 = instantiate_node(SyntaxNode,input, i11...index, s11)
              r11.extend(ViewStatements3)
            else
              @index = i11
              r11 = nil
            end
            if r11
              r1 = r11
            else
              @index = i1
              r1 = nil
            end
          end
        end
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(ViewStatements4)

    node_cache[:view_statements][start_index] = r0

    r0
  end

  module MatchClients0
    def address_match
      elements[0]
    end

    def space
      elements[2]
    end
  end

  module MatchClients1
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def space3
      elements[6]
    end

  end

  module MatchClients2
    def to_s
      elements[4].elements.collect{|e| e.address_match.to_s}.join('; ')
    end
  end

  def _nt_match_clients
    start_index = index
    if node_cache[:match_clients].has_key?(index)
      cached = node_cache[:match_clients][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('match-clients', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 13))
      @index += 13
    else
      terminal_parse_failure('match-clients')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            s5, i5 = [], index
            loop do
              i6, s6 = index, []
              r7 = _nt_address_match
              s6 << r7
              if r7
                if has_terminal?(';', false, index)
                  r8 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure(';')
                  r8 = nil
                end
                s6 << r8
                if r8
                  r9 = _nt_space
                  s6 << r9
                end
              end
              if s6.last
                r6 = instantiate_node(SyntaxNode,input, i6...index, s6)
                r6.extend(MatchClients0)
              else
                @index = i6
                r6 = nil
              end
              if r6
                s5 << r6
              else
                break
              end
            end
            if s5.empty?
              @index = i5
              r5 = nil
            else
              r5 = instantiate_node(SyntaxNode,input, i5...index, s5)
            end
            s0 << r5
            if r5
              if has_terminal?('}', false, index)
                r10 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure('}')
                r10 = nil
              end
              s0 << r10
              if r10
                r11 = _nt_space
                s0 << r11
                if r11
                  if has_terminal?(';', false, index)
                    r12 = instantiate_node(SyntaxNode,input, index...(index + 1))
                    @index += 1
                  else
                    terminal_parse_failure(';')
                    r12 = nil
                  end
                  s0 << r12
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(MatchClients1)
      r0.extend(MatchClients2)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:match_clients][start_index] = r0

    r0
  end

  module MatchDestinations0
    def address_match
      elements[0]
    end

    def space
      elements[2]
    end
  end

  module MatchDestinations1
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def space3
      elements[6]
    end

  end

  module MatchDestinations2
    def to_s
      elements[4].elements.collect{|e| e.address_match.to_s}.join('; ')
    end
  end

  def _nt_match_destinations
    start_index = index
    if node_cache[:match_destinations].has_key?(index)
      cached = node_cache[:match_destinations][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('match-destinations', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 18))
      @index += 18
    else
      terminal_parse_failure('match-destinations')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        if has_terminal?('{', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('{')
          r3 = nil
        end
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            s5, i5 = [], index
            loop do
              i6, s6 = index, []
              r7 = _nt_address_match
              s6 << r7
              if r7
                if has_terminal?(';', false, index)
                  r8 = instantiate_node(SyntaxNode,input, index...(index + 1))
                  @index += 1
                else
                  terminal_parse_failure(';')
                  r8 = nil
                end
                s6 << r8
                if r8
                  r9 = _nt_space
                  s6 << r9
                end
              end
              if s6.last
                r6 = instantiate_node(SyntaxNode,input, i6...index, s6)
                r6.extend(MatchDestinations0)
              else
                @index = i6
                r6 = nil
              end
              if r6
                s5 << r6
              else
                break
              end
            end
            if s5.empty?
              @index = i5
              r5 = nil
            else
              r5 = instantiate_node(SyntaxNode,input, i5...index, s5)
            end
            s0 << r5
            if r5
              if has_terminal?('}', false, index)
                r10 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure('}')
                r10 = nil
              end
              s0 << r10
              if r10
                r11 = _nt_space
                s0 << r11
                if r11
                  if has_terminal?(';', false, index)
                    r12 = instantiate_node(SyntaxNode,input, index...(index + 1))
                    @index += 1
                  else
                    terminal_parse_failure(';')
                    r12 = nil
                  end
                  s0 << r12
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(MatchDestinations1)
      r0.extend(MatchDestinations2)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:match_destinations][start_index] = r0

    r0
  end

  module AttachCacheStatement0
    def space1
      elements[1]
    end

    def cache_name
      elements[2]
    end

    def space2
      elements[3]
    end

  end

  def _nt_attach_cache_statement
    start_index = index
    if node_cache[:attach_cache_statement].has_key?(index)
      cached = node_cache[:attach_cache_statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('attach-cache', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 12))
      @index += 12
    else
      terminal_parse_failure('attach-cache')
      r1 = nil
    end
    s0 << r1
    if r1
      r2 = _nt_space
      s0 << r2
      if r2
        r3 = _nt_cache_name
        s0 << r3
        if r3
          r4 = _nt_space
          s0 << r4
          if r4
            if has_terminal?(';', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure(';')
              r5 = nil
            end
            s0 << r5
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(AttachCacheStatement0)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:attach_cache_statement][start_index] = r0

    r0
  end

  def _nt_cache_name
    start_index = index
    if node_cache[:cache_name].has_key?(index)
      cached = node_cache[:cache_name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    r0 = _nt_name

    node_cache[:cache_name][start_index] = r0

    r0
  end

  def _nt_zone_name
    start_index = index
    if node_cache[:zone_name].has_key?(index)
      cached = node_cache[:zone_name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    r0 = _nt_name

    node_cache[:zone_name][start_index] = r0

    r0
  end

  module ZoneStatements0
    def zone_str
      elements.collect(&:to_s).join(":")
    end
  end

  def _nt_zone_statements
    start_index = index
    if node_cache[:zone_statements].has_key?(index)
      cached = node_cache[:zone_statements][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      i1 = index
      r2 = _nt_zone_type_statement
      if r2
        r1 = r2
      else
        r3 = _nt_zone_file_statement
        if r3
          r1 = r3
        else
          r4 = _nt_zone_masters_statement
          if r4
            r1 = r4
          else
            r5 = _nt_zone_allow_update_statement
            if r5
              r1 = r5
            else
              @index = i1
              r1 = nil
            end
          end
        end
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(ZoneStatements0)

    node_cache[:zone_statements][start_index] = r0

    r0
  end

  module ZoneTypeStatement0
    def space1
      elements[0]
    end

    def space2
      elements[2]
    end

    def zone_type_value
      elements[3]
    end

    def space3
      elements[4]
    end

  end

  module ZoneTypeStatement1
    def to_s
      "type #{zone_type_value}"
    end

    def zone_type
      zone_type_value.text_value.strip_quotes
    end
  end

  def _nt_zone_type_statement
    start_index = index
    if node_cache[:zone_type_statement].has_key?(index)
      cached = node_cache[:zone_type_statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    r1 = _nt_space
    s0 << r1
    if r1
      if has_terminal?('type', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 4))
        @index += 4
      else
        terminal_parse_failure('type')
        r2 = nil
      end
      s0 << r2
      if r2
        r3 = _nt_space
        s0 << r3
        if r3
          r4 = _nt_zone_type_value
          s0 << r4
          if r4
            r5 = _nt_space
            s0 << r5
            if r5
              if has_terminal?(';', false, index)
                r6 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure(';')
                r6 = nil
              end
              s0 << r6
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(ZoneTypeStatement0)
      r0.extend(ZoneTypeStatement1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:zone_type_statement][start_index] = r0

    r0
  end

  module ZoneTypeValue0
    def to_s
      text_value
    end
  end

  def _nt_zone_type_value
    start_index = index
    if node_cache[:zone_type_value].has_key?(index)
      cached = node_cache[:zone_type_value][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    if has_terminal?('slave', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 5))
      @index += 5
    else
      terminal_parse_failure('slave')
      r1 = nil
    end
    if r1
      r0 = r1
      r0.extend(ZoneTypeValue0)
    else
      if has_terminal?('master', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 6))
        @index += 6
      else
        terminal_parse_failure('master')
        r2 = nil
      end
      if r2
        r0 = r2
        r0.extend(ZoneTypeValue0)
      else
        if has_terminal?('stub', false, index)
          r3 = instantiate_node(SyntaxNode,input, index...(index + 4))
          @index += 4
        else
          terminal_parse_failure('stub')
          r3 = nil
        end
        if r3
          r0 = r3
          r0.extend(ZoneTypeValue0)
        else
          if has_terminal?('forward', false, index)
            r4 = instantiate_node(SyntaxNode,input, index...(index + 7))
            @index += 7
          else
            terminal_parse_failure('forward')
            r4 = nil
          end
          if r4
            r0 = r4
            r0.extend(ZoneTypeValue0)
          else
            if has_terminal?('hint', false, index)
              r5 = instantiate_node(SyntaxNode,input, index...(index + 4))
              @index += 4
            else
              terminal_parse_failure('hint')
              r5 = nil
            end
            if r5
              r0 = r5
              r0.extend(ZoneTypeValue0)
            else
              @index = i0
              r0 = nil
            end
          end
        end
      end
    end

    node_cache[:zone_type_value][start_index] = r0

    r0
  end

  module ZoneFileStatement0
    def space1
      elements[0]
    end

    def space2
      elements[2]
    end

    def filename
      elements[3]
    end

    def space3
      elements[4]
    end

  end

  module ZoneFileStatement1
    def to_s
      "file #{filename}"
    end

    def zone_file
      filename.text_value.strip_quotes
    end
  end

  def _nt_zone_file_statement
    start_index = index
    if node_cache[:zone_file_statement].has_key?(index)
      cached = node_cache[:zone_file_statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    r1 = _nt_space
    s0 << r1
    if r1
      if has_terminal?('file', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 4))
        @index += 4
      else
        terminal_parse_failure('file')
        r2 = nil
      end
      s0 << r2
      if r2
        r3 = _nt_space
        s0 << r3
        if r3
          r4 = _nt_filename
          s0 << r4
          if r4
            r5 = _nt_space
            s0 << r5
            if r5
              if has_terminal?(';', false, index)
                r6 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure(';')
                r6 = nil
              end
              s0 << r6
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(ZoneFileStatement0)
      r0.extend(ZoneFileStatement1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:zone_file_statement][start_index] = r0

    r0
  end

  module ZoneMastersStatement0
    def space1
      elements[0]
    end

    def space2
      elements[2]
    end

    def space3
      elements[4]
    end

    def masters_statements
      elements[5]
    end

    def space4
      elements[6]
    end

    def space5
      elements[8]
    end

  end

  module ZoneMastersStatement1
    def to_s
      "masters { #{masters_statements} }"
    end

    def zone_masters
      masters_statements.to_s.strip_quotes
    end
  end

  def _nt_zone_masters_statement
    start_index = index
    if node_cache[:zone_masters_statement].has_key?(index)
      cached = node_cache[:zone_masters_statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    r1 = _nt_space
    s0 << r1
    if r1
      if has_terminal?('masters', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 7))
        @index += 7
      else
        terminal_parse_failure('masters')
        r2 = nil
      end
      s0 << r2
      if r2
        r3 = _nt_space
        s0 << r3
        if r3
          if has_terminal?('{', false, index)
            r4 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure('{')
            r4 = nil
          end
          s0 << r4
          if r4
            r5 = _nt_space
            s0 << r5
            if r5
              r6 = _nt_masters_statements
              s0 << r6
              if r6
                r7 = _nt_space
                s0 << r7
                if r7
                  if has_terminal?('}', false, index)
                    r8 = instantiate_node(SyntaxNode,input, index...(index + 1))
                    @index += 1
                  else
                    terminal_parse_failure('}')
                    r8 = nil
                  end
                  s0 << r8
                  if r8
                    r9 = _nt_space
                    s0 << r9
                    if r9
                      if has_terminal?(';', false, index)
                        r10 = instantiate_node(SyntaxNode,input, index...(index + 1))
                        @index += 1
                      else
                        terminal_parse_failure(';')
                        r10 = nil
                      end
                      s0 << r10
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(ZoneMastersStatement0)
      r0.extend(ZoneMastersStatement1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:zone_masters_statement][start_index] = r0

    r0
  end

  module ZoneAllowUpdateStatement0
    def space1
      elements[0]
    end

    def space2
      elements[2]
    end

    def space3
      elements[4]
    end

    def allow_update_values
      elements[5]
    end

    def space4
      elements[6]
    end

    def space5
      elements[8]
    end

  end

  module ZoneAllowUpdateStatement1
    def to_s
      "allow-update { #{allow_update_values} }"
    end
  end

  def _nt_zone_allow_update_statement
    start_index = index
    if node_cache[:zone_allow_update_statement].has_key?(index)
      cached = node_cache[:zone_allow_update_statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    r1 = _nt_space
    s0 << r1
    if r1
      if has_terminal?('allow-update', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 12))
        @index += 12
      else
        terminal_parse_failure('allow-update')
        r2 = nil
      end
      s0 << r2
      if r2
        r3 = _nt_space
        s0 << r3
        if r3
          if has_terminal?('{', false, index)
            r4 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure('{')
            r4 = nil
          end
          s0 << r4
          if r4
            r5 = _nt_space
            s0 << r5
            if r5
              r6 = _nt_allow_update_values
              s0 << r6
              if r6
                r7 = _nt_space
                s0 << r7
                if r7
                  if has_terminal?('}', false, index)
                    r8 = instantiate_node(SyntaxNode,input, index...(index + 1))
                    @index += 1
                  else
                    terminal_parse_failure('}')
                    r8 = nil
                  end
                  s0 << r8
                  if r8
                    r9 = _nt_space
                    s0 << r9
                    if r9
                      if has_terminal?(';', false, index)
                        r10 = instantiate_node(SyntaxNode,input, index...(index + 1))
                        @index += 1
                      else
                        terminal_parse_failure(';')
                        r10 = nil
                      end
                      s0 << r10
                    end
                  end
                end
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(ZoneAllowUpdateStatement0)
      r0.extend(ZoneAllowUpdateStatement1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:zone_allow_update_statement][start_index] = r0

    r0
  end

  module AllowUpdateValues0
    def allow_update_value
      elements[0]
    end

    def space1
      elements[1]
    end

    def space2
      elements[3]
    end
  end

  module AllowUpdateValues1
    def to_s
      elements.collect{|el| el.allow_update_value}.join(' ')
    end
  end

  def _nt_allow_update_values
    start_index = index
    if node_cache[:allow_update_values].has_key?(index)
      cached = node_cache[:allow_update_values][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      i1, s1 = index, []
      r2 = _nt_allow_update_value
      s1 << r2
      if r2
        r3 = _nt_space
        s1 << r3
        if r3
          if has_terminal?(';', false, index)
            r4 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure(';')
            r4 = nil
          end
          s1 << r4
          if r4
            r5 = _nt_space
            s1 << r5
          end
        end
      end
      if s1.last
        r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
        r1.extend(AllowUpdateValues0)
      else
        @index = i1
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(AllowUpdateValues1)

    node_cache[:allow_update_values][start_index] = r0

    r0
  end

  module AllowUpdateValue0
    def allow_update_value
      elements[1]
    end

  end

  module AllowUpdateValue1
    def to_s
      text_value
    end
  end

  def _nt_allow_update_value
    start_index = index
    if node_cache[:allow_update_value].has_key?(index)
      cached = node_cache[:allow_update_value][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    if has_terminal?('any', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 3))
      @index += 3
    else
      terminal_parse_failure('any')
      r1 = nil
    end
    if r1
      r0 = r1
      r0.extend(AllowUpdateValue1)
    else
      if has_terminal?('none', false, index)
        r2 = instantiate_node(SyntaxNode,input, index...(index + 4))
        @index += 4
      else
        terminal_parse_failure('none')
        r2 = nil
      end
      if r2
        r0 = r2
        r0.extend(AllowUpdateValue1)
      else
        i3, s3 = index, []
        if has_terminal?('"', false, index)
          r4 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('"')
          r4 = nil
        end
        s3 << r4
        if r4
          r5 = _nt_allow_update_value
          s3 << r5
          if r5
            if has_terminal?('"', false, index)
              r6 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure('"')
              r6 = nil
            end
            s3 << r6
          end
        end
        if s3.last
          r3 = instantiate_node(SyntaxNode,input, i3...index, s3)
          r3.extend(AllowUpdateValue0)
        else
          @index = i3
          r3 = nil
        end
        if r3
          r0 = r3
          r0.extend(AllowUpdateValue1)
        else
          @index = i0
          r0 = nil
        end
      end
    end

    node_cache[:allow_update_value][start_index] = r0

    r0
  end

  module Space0
    def inspect(indent = '')
      ''
    end

    def to_s
      ''
    end
  end

  def _nt_space
    start_index = index
    if node_cache[:space].has_key?(index)
      cached = node_cache[:space][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      if has_terminal?('\G[\\s]', true, index)
        r1 = true
        @index += 1
      else
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
    r0.extend(Space0)

    node_cache[:space][start_index] = r0

    r0
  end

  module Comment0
  end

  def _nt_comment
    start_index = index
    if node_cache[:comment].has_key?(index)
      cached = node_cache[:comment][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    s1, i1 = [], index
    loop do
      if has_terminal?('\G[\\s]', true, index)
        r2 = true
        @index += 1
      else
        r2 = nil
      end
      if r2
        s1 << r2
      else
        break
      end
    end
    r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
    s0 << r1
    if r1
      if has_terminal?('#', false, index)
        r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
        @index += 1
      else
        terminal_parse_failure('#')
        r3 = nil
      end
      s0 << r3
      if r3
        s4, i4 = [], index
        loop do
          if has_terminal?('\G[^\\r\\n]', true, index)
            r5 = true
            @index += 1
          else
            r5 = nil
          end
          if r5
            s4 << r5
          else
            break
          end
        end
        r4 = instantiate_node(SyntaxNode,input, i4...index, s4)
        s0 << r4
        if r4
          if has_terminal?('\G[\\r\\n]', true, index)
            r6 = true
            @index += 1
          else
            r6 = nil
          end
          s0 << r6
          if r6
            s7, i7 = [], index
            loop do
              r8 = _nt_comment
              if r8
                s7 << r8
              else
                break
              end
            end
            r7 = instantiate_node(SyntaxNode,input, i7...index, s7)
            s0 << r7
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Comment0)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:comment][start_index] = r0

    r0
  end

  module Filename0
  end

  module Filename1
    def to_s
      text_value
    end
  end

  def _nt_filename
    start_index = index
    if node_cache[:filename].has_key?(index)
      cached = node_cache[:filename][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('"', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 1))
      @index += 1
    else
      terminal_parse_failure('"')
      r1 = nil
    end
    s0 << r1
    if r1
      s2, i2 = [], index
      loop do
        if has_terminal?('\G[\\w\\.\\/\\-_]', true, index)
          r3 = true
          @index += 1
        else
          r3 = nil
        end
        if r3
          s2 << r3
        else
          break
        end
      end
      if s2.empty?
        @index = i2
        r2 = nil
      else
        r2 = instantiate_node(SyntaxNode,input, i2...index, s2)
      end
      s0 << r2
      if r2
        if has_terminal?('"', false, index)
          r4 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('"')
          r4 = nil
        end
        s0 << r4
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Filename0)
      r0.extend(Filename1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:filename][start_index] = r0

    r0
  end

  module Statement0
    def name
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module Statement1
    def space1
      elements[0]
    end

    def space2
      elements[3]
    end
  end

  module Statement2
    def name
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module Statement3
    def space1
      elements[2]
    end

    def space2
      elements[4]
    end

    def space3
      elements[6]
    end
  end

  module Statement4
    def space1
      elements[0]
    end

    def space2
      elements[3]
    end
  end

  module Statement5
  end

  def _nt_statement
    start_index = index
    if node_cache[:statement].has_key?(index)
      cached = node_cache[:statement][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    r2 = _nt_space
    s1 << r2
    if r2
      s3, i3 = [], index
      loop do
        i4, s4 = index, []
        r5 = _nt_name
        s4 << r5
        if r5
          r6 = _nt_space
          s4 << r6
        end
        if s4.last
          r4 = instantiate_node(SyntaxNode,input, i4...index, s4)
          r4.extend(Statement0)
        else
          @index = i4
          r4 = nil
        end
        if r4
          s3 << r4
        else
          break
        end
      end
      if s3.empty?
        @index = i3
        r3 = nil
      else
        r3 = instantiate_node(SyntaxNode,input, i3...index, s3)
      end
      s1 << r3
      if r3
        if has_terminal?(';', false, index)
          r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure(';')
          r7 = nil
        end
        s1 << r7
        if r7
          r8 = _nt_space
          s1 << r8
        end
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(Statement1)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r0 = r1
      r0.extend(Statement5)
    else
      i9, s9 = index, []
      r10 = _nt_space
      s9 << r10
      if r10
        s11, i11 = [], index
        loop do
          i12, s12 = index, []
          s13, i13 = [], index
          loop do
            i14, s14 = index, []
            r15 = _nt_name
            s14 << r15
            if r15
              r16 = _nt_space
              s14 << r16
            end
            if s14.last
              r14 = instantiate_node(SyntaxNode,input, i14...index, s14)
              r14.extend(Statement2)
            else
              @index = i14
              r14 = nil
            end
            if r14
              s13 << r14
            else
              break
            end
          end
          if s13.empty?
            @index = i13
            r13 = nil
          else
            r13 = instantiate_node(SyntaxNode,input, i13...index, s13)
          end
          s12 << r13
          if r13
            if has_terminal?('{', false, index)
              r17 = instantiate_node(SyntaxNode,input, index...(index + 1))
              @index += 1
            else
              terminal_parse_failure('{')
              r17 = nil
            end
            s12 << r17
            if r17
              r18 = _nt_space
              s12 << r18
              if r18
                s19, i19 = [], index
                loop do
                  r20 = _nt_statement
                  if r20
                    s19 << r20
                  else
                    break
                  end
                end
                r19 = instantiate_node(SyntaxNode,input, i19...index, s19)
                s12 << r19
                if r19
                  r21 = _nt_space
                  s12 << r21
                  if r21
                    if has_terminal?('}', false, index)
                      r22 = instantiate_node(SyntaxNode,input, index...(index + 1))
                      @index += 1
                    else
                      terminal_parse_failure('}')
                      r22 = nil
                    end
                    s12 << r22
                    if r22
                      r23 = _nt_space
                      s12 << r23
                    end
                  end
                end
              end
            end
          end
          if s12.last
            r12 = instantiate_node(SyntaxNode,input, i12...index, s12)
            r12.extend(Statement3)
          else
            @index = i12
            r12 = nil
          end
          if r12
            s11 << r12
          else
            break
          end
        end
        if s11.empty?
          @index = i11
          r11 = nil
        else
          r11 = instantiate_node(SyntaxNode,input, i11...index, s11)
        end
        s9 << r11
        if r11
          if has_terminal?(';', false, index)
            r24 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure(';')
            r24 = nil
          end
          s9 << r24
          if r24
            r25 = _nt_space
            s9 << r25
          end
        end
      end
      if s9.last
        r9 = instantiate_node(SyntaxNode,input, i9...index, s9)
        r9.extend(Statement4)
      else
        @index = i9
        r9 = nil
      end
      if r9
        r0 = r9
        r0.extend(Statement5)
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:statement][start_index] = r0

    r0
  end

  module Name0
    def ipaddr_prefix_length
      elements[1]
    end
  end

  module Name1
    def server_ipaddr
      elements[0]
    end

  end

  module Name2
    def to_s
      text_value
    end
  end

  def _nt_name
    start_index = index
    if node_cache[:name].has_key?(index)
      cached = node_cache[:name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    r1 = _nt_id
    if r1
      r0 = r1
      r0.extend(Name2)
    else
      r2 = _nt_string
      if r2
        r0 = r2
        r0.extend(Name2)
      else
        i3, s3 = index, []
        r4 = _nt_server_ipaddr
        s3 << r4
        if r4
          i6, s6 = index, []
          if has_terminal?('/', false, index)
            r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure('/')
            r7 = nil
          end
          s6 << r7
          if r7
            r8 = _nt_ipaddr_prefix_length
            s6 << r8
          end
          if s6.last
            r6 = instantiate_node(SyntaxNode,input, i6...index, s6)
            r6.extend(Name0)
          else
            @index = i6
            r6 = nil
          end
          if r6
            r5 = r6
          else
            r5 = instantiate_node(SyntaxNode,input, index...index)
          end
          s3 << r5
        end
        if s3.last
          r3 = instantiate_node(SyntaxNode,input, i3...index, s3)
          r3.extend(Name1)
        else
          @index = i3
          r3 = nil
        end
        if r3
          r0 = r3
          r0.extend(Name2)
        else
          @index = i0
          r0 = nil
        end
      end
    end

    node_cache[:name][start_index] = r0

    r0
  end

  module Id0
    def to_s
      text_value
    end
  end

  def _nt_id
    start_index = index
    if node_cache[:id].has_key?(index)
      cached = node_cache[:id][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      if has_terminal?('\G[\\w\\-\\.\\/]', true, index)
        r1 = true
        @index += 1
      else
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    if s0.empty?
      @index = i0
      r0 = nil
    else
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Id0)
    end

    node_cache[:id][start_index] = r0

    r0
  end

  module String0
  end

  module String1
    def to_s
      text_value
    end
  end

  def _nt_string
    start_index = index
    if node_cache[:string].has_key?(index)
      cached = node_cache[:string][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    if has_terminal?('"', false, index)
      r1 = instantiate_node(SyntaxNode,input, index...(index + 1))
      @index += 1
    else
      terminal_parse_failure('"')
      r1 = nil
    end
    s0 << r1
    if r1
      s2, i2 = [], index
      loop do
        if has_terminal?('\G[^"]', true, index)
          r3 = true
          @index += 1
        else
          r3 = nil
        end
        if r3
          s2 << r3
        else
          break
        end
      end
      r2 = instantiate_node(SyntaxNode,input, i2...index, s2)
      s0 << r2
      if r2
        if has_terminal?('"', false, index)
          r4 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('"')
          r4 = nil
        end
        s0 << r4
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(String0)
      r0.extend(String1)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:string][start_index] = r0

    r0
  end

  module Ipaddr0
    def to_s
      text_value
    end
  end

  def _nt_ipaddr
    start_index = index
    if node_cache[:ipaddr].has_key?(index)
      cached = node_cache[:ipaddr][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    r1 = _nt_ipv4
    if r1
      r0 = r1
    else
      r2 = _nt_ipv6
      r2.extend(Ipaddr0)
      if r2
        r0 = r2
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:ipaddr][start_index] = r0

    r0
  end

  module Ipv40
  end

  module Ipv41
    def to_s
      text_value
    end
  end

  def _nt_ipv4
    start_index = index
    if node_cache[:ipv4].has_key?(index)
      cached = node_cache[:ipv4][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0, s0 = index, []
    s1, i1 = [], index
    loop do
      if has_terminal?('\G[\\d]', true, index)
        r2 = true
        @index += 1
      else
        r2 = nil
      end
      if r2
        s1 << r2
      else
        break
      end
      if s1.size == 3
        break
      end
    end
    if s1.size < 1
      @index = i1
      r1 = nil
    else
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
    end
    s0 << r1
    if r1
      if has_terminal?('.', false, index)
        r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
        @index += 1
      else
        terminal_parse_failure('.')
        r3 = nil
      end
      s0 << r3
      if r3
        s4, i4 = [], index
        loop do
          if has_terminal?('\G[\\d]', true, index)
            r5 = true
            @index += 1
          else
            r5 = nil
          end
          if r5
            s4 << r5
          else
            break
          end
          if s4.size == 3
            break
          end
        end
        if s4.size < 1
          @index = i4
          r4 = nil
        else
          r4 = instantiate_node(SyntaxNode,input, i4...index, s4)
        end
        s0 << r4
        if r4
          if has_terminal?('.', false, index)
            r6 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure('.')
            r6 = nil
          end
          s0 << r6
          if r6
            s7, i7 = [], index
            loop do
              if has_terminal?('\G[\\d]', true, index)
                r8 = true
                @index += 1
              else
                r8 = nil
              end
              if r8
                s7 << r8
              else
                break
              end
              if s7.size == 3
                break
              end
            end
            if s7.size < 1
              @index = i7
              r7 = nil
            else
              r7 = instantiate_node(SyntaxNode,input, i7...index, s7)
            end
            s0 << r7
            if r7
              if has_terminal?('.', false, index)
                r9 = instantiate_node(SyntaxNode,input, index...(index + 1))
                @index += 1
              else
                terminal_parse_failure('.')
                r9 = nil
              end
              s0 << r9
              if r9
                s10, i10 = [], index
                loop do
                  if has_terminal?('\G[\\d]', true, index)
                    r11 = true
                    @index += 1
                  else
                    r11 = nil
                  end
                  if r11
                    s10 << r11
                  else
                    break
                  end
                  if s10.size == 3
                    break
                  end
                end
                if s10.size < 1
                  @index = i10
                  r10 = nil
                else
                  r10 = instantiate_node(SyntaxNode,input, i10...index, s10)
                end
                s0 << r10
              end
            end
          end
        end
      end
    end
    if s0.last
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Ipv40)
      r0.extend(Ipv41)
    else
      @index = i0
      r0 = nil
    end

    node_cache[:ipv4][start_index] = r0

    r0
  end

  module Ipv60
    def to_s
      text_value
    end
  end

  def _nt_ipv6
    start_index = index
    if node_cache[:ipv6].has_key?(index)
      cached = node_cache[:ipv6][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      if has_terminal?('\G[\\d:]', true, index)
        r1 = true
        @index += 1
      else
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    if s0.empty?
      @index = i0
      r0 = nil
    else
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Ipv60)
    end

    node_cache[:ipv6][start_index] = r0

    r0
  end

  module IpaddrPrefixLength0
    def to_s
      text_value
    end
  end

  def _nt_ipaddr_prefix_length
    start_index = index
    if node_cache[:ipaddr_prefix_length].has_key?(index)
      cached = node_cache[:ipaddr_prefix_length][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      if has_terminal?('\G[\\d]', true, index)
        r1 = true
        @index += 1
      else
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    if s0.empty?
      @index = i0
      r0 = nil
    else
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(IpaddrPrefixLength0)
    end

    node_cache[:ipaddr_prefix_length][start_index] = r0

    r0
  end

  module Port0
    def to_s
      text_value
    end
  end

  def _nt_port
    start_index = index
    if node_cache[:port].has_key?(index)
      cached = node_cache[:port][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    s0, i0 = [], index
    loop do
      if has_terminal?('\G[\\d]', true, index)
        r1 = true
        @index += 1
      else
        r1 = nil
      end
      if r1
        s0 << r1
      else
        break
      end
    end
    if s0.empty?
      @index = i0
      r0 = nil
    else
      r0 = instantiate_node(SyntaxNode,input, i0...index, s0)
      r0.extend(Port0)
    end

    node_cache[:port][start_index] = r0

    r0
  end

  module KeyName0
  end

  module KeyName1
    def to_s
      text_value.strip_quotes
    end
  end

  def _nt_key_name
    start_index = index
    if node_cache[:key_name].has_key?(index)
      cached = node_cache[:key_name][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    if has_terminal?('"', false, index)
      r2 = instantiate_node(SyntaxNode,input, index...(index + 1))
      @index += 1
    else
      terminal_parse_failure('"')
      r2 = nil
    end
    s1 << r2
    if r2
      s3, i3 = [], index
      loop do
        if has_terminal?('\G[\\w\\.\\/\\-_]', true, index)
          r4 = true
          @index += 1
        else
          r4 = nil
        end
        if r4
          s3 << r4
        else
          break
        end
      end
      if s3.empty?
        @index = i3
        r3 = nil
      else
        r3 = instantiate_node(SyntaxNode,input, i3...index, s3)
      end
      s1 << r3
      if r3
        if has_terminal?('"', false, index)
          r5 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('"')
          r5 = nil
        end
        s1 << r5
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(KeyName0)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r0 = r1
      r0.extend(KeyName1)
    else
      if has_terminal?('\G[\\w\\.\\/\\-_]', true, index)
        r6 = true
        @index += 1
      else
        r6 = nil
      end
      if r6
        r0 = r6
        r0.extend(KeyName1)
      else
        @index = i0
        r0 = nil
      end
    end

    node_cache[:key_name][start_index] = r0

    r0
  end

  module AddressMatch0
    def ipaddr_prefix_length
      elements[1]
    end
  end

  module AddressMatch1
    def ipaddr
      elements[1]
    end

    def space
      elements[3]
    end
  end

  module AddressMatch2
    def space1
      elements[1]
    end

    def key_name
      elements[2]
    end

    def space2
      elements[3]
    end
  end

  module AddressMatch3
    def acl_name
      elements[0]
    end

    def space
      elements[1]
    end
  end

  module AddressMatch4
    def space1
      elements[1]
    end

    def space2
      elements[3]
    end

    def space3
      elements[5]
    end
  end

  module AddressMatch5
    def to_s
      text_value
    end
  end

  def _nt_address_match
    start_index = index
    if node_cache[:address_match].has_key?(index)
      cached = node_cache[:address_match][index]
      if cached
        cached = SyntaxNode.new(input, index...(index + 1)) if cached == true
        @index = cached.interval.end
      end
      return cached
    end

    i0 = index
    i1, s1 = index, []
    if has_terminal?('!', false, index)
      r3 = instantiate_node(SyntaxNode,input, index...(index + 1))
      @index += 1
    else
      terminal_parse_failure('!')
      r3 = nil
    end
    if r3
      r2 = r3
    else
      r2 = instantiate_node(SyntaxNode,input, index...index)
    end
    s1 << r2
    if r2
      r4 = _nt_ipaddr
      s1 << r4
      if r4
        i6, s6 = index, []
        if has_terminal?('/', false, index)
          r7 = instantiate_node(SyntaxNode,input, index...(index + 1))
          @index += 1
        else
          terminal_parse_failure('/')
          r7 = nil
        end
        s6 << r7
        if r7
          r8 = _nt_ipaddr_prefix_length
          s6 << r8
        end
        if s6.last
          r6 = instantiate_node(SyntaxNode,input, i6...index, s6)
          r6.extend(AddressMatch0)
        else
          @index = i6
          r6 = nil
        end
        if r6
          r5 = r6
        else
          r5 = instantiate_node(SyntaxNode,input, index...index)
        end
        s1 << r5
        if r5
          r9 = _nt_space
          s1 << r9
        end
      end
    end
    if s1.last
      r1 = instantiate_node(SyntaxNode,input, i1...index, s1)
      r1.extend(AddressMatch1)
    else
      @index = i1
      r1 = nil
    end
    if r1
      r0 = r1
      r0.extend(AddressMatch5)
    else
      i10, s10 = index, []
      if has_terminal?('key', false, index)
        r11 = instantiate_node(SyntaxNode,input, index...(index + 3))
        @index += 3
      else
        terminal_parse_failure('key')
        r11 = nil
      end
      s10 << r11
      if r11
        r12 = _nt_space
        s10 << r12
        if r12
          r13 = _nt_key_name
          s10 << r13
          if r13
            r14 = _nt_space
            s10 << r14
          end
        end
      end
      if s10.last
        r10 = instantiate_node(SyntaxNode,input, i10...index, s10)
        r10.extend(AddressMatch2)
      else
        @index = i10
        r10 = nil
      end
      if r10
        r0 = r10
        r0.extend(AddressMatch5)
      else
        i15, s15 = index, []
        r16 = _nt_acl_name
        s15 << r16
        if r16
          r17 = _nt_space
          s15 << r17
        end
        if s15.last
          r15 = instantiate_node(SyntaxNode,input, i15...index, s15)
          r15.extend(AddressMatch3)
        else
          @index = i15
          r15 = nil
        end
        if r15
          r0 = r15
          r0.extend(AddressMatch5)
        else
          i18, s18 = index, []
          if has_terminal?('{', false, index)
            r19 = instantiate_node(SyntaxNode,input, index...(index + 1))
            @index += 1
          else
            terminal_parse_failure('{')
            r19 = nil
          end
          s18 << r19
          if r19
            r20 = _nt_space
            s18 << r20
            if r20
              s21, i21 = [], index
              loop do
                r22 = _nt_address_match
                if r22
                  s21 << r22
                else
                  break
                end
              end
              if s21.empty?
                @index = i21
                r21 = nil
              else
                r21 = instantiate_node(SyntaxNode,input, i21...index, s21)
              end
              s18 << r21
              if r21
                r23 = _nt_space
                s18 << r23
                if r23
                  if has_terminal?('}', false, index)
                    r24 = instantiate_node(SyntaxNode,input, index...(index + 1))
                    @index += 1
                  else
                    terminal_parse_failure('}')
                    r24 = nil
                  end
                  s18 << r24
                  if r24
                    r25 = _nt_space
                    s18 << r25
                  end
                end
              end
            end
          end
          if s18.last
            r18 = instantiate_node(SyntaxNode,input, i18...index, s18)
            r18.extend(AddressMatch4)
          else
            @index = i18
            r18 = nil
          end
          if r18
            r0 = r18
            r0.extend(AddressMatch5)
          else
            @index = i0
            r0 = nil
          end
        end
      end
    end

    node_cache[:address_match][start_index] = r0

    r0
  end

end

class NamedConfParser < Treetop::Runtime::CompiledParser
  include NamedConf
end
