<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLabelablesTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('labelables', function (Blueprint $table) {
            $table->increments('id');
            $table->integer('user_id')->unsigned()->nullable()->index('fk_labelables_user_id_idx');
            $table->integer('label_id')->unsigned()->nullable()->index('fk_labelables_label_id_idx');
            $table->integer('labelable_id')->unsigned()->nullable();
            $table->string('labelable_type', 45)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::drop('labelables');
    }
}
