<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCommentsTable extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('comments', function (Blueprint $table) {
            $table->increments('id');
            $table->string('commentable_type', 45)->nullable()->index('commentable_fulltext');
            $table->integer('commentable_id')->unsigned()->nullable();
            $table->integer('user_id')->unsigned()->nullable()->index('fk_comments_user_id_idx');
            $table->text('comment', 65535)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::drop('comments');
    }
}
