# HariboteOS

《30天自制操作系统》（川合秀实 著）配套代码改编版。因为作者使用了其自己编写的一套非标准的工具，且无法在非Windows平台下运行，所以本项目在原代码的基础上使用NASM、GCC、Qemu等工具进行编译、运行。

本项目已完成第0～28天内容（除去第28天日文显示部分），项目主要实现已经完成。因为该书后两章内容更偏向于应用层面，所以便不在本项目中实现，有兴趣的朋友可以根据前面的基础上继续完成。

## 项目特色

- 采用GCC、NASM作为工具链，可跨平台使用
- 基于LinkerScript构建内核
- 不依赖于作者自定义HRB文件格式，支持ELF文件格式
- 支持部分C标准库函数的简单实现（libc文件）
- 头文件拆分，结构更为清晰
- 中文键盘支持

## 环境依赖

- `nasm`
- `gcc`
- `binutils`
- `qemu-system-i386`
- `mtools`

### 可选依赖

- `gdb`（调试使用）

### Mac下安装

MacOS下默认Xcode Command Line Tools使用的gcc为clang的别名，在本项目实现中未对clang进行测试，可能会存在问题。

在Mac下推荐使用`x86_64-elf-gcc`工具链进行编译，可使用`brew install x86_64-elf-gcc x86_64-elf-binutils x86_64-elf-gdb`安装。

### 运行

进入对应的文件夹，使用下面的命令运行：

```bash
$ make qemu
# 若使用工具链包含前缀，如x86_64-elf-，可以使用GCCPREFIX
$ make qemu GCCPREFIX=x86_64-elf-
```

若要使用GDB进行调试，请设置`DEBUG`：

```bash
$ make qemu DEBUG=1
```

## 最终目录结构

- `app`：应用程序源码
- `include`：系统内核头文件
- `kernel`：系统内核代码
- `libc`：简单的C标准库部分实现

## C标准库实现

- `strcmp`
- `strncmp`

参考自xv6实现：

- `vsprintf`
- `sprintf`

来自《C程序设计语言》：

- `rand`

## 项目进度

- [X] 第1天：Hello world
- [X] 第2天：汇编与Makefile
- [X] 第3天：进入32位模式
- [X] 第4天：画面显示
- [X] 第5天：GDT/IDT
- [X] 第6天：中断处理
- [X] 第7天：FIFO
- [X] 第8天：鼠标与32位模式
- [X] 第9天：内存管理
- [X] 第10天：窗口叠加
- [X] 第11天：窗口处理
- [X] 第12天：定时器1
- [X] 第13天：定时器2
- [X] 第14天：键盘输入
- [X] 第15天：多任务1
- [X] 第16天：多任务2
- [X] 第17天：命令行窗口
- [X] 第18天：命令行命令
- [X] 第19天：应用程序
- [X] 第20天：API
- [X] 第21天：保护操作系统
- [X] 第22天：C语言应用程序（修改为ELF格式）
- [X] 第23天：应用程序图形处理
- [X] 第24天：窗口操作
- [X] 第25天：更多窗口
- [X] 第26天：窗口操作提速
- [X] 第27天：LDT与库（未按书上处理）
- [X] 第28天：文件操作与文字显示（不包含日文显示部分）

本项目不继续添加第29天以及第30天的内容，有兴趣的朋友可继续阅读后续章节。

## 待解决问题

- [ ] 定时器执行若使用`io_sti`而非`io_stihlt`时会卡死
- [ ] 启动时偶尔黑屏，无法正常绘制界面
- [ ] 多个命令行同时执行命令时会卡死
- [ ] 第28天中`__alloca`无效，`sosu2`无法运行

## 博客文章

- [第0天：前言](https://www.ghosind.com/2021/03/31/hariboteos-0)
- [第1天：Hello world](https://www.ghosind.com/2021/04/28/hariboteos-1)

## 版权信息

项目中代码版权主要归原书作者所有，本人仅针对无法直接运行的部分对该代码作出部分修改。
