"use strict";
/*
This file is part of web3.js.

web3.js is free software: you can redistribute it and/or modify
it under the terms of the GNU Lesser General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

web3.js is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with web3.js.  If not, see <http://www.gnu.org/licenses/>.
*/
Object.defineProperty(exports, "__esModule", { value: true });
exports.uint8ArrayEquals = exports.uint8ArrayConcat = exports.isUint8Array = void 0;
function isUint8Array(data) {
    var _a, _b;
    return (data instanceof Uint8Array ||
        ((_a = data === null || data === void 0 ? void 0 : data.constructor) === null || _a === void 0 ? void 0 : _a.name) === 'Uint8Array' ||
        ((_b = data === null || data === void 0 ? void 0 : data.constructor) === null || _b === void 0 ? void 0 : _b.name) === 'Buffer');
}
exports.isUint8Array = isUint8Array;
function uint8ArrayConcat(...parts) {
    const length = parts.reduce((prev, part) => {
        const agg = prev + part.length;
        return agg;
    }, 0);
    const result = new Uint8Array(length);
    let offset = 0;
    for (const part of parts) {
        result.set(part, offset);
        offset += part.length;
    }
    return result;
}
exports.uint8ArrayConcat = uint8ArrayConcat;
/**
 * Returns true if the two passed Uint8Arrays have the same content
 */
function uint8ArrayEquals(a, b) {
    if (a === b) {
        return true;
    }
    if (a.byteLength !== b.byteLength) {
        return false;
    }
    for (let i = 0; i < a.byteLength; i += 1) {
        if (a[i] !== b[i]) {
            return false;
        }
    }
    return true;
}
exports.uint8ArrayEquals = uint8ArrayEquals;
//# sourceMappingURL=uint8array.js.map