import { Web3Context } from 'web3-core';
import { DataFormat, DEFAULT_RETURN_FORMAT, Web3NetAPI } from 'web3-types';
export declare class Net extends Web3Context<Web3NetAPI> {
    /**
     * Gets the current network ID
     *
     * @param returnFormat - Return format
     * @returns A Promise of the network ID.
     * @example
     * ```ts
     * const net = new Net(Net.givenProvider || 'ws://some.local-or-remote.node:8546');
     * await net.getId();
     * > 1
     * ```
     */
    getId<ReturnFormat extends DataFormat = typeof DEFAULT_RETURN_FORMAT>(returnFormat?: ReturnFormat): Promise<import("web3-types").NumberTypes[ReturnFormat["number"]]>;
    /**
     * Get the number of peers connected to.
     *
     * @param returnFormat - Return format
     * @returns A promise of the number of the peers connected to.
     * @example
     * ```ts
     * const net = new Net(Net.givenProvider || 'ws://some.local-or-remote.node:8546');
     * await net.getPeerCount();
     * > 0
     * ```
     */
    getPeerCount<ReturnFormat extends DataFormat = typeof DEFAULT_RETURN_FORMAT>(returnFormat?: ReturnFormat): Promise<import("web3-types").NumberTypes[ReturnFormat["number"]]>;
    /**
     * Check if the node is listening for peers
     *
     * @returns A promise of a boolean if the node is listening to peers
     * @example
     * ```ts
     * const net = new Net(Net.givenProvider || 'ws://some.local-or-remote.node:8546');
     * await net.isListening();
     * > true
     * ```
     */
    isListening(): Promise<boolean>;
}
