import { ContractExecutionError, TransactionRevertedWithoutReasonError, TransactionRevertInstructionError, TransactionRevertWithCustomError, InvalidResponseError, TransactionPollingTimeoutError } from 'web3-errors';
import { FormatType, ETH_DATA_FORMAT, DataFormat, Bytes, ContractAbi, HexString, Numbers, Transaction, TransactionReceipt } from 'web3-types';
export declare type InternalTransaction = FormatType<Transaction, typeof ETH_DATA_FORMAT>;
export declare type SendTransactionEventsBase<ReturnFormat extends DataFormat, TxType> = {
    sending: FormatType<TxType, typeof ETH_DATA_FORMAT>;
    sent: FormatType<TxType, typeof ETH_DATA_FORMAT>;
    transactionHash: FormatType<Bytes, ReturnFormat>;
    receipt: FormatType<TransactionReceipt, ReturnFormat>;
    confirmation: {
        confirmations: FormatType<Numbers, ReturnFormat>;
        receipt: FormatType<TransactionReceipt, ReturnFormat>;
        latestBlockHash: FormatType<Bytes, ReturnFormat>;
    };
    error: TransactionRevertedWithoutReasonError<FormatType<TransactionReceipt, ReturnFormat>> | TransactionRevertInstructionError<FormatType<TransactionReceipt, ReturnFormat>> | TransactionRevertWithCustomError<FormatType<TransactionReceipt, ReturnFormat>> | TransactionPollingTimeoutError | InvalidResponseError | ContractExecutionError;
};
export declare type SendTransactionEvents<ReturnFormat extends DataFormat> = SendTransactionEventsBase<ReturnFormat, Transaction>;
export declare type SendSignedTransactionEvents<ReturnFormat extends DataFormat> = SendTransactionEventsBase<ReturnFormat, Bytes>;
export interface SendTransactionOptions<ResolveType = TransactionReceipt> {
    ignoreGasPricing?: boolean;
    transactionResolver?: (receipt: TransactionReceipt) => ResolveType;
    contractAbi?: ContractAbi;
    checkRevertBeforeSending?: boolean;
    ignoreFillingGasLimit?: boolean;
}
export interface SendSignedTransactionOptions<ResolveType = TransactionReceipt> {
    transactionResolver?: (receipt: TransactionReceipt) => ResolveType;
    contractAbi?: ContractAbi;
    checkRevertBeforeSending?: boolean;
}
export interface RevertReason {
    reason: string;
    signature?: HexString;
    data?: HexString;
}
export interface RevertReasonWithCustomError extends RevertReason {
    customErrorName: string;
    customErrorDecodedSignature: string;
    customErrorArguments: Record<string, unknown>;
}
