import { Web3Error } from 'web3-types';
export declare abstract class BaseWeb3Error extends Error implements Web3Error {
    readonly name: string;
    abstract readonly code: number;
    stack: string | undefined;
    innerError: Error | Error[] | undefined;
    constructor(msg?: string, innerError?: Error | Error[]);
    static convertToString(value: unknown, unquotValue?: boolean): string;
    toJSON(): {
        name: string;
        code: number;
        message: string;
        innerError: Error | Error[] | undefined;
    };
}
export declare abstract class InvalidValueError extends BaseWeb3Error {
    readonly name: string;
    constructor(value: unknown, msg: string);
}
