/**
 *  A **Provider** provides a connection to the blockchain, whch can be
 *  used to query its current state, simulate execution and send transactions
 *  to update the state.
 *
 *  It is one of the most fundamental components of interacting with a
 *  blockchain application, and there are many ways to connect, such as over
 *  HTTP, WebSockets or injected providers such as [MetaMask](link-metamask).
 *
 *  @_section: api/providers:Providers  [about-providers]
 */


export {
    AbstractProvider, UnmanagedSubscriber
} from "./abstract-provider.js";

export {
    AbstractSigner,
    VoidSigner,
} from "./abstract-signer.js";

export {
    showThrottleMessage
} from "./community.js";

export { getDefaultProvider } from "./default-provider.js";

export {
    EnsResolver,
    MulticoinProviderPlugin
} from "./ens-resolver.js";

export { Network } from "./network.js";

export { NonceManager } from "./signer-noncemanager.js";

export {
    NetworkPlugin,
    GasCostPlugin,
    EnsPlugin,
    FeeDataNetworkPlugin,
    FetchUrlFeeDataNetworkPlugin,
} from "./plugins-network.js";

export {
    Block,
    FeeData,
    Log,
    TransactionReceipt,
    TransactionResponse,

    copyRequest,
    //resolveTransactionRequest,
} from "./provider.js";

export { FallbackProvider } from "./provider-fallback.js";
export { JsonRpcApiProvider, JsonRpcProvider, JsonRpcSigner } from "./provider-jsonrpc.js"

export { BrowserProvider } from "./provider-browser.js";

export { AlchemyProvider } from "./provider-alchemy.js";
export { AnkrProvider } from "./provider-ankr.js";
export { CloudflareProvider } from "./provider-cloudflare.js";
export { ChainstackProvider } from "./provider-chainstack.js";
export { EtherscanProvider, EtherscanPlugin } from "./provider-etherscan.js";
export { InfuraProvider, InfuraWebSocketProvider } from "./provider-infura.js";
export { PocketProvider } from "./provider-pocket.js";
export { QuickNodeProvider } from "./provider-quicknode.js";

import { IpcSocketProvider } from "./provider-ipcsocket.js"; /*-browser*/
export { IpcSocketProvider };
export { SocketProvider } from "./provider-socket.js";
export { WebSocketProvider } from "./provider-websocket.js";

export {
    SocketSubscriber, SocketBlockSubscriber, SocketPendingSubscriber,
    SocketEventSubscriber
} from "./provider-socket.js";

export type {
    AbstractProviderOptions, Subscription, Subscriber,
    AbstractProviderPlugin,
    PerformActionFilter, PerformActionTransaction, PerformActionRequest,
} from "./abstract-provider.js"

export type { ContractRunner } from "./contracts.js";

export type {
    BlockParams, LogParams, TransactionReceiptParams,
    TransactionResponseParams,
} from "./formatting.js";

/*
export type {
    CommunityResourcable
} from "./community.js";

export type {
    AvatarLinkageType, AvatarLinkage, AvatarResult
} from "./ens-resolver.js";
*/
export type { Networkish } from "./network.js";

export type { GasCostParameters } from "./plugins-network.js";

export type {
    BlockTag,
    TransactionRequest, PreparedTransactionRequest,
    EventFilter, Filter, FilterByBlockHash, OrphanFilter, ProviderEvent,
    TopicFilter,
    Provider,
    MinedBlock, MinedTransactionResponse
} from "./provider.js";

export type {
    DebugEventBrowserProvider, Eip1193Provider
} from "./provider-browser.js";

export type { FallbackProviderOptions } from "./provider-fallback.js";

export type {
    JsonRpcPayload, JsonRpcResult, JsonRpcError,
    JsonRpcApiProviderOptions,
    JsonRpcTransactionRequest,
} from "./provider-jsonrpc.js";

export type {
    WebSocketCreator, WebSocketLike
} from "./provider-websocket.js";

export type { Signer } from "./signer.js";

