package railo.runtime.debug;

import railo.commons.io.res.Resource;

/**
 * debug page
 */
public interface DebugPage {

    /**
     * sets the execution time of the page
     * @param t execution time of the page
     */
    public abstract void set(long t);

    /**
     * return the minimum execution time of the page
     * @return minimum execution time
     */
    public abstract int getMinimalExecutionTime();

    /**
     * return the maximum execution time of the page
     * @return maximum execution time
     */
    public abstract int getMaximalExecutionTime();

    /**
     * return the average execution time of the page
     * @return average execution time
     */
    public abstract int getAverageExecutionTime();

    /**
     * return count of call the page
     * @return average execution time
     */
    public abstract int getCount();

    /**
     * return file represetati9on of the debug page
     * @return file object
     */
    public abstract Resource getFile();

}