<!---=0D=0A=09Name:=09=09=09debugging-coldfire.cfm=0D=0A=09Author:=09=09=09=
Nathan=20Mische=0D=0A=09Created:=09=095/19/2009=0D=0A--->=0D=0A=0D=0A=0D=0A=
<!---=20Check=20that=20ColdFire=20is=20enabled=20--->=0D=0A<cfif=20=
IsDebugMode()=0D=0A=09and=20=
StructKeyExists(GetHttpRequestData().headers,"User-Agent")=0D=0A=09and=20=
FindNoCase("ColdFire",GetHttpRequestData().headers["User-Agent"])=20gt=20=
0>=0D=0A=09=0D=0A=09<!---=20Do=20we=20have=20the=20correct=20version=20=
of=20the=20extension=20for=20this=20debug=20template=20--->=0D=0A=09=
<cfif=20=
REFind("ColdFire/\d*\.\d*\.207\.\d*",GetHttpRequestData().headers["User-Ag=
ent"])=20gt=200>=0D=0A=09=09<!---=20Build=20Headers=20--->=0D=0A=09=09=
<cfset=20coldfire_udf_main(debugMode=3Dfalse,maxHeader=3D8000)>=0D=0A=09=
<cfelse>=0D=0A=09=09<!---=20Return=20Error=20--->=0D=0A=09=09<cfset=20=
coldfire_udf_error(debugMode=3Dfalse,maxHeader=3D8000,msg=3D"This=20=
version=20of=20the=20ColdFire=20extension,=20=
#REReplace(GetHttpRequestData().headers['User-Agent'],'.*ColdFire/(\d*[\.\=
d*]+).*','\1')#,=20is=20incompatible=20with=20the=20server's=20version=20=
of=20the=20ColdFire=20debug=20template,=20207.")>=0D=0A=09</cfif>=09=0D=0A=
=0D=0A<!---=20Set=20to=20true=20if=20you=20would=20like=20to=20fall=20=
back=20to=20a=20different=20template=20--->=0D=0A<cfelseif=20false>=0D=0A=
=0D=0A=09<cfinclude=20template=3D"debugging-neo.cfm"=20/>=0D=0A=09=09=0D=0A=
</cfif>=0D=0A=0D=0A=0D=0A<cffunction=20=0D=0A=09=
name=3D"coldfire_udf_error"=20=0D=0A=09returntype=3D"void"=20=0D=0A=09=
output=3D"true"=0D=0A=09hint=3D"Returns=20an=20error=20message=20in=20=
the=20general=20header.">=0D=0A=09=0D=0A=09<cfargument=20=
name=3D"debugMode"=20type=3D"boolean"=20required=3D"false"=20=
default=3D"false">=0D=0A=09<cfargument=20name=3D"maxHeader"=20=
type=3D"numeric"=20required=3D"false"=20default=3D"8000">=0D=0A=09=
<cfargument=20name=3D"msg"=20type=3D"string"=20required=3D"true">=0D=0A=09=
=0D=0A=09<cfset=20var=20result=20=3D=20StructNew()>=0D=0A=09<cfset=20var=20=
general=20=3D=20queryNew("label,value")>=0D=0A=09=0D=0A=09<cfset=20=
queryAddRow(general)>=0D=0A=09<cfset=20querySetCell(general,=20"label",=20=
"Error")>=0D=0A=09<cfset=20querySetCell(general,=20"value",=20=
arguments.msg)>=0D=0A=09=0D=0A=09<cfset=20result.general=3D=20=
coldfire_udf_encode(general)>=0D=0A=09<cfset=20result.general=20=3D=20=
coldfire_udf_sizeSplit(result.general,=20arguments.maxHeader)>=0D=0A=09=0D=
=0A=09<cfif=20arguments.debugMode>=0D=0A=09=09<cfdump=20var=3D"#result#">=0D=
=0A=09</cfif>=0D=0A=0D=0A=09<cftry>=0D=0A=09<cfloop=20index=3D"x"=20=
from=3D"1"=20to=3D"#arrayLen(result.general)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-general-#x#"=20value=3D"#result.general[x]#">=0D=0A=09=
</cfloop>=0D=0A=09<cfcatch></cfcatch>=0D=0A=09</cftry>=09=0D=0A=09=0D=0A=
</cffunction>=0D=0A=0D=0A=0D=0A<cffunction=20=0D=0A=09=
name=3D"coldfire_udf_getCFCs"=0D=0A=09returntype=3D"query"=0D=0A=09=
output=3D"false"=20=0D=0A=09hint=3D"Gets=20CFC=20from=20the=20debugging=20=
info">=0D=0A=09=09=0D=0A=09<cfargument=20name=3D"data"=20type=3D"struct"=20=
required=3D"true">=0D=0A=09=0D=0A=09<cfset=20var=20pages=20=3D=20=
data.pages>=09=0D=0A=09<cfset=20var=20first_result=20=3D=20"">=0D=0A=09=
<cfset=20var=20result=20=3D=20=
queryNew("cfc,method,totaltime,totalinstances,avgtime")>=0D=0A=09<cfset=20=
var=20cfc=20=3D=20"">=0D=0A=09<cfset=20var=20method=20=3D=20"">=09=0D=0A=09=
=0D=0A=09<cfquery=20dbType=3D"query"=20name=3D"first_result"=20=
debug=3D"false">=0D=0A=09=09select=20src=20as=20template,=20total=20as=20=
totaltime,=20count=20as=20totalinstances,=20avg=20as=20avgtime=0D=0A=09=09=
from=20pages=0D=0A=09=09where=20src=20like=20'%.cfc%'=0D=0A=09</cfquery>=0D=
=0A=0D=0A=09<cfloop=20query=3D"first_result">=0D=0A=09=09<cfset=20=
queryAddRow(result)>=09=09=0D=0A=09=09<cfset=20cfc=20=3D=20=
trim(listFirst(template,"$"))>=09=09=0D=0A=09=09<cfset=20=
querySetCell(result,=20"cfc",=20cfc)>=0D=0A=09=09<cfif=20=
find("$",template)>=09=09=0D=0A=09=09=09<cfset=20method=20=3D=20=
trim(listLast(template,"$"))>=0D=0A=09=09<cfelse>=0D=0A=09=09=09<cfset=20=
method=20=3D=20"">=0D=0A=09=09</cfif>=0D=0A=09=09<cfset=20=
querySetCell(result,=20"method",method)>=0D=0A=09=09<cfset=20=
querySetCell(result,=20"totaltime",=20totaltime)>=0D=0A=09=09<cfset=20=
querySetCell(result,=20"totalinstances",=20totalinstances)>=0D=0A=09=09=
<cfset=20querySetCell(result,=20"avgtime",=20avgtime)>=09=09=0D=0A=09=
</cfloop>=0D=0A=09=0D=0A=09<cfreturn=20result>=09=0D=0A</cffunction>=0D=0A=
=0D=0A=0D=0A<cffunction=20=0D=0A=09name=3D"coldfire_udf_getChildTemplates"=
=0D=0A=09returntype=3D"query"=0D=0A=09output=3D"false"=20=0D=0A=09=
hint=3D"Gets=20includes,=20custom=20tags.">=0D=0A=09=09=0D=0A=09=
<cfargument=20name=3D"data"=20type=3D"struct"=20required=3D"true">=0D=0A=0D=
=0A=09<cfset=20var=20result=20=3D=20=
queryNew("template,totaltime,totalinstances,avgtime")>=0D=0A=09=0D=0A=09=
<!---=20TODO:=20Join=20with=20history=20and=20figure=20out=20which=20=
templates=20are=20child=20templates=20--->=0D=0A=09=0D=0A=09<cfreturn=20=
result=20/>=09=0D=0A=09=0D=0A</cffunction>=0D=0A=0D=0A=0D=0A<cffunction=20=
=0D=0A=09name=3D"coldfire_udf_getGeneral"=0D=0A=09returntype=3D"query"=0D=
=0A=09output=3D"false"=0D=0A=09hint=3D"Gets=20General=20info">=0D=0A=09=0D=
=0A=09<cfargument=20name=3D"data"=20type=3D"struct"=20required=3D"true">=0D=
=0A=09=0D=0A=09<cfset=20var=20result=20=3D=20queryNew("label,value")>=0D=0A=
=09<cfset=20var=20myapp=20=3D=20"">=0D=0A=09<cfset=20var=20totaltime=20=3D=
=200>=0D=0A=09<cfset=20var=20cfdebug_execution=20=3D=20"">=0D=0A=09=
<cfset=20var=20pages=20=3D=20data.pages>=0D=0A=09=0D=0A=09<cfif=20=
isDefined("application.applicationname")>=0D=0A=09=09<cfset=20myapp=20=3D=20=
application.applicationName>=0D=0A=09</cfif>=09=0D=0A=09=0D=0A=09<cfloop=20=
query=3D"pages">=0D=0A=09=09<cfset=20totaltime=20=3D=20totaltime=20+=20=
pages.total>=0D=0A=09</cfloop>=09=0D=0A=09=0D=0A=09<cfset=20=
queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20"label",=20=
"Server")>=0D=0A=09<cfset=20querySetCell(result,=20"value",=20=
"#server.coldfusion.productname#=20=
#coldfire_udf_ucase_first(server.coldfusion.productlevel)#=20=
#uCase(server.railo.state)#=20#server.railo.version#=20(CFML=20Version=20=
#server.ColdFusion.ProductVersion#)")>=0D=0A=09=0D=0A=09<cfset=20=
queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20"label",=20=
"Template")>=0D=0A=09<cfset=20querySetCell(result,=20"value",=20=
"#cgi.SCRIPT_NAME#=20(#getBaseTemplatePath()#)")>=0D=0A=09=0D=0A=09=
<cfset=20queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20=
"label",=20"Timestamp")>=0D=0A=09<cfset=20querySetCell(result,=20=
"value",=20"#LSDateFormat(now())#=20#LSTimeFormat(now())#")>=09=0D=0A=09=0D=
=0A=09<cftry>=0D=0A=09=09<cfset=20queryAddRow(result)>=0D=0A=09=09<cfset=20=
querySetCell(result,=20"label",=20"Time=20Zone")>=0D=0A=09=09<cfset=20=
querySetCell(result,=20"value",=20=
GetPageContext().getConfig().getTimeZone().getDisplayName())>=0D=0A=09=
<cfcatch></cfcatch>=0D=0A=09</cftry>=0D=0A=09=0D=0A=09<cfset=20=
queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20"label",=20=
"Locale")>=0D=0A=09<cfset=20querySetCell(result,=20"value",=20=
coldfire_udf_ucase_first(getLocale()))>=0D=0A=09=0D=0A=09<cfset=20=
queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20"label",=20=
"UserAgent")>=0D=0A=09<cfset=20querySetCell(result,=20"value",=20=
cgi.http_user_agent)>=0D=0A=09=0D=0A=09<cfset=20queryAddRow(result)>=0D=0A=
=09<cfset=20querySetCell(result,=20"label",=20"RemoteIP")>=0D=0A=09=
<cfset=20querySetCell(result,=20"value",=20cgi.remote_addr)>=0D=0A=09=0D=0A=
=09<cfset=20queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20=
"label",=20"HostName")>=0D=0A=09<cfset=20querySetCell(result,=20"value",=20=
cgi.server_name)>=0D=0A=09=0D=0A=09<cfset=20queryAddRow(result)>=0D=0A=09=
<cfset=20querySetCell(result,=20"label",=20"Application")>=0D=0A=09=
<cfset=20querySetCell(result,=20"value",=20myapp)>=0D=0A=09=0D=0A=09=
<cfset=20queryAddRow(result)>=0D=0A=09<cfset=20querySetCell(result,=20=
"label",=20"TotalExecTime")>=0D=0A=09<cfset=20querySetCell(result,=20=
"value",=20totaltime)>=0D=0A=09=09=0D=0A=09<cfreturn=20result>=0D=0A=09=0D=
=0A</cffunction>=0D=0A=0D=0A=0D=0A<cffunction=20=0D=0A=09=
name=3D"coldfire_udf_getQueries"=20=0D=0A=09returnType=3D"query"=0D=0A=09=
output=3D"false"=20=20=0D=0A=09hint=3D"Gets=20queries=20from=20debugging=20=
info">=0D=0A=09=09=0D=0A=09<cfargument=20name=3D"data"=20type=3D"struct"=20=
required=3D"true">=0D=0A=09=0D=0A=09<cfset=20var=20result=20=3D=20=
queryNew("datasource,=20queryname,=20et,=20sql,=20parameters,=20=
resultsets,=20recordsreturned,=20type,=20cachedquery,=20template,=20=
timestamp")>=09=0D=0A=09<cfset=20var=20coldfire_queries=20=3D=20=
data.queries>=09=0D=0A=09=0D=0A=09<!---=20Add=20SQL=20queries=20to=20the=20=
result=20--->=0D=0A=09<cfloop=20query=3D"coldfire_queries">=09=09=0D=0A=09=
=09<cfset=20QueryAddRow(result)>=0D=0A=09=09<cfset=20=
QuerySetCell(result,"datasource",coldfire_queries.datasource)>=0D=0A=09=09=
<cfset=20QuerySetCell(result,"queryname",coldfire_queries.name)>=0D=0A=09=
=09<cfset=20QuerySetCell(result,"et",coldfire_queries.time)>=09=09=0D=0A=09=
=09<cfset=20QuerySetCell(result,"sql",coldfire_queries.sql)>=0D=0A=09=09=
<cfset=20QuerySetCell(result,"parameters",ArrayNew(1))>=0D=0A=09=09=
<cfset=20QuerySetCell(result,"resultsets","")>=0D=0A=09=09<cfset=20=
QuerySetCell(result,"recordsreturned",Max(coldfire_queries.count,=200))>=0D=
=0A=09=09<cfset=20QuerySetCell(result,"type","SqlQuery")>=0D=0A=09=09=
<cfset=20QuerySetCell(result,"cachedquery","")>=0D=0A=09=09<cfset=20=
QuerySetCell(result,"template",coldfire_queries.src)>=0D=0A=09=09<cfset=20=
QuerySetCell(result,"timestamp","")>=09=0D=0A=09</cfloop>=0D=0A=09=0D=0A=09=
<cfreturn=20result>=0D=0A=09=0D=0A</cffunction>=0D=0A=0D=0A=0D=0A=
<cffunction=20=0D=0A=09name=3D"coldfire_udf_getTemplates"=20=0D=0A=09=
returtType=3D"query"=0D=0A=09output=3D"false"=20=0D=0A=09hint=3D"Gets=20=
templates.">=0D=0A=09=0D=0A=09<cfargument=20name=3D"data"=20=
type=3D"struct"=20required=3D"true">=0D=0A=0D=0A=09<cfset=20var=20pages=20=
=3D=20data.pages>=09=0D=0A=09=0D=0A=09<!---=20TODO:=20Join=20with=20=
history=20and=20figure=20out=20which=20templates=20are=20top=20level=20=
templates=20--->=0D=0A=09=0D=0A=09<cfquery=20dbType=3D"query"=20=
name=3D"result"=20debug=3D"false">=0D=0A=09=09select=20src=20as=20=
template,=20total=20as=20totaltime,=20count=20as=20totalinstances,=20avg=20=
as=20avgtime=0D=0A=09=09from=20pages=0D=0A=09=09where=20src=20like=20=
'%.cfm'=0D=0A=09</cfquery>=0D=0A=09=0D=0A=09<cfreturn=20result>=09=0D=0A=09=
=0D=0A</cffunction>=0D=0A=0D=0A=0D=0A<cffunction=20=0D=0A=09=
name=3D"coldfire_udf_getTimer"=0D=0A=09returntype=3D"query"=20=20=0D=0A=09=
output=3D"false"=09=09=0D=0A=09hint=3D"Gets=20Timer=20info">=0D=0A=09=09=0D=
=0A=09<cfargument=20name=3D"data"=20type=3D"struct"=20required=3D"true">=0D=
=0A=09=0D=0A=09<cfset=20var=20timers=20=3D=20"">=0D=0A=09<cfset=20var=20=
result=20=3D=20queryNew("")>=0D=0A=09=0D=0A=09<cfif=20not=20=
isDefined("data.timers")>=0D=0A=09=09<cfset=20timers=20=3D=20=
queryNew('label,time,template')>=0D=0A=09<cfelse>=0D=0A=09=09<cfset=20=
timers=20=3D=20data.timers>=0D=0A=09</cfif>=09=0D=0A=09=0D=0A=09<cfquery=20=
dbType=3D"query"=20name=3D"result"=20debug=3D"false">=0D=0A=09=09select=09=
label=20as=20message,=20time=20as=20duration=0D=0A=09=09from=20timers=0D=0A=
=09</cfquery>=0D=0A=0D=0A=09<cfreturn=20result>=0D=0A</cffunction>=0D=0A=0D=
=0A=0D=0A<cffunction=20=0D=0A=09name=3D"coldfire_udf_getTrace"=0D=0A=09=
returntype=3D"query"=0D=0A=09output=3D"false"=20=20=0D=0A=09hint=3D"Gets=20=
Trace=20info">=0D=0A=09=0D=0A=09<cfargument=20name=3D"data"=20=
type=3D"struct"=20required=3D"true">=0D=0A=09=0D=0A=09<cfset=20var=20=
traces=20=3D=20"">=0D=0A=09<cfset=20var=20result=20=3D=20=
queryNew("message,endtime,priority,category,result,delta")>=0D=0A=09=
<cfset=20var=20first_result=20=3D=20"">=0D=0A=09<cfset=20var=20=
resultString=20=3D=20"">=0D=0A=09=0D=0A=09<cfif=20not=20=
isDefined("data.traces")>=0D=0A=09=09<cfset=20traces=20=3D=20=
queryNew("type,category,text,template,line,var,total,trace")>=0D=0A=09=
<cfelse>=0D=0A=09=09<cfset=20traces=20=3D=20data.traces>=0D=0A=09</cfif>=0D=
=0A=09=0D=0A=09<cfquery=20dbType=3D"query"=20name=3D"first_result"=20=
debug=3D"false">=0D=0A=09=09select=20type=20as=20priority,=20category=20=
as=20category,=20time=20as=20delta,=20text=20as=20message,=20varname,=20=
varvalue=0D=0A=09=09from=20traces=0D=0A=09</cfquery>=0D=0A=0D=0A=09=
<cfloop=20query=3D"first_result">=0D=0A=09=09=0D=0A=09=09<cfset=20=
QueryAddRow(result)>=0D=0A=09=09<cfset=20QuerySetCell(result,=20=
"message",=20message)>=0D=0A=09=09<cfset=20QuerySetCell(result,=20=
"endtime",=200)>=0D=0A=09=09<cfset=20QuerySetCell(result,=20"priority",=20=
priority)>=0D=0A=09=09<cfset=20QuerySetCell(result,=20"category",=20=
category)>=0D=0A=09=09<cfset=20QuerySetCell(result,=20"delta",=20delta)>=0D=
=0A=09=09=0D=0A=09=09<cfif=20currentRow=20is=201>=0D=0A=09=09=09<cfset=20=
QuerySetCell(result,=20"delta",=200)>=0D=0A=09=09</cfif>=0D=0A=09=09=
<!---=20TODO:=20Enhance=20Trace=20--->=0D=0A=09=09<cfif=20Len(varname)>=0D=
=0A=09=09=09<cfset=20QuerySetCell(result,=20"result",=20varname=20&=20=
"=3D"=20&=20varvalue)>=0D=0A=09=09</cfif>=0D=0A=09=09=09=09=09=09=0D=0A=09=
</cfloop>=0D=0A=09=0D=0A=09<cfreturn=20result>=0D=0A</cffunction>=0D=0A=0D=
=0A<cffunction=0D=0A=09name=3D"coldfire_udf_getVariables"=0D=0A=09=
returntype=3D"query"=0D=0A=09output=3D"false"=0D=0A=09hint=3D"Get=20=
Variable=20values">=0D=0A=09=0D=0A=09<cfargument=20name=3D"variableNames"=20=
type=3D"array"=20required=3D"true">=0D=0A=09=0D=0A=09<cfset=20var=20=
__coldfireResult__=20=3D=20queryNew("label,value")>=0D=0A=09<cfset=20var=20=
__coldfireX__=20=3D=201>=0D=0A=09=0D=0A=09<cfloop=20=
index=3D"__coldfireX__"=20from=3D"1"=20=
to=3D"#arrayLen(arguments.variableNames)#">=0D=0A=09=09=09=0D=0A=09=09=
<cftry>=0D=0A=09=09=09=0D=0A=09=09=09<cfset=20=
QueryAddRow(__coldfireResult__)>=09=09=0D=0A=09=09=09=09=0D=0A=09=09=09=
<!---=20set=20the=20label=20--->=0D=0A=09=09=09<cfset=20=
QuerySetCell(__coldfireResult__,"label",arguments.variableNames[__coldfire=
X__])>=0D=0A=09=09=09=0D=0A=09=09=09<cfif=20=
CompareNoCase(variableNames[__coldfireX__],"variables")=20neq=200=20and=20=
IsDefined(variableNames[__coldfireX__])>=09=09=09=09=09=09=09=09=0D=0A=09=
=09=09=09<!---=20get=20the=20value=20--->=0D=0A=09=09=09=09<cfset=20=
QuerySetCell(__coldfireResult__,"value",coldfire_udf_encode(evaluate(varia=
bleNames[__coldfireX__])))>=09=09=09=0D=0A=09=09=09<cfelseif=20=
StructKeyExists(request,"__coldFireVariableValues__")=20and=20=
StructKeyExists(request.__coldFireVariableValues__,variableNames[__coldfir=
eX__])>=0D=0A=09=09=09=09<!---=20check=20to=20see=20if=20we=20were=20=
using=20application.cfm=20--->=0D=0A=09=09=09=09<cfset=20=
QuerySetCell(__coldfireResult__,"value",coldfire_udf_encode(evaluate("requ=
est.__coldFireVariableValues__."=20&=20variableNames[__coldfireX__])))>=0D=
=0A=09=09=09<cfelseif=20=
CompareNoCase(variableNames[__coldfireX__],"variables")=20eq=200>=0D=0A=09=
=09=09=09<!---=20get=20the=20value=20--->=0D=0A=09=09=09=09<cfset=20=
QuerySetCell(__coldfireResult__,"value",coldfire_udf_encode(evaluate(varia=
bleNames[__coldfireX__])))>=09=0D=0A=09=09=09<cfelse>=0D=0A=09=09=09=09=
<!---=20set=20default=20value=20--->=0D=0A=09=09=09=09<cfset=20=
QuerySetCell(__coldfireResult__,"value",coldfire_udf_encode("undefined"))>=
=09=09=09=0D=0A=09=09=09</cfif>=0D=0A=09=09=0D=0A=09=09=09<cfcatch>=0D=0A=
=09=09=09=09<!---=20do=20nothing=20--->=0D=0A=09=09=09</cfcatch>=0D=0A=09=
=09=0D=0A=09=09</cftry>=0D=0A=09=09=0D=0A=09</cfloop>=0D=0A=09=0D=0A=09=
<cfreturn=20__coldfireResult__>=0D=0A=09=0D=0A</cffunction>=0D=0A=0D=0A=0D=
=0A<cffunction=20=0D=0A=09name=3D"coldfire_udf_main"=20=0D=0A=09=
returntype=3D"void"=20=0D=0A=09output=3D"true"=0D=0A=09hint=3D"Build=20=
and=20set=20Coldfire=20HTTP=20headers">=0D=0A=09=09=0D=0A=09<cfargument=20=
name=3D"debugMode"=20type=3D"boolean"=20required=3D"false"=20=
default=3D"false">=0D=0A=09<cfargument=20name=3D"maxHeader"=20=
type=3D"numeric"=20required=3D"false"=20default=3D"8000">=0D=0A=09=0D=0A=09=
<cfset=20var=20debugging=20=3D=20"">=0D=0A=09<cfset=20var=20result=20=3D=20=
StructNew()>=0D=0A=09<cfset=20var=20varJSON=20=3D=20"">=0D=0A=09<cfset=20=
var=20varArray=20=3D=20ArrayNew(1)>=09=0D=0A=09<cfset=20var=20=
requestData=20=3D=20GetHttpRequestData()>=0D=0A=09=0D=0A=09<!---=20Gets=20=
the=20debug=20data.=20--->=0D=0A=09<cfadmin=20action=3D"getDebugData"=20=
returnVariable=3D"debugging">=0D=0A=09=09=09=0D=0A=09<cftry>=0D=0A=09=0D=0A=
=09<cfif=20not=20IsDebugMode()>=0D=0A=09=09<!---=20Return=20Error=20--->=0D=
=0A=09=09<cfset=20=
coldfire_udf_error(debugMode=3Dfalse,maxHeader=3D8000,msg=3D"The=20=
coldfusion=20debugging=20service=20does=20not=20appear=20to=20be=20=
running.")>=0D=0A=09=09<cfreturn>=0D=0A=09</cfif>=0D=0A=09=09=0D=0A=09=
<cfif=20structKeyExists(requestData.headers,"x-coldfire-variables")>=0D=0A=
=09=09<cfset=20varJSON=20=3D=20=
requestData.headers["x-coldfire-variables"]>=0D=0A=09=09<cfset=20=
varArray=20=3D=20coldfire_udf_decode(varJSON)>=0D=0A=09</cfif>=09=09=09=0D=
=0A=09=0D=0A=09<cfset=20result.general=3D=20=
coldfire_udf_encode(coldfire_udf_getGeneral(debugging))>=09=0D=0A=09=
<cfset=20result.templates=20=3D=20=
coldfire_udf_encode(coldfire_udf_getTemplates(debugging))>=09=09=0D=0A=09=
<cfset=20result.ctemplates=20=3D=20=
coldfire_udf_encode(coldfire_udf_getChildTemplates(debugging))>=0D=0A=09=
<cfset=20result.cfcs=20=3D=20=
coldfire_udf_encode(coldfire_udf_getCFCs(debugging))>=0D=0A=09<cfset=20=
result.queries=20=3D=20=
coldfire_udf_encode(coldfire_udf_getQueries(debugging))>=0D=0A=09<cfset=20=
result.trace=20=3D=20=
coldfire_udf_encode(coldfire_udf_getTrace(debugging))>=0D=0A=09<cfset=20=
result.timer=20=3D=20=
coldfire_udf_encode(coldfire_udf_getTimer(debugging))>=09=09=09=09=0D=0A=09=
<cfset=20result.variables=20=3D=20=
coldfire_udf_encode(coldfire_udf_getVariables(varArray))>=0D=0A=0D=0A=09=
<!---=20now=20split=20into=20arrays=20--->=0D=0A=09<cfset=20=
result.general=20=3D=20coldfire_udf_sizeSplit(result.general,=20=
arguments.maxHeader)>=0D=0A=09<cfset=20result.templates=20=3D=20=
coldfire_udf_sizeSplit(result.templates,=20arguments.maxHeader)>=0D=0A=09=
<cfset=20result.ctemplates=20=3D=20=
coldfire_udf_sizeSplit(result.ctemplates,=20arguments.maxHeader)>=0D=0A=09=
<cfset=20result.cfcs=20=3D=20coldfire_udf_sizeSplit(result.cfcs,=20=
arguments.maxHeader)>=0D=0A=09<cfset=20result.queries=20=3D=20=
coldfire_udf_sizeSplit(result.queries,=20arguments.maxHeader)>=0D=0A=09=
<cfset=20result.trace=20=3D=20coldfire_udf_sizeSplit(result.trace,=20=
arguments.maxHeader)>=0D=0A=09<cfset=20result.timer=20=3D=20=
coldfire_udf_sizeSplit(result.timer,=20arguments.maxHeader)>=0D=0A=09=
<cfset=20result.variables=20=3D=20=
coldfire_udf_sizeSplit(result.variables,=20arguments.maxHeader)>=0D=0A=0D=
=0A=0D=0A=09<cfif=20arguments.debugMode>=0D=0A=09=09<cfdump=20=
var=3D"#result#">=0D=0A=09</cfif>=0D=0A=09=0D=0A=09<cfloop=20index=3D"x"=20=
from=3D"1"=20to=3D"#arrayLen(result.general)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-general-#x#"=20value=3D"#result.general[x]#">=0D=0A=09=
</cfloop>=09=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.templates)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-templates-#x#"=20value=3D"#result.templates[x]#">=0D=0A=
=09</cfloop>=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.ctemplates)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-ctemplates-#x#"=20value=3D"#result.ctemplates[x]#">=0D=
=0A=09</cfloop>=09=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.cfcs)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-cfcs-#x#"=20value=3D"#result.cfcs[x]#">=0D=0A=09=
</cfloop>=09=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.queries)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-queries-#x#"=20value=3D"#result.queries[x]#">=0D=0A=09=
</cfloop>=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.trace)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-trace-#x#"=20value=3D"#result.trace[x]#">=09=09=09=09=0D=
=0A=09</cfloop>=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.timer)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-timer-#x#"=20value=3D"#result.timer[x]#">=09=09=09=09=0D=
=0A=09</cfloop>=0D=0A=09<cfloop=20index=3D"x"=20from=3D"1"=20=
to=3D"#arrayLen(result.variables)#">=0D=0A=09=09<cfheader=20=
name=3D"x-coldfire-variables-#x#"=20value=3D"#result.variables[x]#">=09=09=
=09=09=0D=0A=09</cfloop>=0D=0A=09=0D=0A=09<cfcatch>=0D=0A=09=09<!---=20=
make=20sure=20we=20don't=20throw=20an=20error=20--->=0D=0A=09=09=
<cfrethrow/>=0D=0A=09</cfcatch>=0D=0A=09=0D=0A=09</cftry>=09=0D=0A=0D=0A=
</cffunction>=0D=0A=0D=0A=09=0D=0A=0D=0A=09=0D=0A<!---=20UTILITY=20=
FUNCTIONS=20--->=0D=0A=0D=0A=0D=0A=0D=0A=0D=0A<cffunction=20=0D=0A=09=
name=3D"coldfire_udf_CFDebugSerializable"=0D=0A=09returntype=3D"string"=0D=
=0A=09output=3D"false"=0D=0A=09hint=3D"Handle=20output=20of=20complex=20=
data=20types.Taken=20from=20classic.cfm.">=0D=0A=09=09=0D=0A=09=
<cfargument=20name=3D"variable"=20type=3D"any"=20required=3D"true">=0D=0A=
=09=0D=0A=09<cfset=20var=20ret=20=3D=20"undefined">=0D=0A=09=0D=0A=09=
<cftry>=0D=0A=09=09<cfif=20IsSimpleValue(variable)>=09=09=0D=0A=09=09=09=
<cfset=20ret=20=3D=20xmlFormat(variable)>=09=09=09=09=0D=0A=09=09=
<cfelseif=20IsStruct(variable)>=0D=0A=09=09=09<cfset=20ret=20=3D=20=
("Struct=20("=20&=20StructCount(variable)=20&=20")")>=09=09=09=0D=0A=09=09=
<cfelseif=20IsArray(variable)>=0D=0A=09=09=09<cfset=20ret=20=3D=20=
("Array=20("=20&=20ArrayLen(variable)=20&=20")")>=09=09=09=0D=0A=09=09=
<cfelseif=20IsQuery(variable)>=0D=0A=09=09=09<cfset=20ret=20=3D=20=
("Query=20("=20&=20variable.RecordCount=20&=20")")>=09=09=09=0D=0A=09=09=
<cfelse>=0D=0A=09=09=09<cfset=20ret=20=3D=20("Complex=20type")>=09=09=09=09=
=0D=0A=09=09</cfif>=09=09=0D=0A=09=09<cfcatch></cfcatch>=0D=0A=09=
</cftry>=0D=0A=09=0D=0A=09<cfreturn=20ret>=0D=0A=0D=0A</cffunction>=0D=0A=
=0D=0A=0D=0A=0D=0A=0D=0A<cffunction=20=0D=0A=09=
name=3D"coldfire_udf_decode"=20=0D=0A=09returntype=3D"any"=20=0D=0A=09=
output=3D"false"=0D=0A=09hint=3D"Converts=20data=20frm=20JSON=20to=20CF=20=
format">=0D=0A=09=0D=0A=09<cfargument=20name=3D"data"=20type=3D"string"=20=
required=3D"Yes"=20/>=0D=0A=09=0D=0A=09<!---=20DECLARE=20VARIABLES=20=
--->=0D=0A=09<cfset=20var=20ar=20=3D=20ArrayNew(1)=20/>=0D=0A=09<cfset=20=
var=20st=20=3D=20StructNew()=20/>=0D=0A=09<cfset=20var=20dataType=20=3D=20=
""=20/>=0D=0A=09<cfset=20var=20inQuotes=20=3D=20false=20/>=0D=0A=09=
<cfset=20var=20startPos=20=3D=201=20/>=0D=0A=09<cfset=20var=20=
nestingLevel=20=3D=200=20/>=0D=0A=09<cfset=20var=20dataSize=20=3D=200=20=
/>=0D=0A=09<cfset=20var=20i=20=3D=201=20/>=0D=0A=09<cfset=20var=20=
skipIncrement=20=3D=20false=20/>=0D=0A=09<cfset=20var=20j=20=3D=200=20/>=0D=
=0A=09<cfset=20var=20char=20=3D=20""=20/>=0D=0A=09<cfset=20var=20dataStr=20=
=3D=20""=20/>=0D=0A=09<cfset=20var=20structVal=20=3D=20""=20/>=0D=0A=09=
<cfset=20var=20structKey=20=3D=20""=20/>=0D=0A=09<cfset=20var=20colonPos=20=
=3D=20""=20/>=0D=0A=09<cfset=20var=20qRows=20=3D=200=20/>=0D=0A=09<cfset=20=
var=20qCol=20=3D=20""=20/>=0D=0A=09<cfset=20var=20qData=20=3D=20""=20/>=0D=
=0A=09<cfset=20var=20unescapeVals=20=3D=20"\"",\',\\,\/,\b,\t,\n,\f,\r"=20=
/>=0D=0A=09<cfset=20var=20unescapeToVals=20=3D=20=
""",',\,/,#Chr(8)#,#Chr(9)#,#Chr(10)#,#Chr(12)#,#Chr(13)#"=20/>=0D=0A=09=0D=
=0A=09<cfset=20var=20_data=20=3D=20Trim(arguments.data)=20/>=0D=0A=0D=0A=09=
<!---=20NULL=20--->=0D=0A=09<cfif=20NOT=20IsNumeric(_data)=20AND=20_data=20=
EQ=20"null">=0D=0A=09=09<cfreturn=20""=20/>=0D=0A=09=0D=0A=09<!---=20=
BOOLEAN=20--->=0D=0A=09<cfelseif=20NOT=20IsNumeric(_data)=20AND=20=
ListFindNoCase("True,False",=20_data)>=0D=0A=09=09<cfreturn=20_data=20/>=0D=
=0A=09=0D=0A=09<!---=20NUMBER=20--->=0D=0A=09<cfelseif=20=
IsNumeric(_data)>=0D=0A=09=09<cfreturn=20_data=20/>=0D=0A=09=0D=0A=09=
<!---=20EMPTY=20STRING=20--->=0D=0A=09<cfelseif=20_data=20EQ=20"''"=20OR=20=
_data=20EQ=20'""'>=0D=0A=09=09<cfreturn=20""=20/>=0D=0A=09=0D=0A=09<!---=20=
STRING=20--->=0D=0A=09<cfelseif=20ReFind('^".+"$',=20_data)=20EQ=201=20=
OR=20ReFind("^'.+'$",=20_data)=20EQ=201>=0D=0A=09=09<cfreturn=20=
ReplaceList(=20mid(_data,=202,=20Len(_data)-2),=20unescapeVals,=20=
unescapeToVals)=20/>=0D=0A=09=0D=0A=09<!---=20ARRAY,=20STRUCT,=20OR=20=
QUERY=20--->=0D=0A=09<cfelseif=20ReFind("^\[.*\]$",=20_data)=20EQ=201=0D=0A=
=09=09OR=20ReFind("^\{.*\}$",=20_data)=20EQ=201=0D=0A=09=09OR=20=
ReFindNoCase('^\{"recordcount":[0-9]+,"columnlist":"[^"]+","data":\{("[^"]=
+":\[[^]]*\],?)+\}\}$',=20_data,=200)=20EQ=201>=0D=0A=09=09=0D=0A=09=09=
<!---=20Store=20the=20data=20type=20we're=20dealing=20with=20--->=0D=0A=09=
=09<cfif=20ReFind("^\[.*\]$",=20_data)=20EQ=201>=0D=0A=09=09=09<cfset=20=
dataType=20=3D=20"array"=20/>=0D=0A=09=09<cfelseif=20=
ReFindNoCase('^\{"recordcount":[0-9]+,"columnlist":"[^"]+","data":\{("[^"]=
+":\[[^]]*\],?)+\}\}$',=20_data,=200)=20EQ=201>=0D=0A=09=09=09<cfset=20=
dataType=20=3D=20"query"=20/>=0D=0A=09=09<cfelse>=0D=0A=09=09=09<cfset=20=
dataType=20=3D=20"struct"=20/>=0D=0A=09=09</cfif>=0D=0A=09=09=0D=0A=09=09=
<!---=20Remove=20the=20brackets=20--->=0D=0A=09=09<cfset=20_data=20=3D=20=
Trim(=20Mid(_data,=202,=20Len(_data)-2)=20)=20/>=0D=0A=09=09=0D=0A=09=09=
<!---=20Deal=20with=20empty=20array/struct=20--->=0D=0A=09=09<cfif=20=
Len(_data)=20EQ=200>=0D=0A=09=09=09<cfif=20dataType=20EQ=20"array">=0D=0A=
=09=09=09=09<cfreturn=20ar=20/>=0D=0A=09=09=09<cfelse>=0D=0A=09=09=09=09=
<cfreturn=20st=20/>=0D=0A=09=09=09</cfif>=0D=0A=09=09</cfif>=0D=0A=09=09=0D=
=0A=09=09<!---=20Loop=20through=20the=20string=20characters=20--->=0D=0A=09=
=09<cfset=20dataSize=20=3D=20Len(_data)=20+=201=20/>=0D=0A=09=09<cfloop=20=
condition=3D"#i#=20LTE=20#dataSize#">=0D=0A=09=09=09<cfset=20=
skipIncrement=20=3D=20false=20/>=0D=0A=09=09=09<!---=20Save=20current=20=
character=20--->=0D=0A=09=09=09<cfset=20char=20=3D=20Mid(_data,=20i,=20=
1)=20/>=0D=0A=09=09=09=0D=0A=09=09=09<!---=20If=20char=20is=20a=20quote,=20=
switch=20the=20quote=20status=20--->=0D=0A=09=09=09<cfif=20char=20EQ=20=
'"'>=0D=0A=09=09=09=09<cfset=20inQuotes=20=3D=20NOT=20inQuotes=20/>=0D=0A=
=09=09=09<!---=20If=20char=20is=20escape=20character,=20skip=20the=20=
next=20character=20--->=0D=0A=09=09=09<cfelseif=20char=20EQ=20"\"=20AND=20=
inQuotes>=0D=0A=09=09=09=09<cfset=20i=20=3D=20i=20+=202=20/>=0D=0A=09=09=09=
=09<cfset=20skipIncrement=20=3D=20true=20/>=0D=0A=09=09=09<!---=20If=20=
char=20is=20a=20comma=20and=20is=20not=20in=20quotes,=20or=20if=20end=20=
of=20string,=20deal=20with=20data=20--->=0D=0A=09=09=09<cfelseif=20(char=20=
EQ=20","=20AND=20NOT=20inQuotes=20AND=20nestingLevel=20EQ=200)=20OR=20i=20=
EQ=20Len(_data)+1>=0D=0A=09=09=09=09<cfset=20dataStr=20=3D=20Mid(_data,=20=
startPos,=20i-startPos)=20/>=0D=0A=09=09=09=09=0D=0A=09=09=09=09<!---=20=
If=20data=20type=20is=20array,=20append=20data=20to=20the=20array=20--->=0D=
=0A=09=09=09=09<cfif=20dataType=20EQ=20"array">=0D=0A=09=09=09=09=09=
<cfset=20arrayappend(=20ar,=20coldfire_udf_decode(dataStr)=20)=20/>=0D=0A=
=09=09=09=09<!---=20If=20data=20type=20is=20struct=20or=20query...=20=
--->=0D=0A=09=09=09=09<cfelseif=20dataType=20EQ=20"struct"=20OR=20=
dataType=20EQ=20"query">=0D=0A=09=09=09=09=09<cfset=20dataStr=20=3D=20=
Mid(_data,=20startPos,=20i-startPos)=20/>=0D=0A=09=09=09=09=09<cfset=20=
colonPos=20=3D=20Find(":",=20dataStr)=20/>=0D=0A=09=09=09=09=09<cfset=20=
structKey=20=3D=20Trim(=20Mid(dataStr,=201,=20colonPos-1)=20)=20/>=0D=0A=09=
=09=09=09=09=0D=0A=09=09=09=09=09<!---=20If=20needed,=20remove=20quotes=20=
from=20keys=20--->=0D=0A=09=09=09=09=09<cfif=20Left(structKey,=201)=20EQ=20=
"'"=20OR=20Left(structKey,=201)=20EQ=20'"'>=0D=0A=09=09=09=09=09=09=
<cfset=20structKey=20=3D=20Mid(=20structKey,=202,=20Len(structKey)-2=20)=20=
/>=0D=0A=09=09=09=09=09</cfif>=0D=0A=09=09=09=09=09=0D=0A=09=09=09=09=09=
<cfset=20structVal=20=3D=20Mid(=20dataStr,=20colonPos+1,=20=
Len(dataStr)-colonPos=20)=20/>=0D=0A=09=09=09=09=09=0D=0A=09=09=09=09=09=
<!---=20If=20struct,=20add=20to=20the=20structure=20--->=0D=0A=09=09=09=09=
=09<cfif=20dataType=20EQ=20"struct">=0D=0A=09=09=09=09=09=09<cfset=20=
StructInsert(=20st,=20structKey,=20coldfire_udf_decode(structVal)=20)=20=
/>=0D=0A=09=09=09=09=09=0D=0A=09=09=09=09=09<!---=20If=20query,=20build=20=
the=20query=20--->=0D=0A=09=09=09=09=09<cfelse>=0D=0A=09=09=09=09=09=09=
<cfif=20structKey=20EQ=20"recordcount">=0D=0A=09=09=09=09=09=09=09<cfset=20=
qRows=20=3D=20coldfire_udf_decode(structVal)=20/>=0D=0A=09=09=09=09=09=09=
<cfelseif=20structKey=20EQ=20"columnlist">=0D=0A=09=09=09=09=09=09=09=
<cfset=20st=20=3D=20QueryNew(=20coldfire_udf_decode(structVal)=20)=20/>=0D=
=0A=09=09=09=09=09=09=09<cfif=20qRows>=0D=0A=09=09=09=09=09=09=09=09=
<cfset=20QueryAddRow(st,=20qRows)=20/>=0D=0A=09=09=09=09=09=09=09</cfif>=0D=
=0A=09=09=09=09=09=09<cfelseif=20structKey=20EQ=20"data">=0D=0A=09=09=09=09=
=09=09=09<cfset=20qData=20=3D=20coldfire_udf_decode(structVal)=20/>=0D=0A=
=09=09=09=09=09=09=09<cfset=20ar=20=3D=20StructKeyArray(qData)=20/>=0D=0A=
=09=09=09=09=09=09=09<cfloop=20from=3D"1"=20to=3D"#ArrayLen(ar)#"=20=
index=3D"j">=0D=0A=09=09=09=09=09=09=09=09<cfloop=20from=3D"1"=20=
to=3D"#st.recordcount#"=20index=3D"qRows">=0D=0A=09=09=09=09=09=09=09=09=09=
<cfset=20qCol=20=3D=20ar[j]=20/>=0D=0A=09=09=09=09=09=09=09=09=09<cfset=20=
QuerySetCell(st,=20qCol,=20qData[qCol][qRows],=20qRows)=20/>=0D=0A=09=09=09=
=09=09=09=09=09</cfloop>=0D=0A=09=09=09=09=09=09=09</cfloop>=0D=0A=09=09=09=
=09=09=09</cfif>=0D=0A=09=09=09=09=09</cfif>=0D=0A=09=09=09=09</cfif>=0D=0A=
=09=09=09=09=0D=0A=09=09=09=09<cfset=20startPos=20=3D=20i=20+=201=20/>=0D=
=0A=09=09=09<!---=20If=20starting=20a=20new=20array=20or=20struct,=20add=20=
to=20nesting=20level=20--->=0D=0A=09=09=09<cfelseif=20"{["=20CONTAINS=20=
char=20AND=20NOT=20inQuotes>=0D=0A=09=09=09=09<cfset=20nestingLevel=20=3D=20=
nestingLevel=20+=201=20/>=0D=0A=09=09=09<!---=20If=20ending=20an=20array=20=
or=20struct,=20subtract=20from=20nesting=20level=20--->=0D=0A=09=09=09=
<cfelseif=20"]}"=20CONTAINS=20char=20AND=20NOT=20inQuotes>=0D=0A=09=09=09=
=09<cfset=20nestingLevel=20=3D=20nestingLevel=20-=201=20/>=0D=0A=09=09=09=
</cfif>=0D=0A=09=09=09=0D=0A=09=09=09<cfif=20NOT=20skipIncrement>=0D=0A=09=
=09=09=09<cfset=20i=20=3D=20i=20+=201=20/>=0D=0A=09=09=09</cfif>=0D=0A=09=
=09</cfloop>=0D=0A=09=09=0D=0A=09=09<!---=20Return=20appropriate=20value=20=
based=20on=20data=20type=20--->=0D=0A=09=09<cfif=20dataType=20EQ=20=
"array">=0D=0A=09=09=09<cfreturn=20ar=20/>=0D=0A=09=09<cfelse>=0D=0A=09=09=
=09<cfreturn=20st=20/>=0D=0A=09=09</cfif>=0D=0A=09=0D=0A=09<!---=20=
INVALID=20JSON=20--->=0D=0A=09<cfelse>=0D=0A=09=09<cfthrow=20=
message=3D"Invalid=20JSON"=20detail=3D"The=20document=20you=20are=20=
trying=20to=20decode=20is=20not=20in=20valid=20JSON=20format"=20/>=0D=0A=09=
</cfif>=0D=0A</cffunction>=0D=0A=0D=0A=0D=0A=0D=0A=0D=0A<cffunction=20=0D=
=0A=09name=3D"coldfire_udf_encode"=20=0D=0A=09returntype=3D"string"=20=0D=
=0A=09output=3D"false"=0D=0A=09hint=3D"Converts=20data=20from=20CF=20to=20=
JSON=20format">=0D=0A=09=09=0D=0A=09<cfargument=20name=3D"data"=20=
type=3D"any"=20required=3D"Yes"=20/>=0D=0A=09<!---=0D=0A=09=09The=20=
following=20argument=20allows=20for=20formatting=20queries=20in=20query=20=
or=20struct=20format=0D=0A=09=09If=20set=20to=20query,=20query=20will=20=
be=20a=20structure=20of=20colums=20filled=20with=20arrays=20of=20data=0D=0A=
=09=09If=20set=20to=20array,=20query=20will=20be=20an=20array=20of=20=
records=20filled=20with=20a=20structure=20of=20columns=0D=0A=09--->=0D=0A=
=09<cfargument=20name=3D"queryFormat"=20type=3D"string"=20required=3D"No"=20=
default=3D"query"=20/>=0D=0A=09<cfargument=20name=3D"queryKeyCase"=20=
type=3D"string"=20required=3D"No"=20default=3D"upper"=20/>=0D=0A=09=
<cfargument=20name=3D"stringNumbers"=20type=3D"boolean"=20required=3D"No"=20=
default=3Dfalse=20>=0D=0A=09<cfargument=20name=3D"formatDates"=20=
type=3D"boolean"=20required=3D"No"=20default=3Dfalse=20>=0D=0A=09=0D=0A=09=
<!---=20VARIABLE=20DECLARATION=20--->=0D=0A=09<cfset=20var=20jsonString=20=
=3D=20""=20/>=0D=0A=09<cfset=20var=20tempVal=20=3D=20""=20/>=0D=0A=09=
<cfset=20var=20arKeys=20=3D=20""=20/>=0D=0A=09<cfset=20var=20colPos=20=3D=20=
1=20/>=0D=0A=09<cfset=20var=20i=20=3D=201=20/>=0D=0A=09=0D=0A=09<cfset=20=
var=20ignoreStructKeys=20=3D=20=
"_CF_HTMLASSEMBLER,__COLDFIREVARIABLEVALUES__,__COLDFIRETRACEVALUES__,__CO=
LDFIRETRACESTARTTIME__">=0D=0A=09<cfset=20var=20ignoreFunctionPrefix=20=3D=
=20"coldfire_udf">=0D=0A=09=0D=0A=09<cfset=20var=20_data=20=3D=20=
arguments.data=20/>=0D=0A=0D=0A=09<cfset=20var=20recordcountKey=20=3D=20=
""=20/>=0D=0A=09<cfset=20var=20columnlistKey=20=3D=20""=20/>=0D=0A=09=
<cfset=20var=20columnlist=20=3D=20""=20/>=0D=0A=09<cfset=20var=20dataKey=20=
=3D=20""=20/>=0D=0A=09<cfset=20var=20column=20=3D=20""=20/>=0D=0A=09=0D=0A=
=09<!---=20ARRAY=20--->=0D=0A=09<cfif=20IsArray(_data)=20AND=20NOT=20=
IsBinary(_data)>=0D=0A=09=09<cfset=20jsonString=20=3D=20ArrayNew(1)/>=09=0D=
=0A=09=09<cfloop=20from=3D"1"=20to=3D"#ArrayLen(_data)#"=20index=3D"i">=0D=
=0A=09=09=09<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20_data[i],=20=
arguments.queryFormat,=20arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=
<cfset=20ArrayAppend(jsonString,=20tempVal)=20/>=0D=0A=09=09</cfloop>=09=09=
=0D=0A=09=09<cfreturn=20"["=20&=20ArrayToList(jsonString,",")=20&=20"]"=20=
/>=0D=0A=09=09=0D=0A=09<!---=20BINARY=20--->=0D=0A=09<cfelseif=20=
IsBinary(_data)>=0D=0A=09=09<cfset=20jsonString=20=3D=20ArrayNew(1)/>=09=09=
=0D=0A=09=09<cfloop=20from=3D"1"=20to=3D"#Min(ArrayLen(_data),1000)#"=20=
index=3D"i">=0D=0A=09=09=09<cfset=20ArrayAppend(jsonString,_data[i])=20=
/>=0D=0A=09=09</cfloop>=09=09=0D=0A=09=09<cfreturn=20=
"{""__cftype__"":""binary"",""data"":"""=20&=20=
ArrayToList(jsonString,"")=20&=20""",""length"":"=20&=20ArrayLen(_data)=20=
&=20"}"=20/>=0D=0A=0D=0A=09<!---=20BOOLEAN=20--->=0D=0A=09<cfelseif=20=
IsBoolean(_data)=20AND=20NOT=20IsNumeric(_data)=20AND=20NOT=20=
ListFindNoCase("Yes,No",=20_data)>=0D=0A=09=09<cfreturn=20=
LCase(ToString(_data))=20/>=0D=0A=09=09=0D=0A=09<!---=20CUSTOM=20=
FUNCTION=20--->=0D=0A=09<cfelseif=20IsCustomFunction(_data)>=0D=0A=09=09=
<cfset=20md=20=3D=20GetMetaData(_data)=20/>=0D=0A=09=09<cfif=20=
CompareNoCase(Left(md.name,Len(ignoreFunctionPrefix)),ignoreFunctionPrefix=
)=20eq=200>=0D=0A=09=09=09<cfreturn=20"coldfire_ignore_value"=20/>=0D=0A=09=
=09<cfelse>=09=09=0D=0A=09=09=09<cfset=20jsonString=20=3D=20ArrayNew(1)=20=
/>=0D=0A=09=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""customfunction""")>=0D=0A=09=09=09=
<cfset=20arKeys=20=3D=20StructKeyArray(md)=20/>=0D=0A=09=09=09<cfloop=20=
from=3D"1"=20to=3D"#ArrayLen(arKeys)#"=20index=3D"i">=0D=0A=09=09=09=09=
<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20md[=20arKeys[i]=20],=20=
arguments.queryFormat,=20arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09=
<cfset=20ArrayAppend(jsonString,=20'"'=20&=20arKeys[i]=20&=20'":'=20&=20=
tempVal)=20/>=0D=0A=09=09=09</cfloop>=0D=0A=09=09=09<cfreturn=20"{"=20&=20=
ArrayToList(jsonString,",")=20&=20"}"=20/>=0D=0A=09=09</cfif>=09=0D=0A=09=
=09=0D=0A=09<!---=20NUMBER=20--->=0D=0A=09<cfelseif=20NOT=20=
stringNumbers=20AND=20IsNumeric(_data)=20AND=20NOT=20=
REFind("^0+[^\.]",_data)>=0D=0A=09=09<cfreturn=20ToString(_data)=20/>=0D=0A=
=09=0D=0A=09<!---=20DATE=20--->=0D=0A=09<cfelseif=20IsDate(_data)=20AND=20=
arguments.formatDates>=0D=0A=09=09<cfreturn=20'"#DateFormat(_data,=20=
"mmmm,=20dd=20yyyy")#=20#TimeFormat(_data,=20"HH:mm:ss")#"'=20/>=0D=0A=09=
=09=0D=0A=09<!---=20WDDX=20--->=0D=0A=09<cfelseif=20IsWDDX(_data)>=0D=0A=09=
=09<cfwddx=20action=3D"wddx2cfml"=20input=3D"#_data#"=20output=3D"tempVal"=
=20/>=0D=0A=09=09<cfreturn=20"{""__cftype__"":""wddx"",""data"":"=20&=20=
coldfire_udf_encode(=20tempVal,=20arguments.queryFormat,=20=
arguments.queryKeyCase=20)=20&=20"}"=20/>=0D=0A=09=09=0D=0A=09<!---=20=
STRING=20--->=0D=0A=09<cfelseif=20IsSimpleValue(_data)>=0D=0A=09=09=
<cfreturn=20'"'=20&=20Replace(JSStringFormat(_data),=20"/",=20"\/",=20=
"ALL")=20&=20'"'=20/>=0D=0A=09=09=0D=0A=09<!---=20OBJECT=20--->=0D=0A=09=
<cfelseif=20IsObject(_data)>=09=0D=0A=09=09<cfset=20md=20=3D=20=
GetMetaData(_data)=20/>=09=0D=0A=09=09<cfset=20arKeys=20=3D=20=
StructKeyArray(md)=20/>=09=09=0D=0A=09=09=0D=0A=09=09<cfif=20=
ArrayLen(arKeys)=20eq=200>=0D=0A=09=09=09<!---=20java=20object=20--->=0D=0A=
=09=09=09<cftry>=0D=0A=09=09=09=09<cfset=20jsonString=20=3D=20=
ArrayNew(1)=20/>=0D=0A=09=09=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""java""")=20/>=0D=0A=09=09=09=09=0D=
=0A=09=09=09=09<!---=20get=20the=20class=20name=20--->=0D=0A=09=09=09=09=0D=
=0A=09=09=09=09<cfset=20ArrayAppend(jsonString,'"CLASSNAME":"'=20&=20=
_data.getClass().getName()=20&=20'"')=20/>=0D=0A=09=09=09=09=0D=0A=09=09=09=
=09<!---=20get=20object=20method=20data,=20this=20could=20probabaly=20=
use=20some=20work=20--->=0D=0A=09=09=09=09=0D=0A=09=09=09=09<cfset=20=
methods=20=3D=20_data.getClass().getMethods()>=0D=0A=09=09=09=09<cfset=20=
methodStruct=20=3D=20StructNew()=20/>=0D=0A=09=09=09=09<cfset=20=
methodArray=20=3D=20ArrayNew(1)=20/>=0D=0A=09=09=09=09<cfloop=20from=3D"1"=
=20to=3D"#ArrayLen(methods)#"=20index=3D"i">=09=0D=0A=09=09=09=09=09=
<cfset=20methodString=20=3D=20methods[i].getName()=20&=20"("=20/>=0D=0A=09=
=09=09=09=09<cfset=20params=20=3D=20methods[i].getParameterTypes()>=0D=0A=
=09=09=09=09=09<cfset=20delim=20=3D=20""/>=0D=0A=09=09=09=09=09<cfloop=20=
from=3D"1"=20to=3D"#ArrayLen(params)#"=20index=3D"x">=0D=0A=09=09=09=09=09=
=09<cfset=20methodString=20=3D=20methodString=20&=20delim=20&=20"=20"=20=
&=20params[x].getCanonicalName()=20/>=0D=0A=09=09=09=09=09=09<cfset=20=
delim=20=3D=20","=20/>=0D=0A=09=09=09=09=09</cfloop>=0D=0A=09=09=09=09=09=
<cfset=20methodString=20=3D=20methodString=20&=20")"=20/>=09=0D=0A=09=09=09=
=09=09<cfset=20methodStruct[methods[i].getName()]=20=3D=20StructNew()=20=
/>=0D=0A=09=09=09=09=09<cfset=20=
methodStruct[methods[i].getName()].method=20=3D=20methodString=20/>=09=0D=
=0A=09=09=09=09=09<cfset=20methodStruct[methods[i].getName()].returntype=20=
=3D=20methods[i].getReturnType().getCanonicalName()=20/>=0D=0A=09=09=09=09=
</cfloop>=09=09=09=09=0D=0A=09=09=09=09<cfset=20sortedKeys=20=3D=20=
StructSort(methodStruct,"textnocase","asc","method")=20/>=09=09=09=09=0D=0A=
=09=09=09=09=0D=0A=09=09=09=09<cfloop=20from=3D"1"=20=
to=3D"#ArrayLen(sortedKeys)#"=20index=3D"i">=0D=0A=09=09=09=09=09<cfset=20=
ArrayAppend(methodArray,methodStruct[sortedKeys[i]])=20/>=0D=0A=09=09=09=09=
</cfloop>=0D=0A=0D=0A=09=09=09=09<cfset=20tempVal=20=3D=20=
coldfire_udf_encode(=20methodArray,=20arguments.queryFormat,=20=
arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09=0D=0A=09=09=09=09=
<cfset=20ArrayAppend(jsonString,'"METHODS":'=20&=20tempVal)=20/>=0D=0A=09=
=09=09=09=0D=0A=09=09=09=09<!---=20get=20object=20field=20data,=20not=20=
getting=20values=20--->=0D=0A=09=09=09=09<cfset=20fields=20=3D=20=
_data.getClass().getFields()>=0D=0A=09=09=09=09<cfset=20fieldStruct=20=3D=20=
StructNew()=20/>=0D=0A=09=09=09=09<cfset=20fieldArray=20=3D=20=
ArrayNew(1)=20/>=09=09=09=09=0D=0A=09=09=09=09<cfloop=20from=3D"1"=20=
to=3D"#ArrayLen(fields)#"=20index=3D"i">=09=0D=0A=09=09=09=09=09<cfset=20=
fieldStruct[fields[i].getName()]=20=3D=20StructNew()=20/>=0D=0A=09=09=09=09=
=09<cfset=20fieldStruct[fields[i].getName()].field=20=3D=20=
fields[i].getType().getName()=20&=20"=20"=20&=20fields[i].getName()=20/>=09=
=0D=0A=09=09=09=09=09<cfset=20fieldStruct[fields[i].getName()].value=20=3D=
=20fields[i].getType().getName()=20/>=0D=0A=09=09=09=09</cfloop>=09=09=09=
=09=0D=0A=09=09=09=09<cfset=20sortedKeys=20=3D=20=
StructSort(fieldStruct,"textnocase","asc","field")=20/>=0D=0A=09=09=09=09=
=0D=0A=09=09=09=09<cfloop=20from=3D"1"=20to=3D"#ArrayLen(sortedKeys)#"=20=
index=3D"i">=0D=0A=09=09=09=09=09<cfset=20=
ArrayAppend(fieldArray,fieldStruct[sortedKeys[i]])=20/>=0D=0A=09=09=09=09=
</cfloop>=0D=0A=09=09=09=09=0D=0A=09=09=09=09<cfset=20tempVal=20=3D=20=
coldfire_udf_encode(=20fieldArray,=20arguments.queryFormat,=20=
arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09=0D=0A=09=09=09=09=
<cfset=20ArrayAppend(jsonString,'"FIELDS":'=20&=20tempVal)=20/>=0D=0A=09=09=
=09=09=0D=0A=09=09=09=09=0D=0A=09=09=09=09<cfreturn=20"{"=20&=20=
ArrayToList(jsonString,",")=20&=20"}"=20/>=09=09=09=09=0D=0A=09=09=09=0D=0A=
=09=09=09=09<cfcatch=20type=3D"any">=0D=0A=09=09=09=09=09<cfreturn=20=
"{""__cftype__"":""unknown""}"=20/>=09=0D=0A=09=09=09=09</cfcatch>=0D=0A=09=
=09=09</cftry>=09=09=09=0D=0A=09=09<cfelse>=0D=0A=09=09=09<!---=20=
component=20--->=09=09=0D=0A=09=09=09<cfset=20jsonString=20=3D=20=
ArrayNew(1)=20/>=0D=0A=09=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""component""")=20/>=0D=0A=09=09=09=
<cfloop=20from=3D"1"=20to=3D"#ArrayLen(arKeys)#"=20index=3D"i">=09=09=09=0D=
=0A=09=09=09=09<cfif=20ListFind("NAME,FUNCTIONS",arKeys[i])>=0D=0A=09=09=09=
=09=09<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20md[=20arKeys[i]=20=
],=20arguments.queryFormat,=20arguments.queryKeyCase=20)=20/>=0D=0A=09=09=
=09=09=09<cfset=20ArrayAppend(jsonString,=20'"'=20&=20arKeys[i]=20&=20=
'":'=20&=20tempVal)=20/>=0D=0A=09=09=09=09</cfif>=0D=0A=09=09=09=
</cfloop>=0D=0A=09=09=09<cfreturn=20"{"=20&=20=
ArrayToList(jsonString,",")=20&=20"}"=20/>=0D=0A=09=09</cfif>=0D=0A=09=0D=
=0A=09<!---=20STRUCT=20--->=0D=0A=09<cfelseif=20IsStruct(_data)>=0D=0A=09=
=09<cfset=20jsonString=20=3D=20ArrayNew(1)=20/>=0D=0A=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""struct""")=20/>=0D=0A=09=09=
<cfset=20arKeys=20=3D=20StructKeyArray(_data)=20/>=0D=0A=09=09<cfloop=20=
from=3D"1"=20to=3D"#ArrayLen(arKeys)#"=20index=3D"i">=09=09=09=0D=0A=09=09=
=09<cfif=20ListFindNoCase(ignoreStructKeys,=20arKeys[i])=20eq=200>=0D=0A=09=
=09=09=09<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20_data[=20=
arKeys[i]=20],=20arguments.queryFormat,=20arguments.queryKeyCase=20)=20=
/>=0D=0A=09=09=09=09<cfif=20tempVal=20neq=20"coldfire_ignore_value">=0D=0A=
=09=09=09=09=09<cfset=20ArrayAppend(jsonString,=20'"'=20&=20arKeys[i]=20=
&=20'":'=20&=20tempVal)=20/>=0D=0A=09=09=09=09</cfif>=0D=0A=09=09=09=
</cfif>=09=09=09=0D=0A=09=09</cfloop>=09=09=09=09=0D=0A=09=09<cfreturn=20=
"{"=20&=20ArrayToList(jsonString,",")=20&=20"}"=20/>=09=09=0D=0A=09=0D=0A=
=09<!---=20QUERY=20--->=0D=0A=09<cfelseif=20IsQuery(_data)>=0D=0A=09=09=
<!---=20Add=20query=20meta=20data=20--->=0D=0A=09=09<cfif=20=
arguments.queryKeyCase=20EQ=20"lower">=0D=0A=09=09=09<cfset=20=
recordcountKey=20=3D=20"recordcount"=20/>=0D=0A=09=09=09<cfset=20=
columnlistKey=20=3D=20"columnlist"=20/>=0D=0A=09=09=09<cfset=20=
columnlist=20=3D=20LCase(_data.columnlist)=20/>=0D=0A=09=09=09<cfset=20=
dataKey=20=3D=20"data"=20/>=0D=0A=09=09<cfelse>=0D=0A=09=09=09<cfset=20=
recordcountKey=20=3D=20"RECORDCOUNT"=20/>=0D=0A=09=09=09<cfset=20=
columnlistKey=20=3D=20"COLUMNLIST"=20/>=0D=0A=09=09=09<cfset=20=
columnlist=20=3D=20UCase(_data.columnlist)=20/>=0D=0A=09=09=09<cfset=20=
dataKey=20=3D=20"DATA"=20/>=0D=0A=09=09</cfif>=0D=0A=09=09<cfset=20=
jsonString=20=3D=20ArrayNew(1)=20/>=0D=0A=09=09<cfset=20=
ArrayAppend(jsonString,"""#recordcountKey#"":#_data.recordcount#,")=20/>=0D=
=0A=09=09<cfset=20=
ArrayAppend(jsonString,"""#columnlistKey#"":""#columnlist#"",")=20/>=0D=0A=
=09=09<cfset=20ArrayAppend(jsonString,"""#dataKey#"":")=20/>=0D=0A=09=09=09=
=09=0D=0A=09=09<!---=20Make=20query=20a=20structure=20of=20arrays=20--->=0D=
=0A=09=09<cfif=20arguments.queryFormat=20EQ=20"query">=0D=0A=09=09=09=
<cfset=20ArrayAppend(jsonString,"{")=20/>=0D=0A=09=09=09<cfset=20colPos=20=
=3D=201=20/>=0D=0A=09=09=09=0D=0A=09=09=09<cfloop=20=
list=3D"#_data.columnlist#"=20delimiters=3D","=20index=3D"column">=0D=0A=09=
=09=09=09<cfif=20colPos=20GT=201>=0D=0A=09=09=09=09=09<cfset=20=
ArrayAppend(jsonString,",")=20/>=0D=0A=09=09=09=09</cfif>=0D=0A=09=09=09=09=
<cfif=20arguments.queryKeyCase=20EQ=20"lower">=0D=0A=09=09=09=09=09=
<cfset=20column=20=3D=20LCase(column)=20/>=0D=0A=09=09=09=09</cfif>=0D=0A=
=09=09=09=09<cfset=20ArrayAppend(jsonString,"""#column#"":[")=20/>=0D=0A=09=
=09=09=09=0D=0A=09=09=09=09<cfloop=20from=3D"1"=20=
to=3D"#_data.recordcount#"=20index=3D"i">=0D=0A=09=09=09=09=09<!---=20=
Get=20cell=20value;=20recurse=20to=20get=20proper=20format=20depending=20=
on=20string/number/boolean=20data=20type=20--->=0D=0A=09=09=09=09=09=
<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20_data[column][i],=20=
arguments.queryFormat,=20arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09=
=09=0D=0A=09=09=09=09=09<cfif=20i=20GT=201>=0D=0A=09=09=09=09=09=09=
<cfset=20ArrayAppend(jsonString,",")=20/>=0D=0A=09=09=09=09=09</cfif>=0D=0A=
=09=09=09=09=09<cfset=20ArrayAppend(jsonString,tempVal)=20/>=0D=0A=09=09=09=
=09</cfloop>=0D=0A=09=09=09=09=0D=0A=09=09=09=09<cfset=20=
ArrayAppend(jsonString,"]")=20/>=0D=0A=09=09=09=09=0D=0A=09=09=09=09=
<cfset=20colPos=20=3D=20colPos=20+=201=20/>=0D=0A=09=09=09</cfloop>=0D=0A=
=09=09=09<cfset=20ArrayAppend(jsonString,"}")=20/>=0D=0A=09=09<!---=20=
Make=20query=20an=20array=20of=20structures=20--->=0D=0A=09=09<cfelse>=0D=
=0A=09=09=09<cfset=20ArrayAppend(jsonString,"[")=20/>=0D=0A=09=09=09=
<cfloop=20query=3D"_data">=0D=0A=09=09=09=09<cfif=20CurrentRow=20GT=201>=0D=
=0A=09=09=09=09=09<cfset=20ArrayAppend(jsonString,",")=20/>=0D=0A=09=09=09=
=09</cfif>=0D=0A=09=09=09=09<cfset=20ArrayAppend(jsonString,"{")=20/>=0D=0A=
=09=09=09=09<cfset=20colPos=20=3D=201=20/>=0D=0A=09=09=09=09<cfloop=20=
list=3D"#columnlist#"=20delimiters=3D","=20index=3D"column">=0D=0A=09=09=09=
=09=09<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20=
_data[column][CurrentRow],=20arguments.queryFormat,=20=
arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09=09=0D=0A=09=09=09=09=09=
<cfif=20colPos=20GT=201>=0D=0A=09=09=09=09=09=09<cfset=20=
ArrayAppend(jsonString,",")=20/>=0D=0A=09=09=09=09=09</cfif>=0D=0A=09=09=09=
=09=09=0D=0A=09=09=09=09=09<cfif=20arguments.queryKeyCase=20EQ=20=
"lower">=0D=0A=09=09=09=09=09=09<cfset=20column=20=3D=20LCase(column)=20=
/>=0D=0A=09=09=09=09=09</cfif>=0D=0A=09=09=09=09=09<cfset=20=
ArrayAppend(jsonString,"""#column#"":#tempVal#")=20/>=0D=0A=09=09=09=09=09=
=0D=0A=09=09=09=09=09<cfset=20colPos=20=3D=20colPos=20+=201=20/>=0D=0A=09=
=09=09=09</cfloop>=0D=0A=09=09=09=09<cfset=20ArrayAppend(jsonString,"}")=20=
/>=0D=0A=09=09=09</cfloop>=0D=0A=09=09=09<cfset=20=
ArrayAppend(jsonString,"]")=20/>=0D=0A=09=09</cfif>=0D=0A=09=09=0D=0A=09=09=
<!---=20Wrap=20all=20query=20data=20into=20an=20object=20--->=0D=0A=09=09=
<cfreturn=20"{"=20&=20ArrayToList(jsonString,"")=20&=20"}"=20/>=0D=0A=09=09=
=0D=0A=09<!---=20XML=20DOC=20--->=0D=0A=09<cfelseif=20IsXMLDoc(_data)>=0D=
=0A=09=09<cfset=20jsonString=20=3D=20ArrayNew(1)=20/>=0D=0A=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""xmldoc""")=20/>=0D=0A=09=09=
<cfset=20arKeys=20=3D=20ListToArray("XmlComment,XmlRoot")=20/>=0D=0A=09=09=
<cfloop=20from=3D"1"=20to=3D"#ArrayLen(arKeys)#"=20index=3D"i">=09=09=09=0D=
=0A=09=09=09<cfif=20ListFindNoCase(ignoreStructKeys,=20arKeys[i])=20eq=20=
0>=0D=0A=09=09=09=09<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20=
_data[=20arKeys[i]=20],=20arguments.queryFormat,=20=
arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09<cfif=20tempVal=20neq=20=
"coldfire_ignore_value">=0D=0A=09=09=09=09=09<cfset=20=
ArrayAppend(jsonString,=20'"'=20&=20arKeys[i]=20&=20'":'=20&=20tempVal)=20=
/>=0D=0A=09=09=09=09</cfif>=0D=0A=09=09=09</cfif>=09=09=09=0D=0A=09=09=
</cfloop>=09=09=09=09=0D=0A=09=09<cfreturn=20"{"=20&=20=
ArrayToList(jsonString,",")=20&=20"}"=20/>=0D=0A=09=0D=0A=09<!---=20XML=20=
ELEMENT=20--->=0D=0A=09<cfelseif=20IsXmlElem(_data)>=0D=0A=09=09<cfset=20=
jsonString=20=3D=20ArrayNew(1)=20/>=0D=0A=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""xmlelem""")=20/>=0D=0A=09=09=
<cfset=20arKeys=20=3D=20=
ListToArray("XmlName,XmlNsPrefix,XmlNsURI,XmlText,XmlComment,XmlAttributes=
,XmlChildren")=20/>=0D=0A=09=09<cfloop=20from=3D"1"=20=
to=3D"#ArrayLen(arKeys)#"=20index=3D"i">=09=09=09=0D=0A=09=09=09<cfif=20=
ListFindNoCase(ignoreStructKeys,=20arKeys[i])=20eq=200>=0D=0A=09=09=09=09=
<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20_data[=20arKeys[i]=20],=20=
arguments.queryFormat,=20arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09=
<cfif=20tempVal=20neq=20"coldfire_ignore_value">=0D=0A=09=09=09=09=09=
<cfset=20ArrayAppend(jsonString,=20'"'=20&=20arKeys[i]=20&=20'":'=20&=20=
tempVal)=20/>=0D=0A=09=09=09=09</cfif>=0D=0A=09=09=09</cfif>=09=09=09=0D=0A=
=09=09</cfloop>=09=09=09=09=0D=0A=09=09<cfreturn=20"{"=20&=20=
ArrayToList(jsonString,",")=20&=20"}"=20/>=0D=0A=09=09=0D=0A=09<!---=20=
XML=20NODE=20--->=0D=0A=09<cfelseif=20IsXmlNode(_data)>=0D=0A=09=09=
<cfset=20jsonString=20=3D=20ArrayNew(1)=20/>=0D=0A=09=09<cfset=20=
ArrayAppend(jsonString,"""__cftype__"":""xmlnode""")=20/>=0D=0A=09=09=
<cfset=20arKeys=20=3D=20ListToArray("XmlName,XmlType,XmlValue")=20/>=0D=0A=
=09=09<cfloop=20from=3D"1"=20to=3D"#ArrayLen(arKeys)#"=20index=3D"i">=09=09=
=09=0D=0A=09=09=09<cfif=20ListFindNoCase(ignoreStructKeys,=20arKeys[i])=20=
eq=200>=0D=0A=09=09=09=09<cfset=20tempVal=20=3D=20coldfire_udf_encode(=20=
_data[=20arKeys[i]=20],=20arguments.queryFormat,=20=
arguments.queryKeyCase=20)=20/>=0D=0A=09=09=09=09<cfif=20tempVal=20neq=20=
"coldfire_ignore_value">=0D=0A=09=09=09=09=09<cfset=20=
ArrayAppend(jsonString,=20'"'=20&=20arKeys[i]=20&=20'":'=20&=20tempVal)=20=
/>=0D=0A=09=09=09=09</cfif>=0D=0A=09=09=09</cfif>=09=09=09=0D=0A=09=09=
</cfloop>=09=09=09=09=0D=0A=09=09<cfreturn=20"{"=20&=20=
ArrayToList(jsonString,",")=20&=20"}"=20/>=0D=0A=09=0D=0A=09<!---=20=
UNKNOWN=20OBJECT=20TYPE=20--->=0D=0A=09<cfelse>=0D=0A=09=09<cfreturn=20=
"{""__cftype__"":""unknown""}"=20/>=09=0D=0A=09</cfif>=0D=0A=
</cffunction>=0D=0A=0D=0A=0D=0A=0D=0A<!---=20TODO:=20Isn't=20there=20a=20=
Java=20method=20to=20make=20this=20quicker?=20--->=0D=0A<cffunction=20=0D=
=0A=09name=3D"coldfire_udf_sizeSplit"=20=0D=0A=09output=3D"false"=20=0D=0A=
=09hint=3D"Splits=20a=20string=20into=20an=20array=20of=20N=20chars">=0D=0A=
=09=0D=0A=09<cfargument=20name=3D"string"=20type=3D"string"=20=
required=3D"true">=0D=0A=09<cfargument=20name=3D"size"=20type=3D"numeric"=20=
required=3D"true">=0D=0A=09=0D=0A=09<cfset=20var=20result=20=3D=20=
arrayNew(1)>=0D=0A=09=0D=0A=09<cfif=20len(arguments.string)=20lt=20=
arguments.size>=0D=0A=09=09<cfset=20result[1]=20=3D=20arguments.string>=0D=
=0A=09=09<cfreturn=20result>=0D=0A=09</cfif>=0D=0A=0D=0A=09<cfloop=20=
condition=3D"len(arguments.string)=20gt=20arguments.size">=0D=0A=09=09=
<cfset=20arrayAppend(result,=20left(arguments.string,=20=
arguments.size))>=0D=0A=09=09<cfset=20arguments.string=20=3D=20=
right(arguments.string,=20len(arguments.string)-arguments.size)>=0D=0A=09=
</cfloop>=0D=0A=09<cfif=20len(arguments.string)>=0D=0A=09=09<cfset=20=
arrayAppend(result,arguments.string)>=0D=0A=09</cfif>=09=0D=0A=0D=0A=09=
<cfreturn=20result>=09=0D=0A</cffunction>=0D=0A=0D=0A=0D=0A=0D=0A=0D=0A=
<cffunction=0D=0A=09name=3D"coldfire_udf_ucase_first"=0D=0A=09=
output=3D"false"=0D=0A=09hint=3D"Makes=20first=20letter=20upper=20case">=0D=
=0A=09=0D=0A=09<cfargument=20name=3D"str"=20type=3D"string"=20=
required=3D"true">=0D=0A=09=0D=0A=09<cfset=20var=20size=20=3D=20=
Len(str)>=0D=0A=09<cfif=20size=20eq=200>=0D=0A=09=09<cfreturn=20str>=0D=0A=
=09<cfelseif=20size=20eq=201>=0D=0A=09=09<cfreturn=20UCase(str)>=0D=0A=09=
<cfelse>msg=0D=0A=09=09<cfreturn=20UCase(mid(str,1,1))=20&=20=
Mid(str,2,size)>=0D=0A=09</cfif>=0D=0A</cffunction>=0D=0A=
