/**
 * Implements the CFML Function querysetcell
 */
package railo.runtime.functions.query;

import railo.runtime.PageContext;
import railo.runtime.exp.FunctionException;
import railo.runtime.exp.PageException;
import railo.runtime.functions.BIF;
import railo.runtime.op.Caster;
import railo.runtime.type.Collection;
import railo.runtime.type.Query;
import railo.runtime.type.QueryImpl;
import railo.runtime.type.Struct;
import railo.runtime.type.StructImpl;
import railo.runtime.type.util.KeyConstants;

public final class QueryConvertForGrid extends BIF {

	private static final long serialVersionUID = 871091293736619034L;

	public static Struct call(PageContext pc , Query src, double dpage,double dpageSize) throws PageException {
		int page=(int) dpage;
		int pageSize=(int) dpageSize;
		if(page<1) {
			throw new FunctionException(pc,"QueryConvertForGrid",2,"page","page must be a positive number now ("+page+")");
		} 
		
		int start = ((page-1)*pageSize)+1;
		int end = start+pageSize;
		
		Collection.Key[] srcColumns = src.getColumnNames();
		int srcRows = src.getRowCount();

		int trgRows = srcRows-start+1;
		if (trgRows > pageSize) trgRows = pageSize;
		if(trgRows<0)trgRows=0;
		
		Query trg=new QueryImpl(srcColumns,trgRows,src.getName());
		int trgRow=0;
		for (int srcRow = start; (srcRow <= end) && (srcRow <= srcRows); srcRow++) {
			trgRow++;
			for (int col = 0; col < srcColumns.length; col++){
				trg.setAtEL(
					srcColumns[col], 
					trgRow,
					src.getAt(srcColumns[col],srcRow, null));
			}
		}
		
		Struct sct = new StructImpl();
		sct.setEL(KeyConstants._QUERY, trg);
		sct.setEL("TOTALROWCOUNT", new Integer(srcRows));
		return sct;
	}
	
	@Override
	public Object invoke(PageContext pc, Object[] args) throws PageException {
		return call(pc,Caster.toQuery(args[0]),Caster.toDoubleValue(args[1]),Caster.toDoubleValue(args[2]));
	}
}