package railo.runtime.db.driver.state;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import railo.runtime.PageContext;
import railo.runtime.PageContextImpl;
import railo.runtime.debug.ActiveQuery;

public class StateUtil {
	
	public static boolean execute(PageContext pc, Statement stat, String sql) throws SQLException {
		if(pc==null) return stat.execute(sql);
		PageContextImpl pci = (PageContextImpl)pc;
		try {
			setActiveStatement(pci,stat,sql);
			 return stat.execute(sql);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static boolean execute(PageContext pc, Statement stat, String sql, int autoGeneratedKeys) throws SQLException {
		if(pc==null) return stat.execute(sql,autoGeneratedKeys);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			 return stat.execute(sql,autoGeneratedKeys);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static boolean execute(PageContext pc, Statement stat, String sql, int[] columnIndexes) throws SQLException {
		if(pc==null) return stat.execute(sql,columnIndexes);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.execute(sql,columnIndexes);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static boolean execute(PageContext pc, Statement stat, String sql, String[] columnNames) throws SQLException {
		if(pc==null) return stat.execute(sql,columnNames);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.execute(sql,columnNames);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static ResultSet executeQuery(PageContext pc, Statement stat, String sql) throws SQLException {
		if(pc==null) return stat.executeQuery(sql);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.executeQuery(sql);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static int executeUpdate(PageContext pc, Statement stat, String sql) throws SQLException {
		if(pc==null) return stat.executeUpdate(sql);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.executeUpdate(sql);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static int executeUpdate(PageContext pc, Statement stat, String sql, int autoGeneratedKeys) throws SQLException {
		if(pc==null) return stat.executeUpdate(sql,autoGeneratedKeys);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.executeUpdate(sql,autoGeneratedKeys);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static int executeUpdate(PageContext pc, Statement stat, String sql, int[] columnIndexes) throws SQLException {
		if(pc==null) return stat.executeUpdate(sql,columnIndexes);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.executeUpdate(sql,columnIndexes);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static int executeUpdate(PageContext pc, Statement stat, String sql, String[] columnNames) throws SQLException {
		if(pc==null) return stat.executeUpdate(sql,columnNames);
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.executeUpdate(sql,columnNames);
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static boolean execute(PageContext pc, PreparedStatement stat, String sql) throws SQLException {
		if(pc==null) return stat.execute();
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.execute();
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static ResultSet executeQuery(PageContext pc, PreparedStatement stat, String sql) throws SQLException {
		if(pc==null) return stat.executeQuery();
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			return stat.executeQuery();
		}
		finally {
			pci.releaseActiveQuery();
		}
	}

	public static int executeUpdate(PageContext pc, PreparedStatement stat, String sql) throws SQLException {
		if(pc==null) return stat.executeUpdate();
		PageContextImpl pci = (PageContextImpl) pc;
		try {
			setActiveStatement(pci,stat,sql);
			 return stat.executeUpdate();
		}
		finally {
			pci.releaseActiveQuery();
		}
	}
	
	

	private static void setActiveStatement(PageContextImpl pc,Statement stat, String sql) {
		pc.setActiveQuery(new ActiveQuery(sql,System.currentTimeMillis()));
	}
}
