package railo.runtime.db.driver.state;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import railo.runtime.PageContext;
import railo.runtime.db.driver.ConnectionProxy;
import railo.runtime.db.driver.StatementProxy;
import railo.runtime.engine.ThreadLocalPageContext;

public class StateStatement extends StatementProxy {

	public StateStatement(ConnectionProxy conn, Statement stat) {
		super(conn, stat);
	}	

	@Override
	public boolean execute(String sql) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(),stat, sql);
	}

	@Override
	public boolean execute(PageContext pc, String sql) throws SQLException {
		return StateUtil.execute(pc,stat, sql);
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql,autoGeneratedKeys);
	}

	@Override
	public boolean execute(PageContext pc, String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.execute(pc, stat, sql,autoGeneratedKeys);
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql,columnIndexes);
	}

	@Override
	public boolean execute(PageContext pc, String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.execute(pc, stat, sql,columnIndexes);
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql,columnNames);
	}

	@Override
	public boolean execute(PageContext pc, String sql, String[] columnNames) throws SQLException {
		return StateUtil.execute(pc, stat, sql,columnNames);
	}
	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		return StateUtil.executeQuery(ThreadLocalPageContext.get(), stat,sql);
	}
	@Override
	public ResultSet executeQuery(PageContext pc, String sql) throws SQLException {
		return StateUtil.executeQuery(pc, stat,sql);
	}
	
	@Override
	public int executeUpdate(String sql) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql);
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql,autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql,autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql,columnIndexes);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql,columnIndexes);
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql,columnNames);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql, String[] columnNames) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql,columnNames);
	}
}
