package railo.runtime.db.driver.state;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import railo.runtime.PageContext;
import railo.runtime.PageContextImpl;
import railo.runtime.db.driver.CallableStatementProxy;
import railo.runtime.db.driver.ConnectionProxy;
import railo.runtime.debug.ActiveQuery;
import railo.runtime.engine.ThreadLocalPageContext;

public class StateCallableStatement extends CallableStatementProxy {

	public StateCallableStatement(ConnectionProxy conn,CallableStatement prepareCall, String sql) {
		super(conn, prepareCall,sql);
	}
	

	@Override
	public boolean execute(String sql) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(),stat, sql);
	}

	@Override
	public boolean execute(PageContext pc, String sql) throws SQLException {
		return StateUtil.execute(pc,stat, sql);
	}

	@Override
	public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql,autoGeneratedKeys);
	}

	@Override
	public boolean execute(PageContext pc, String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.execute(pc, stat, sql,autoGeneratedKeys);
	}

	@Override
	public boolean execute(String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql,columnIndexes);
	}

	@Override
	public boolean execute(PageContext pc, String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.execute(pc, stat, sql,columnIndexes);
	}

	@Override
	public boolean execute(String sql, String[] columnNames) throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql,columnNames);
	}

	@Override
	public boolean execute(PageContext pc, String sql, String[] columnNames) throws SQLException {
		return StateUtil.execute(pc, stat, sql,columnNames);
	}
	@Override
	public ResultSet executeQuery(String sql) throws SQLException {
		return StateUtil.executeQuery(ThreadLocalPageContext.get(), stat,sql);
	}
	@Override
	public ResultSet executeQuery(PageContext pc, String sql) throws SQLException {
		return StateUtil.executeQuery(pc, stat,sql);
	}
	
	@Override
	public int executeUpdate(String sql) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql);
	}

	@Override
	public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql,autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql, int autoGeneratedKeys) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql,autoGeneratedKeys);
	}

	@Override
	public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql,columnIndexes);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql, int[] columnIndexes) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql,columnIndexes);
	}

	@Override
	public int executeUpdate(String sql, String[] columnNames) throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql,columnNames);
	}

	@Override
	public int executeUpdate(PageContext pc, String sql, String[] columnNames) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql,columnNames);
	}
	
	@Override
	public boolean execute() throws SQLException {
		return StateUtil.execute(ThreadLocalPageContext.get(), stat, sql);
	}
	
	@Override
	public boolean execute(PageContext pc) throws SQLException {
		return StateUtil.execute(pc, stat, sql);
	}

	@Override
	public ResultSet executeQuery() throws SQLException {
		return StateUtil.executeQuery(ThreadLocalPageContext.get(), stat, sql);
	}

	@Override
	public ResultSet executeQuery(PageContext pc) throws SQLException {
		return StateUtil.executeQuery(pc, stat, sql);
	}

	@Override
	public int executeUpdate() throws SQLException {
		return StateUtil.executeUpdate(ThreadLocalPageContext.get(), stat, sql);
	}

	@Override
	public int executeUpdate(PageContext pc) throws SQLException {
		return StateUtil.executeUpdate(pc, stat, sql);
	}

	protected void setActiveStatement(PageContextImpl pc,Statement stat, String sql) {
		pc.setActiveQuery(new ActiveQuery(sql,System.currentTimeMillis()));
	}

}
